/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.graph.BalloonHelp;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.GraphPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Polygon;

public class LineGraphPanel
extends GraphPanel {
    protected int leftMargin = 80;
    protected int rightMargin = 40;
    protected int topMargin = 10;
    protected int bottomMargin = 30;
    protected int graphDepth = 10;
    protected int lineWidth = 1;
    protected int threeDXOffset = 3;
    protected int threeDYOffset = 2;
    private Number maxXn;
    private Number minXn;
    private Number maxYn;
    private Number minYn;
    private boolean showShadow = true;

    public void setShowShadow(boolean bl) {
        if (this.showShadow != bl) {
            this.showShadow = bl;
            this.renderGraph();
        }
    }

    public boolean getShowsShadow() {
        return this.showShadow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void drawGraph() {
        int n;
        String string;
        Number[] numberArray;
        if (this.bufferG == null) {
            return;
        }
        int n2 = this.getNumDataSets();
        int n3 = 0;
        int n4 = 0;
        this.maxYn = null;
        this.minYn = null;
        this.maxXn = null;
        this.minXn = null;
        this.bufferG.setColor(Color.white);
        this.bufferG.fillRect(0, 0, this.graphSize.width, this.graphSize.height);
        if (n2 <= 0) {
            return;
        }
        DataSet dataSet = this.getDataSet(0);
        if (this.threeD) {
            this.graphDepth = Math.min(45, 9 * n2);
            n3 = (int)((float)n2 / (float)this.graphDepth) * 3;
            n4 = (int)((float)n2 / (float)this.graphDepth) * 2;
            this.lineWidth = this.graphDepth / n2;
            this.threeDYOffset = 2;
            this.threeDXOffset = 3;
        } else {
            this.graphDepth = 1;
            this.lineWidth = 1;
            this.threeDXOffset = 0;
            this.threeDYOffset = 0;
        }
        FontMetrics fontMetrics = this.bufferG.getFontMetrics();
        this.leftMargin = 40;
        this.rightMargin = Math.max(this.graphDepth * this.threeDXOffset + 10, 20);
        this.bottomMargin = 20;
        this.topMargin = Math.max(this.graphDepth * this.threeDYOffset + 10, 40);
        int n5 = 0;
        while (n5 < n2) {
            numberArray = this.getDataSet(n5);
            if (numberArray.getNumValues() > 0) {
                Number number = numberArray.getMaxXValue();
                if (this.maxXn == null || number.doubleValue() > this.maxXn.doubleValue()) {
                    this.maxXn = number;
                }
                number = numberArray.getMaxYValue();
                if (this.maxYn == null || number.doubleValue() > this.maxYn.doubleValue()) {
                    this.maxYn = number;
                }
                number = numberArray.getMinXValue();
                if (this.minXn == null || number.doubleValue() < this.minXn.doubleValue()) {
                    this.minXn = number;
                }
                number = numberArray.getMinYValue();
                if (this.minYn == null || number.doubleValue() < this.minYn.doubleValue()) {
                    this.minYn = number;
                }
            }
            ++n5;
        }
        if (this.maxXn == null || this.maxYn == null || this.minXn == null || this.minYn == null) {
            String string2 = "No Data to Graph";
            this.bufferG.setColor(Color.black);
            this.bufferG.drawString(string2, this.graphSize.width / 2 - fontMetrics.stringWidth(string2), (this.graphSize.height + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent()) / 2);
            return;
        }
        Number[] numberArray2 = DataSet.getTicks(this.minYn, this.maxYn, this.graphSize.height - this.bottomMargin - this.topMargin, this.getDataSet(0).getYType(), fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent());
        numberArray = DataSet.getTicks(this.minXn, this.maxXn, this.graphSize.width - this.rightMargin - this.leftMargin, this.getDataSet(0).getXType(), Math.max(fontMetrics.stringWidth(DataSet.formatValue(this.maxXn, this.getDataSet(0).getXType())), fontMetrics.stringWidth(DataSet.formatValue(this.minXn, this.getDataSet(0).getXType()))) + 10);
        this.minYn = numberArray2[0];
        this.maxYn = numberArray2[numberArray2.length - 1];
        this.minXn = numberArray[0];
        this.maxXn = numberArray[numberArray.length - 1];
        this.leftMargin = Math.max(fontMetrics.stringWidth(DataSet.formatValue(this.maxYn, this.getDataSet(0).getYType())) + 3, Math.max(fontMetrics.stringWidth(DataSet.formatValue(this.minYn, this.getDataSet(0).getXType())) + 3, this.leftMargin));
        if (this.graphSize.height - this.bottomMargin <= this.topMargin || this.graphSize.width - this.rightMargin <= this.leftMargin) {
            return;
        }
        double d = this.maxXn.doubleValue();
        double d2 = this.minXn.doubleValue();
        double d3 = this.maxYn.doubleValue();
        double d4 = this.minYn.doubleValue();
        int n6 = 0;
        while (n6 < numberArray2.length) {
            string = DataSet.formatValue(numberArray2[n6], dataSet.getYType());
            int n7 = fontMetrics.stringWidth(string);
            n = this.graphSize.height - this.bottomMargin - (this.graphSize.height - this.bottomMargin - this.topMargin) * n6 / (numberArray2.length - 1);
            this.bufferG.setColor(Color.black);
            this.bufferG.drawString(string, this.leftMargin - n7, n);
            this.bufferG.setColor(Color.lightGray);
            this.bufferG.drawLine(2, n, this.leftMargin, n);
            this.bufferG.drawLine(this.leftMargin, n, this.leftMargin + this.graphDepth * this.threeDXOffset, n - this.graphDepth * this.threeDYOffset);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, n - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, n - this.threeDYOffset * this.graphDepth);
            ++n6;
        }
        n6 = 0;
        while (n6 < numberArray.length) {
            string = DataSet.formatValue(numberArray[n6], dataSet.getXType());
            int n8 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            n = (this.graphSize.width - this.leftMargin - this.rightMargin) * n6 / (numberArray.length - 1);
            this.bufferG.setColor(Color.black);
            this.bufferG.drawString(string, this.leftMargin + n + 2, this.graphSize.height - this.bottomMargin + n8);
            this.bufferG.setColor(Color.lightGray);
            this.bufferG.drawLine(this.leftMargin + n, this.graphSize.height - this.bottomMargin, this.leftMargin + n, this.graphSize.height - this.bottomMargin + n8 + 2);
            this.bufferG.drawLine(this.leftMargin + n, this.graphSize.height - this.bottomMargin, this.leftMargin + n + this.graphDepth * this.threeDXOffset, this.graphSize.height - this.bottomMargin - this.graphDepth * this.threeDYOffset);
            this.bufferG.drawLine(this.leftMargin + n + this.graphDepth * this.threeDXOffset, this.graphSize.height - this.bottomMargin - this.graphDepth * this.threeDYOffset, this.leftMargin + n + this.graphDepth * this.threeDXOffset, this.topMargin - this.graphDepth * this.threeDYOffset);
            ++n6;
        }
        this.bufferG.setColor(Color.black);
        this.bufferG.drawLine(this.leftMargin, this.topMargin, this.leftMargin, this.graphSize.height - this.bottomMargin);
        this.bufferG.drawLine(this.leftMargin, this.graphSize.height - this.bottomMargin, this.graphSize.width - this.rightMargin, this.graphSize.height - this.bottomMargin);
        if (this.threeD) {
            this.bufferG.drawLine(this.leftMargin, this.topMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin, this.graphSize.height - this.bottomMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.leftMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin, this.graphSize.height - this.bottomMargin);
        }
        double d5 = d - d2;
        double d6 = d3 - d4;
        double d7 = (double)(this.graphSize.width - this.rightMargin - this.leftMargin) / d5;
        double d8 = (double)(this.graphSize.height - this.bottomMargin - this.topMargin) / d6;
        this.removeAllBalloonHelpItems();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        this.rightMargin -= this.graphDepth * this.threeDXOffset;
        this.leftMargin += this.graphDepth * this.threeDXOffset;
        this.topMargin -= this.graphDepth * this.threeDYOffset;
        this.bottomMargin += this.graphDepth * this.threeDYOffset;
        int n9 = 0;
        while (n9 < n2) {
            Object object;
            this.rightMargin += this.lineWidth * this.threeDXOffset;
            this.leftMargin -= this.lineWidth * this.threeDXOffset;
            this.bottomMargin -= this.lineWidth * this.threeDYOffset;
            this.topMargin += this.lineWidth * this.threeDYOffset;
            dataSet = this.getDataSet(n9);
            Color color = this.getColor(n9);
            boolean bl = true;
            String[] stringArray = dataSet.getDescription();
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            this.bufferG.setColor(color);
            int n10 = dataSet.getNumValues();
            int[] nArray3 = new int[n10 * 2 + 1];
            int[] nArray4 = new int[n10 * 2 + 1];
            double d13 = 0.0;
            int n11 = 60;
            int n12 = 0;
            while (n12 < n10) {
                this.bufferG.setColor(Color.black);
                this.bufferG.drawLine(this.leftMargin, this.topMargin, this.leftMargin, this.graphSize.height - this.bottomMargin);
                this.bufferG.drawLine(this.leftMargin, this.graphSize.height - this.bottomMargin, this.graphSize.width - this.rightMargin, this.graphSize.height - this.bottomMargin);
                d11 = (double)this.leftMargin + (dataSet.xvalues[n12].doubleValue() - d2) * d7;
                d12 = (double)(this.graphSize.height - this.bottomMargin) - (dataSet.yvalues[n12].doubleValue() - d4) * d8;
                if (!bl) {
                    if (this.threeD) {
                        boolean bl2;
                        object = new int[]{(int)d9, (int)d9 + this.threeDXOffset * this.lineWidth, (int)d11 + this.threeDXOffset * this.lineWidth, (int)d11};
                        int[] nArray5 = new int[]{this.graphSize.height - this.bottomMargin, this.graphSize.height - this.bottomMargin - this.lineWidth * this.threeDYOffset, this.graphSize.height - this.bottomMargin - this.lineWidth * this.threeDYOffset, this.graphSize.height - this.bottomMargin};
                        if (this.showShadow) {
                            this.bufferG.setColor(color.darker().darker().darker());
                            this.bufferG.setXORMode(Color.white);
                            this.bufferG.fillPolygon(new Polygon((int[])object, nArray5, 4));
                            this.bufferG.setPaintMode();
                        }
                        d13 = d11 != d9 ? (d12 - d10) / (d11 - d9) : 1000.0;
                        int n13 = 0;
                        boolean bl3 = bl2 = d13 > 0.0;
                        if (d13 < 0.0) {
                            d13 *= -1.0;
                        }
                        n13 = d13 <= 0.5 ? (int)(2.0 * d13 * 60.0) : (d13 <= 1.0 ? (int)(d13 * 70.0) : (d13 < 6.0 ? 75 + (int)((d13 - 1.0) / 5.0 * 10.0) : 80));
                        if (bl2) {
                            n13 *= -1;
                        }
                        this.bufferG.setColor(new Color(Math.min(Math.max(color.getRed() + n13, 0), 255), Math.min(Math.max(color.getGreen() + n13, 0), 255), Math.min(Math.max(color.getBlue() + n13, 0), 255)));
                        nArray[0] = (int)d9;
                        nArray2[0] = (int)d10;
                        nArray[1] = (int)d9 + this.lineWidth * this.threeDXOffset;
                        nArray2[1] = (int)d10 - this.lineWidth * this.threeDYOffset;
                        nArray[2] = (int)d11 + this.lineWidth * this.threeDXOffset;
                        nArray2[2] = (int)d12 - this.lineWidth * this.threeDYOffset;
                        nArray[3] = (int)d11;
                        nArray2[3] = (int)d12;
                        this.bufferG.fillPolygon(nArray, nArray2, 4);
                        this.bufferG.setColor(color);
                        this.bufferG.drawPolygon(nArray, nArray2, 4);
                    } else {
                        this.bufferG.setColor(color);
                        this.bufferG.drawLine((int)d9, (int)d10, (int)d11, (int)d12);
                    }
                }
                if (this.threeD) {
                    nArray3[n12] = (int)d11;
                    nArray3[n10 * 2 - n12 - 1] = (int)d11 + this.lineWidth * this.threeDXOffset;
                    nArray4[n12] = (int)d12;
                    nArray4[n10 * 2 - n12 - 1] = (int)d12 - this.lineWidth * this.threeDYOffset;
                } else {
                    nArray3[n12] = (int)d11;
                    nArray3[n10 * 2 - n12 - 1] = (int)d11;
                    nArray4[n12] = (int)d12 + 4;
                    nArray4[n10 * 2 - n12 - 1] = (int)d12 - 4;
                }
                bl = false;
                d9 = d11;
                d10 = d12;
                ++n12;
            }
            nArray3[nArray3.length - 1] = nArray3[0];
            nArray4[nArray4.length - 1] = nArray4[0];
            Number number = dataSet.getMaxYValue();
            object = dataSet.getMinYValue();
            try {
                this.addBalloonHelpArea(new BalloonHelp(stringArray, new Polygon(nArray3, nArray4, n10 * 2), this.graphSize, color));
            }
            catch (Exception exception) {
                System.err.println("Got exception creating ballon help area: " + exception);
            }
            ++n9;
        }
    }

    public LineGraphPanel(Dimension dimension) {
        super(dimension);
    }
}

