/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.graph.KeyItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public class KeyPanel
extends JPanel
implements ComponentListener {
    protected Vector keyItems;
    protected Image graphImage = null;
    protected Dimension graphSize = null;
    protected Graphics bufferG = null;

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public synchronized void componentResized(ComponentEvent componentEvent) {
        this.graphSize = this.getSize();
        this.renderKey();
    }

    public void addKeyItem(KeyItem keyItem) {
        this.keyItems.addElement(keyItem);
        this.renderKey();
    }

    public final synchronized void renderKey() {
        if (this.graphSize.width <= 0 || this.graphSize.height <= 0) {
            return;
        }
        this.graphImage = this.createImage(this.graphSize.width, this.graphSize.height);
        this.bufferG = this.graphImage.getGraphics();
        this.bufferG.setColor(this.getBackground());
        this.bufferG.fillRect(0, 0, this.graphSize.width, this.graphSize.height);
        FontMetrics fontMetrics = this.bufferG.getFontMetrics();
        int n = 0;
        int n2 = 5;
        int n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n4 = 0;
        Enumeration enumeration = this.keyItems.elements();
        while (enumeration.hasMoreElements()) {
            KeyItem keyItem = (KeyItem)enumeration.nextElement();
            this.bufferG.setColor(Color.black);
            this.bufferG.fillRect(n2, (n3 + 4) * n4 + 6, 20, n3 - 1);
            this.bufferG.setColor(keyItem.getColor());
            this.bufferG.fillRect(n2, (n3 + 4) * n4 + 6, 20, n3 - 1);
            this.bufferG.setColor(Color.black);
            this.bufferG.drawString(keyItem.getLabel(), n2 + 22, (n3 + 4) * (n4 + 1));
            int n5 = n2 + 22 + fontMetrics.stringWidth(keyItem.getLabel());
            if (n5 > n) {
                n = n5;
            }
            if ((n3 + 4) * (n4 + 1) > this.graphSize.height - n3) {
                n2 += n + 5;
                n = 0;
                n4 = -1;
            }
            ++n4;
        }
        this.repaint();
    }

    public void removeAllKeyItems() {
        this.keyItems.removeAllElements();
        this.renderKey();
    }

    public Dimension getMinimumSize() {
        return this.graphSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public synchronized void update(Graphics graphics) {
        if (this.graphImage == null) {
            this.renderKey();
        }
        if (this.graphImage != null) {
            graphics.drawImage(this.graphImage, 0, 0, null);
        }
    }

    public KeyPanel(Dimension dimension) {
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.graphSize = dimension;
        this.keyItems = new Vector();
        this.addComponentListener(this);
        this.repaint();
    }
}

