/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.GIFEncoder;
import com.seanreilly.awt.graph.BalloonHelp;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.DataSetInfo;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class GraphPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
ComponentListener {
    private Vector balloonHelpItems = new Vector();
    private Vector dataSets = new Vector();
    private Image bufferImage = null;
    protected Image graphImage = null;
    protected Dimension graphSize = null;
    protected Graphics bufferG;
    private Point mousePosition = null;
    private boolean balloonHelpEnabled = true;
    protected boolean threeD = true;
    private boolean dirty = true;

    public boolean isThreeD() {
        return this.threeD;
    }

    public synchronized void writeGIF(OutputStream outputStream) throws AWTException, IOException {
        new GIFEncoder(this.bufferImage).Write(outputStream);
    }

    public synchronized void writeGIFWithInfo(OutputStream outputStream) throws AWTException, IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        FontMetrics fontMetrics = this.bufferG.getFontMetrics();
        Enumeration enumeration = this.balloonHelpItems.elements();
        while (enumeration.hasMoreElements()) {
            BalloonHelp balloonHelp = (BalloonHelp)enumeration.nextElement();
            ++n2;
            n3 = Math.max(n3, balloonHelp.helpText.length);
            n = 0;
            while (n < balloonHelp.helpText.length) {
                n4 = Math.max(n4, fontMetrics.stringWidth(balloonHelp.helpText[n]));
                ++n;
            }
        }
        int n5 = 4;
        int n6 = 10;
        n = 2;
        int n7 = 2;
        int n8 = 10;
        int n9 = 10;
        Image image = this.createImage(Math.max(this.graphSize.width, n8 + n9 + (n4 + n6) * n2), this.graphSize.height + (n8 + n9 + n3 * (n5 + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent())));
        Graphics graphics = image.getGraphics();
        int n10 = n8;
        Enumeration enumeration2 = this.balloonHelpItems.elements();
        while (enumeration2.hasMoreElements()) {
            BalloonHelp balloonHelp = (BalloonHelp)enumeration2.nextElement();
            int n11 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + n;
            int n12 = 0;
            while (n12 < balloonHelp.helpText.length) {
                graphics.setColor(balloonHelp.dataSetColor);
                graphics.drawString(balloonHelp.helpText[n12], n10, n11);
                n11 += fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + n5;
                ++n12;
            }
            n10 += n4 + n6;
        }
        graphics.drawImage(this.bufferImage, 0, n + n7 + n3 * (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + n5), null);
        new GIFEncoder(image).Write(outputStream);
    }

    public void setThreeD(boolean bl) {
        this.threeD = bl;
        if (this.bufferImage != null) {
            this.renderGraph();
        }
    }

    public void setBalloonHelpEnabled(boolean bl) {
        this.balloonHelpEnabled = bl;
        if (this.bufferImage != null) {
            this.renderGraph();
        }
    }

    public synchronized void addDataSetGraph(DataSet dataSet, Color color) {
        dataSet.sortAscending();
        this.dataSets.addElement(new DataSetInfo(dataSet, color));
    }

    public synchronized void removeAllDataSets() {
        this.dataSets.removeAllElements();
        this.removeAllBalloonHelpItems();
    }

    public int getNumDataSets() {
        return this.dataSets.size();
    }

    public DataSet getDataSet(int n) {
        return ((DataSetInfo)this.dataSets.elementAt((int)n)).dataSet;
    }

    public Color getColor(int n) {
        return ((DataSetInfo)this.dataSets.elementAt((int)n)).color;
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public synchronized void componentResized(ComponentEvent componentEvent) {
        this.graphSize = this.getSize();
        this.renderGraph();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void renderGraph() {
        if (this.graphSize.width <= 0 || this.graphSize.height <= 0) {
            return;
        }
        this.graphImage = this.createImage(this.graphSize.width, this.graphSize.height);
        if (this.graphImage == null) {
            System.err.println("Couldn't create image!! size:" + this.graphSize);
            try {
                throw new Exception("test");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                this.dirty = true;
                return;
            }
        }
        this.bufferG = this.graphImage.getGraphics();
        this.drawGraph();
        if (this.graphImage == null) {
            return;
        }
        this.bufferImage = this.createImage(this.graphImage.getWidth(null), this.graphImage.getHeight(null));
        this.bufferImage.getGraphics().drawImage(this.graphImage, 0, 0, null);
        this.repaint();
    }

    protected abstract void drawGraph();

    protected void addBalloonHelpArea(BalloonHelp balloonHelp) {
        this.balloonHelpItems.insertElementAt(balloonHelp, 0);
    }

    protected void removeAllBalloonHelpItems() {
        this.balloonHelpItems.removeAllElements();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.balloonHelpEnabled) {
            return;
        }
        this.mousePosition = mouseEvent.getPoint();
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.balloonHelpEnabled) {
            return;
        }
        this.mousePosition = mouseEvent.getPoint();
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.balloonHelpEnabled) {
            return;
        }
        this.mousePosition = mouseEvent.getPoint();
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.balloonHelpEnabled) {
            return;
        }
        this.mousePosition = null;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.graphImage == null) {
            this.renderGraph();
            if (this.graphImage == null) {
                return;
            }
        }
        if (this.bufferImage == null) {
            this.renderGraph();
            if (this.bufferImage == null) {
                return;
            }
        }
        if (this.mousePosition != null) {
            Graphics graphics2 = this.bufferImage.getGraphics();
            graphics2.drawImage(this.graphImage, 0, 0, null);
            if (this.balloonHelpEnabled) {
                Enumeration enumeration = this.balloonHelpItems.elements();
                while (enumeration.hasMoreElements()) {
                    BalloonHelp balloonHelp = (BalloonHelp)enumeration.nextElement();
                    if (!balloonHelp.isMouseInside(this.mousePosition)) continue;
                    balloonHelp.handleMouseInside(graphics2, this.mousePosition.x, this.mousePosition.y);
                    break;
                }
            }
        }
        graphics.drawImage(this.bufferImage, 0, 0, null);
    }

    public GraphPanel(Dimension dimension) {
        this.setBackground(Color.white);
        this.graphSize = dimension;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.repaint();
    }
}

