/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import com.seanreilly.awt.graph.BalloonHelp;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.GraphPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Polygon;

public class BarGraphPanel
extends GraphPanel {
    protected int leftMargin = 80;
    protected int rightMargin = 10;
    protected int topMargin = 10;
    protected int bottomMargin = 30;
    protected int graphDepth = 100;
    protected int threeDXOffset = 3;
    protected int threeDYOffset = 2;
    protected int intervalType = -3;

    public void setInterval(int n) {
        this.intervalType = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void drawGraph() {
        int n;
        int n2;
        String string;
        int n3;
        if (this.bufferG == null) {
            return;
        }
        int n4 = this.getNumDataSets();
        this.bufferG.setColor(Color.white);
        this.bufferG.fillRect(0, 0, this.graphSize.width, this.graphSize.height);
        if (n4 <= 0) {
            return;
        }
        Number number = null;
        Number number2 = null;
        Number number3 = null;
        Number number4 = null;
        int n5 = 0;
        while (n5 < this.getNumDataSets()) {
            DataSet dataSet = this.getDataSet(n5);
            Number number5 = dataSet.getMinXValue();
            if (number2 == null || number2.doubleValue() > number5.doubleValue()) {
                number2 = number5;
            }
            number5 = dataSet.getMaxXValue();
            if (number == null || number.doubleValue() < number5.doubleValue()) {
                number = number5;
            }
            number5 = dataSet.getMinYValue();
            if (number4 == null || number4.doubleValue() > number5.doubleValue()) {
                number4 = number5;
            }
            number5 = dataSet.getMaxYValue();
            if (number3 == null || number3.doubleValue() < number5.doubleValue()) {
                number3 = number5;
            }
            ++n5;
        }
        n5 = DataSet.getNumIntervals(this.intervalType, number2, number);
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        if (this.threeD) {
            this.graphDepth = Math.min(45, 9 * n4);
            n6 = (int)((float)n4 / (float)this.graphDepth) * 3;
            n7 = (int)((float)n4 / (float)this.graphDepth) * 2;
            n8 = this.graphDepth / n4;
            n3 = this.graphDepth / n4;
            this.threeDYOffset = 2;
            this.threeDXOffset = 3;
        } else {
            this.graphDepth = 1;
            n8 = 1;
            n3 = 1;
            this.threeDXOffset = 0;
            this.threeDYOffset = 0;
        }
        FontMetrics fontMetrics = this.bufferG.getFontMetrics();
        this.leftMargin = 40;
        this.rightMargin = Math.max(this.graphDepth * this.threeDXOffset + 10, 20);
        this.bottomMargin = 20;
        this.topMargin = Math.max(this.graphDepth * this.threeDYOffset + 10, 40);
        if (this.graphSize.height - this.bottomMargin <= this.topMargin || this.graphSize.width - this.rightMargin <= this.leftMargin) {
            return;
        }
        Number[] numberArray = DataSet.getTicks(number4, number3, this.graphSize.height - this.bottomMargin - this.topMargin, this.getDataSet(0).getYType(), fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent());
        Number[] numberArray2 = DataSet.getBarTicks(number2, n5, this.intervalType);
        this.leftMargin = Math.max(fontMetrics.stringWidth(DataSet.formatValue(number3, this.getDataSet(0).getYType())) + 3, Math.max(fontMetrics.stringWidth(DataSet.formatValue(number4, this.getDataSet(0).getXType())) + 3, this.leftMargin));
        double d = numberArray2[numberArray2.length - 1].doubleValue();
        double d2 = numberArray2[0].doubleValue();
        double d3 = numberArray[numberArray.length - 1].doubleValue();
        double d4 = numberArray[0].doubleValue();
        double d5 = d - d2;
        double d6 = d3 - d4;
        double d7 = (double)(this.graphSize.width - this.rightMargin - this.leftMargin) / d5;
        double d8 = (double)(this.graphSize.height - this.bottomMargin - this.topMargin) / d6;
        this.removeAllBalloonHelpItems();
        DataSet dataSet = this.getDataSet(0);
        int n9 = 0;
        while (n9 < numberArray.length) {
            string = DataSet.formatValue(numberArray[n9], dataSet.getYType());
            int n10 = fontMetrics.stringWidth(string);
            n2 = this.graphSize.height - this.bottomMargin - (this.graphSize.height - this.bottomMargin - this.topMargin) * n9 / (numberArray.length - 1);
            this.bufferG.setColor(Color.black);
            this.bufferG.drawString(string, this.leftMargin - n10, n2);
            this.bufferG.setColor(Color.lightGray);
            this.bufferG.drawLine(2, n2, this.leftMargin, n2);
            this.bufferG.drawLine(this.leftMargin, n2, this.leftMargin + this.graphDepth * this.threeDXOffset, n2 - this.graphDepth * this.threeDYOffset);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, n2 - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, n2 - this.threeDYOffset * this.graphDepth);
            ++n9;
        }
        n9 = -1;
        n2 = -1;
        int n11 = 0;
        int n12 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        int n13 = 0;
        while (n13 < numberArray2.length) {
            n = (int)((numberArray2[n13].doubleValue() - d2) * d7);
            if (n2 >= 0) {
                n11 = n - n2;
            }
            n2 = n;
            this.bufferG.setColor(Color.lightGray);
            this.bufferG.drawLine(this.leftMargin + n, this.graphSize.height - this.bottomMargin, this.leftMargin + n + this.graphDepth * this.threeDXOffset, this.graphSize.height - this.bottomMargin - this.graphDepth * this.threeDYOffset);
            this.bufferG.drawLine(this.leftMargin + n + this.graphDepth * this.threeDXOffset, this.graphSize.height - this.bottomMargin - this.graphDepth * this.threeDYOffset, this.leftMargin + n + this.graphDepth * this.threeDXOffset, this.topMargin - this.graphDepth * this.threeDYOffset);
            ++n13;
        }
        n9 = -1;
        n13 = 0;
        while (n13 < numberArray2.length) {
            string = DataSet.formatValue(numberArray2[n13], dataSet.getXType());
            n12 = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
            n = (int)((numberArray2[n13].doubleValue() - d2) * d7);
            if (n > n9) {
                this.bufferG.setColor(Color.black);
                this.bufferG.drawString(string, this.leftMargin + n + 2, this.graphSize.height - this.bottomMargin + n12);
                this.bufferG.setColor(Color.lightGray);
                this.bufferG.drawLine(this.leftMargin + n, this.graphSize.height - this.bottomMargin, this.leftMargin + n, this.graphSize.height - this.bottomMargin + n12 + 2);
                n9 = n + fontMetrics.stringWidth(string) + 4;
            }
            ++n13;
        }
        this.bufferG.setColor(Color.black);
        this.bufferG.drawLine(this.leftMargin, this.topMargin, this.leftMargin, this.graphSize.height - this.bottomMargin);
        this.bufferG.drawLine(this.leftMargin, this.graphSize.height - this.bottomMargin, this.graphSize.width - this.rightMargin, this.graphSize.height - this.bottomMargin);
        if (this.threeD) {
            this.bufferG.drawLine(this.leftMargin, this.topMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin, this.graphSize.height - this.bottomMargin, this.leftMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.leftMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.leftMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.topMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth);
            this.bufferG.drawLine(this.graphSize.width - this.rightMargin + this.threeDXOffset * this.graphDepth, this.graphSize.height - this.bottomMargin - this.threeDYOffset * this.graphDepth, this.graphSize.width - this.rightMargin, this.graphSize.height - this.bottomMargin);
        }
        this.rightMargin -= this.graphDepth * this.threeDXOffset;
        this.leftMargin += this.graphDepth * this.threeDXOffset;
        this.topMargin -= this.graphDepth * this.threeDYOffset;
        this.bottomMargin += this.graphDepth * this.threeDYOffset;
        n = 0;
        while (n < n4) {
            this.rightMargin += n3 * this.threeDXOffset;
            this.leftMargin -= n3 * this.threeDXOffset;
            this.bottomMargin -= n3 * this.threeDYOffset;
            this.topMargin += n3 * this.threeDYOffset;
            DataSet dataSet2 = this.getDataSet(n);
            Color color = this.getColor(n);
            String[] stringArray = dataSet2.getDescription();
            this.bufferG.setColor(color);
            int n14 = dataSet2.getNumValues();
            int[] nArray = new int[n14 * 4];
            int[] nArray2 = new int[n14 * 4];
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[4];
            double d9 = 0.0;
            int n15 = 60;
            int n16 = 0;
            while (n16 < n14) {
                if (n16 == 0) {
                    this.bufferG.setColor(Color.black);
                    this.bufferG.drawLine(this.leftMargin, this.topMargin, this.leftMargin, this.graphSize.height - this.bottomMargin);
                    this.bufferG.drawLine(this.leftMargin, this.graphSize.height - this.bottomMargin, this.graphSize.width - this.rightMargin, this.graphSize.height - this.bottomMargin);
                }
                int n17 = (int)((double)this.leftMargin + (dataSet2.xvalues[n16].doubleValue() - d2) * d7);
                int n18 = n11;
                int n19 = (int)((double)(this.graphSize.height - this.bottomMargin) - (dataSet2.yvalues[n16].doubleValue() - d4) * d8);
                int n20 = (int)((dataSet2.yvalues[n16].doubleValue() - d4) * d8);
                this.bufferG.setColor(color);
                this.bufferG.fillRect(n17, n19, n18, n20);
                this.bufferG.setColor(Color.black);
                this.bufferG.drawRect(n17, n19, n18, n20);
                if (this.threeD) {
                    nArray3[0] = n17;
                    nArray3[1] = n17 + n3 * this.threeDXOffset;
                    nArray3[2] = nArray3[1] + n18;
                    nArray3[3] = nArray3[0] + n18;
                    nArray4[0] = n19;
                    nArray4[1] = n19 - n3 * this.threeDYOffset;
                    nArray4[2] = nArray4[1];
                    nArray4[3] = nArray4[0];
                    this.bufferG.setColor(color.brighter());
                    this.bufferG.fillPolygon(nArray3, nArray4, 4);
                    this.bufferG.setColor(Color.black);
                    this.bufferG.drawPolygon(nArray3, nArray4, 4);
                    nArray3[0] = n17 + n18;
                    nArray3[1] = n17 + n18 + n3 * this.threeDXOffset;
                    nArray3[2] = nArray3[1];
                    nArray3[3] = nArray3[0];
                    nArray4[0] = n19;
                    nArray4[1] = n19 - n3 * this.threeDYOffset;
                    nArray4[2] = nArray4[1] + n20;
                    nArray4[3] = nArray4[0] + n20;
                    this.bufferG.setColor(color.darker());
                    this.bufferG.fillPolygon(nArray3, nArray4, 4);
                    this.bufferG.setColor(Color.black);
                    this.bufferG.drawPolygon(nArray3, nArray4, 4);
                }
                nArray[n16 * 4] = n17;
                nArray[n16 * 4 + 1] = n17;
                nArray[n16 * 4 + 2] = n17 + n18;
                nArray[n16 * 4 + 3] = n17 + n18;
                nArray2[n16 * 4] = n19 + n20;
                nArray2[n16 * 4 + 1] = n19;
                nArray2[n16 * 4 + 2] = n19;
                nArray2[n16 * 4 + 3] = n19 + n20;
                ++n16;
            }
            try {
                this.addBalloonHelpArea(new BalloonHelp(stringArray, new Polygon(nArray, nArray2, nArray.length), this.graphSize, color));
            }
            catch (Exception exception) {
                System.err.println("Got exception creating ballon help area: " + exception);
            }
            ++n;
        }
    }

    public BarGraphPanel(Dimension dimension) {
        super(dimension);
    }
}

