/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class BalloonHelp {
    public static final int SQUARED = 0;
    public static final int ROUNDED = 1;
    String[] helpText = new String[]{"No Info"};
    Color dataSetColor = Color.black;
    Color bgColor = Color.yellow;
    Color fgColor = Color.black;
    boolean shadow = false;
    Polygon targetArea = null;
    Dimension canvasSize = null;

    private static final Polygon rectangleToPolygon(Rectangle rectangle) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = rectangle.x;
        nArray2[0] = rectangle.y;
        nArray[1] = rectangle.x + rectangle.width;
        nArray2[1] = rectangle.y;
        nArray[2] = rectangle.x + rectangle.width;
        nArray2[2] = rectangle.y + rectangle.height;
        nArray[3] = rectangle.x;
        nArray2[3] = rectangle.y + rectangle.height;
        return new Polygon(nArray, nArray2, 4);
    }

    public Dimension getBallonSize(Graphics graphics) {
        int n = 10;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = 0;
        while (n2 < this.helpText.length) {
            n = Math.max(fontMetrics.stringWidth(this.helpText[n2]), n);
            ++n2;
        }
        return new Dimension(n + 10, (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5) * this.helpText.length);
    }

    public boolean isMouseInside(Point point) {
        return this.isMouseInside(point.x, point.y);
    }

    public boolean isMouseInside(int n, int n2) {
        if (this.targetArea != null) {
            return this.targetArea.contains(n, n2);
        }
        return false;
    }

    public void handleMouseInside(Graphics graphics, int n, int n2) {
        if (this.isMouseInside(n, n2)) {
            this.drawBalloon(graphics, n, n2);
        }
    }

    public void drawBalloon(Graphics graphics, int n, int n2) {
        int n3 = n + 10;
        int n4 = n2 + 10;
        graphics.setColor(Color.green);
        graphics.setXORMode(Color.gray);
        graphics.drawPolygon(this.targetArea);
        graphics.setPaintMode();
        Dimension dimension = this.getBallonSize(graphics);
        if (n3 + dimension.width > this.canvasSize.width) {
            n3 = this.canvasSize.width - dimension.width;
        }
        if (n4 + dimension.height > this.canvasSize.height) {
            n4 = this.canvasSize.height - dimension.height;
        }
        if (this.shadow) {
            graphics.setColor(Color.black);
            graphics.fillRoundRect(n3 + 10, n4 + 10, dimension.width, dimension.height, 10, 10);
        }
        graphics.setColor(this.bgColor);
        graphics.fillRoundRect(n3, n4, dimension.width, dimension.height, 10, 10);
        graphics.setColor(Color.black);
        graphics.drawRoundRect(n3, n4, dimension.width, dimension.height, 10, 10);
        graphics.setColor(this.fgColor);
        int n5 = (int)((float)dimension.height / (float)this.helpText.length);
        int n6 = 0;
        while (n6 < this.helpText.length) {
            graphics.drawString(this.helpText[n6], n3 + 5, n4 + n5 * n6 + n5 - 5);
            ++n6;
        }
    }

    public BalloonHelp(String[] stringArray, boolean bl, Polygon polygon, Dimension dimension, Color color) {
        if (stringArray != null) {
            this.helpText = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.helpText, 0, stringArray.length);
        }
        this.dataSetColor = color;
        this.targetArea = polygon;
        this.canvasSize = dimension;
        this.shadow = bl;
    }

    public BalloonHelp(String[] stringArray, Polygon polygon, Dimension dimension, Color color) {
        this(stringArray, true, polygon, dimension, color);
    }

    public BalloonHelp(String[] stringArray, Rectangle rectangle, Dimension dimension, Color color) {
        this(stringArray, true, rectangle, dimension, color);
    }

    public BalloonHelp(String[] stringArray, boolean bl, Rectangle rectangle, Dimension dimension, Color color) {
        this(stringArray, true, BalloonHelp.rectangleToPolygon(rectangle), dimension, color);
    }
}

