/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import com.seanreilly.awt.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JWindow;

public class SplashWindow
extends JWindow {
    private JProgressBar progressBar = null;
    private JTextField statusField = null;

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setStatusText(String string) {
        this.statusField.setText(string);
    }

    public void setProgressValue(int n) {
        if (this.progressBar != null) {
            this.progressBar.setValue(n);
            this.progressBar.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SplashWindow(JFrame jFrame, String string, int n) {
        super(jFrame);
        Toolkit toolkit = this.getToolkit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add(jPanel);
        jPanel.add((Component)new ImagePanel(string), "Center");
        if (n >= 0) {
            this.progressBar = new JProgressBar();
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(n);
            this.progressBar.setValue(0);
        }
        this.statusField = new JTextField("");
        jPanel.add((Component)this.statusField, "South");
        ((Component)this).setSize(this.getPreferredSize());
        this.invalidate();
        this.validate();
        try {
            Dimension dimension = toolkit.getScreenSize();
            Dimension dimension2 = this.getSize();
            ((Component)this).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
            return;
        }
        catch (Exception exception) {
        }
    }
}

