/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr_ = new byte[4096];
    short[] strNxt_ = new short[4096];
    short[] strHsh_ = new short[9973];
    short numStrings_;

    public int AddCharString(short n, byte by) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int n2 = LZWStringTable.Hash((short)n, by);
        while (this.strHsh_[n2] != -1) {
            n2 = (n2 + 2039) % 9973;
        }
        this.strHsh_[n2] = this.numStrings_;
        this.strChr_[this.numStrings_] = by;
        this.strNxt_[this.numStrings_] = n != -1 ? n : -1;
        short s = this.numStrings_;
        this.numStrings_ = (short)(s + 1);
        return s;
    }

    public short FindCharString(short s, byte by) {
        short s2;
        if (s == -1) {
            return by;
        }
        int n = LZWStringTable.Hash(s, by);
        while ((s2 = this.strHsh_[n]) != -1) {
            if (this.strNxt_[s2] == s && this.strChr_[s2] == by) {
                return s2;
            }
            n = (n + 2039) % 9973;
        }
        return -1;
    }

    public void ClearTable(int n) {
        this.numStrings_ = 0;
        int n2 = 0;
        while (n2 < 9973) {
            this.strHsh_[n2] = -1;
            ++n2;
        }
        n2 = (1 << n) + 2;
        int n3 = 0;
        while (n3 < n2) {
            this.AddCharString((short)-1, (byte)n3);
            ++n3;
        }
    }

    public static int Hash(short s, byte by) {
        return (((short)(by << 8) ^ s) & 0xFFFF) % 9973;
    }
}

