/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import com.seanreilly.awt.JLinkLabel;
import com.seanreilly.awt.JLinkListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class JLinkLabel
extends JLabel {
    private Vector linkListeners = new Vector();
    private Object linkTarget;
    private int width = 0;
    private int height = 0;
    private Color origFG;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyLinkListeners() {
        Enumeration enumeration = this.linkListeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((JLinkListener)enumeration.nextElement()).linkActivated(this.linkTarget);
            }
            catch (Exception exception) {
                System.err.println("Exception notifying link listeners: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.width = n3;
        this.height = n4;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.width > 0 && this.height > 0) {
            graphics.setColor(this.getForeground());
            graphics.drawLine(0, this.height - 1, this.width, this.height - 1);
        }
    }

    public void addLinkListener(JLinkListener jLinkListener) {
        this.linkListeners.addElement(jLinkListener);
    }

    public void removeLinkListener(JLinkListener jLinkListener) {
        this.linkListeners.removeElement(jLinkListener);
    }

    /* synthetic */ Color access$0() {
        return this.origFG;
    }

    /* synthetic */ void access$1(Color color) {
        this.origFG = color;
    }

    /* synthetic */ void access$2() {
        this.notifyLinkListeners();
    }

    public JLinkLabel(String string, Object object, int n) {
        super(string, n);
        this.linkTarget = object;
        JLinkLabel jLinkLabel = this;
        if (jLinkLabel == null) {
            throw null;
        }
        this.addMouseListener(new MouseAdapter(jLinkLabel){
            private final /* synthetic */ JLinkLabel this$0;
            boolean working;

            public final void mouseClicked(MouseEvent mouseEvent) {
                this.this$0.access$1(this.this$0.getForeground());
                this.this$0.setForeground(Color.red);
                this.this$0.repaint();
                this.working = true;
                this.this$0.setCursor(Cursor.getPredefinedCursor(3));
                1 v0 = this;
                if (v0 == null) {
                    throw null;
                }
                SwingUtilities.invokeLater(new Thread(v0){
                    private final /* synthetic */ 1 this$0;
                    private final /* synthetic */ JLinkLabel this$1;

                    public final void run() {
                        this.this$1.repaint();
                        this.this$1.access$2();
                        this.this$1.setForeground(this.this$1.access$0());
                        this.this$0.working = false;
                        this.this$1.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    {
                        this.this$0 = var1_1;
                        this.this$1 = this.this$0.access$0();
                        this.constructor$0(var1_1);
                    }

                    public void constructor$0(1 var1_1) {
                    }
                });
            }

            public final void mouseEntered(MouseEvent mouseEvent) {
                this.this$0.setCursor(Cursor.getPredefinedCursor(12));
            }

            public final void mouseExited(MouseEvent mouseEvent) {
                if (!this.working) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            /* synthetic */ JLinkLabel access$0() {
                return this.this$0;
            }
            {
                this.this$0 = jLinkLabel;
                this.working = false;
                this.constructor$0(jLinkLabel);
            }

            public void constructor$0(JLinkLabel jLinkLabel) {
            }
        });
    }
}

