/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTextField;

public class JDateField
extends JTextField
implements KeyListener {
    private DateFormat dateFormat = null;

    private final void initHotKeys() {
        this.addKeyListener(this);
    }

    public Date setDate(Date date) {
        this.setText(this.dateFormat.format(date));
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDate() {
        Date date = null;
        try {
            date = new Date(this.dateFormat.parse(this.getText()).getTime() + 46400000L);
        }
        catch (Exception exception) {
        }
        if (date == null) {
            return new Date();
        }
        return date;
    }

    public void incrementDate() {
        Date date = this.getDate();
        if (date == null) {
            this.getToolkit().beep();
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        this.setDate(calendar.getTime());
    }

    public void decrementDate() {
        Date date = this.getDate();
        if (date == null) {
            this.getToolkit().beep();
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        this.setDate(calendar.getTime());
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '+' || c == '=') {
            keyEvent.consume();
            this.incrementDate();
        } else if (c == '-' || c == '_') {
            keyEvent.consume();
            this.decrementDate();
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '^' || c == '&' || c == '*' || c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == ';' || c == '\'' || c == '\"' || c == '<' || c == '>' || c == '?' || c == '~' || c == '`') {
            keyEvent.consume();
        }
    }

    public JDateField(DateFormat dateFormat) {
        this(dateFormat, dateFormat.format(new Date()).length() + 4);
    }

    public JDateField(DateFormat dateFormat, int n) {
        super(n);
        this.dateFormat = dateFormat;
        this.initHotKeys();
    }
}

