/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.awt;

import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.util.StringUtils;
import javax.swing.JTextField;

public class JCurrencyField
extends JTextField {
    private CurrencyType currencyType;
    private int numDecimals;
    private int centMult;
    private char dec;
    private char com;

    public CurrencyType getCurrencyType() {
        return this.currencyType;
    }

    public synchronized void setCurrencyType(CurrencyType currencyType) {
        this.currencyType = currencyType;
        this.numDecimals = currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.setValue(this.getValue());
    }

    public void setValue(long l) {
        super.setText(StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult));
    }

    public void setText(String string) {
        this.setValue(StringUtils.parseCurrency(string, this.dec, this.numDecimals, this.centMult));
    }

    public String getText() {
        return StringUtils.formatCurrency(this.getValue(), false, this.dec, this.com, this.numDecimals, this.centMult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getValue() {
        String string = super.getText().trim();
        if (string.length() <= 0) {
            return 0;
        }
        try {
            return StringUtils.parseCurrency(string, this.dec, this.numDecimals, this.centMult);
        }
        catch (Exception exception) {
            try {
                this.getToolkit().beep();
                return 0;
            }
            catch (Exception exception2) {
            }
            return 0;
        }
    }

    public JCurrencyField(CurrencyType currencyType, char c, char c2) {
        this(12, currencyType, c, c2);
    }

    public JCurrencyField(int n, CurrencyType currencyType, char c, char c2) {
        super(n);
        this.dec = c;
        this.com = c2;
        this.setHorizontalAlignment(4);
        this.setCurrencyType(currencyType);
    }
}

