/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JDateField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransactionsSettingsPanel
extends JPanel {
    MoneydanceGUI moneydanceGUI;
    JComboBox accountChoice;
    JDateField startDateField;
    JDateField endDateField;
    JComboBox subtotalByChoice;
    private DateFormat dateFormat;
    private AccountListModel accountModel;
    private RootAccount rootAccount;

    public void goneAway() {
        this.accountModel.goneAway();
    }

    public TransactionsSettingsPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, Account account) {
        super(new GridBagLayout());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.accountModel = new AccountListModel(rootAccount);
        this.accountModel.setShowAccountsOfType(0, false);
        this.accountChoice = new JComboBox(this.accountModel);
        if (account.getAccountType() == 0) {
            this.accountChoice.setSelectedIndex(0);
        } else {
            this.accountChoice.setSelectedItem(account);
        }
        this.subtotalByChoice = new JComboBox();
        this.subtotalByChoice.addItem(this.moneydanceGUI.resources.getString("report_subtotalby_none"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.resources.getString("report_subtotalby_day"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.resources.getString("report_subtotalby_week"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.resources.getString("report_subtotalby_month"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.resources.getString("report_subtotalby_year"));
        this.subtotalByChoice.addItem(this.moneydanceGUI.resources.getString("report_subtotalby_account"));
        Calendar calendar = Calendar.getInstance();
        this.startDateField = new JDateField(this.dateFormat);
        this.endDateField = new JDateField(this.dateFormat);
        this.endDateField.setDate(calendar.getTime());
        calendar.set(2, 0);
        calendar.set(5, 1);
        this.startDateField.setDate(calendar.getTime());
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("report_account") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.add((Component)this.subtotalByChoice, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 2, 1, true, false));
        int n = 2;
        int n2 = 0;
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("report_begindate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.startDateField, AwtUtil.getConstraints(n--, n2++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("report_enddate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.endDateField, AwtUtil.getConstraints(n++, n2++, 1.0f, 0.0f, 1, 1, true, false));
    }
}

