/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.PrintJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ReportViewer
extends JPanel {
    public static final int DATE = 0;
    public static final int DESCRIPTION = 1;
    public static final int CHECKNUM = 2;
    public static final int ACCOUNT = 3;
    public static final int CREDIT_AMOUNT = 4;
    public static final int DEBIT_AMOUNT = 5;
    public static final int STATUS = 6;
    public static final int AMOUNT = 7;
    private MoneydanceGUI moneydanceGUI;
    private JPanel headerPanel;
    private JPanel reportPanel;
    private JLabel titleLabel;
    private JLabel dateLabel;
    private AccountPanel parentPanel;
    private RootAccount rootAccount;
    private DateFormat dateFormat;
    private JTable reportTable;
    private ReportTableModel tableModel;
    private char dec;
    private char com;
    private String[] headerNames;
    private ReportCellRenderer reportCellRenderer;
    private String[] fields = new String[0];
    private String title;
    private Account account;
    private int[] columns = new int[0];
    private int accountID;
    private int numDecimals = 4;
    private String currencyPrefix;
    private String currencySuffix;
    private Vector transactions;
    private int groupBy;
    private JFrame parentFrame;

    public void doBalanceReport(String string, long l, CurrencyType currencyType, boolean bl) {
        this.titleLabel.setText(string);
        this.dateLabel.setText(this.moneydanceGUI.resources.getString("as_of") + ": " + this.dateFormat.format(new Date(l)));
        this.numDecimals = currencyType.getDecimalPlaces();
        this.currencyPrefix = currencyType.getPrefix();
        this.currencySuffix = currencyType.getSuffix();
        Hashtable<Integer, AccountData> hashtable = new Hashtable<Integer, AccountData>();
        this.transactions.removeAllElements();
        Enumeration enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            long l2 = transaction.getDate();
            if (l2 > l) continue;
            int n = transaction.getDestAccountId();
            int n2 = transaction.getSourceAccountId();
            Account account = this.rootAccount.getAccountById(n);
            Account account2 = this.rootAccount.getAccountById(n2);
            Integer n3 = new Integer(n);
            AccountData accountData = (AccountData)hashtable.get(n3);
            if (accountData == null) {
                ReportViewer reportViewer = this;
                if (reportViewer == null) {
                    throw null;
                }
                accountData = reportViewer.new AccountData();
                accountData.account = account;
                hashtable.put(n3, accountData);
            }
            accountData.amount += transaction.getAmount(n);
            Integer n4 = new Integer(n2);
            AccountData accountData2 = (AccountData)hashtable.get(n4);
            if (accountData2 == null) {
                ReportViewer reportViewer = this;
                if (reportViewer == null) {
                    throw null;
                }
                accountData2 = reportViewer.new AccountData();
                accountData2.account = account2;
                hashtable.put(n4, accountData2);
            }
            accountData2.amount += transaction.getAmount(n2);
        }
        this.addSubAccounts(this.rootAccount, hashtable, this.transactions, currencyType, this.rootAccount.getCurrencyTable(), bl);
        this.columns = new int[]{3, 7};
        this.tableModel.fireTableStructureChanged();
        this.tableModel.fireTableDataChanged();
        this.setColumnWidths();
        this.reportTable.sizeColumnsToFit(-1);
    }

    private final long addSubAccounts(Account account, Hashtable hashtable, Vector vector, CurrencyType currencyType, CurrencyTable currencyTable, boolean bl) {
        Account account2 = account;
        synchronized (account2) {
            boolean bl2 = false;
            long l = 0L;
            int n = 0;
            while (n < account.getSubAccountCount()) {
                bl2 = true;
                Account account3 = account.getSubAccount(n);
                if (bl || account3.isRegisterAccount()) {
                    AccountData accountData = (AccountData)hashtable.get(new Integer(account3.getAccountNum()));
                    if (accountData == null) {
                        ReportViewer reportViewer = this;
                        if (reportViewer == null) {
                            throw null;
                        }
                        accountData = reportViewer.new AccountData();
                        accountData.account = account3;
                    }
                    CurrencyType currencyType2 = currencyTable.getCurrencyType(accountData.account.getCurrencyType());
                    accountData.amount = currencyTable.convertValue(accountData.amount, currencyType2, currencyType);
                    l += accountData.amount;
                    vector.addElement(accountData);
                    l += this.addSubAccounts(account3, hashtable, vector, currencyType, currencyTable, bl);
                }
                ++n;
            }
            if (bl2) {
                ReportViewer reportViewer = this;
                if (reportViewer == null) {
                    throw null;
                }
                SubTotalRow subTotalRow = reportViewer.new SubTotalRow();
                subTotalRow.label = account.getAccountType() == 0 ? this.moneydanceGUI.resources.getString("report_total") : this.moneydanceGUI.resources.getString("report_subtotal_for") + ": " + account.getFullAccountName();
                subTotalRow.labelColumn = 0;
                subTotalRow.amountColumn = 1;
                subTotalRow.amount = l;
                this.transactions.addElement(subTotalRow);
            }
            long l2 = l;
            Object var8_16 = null;
            return l2;
        }
    }

    public void doTransactionReport(String string, long l, long l2, int n, Account account) {
        CurrencyType currencyType = this.rootAccount.getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.account = account;
        this.accountID = account.getAccountNum();
        this.numDecimals = currencyType.getDecimalPlaces();
        this.currencyPrefix = currencyType.getPrefix();
        this.currencySuffix = currencyType.getSuffix();
        this.titleLabel.setText(string + ": " + account.getFullAccountName());
        this.accountID = account.getAccountNum();
        if (l <= 0L || l2 <= 0L) {
            this.dateLabel.setText("");
        } else {
            this.dateLabel.setText(this.dateFormat.format(new Date(l)) + " - " + this.dateFormat.format(new Date(l2)));
        }
        this.transactions.removeAllElements();
        Enumeration enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            long l3;
            Transaction transaction = (Transaction)enumeration.nextElement();
            if (!account.containsTransaction(transaction, false, true) || (l3 = transaction.getDate()) < l || l3 > l2) continue;
            this.transactions.addElement(transaction);
        }
        this.subtotalTransactions(n, 5, account.getAccountNum());
        this.columns = new int[]{0, 3, 2, 1, 6, 7};
        this.tableModel.fireTableStructureChanged();
        this.tableModel.fireTableDataChanged();
        this.setColumnWidths();
        this.reportTable.sizeColumnsToFit(0);
    }

    private final void subtotalTransactions(int n, int n2, int n3) {
        int n4 = 0;
        if (n == 0 || n == 1 || n == 2 || n == 3 || n == 4) {
            AccountTransactionSet.sortTransactions(this.transactions, 0, n3, this.rootAccount);
            long l = -1L;
            ReportViewer reportViewer = this;
            if (reportViewer == null) {
                throw null;
            }
            SubTotalRow subTotalRow = reportViewer.new SubTotalRow();
            subTotalRow.labelColumn = n4;
            subTotalRow.amountColumn = n2;
            Calendar calendar = Calendar.getInstance();
            int n5 = 0;
            while (n5 < this.transactions.size()) {
                Transaction transaction = (Transaction)this.transactions.elementAt(n5);
                calendar.setTime(new Date(transaction.getDate()));
                if (n == 3) {
                    calendar.set(5, 0);
                } else if (n == 2) {
                    while (calendar.get(7) != calendar.getMinimum(7)) {
                        calendar.roll(7, false);
                    }
                } else if (n == 4) {
                    calendar.set(6, 0);
                }
                calendar.set(11, 12);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                long l2 = calendar.getTime().getTime();
                if (n != 0 && l2 != l && l > 0L) {
                    this.transactions.insertElementAt(subTotalRow, n5++);
                    ReportViewer reportViewer2 = this;
                    if (reportViewer2 == null) {
                        throw null;
                    }
                    this.transactions.insertElementAt(reportViewer2.new BlankRow(), n5++);
                    ReportViewer reportViewer3 = this;
                    if (reportViewer3 == null) {
                        throw null;
                    }
                    subTotalRow = reportViewer3.new SubTotalRow();
                    subTotalRow.labelColumn = n4;
                    subTotalRow.amountColumn = n2;
                }
                l = l2;
                long l3 = transaction.getAmount(n3);
                subTotalRow.amount += l3;
                ++n5;
            }
            if (l > 0L && n != 0) {
                this.transactions.addElement(subTotalRow);
                ReportViewer reportViewer4 = this;
                if (reportViewer4 == null) {
                    throw null;
                }
                this.transactions.addElement(reportViewer4.new BlankRow());
            }
        } else {
            AccountTransactionSet.sortTransactions(this.transactions, 5, this.account.getAccountNum(), this.rootAccount);
            int n6 = -1;
            ReportViewer reportViewer = this;
            if (reportViewer == null) {
                throw null;
            }
            SubTotalRow subTotalRow = reportViewer.new SubTotalRow();
            subTotalRow.labelColumn = n4;
            subTotalRow.amountColumn = n2;
            int n7 = 0;
            while (n7 < this.transactions.size()) {
                Transaction transaction = (Transaction)this.transactions.elementAt(n7);
                if (n7 != 0 && transaction.getAccountId(n3) != n6) {
                    this.transactions.insertElementAt(subTotalRow, n7++);
                    ReportViewer reportViewer5 = this;
                    if (reportViewer5 == null) {
                        throw null;
                    }
                    this.transactions.insertElementAt(reportViewer5.new BlankRow(), n7++);
                    ReportViewer reportViewer6 = this;
                    if (reportViewer6 == null) {
                        throw null;
                    }
                    subTotalRow = reportViewer6.new SubTotalRow();
                    subTotalRow.labelColumn = n4;
                    subTotalRow.amountColumn = n2;
                }
                n6 = transaction.getAccountId(n3);
                subTotalRow.amount += transaction.getAmount(n3);
                ++n7;
            }
            this.transactions.addElement(subTotalRow);
            ReportViewer reportViewer7 = this;
            if (reportViewer7 == null) {
                throw null;
            }
            this.transactions.addElement(reportViewer7.new BlankRow());
        }
    }

    private final void setColumnWidths() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        while (n < this.columns.length) {
            TableColumn tableColumn = this.reportTable.getColumnModel().getColumn(n);
            int n2 = this.columns[n];
            tableColumn.setCellRenderer(this.reportCellRenderer);
            if (n2 == 6) {
                tableColumn.setMaxWidth(10);
            } else if (n2 == 0) {
                tableColumn.setMaxWidth(fontMetrics.stringWidth(this.dateFormat.format(new Date())) + 25);
            }
            ++n;
        }
    }

    private final String htmlify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == ' ') {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "nbsp;");
                n += "nbsp;".length();
            } else if (c == '<') {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "lt;");
                n += "lt;".length();
            } else if (c == '>') {
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "gt;");
                n += "gt;".length();
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveReport() {
        FileDialog fileDialog = new FileDialog((Frame)this.parentFrame, this.moneydanceGUI.resources.getString("choose_report_file_title"), 1);
        ReportViewer reportViewer = this;
        if (reportViewer == null) {
            throw null;
        }
        fileDialog.setFilenameFilter(reportViewer.new HtmlFilenameFilter());
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) return;
        if (string2 == null) {
            return;
        }
        try {
            File file = new File(string2, string);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("");
            printStream.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional\">");
            printStream.println("<HTML>");
            printStream.println("<HEAD>");
            printStream.println("   <META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-1\">");
            printStream.println("   <META NAME=\"GENERATOR\" CONTENT=\"Moneydance\">");
            printStream.println("   <TITLE>Moneydance Report</TITLE>");
            printStream.println("</HEAD>");
            printStream.println("<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#0000AA\" ALINK=\"#FFFF00\">");
            printStream.println("&nbsp;");
            printStream.println("<CENTER>");
            printStream.println("  <H1>" + this.htmlify(this.titleLabel.getText()) + "</H1>");
            printStream.println("  <H3>" + this.htmlify(this.dateLabel.getText()) + "</H3>");
            printStream.println("</CENTER>\n<P>");
            printStream.println("<TABLE WIDTH=\"100%\" CELLSPACING=\"0\">");
            printStream.println(" <TR>");
            int n = 0;
            while (n < this.reportTable.getColumnCount()) {
                printStream.println("  <TH BGCOLOR=\"#AAAAAA\" ALIGN=\"CENTER\">" + this.htmlify(this.reportTable.getColumnName(n)) + "</TH>");
                ++n;
            }
            printStream.println(" </TR>");
            n = 0;
            while (n < this.transactions.size()) {
                printStream.println(" <TR>");
                Object e = this.transactions.elementAt(n);
                boolean bl = e instanceof SubTotalRow;
                if (!(e instanceof BlankRow)) {
                    int n2 = 0;
                    while (n2 < this.columns.length) {
                        int n3;
                        Object object = this.reportTable.getValueAt(n, n2);
                        String string3 = String.valueOf(object);
                        int n4 = this.reportTable.convertColumnIndexToModel(n2);
                        String string4 = "LEFT";
                        String string5 = null;
                        String string6 = "#FFFFFF";
                        if (e instanceof SubTotalRow) {
                            string6 = "#CCCCCC";
                        }
                        if ((n3 = this.columns[n4]) == 6) {
                            string4 = "CENTER";
                        } else if (n3 == 4 || n3 == 5 || n3 == 7) {
                            string4 = "RIGHT";
                            if (string3.indexOf(45) >= 0) {
                                string5 = "red";
                            }
                        } else {
                            string4 = "LEFT";
                        }
                        printStream.print("  <TD BGCOLOR=\"" + string6 + "\" ALIGN=\"" + string4 + "\">");
                        if (string5 != null) {
                            printStream.print("<FONT COLOR=\"" + string5 + "\">");
                        }
                        if (bl) {
                            printStream.print("<B>");
                        }
                        printStream.print("&nbsp;" + this.htmlify(string3));
                        if (bl) {
                            printStream.print("</B>");
                        }
                        if (string5 != null) {
                            printStream.print("</FONT>");
                        }
                        printStream.println("</TD>");
                        ++n2;
                    }
                }
                printStream.println(" </TR>");
                ++n;
            }
            printStream.println("</TABLE>");
            printStream.println("<HR>");
            printStream.println("<i>" + this.htmlify(this.moneydanceGUI.resources.getString("report_generated")) + ": " + this.htmlify(String.valueOf(new Date())) + "<br>");
            printStream.println(this.htmlify("Moneydance 2.0b5") + "</i>");
            printStream.println("</BODY>");
            printStream.println("</HTML>");
            printStream.close();
            return;
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.parentFrame, this.moneydanceGUI.resources.getString("err_save_report") + ": " + exception);
        }
    }

    public void printReport() {
        PrintJob printJob = this.getToolkit().getPrintJob(this.parentFrame, this.moneydanceGUI.resources.getString("report_print_txt"), new Properties());
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        int n = 5;
        int n2 = 40;
        int n3 = 40;
        int n4 = 20;
        int n5 = 20;
        int n6 = 20;
        Graphics graphics = printJob.getGraphics();
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() + 4);
        Font font3 = new Font(font.getName(), 1, font.getSize() + 2);
        Font font4 = new Font(font.getName(), 1, font.getSize());
        Font font5 = new Font(font.getName(), 0, 10);
        Font font6 = font4;
        graphics.setColor(Color.black);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = this.titleLabel.getText();
        graphics.drawString(string, dimension.width / 2 - fontMetrics.stringWidth(string) / 2, (n6 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5) - fontMetrics.getMaxDescent() - 1);
        graphics.setFont(font3);
        fontMetrics = graphics.getFontMetrics();
        String string2 = this.dateLabel.getText();
        graphics.drawString(string2, dimension.width / 2 - fontMetrics.stringWidth(string2) / 2, (n6 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5) - fontMetrics.getMaxDescent() - 1);
        n6 += 30;
        JTableHeader jTableHeader = this.reportTable.getTableHeader();
        TableColumnModel tableColumnModel = this.reportTable.getColumnModel();
        int n7 = 0;
        while (n7 < this.transactions.size()) {
            int n8;
            graphics.setFont(font6);
            fontMetrics = graphics.getFontMetrics();
            graphics.setColor(Color.lightGray);
            graphics.fillRect(40, (n6 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5) - (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5), dimension.width - 80, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5);
            graphics.setColor(Color.black);
            graphics.drawRect(40, n6 - (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5), dimension.width - 80, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 5);
            int n9 = dimension.width - 40 - 40;
            int n10 = this.reportTable.getSize().width;
            double d = (double)n9 / (double)n10;
            int n11 = 40;
            int n12 = 0;
            while (n12 < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn = tableColumnModel.getColumn(this.reportTable.convertColumnIndexToModel(n12));
                n8 = (int)((double)tableColumn.getWidth() * d);
                int n13 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5;
                String string3 = this.reportTable.getColumnName(n12);
                graphics.setClip(n11, n6 - n13, n8, n13);
                graphics.drawString(string3, n11 + n8 / 2 - fontMetrics.stringWidth(string3) / 2, n6 - fontMetrics.getMaxDescent() - 1);
                n11 += n8;
                ++n12;
            }
            graphics.setClip(0, 0, dimension.width, dimension.height);
            graphics.setFont(font5);
            while (n7 < this.transactions.size() && n6 < dimension.height - 20) {
                n11 = 40;
                n12 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 5;
                int n14 = 0;
                while (n14 < tableColumnModel.getColumnCount()) {
                    n8 = this.reportTable.convertColumnIndexToModel(n14);
                    TableColumn tableColumn = tableColumnModel.getColumn(n8);
                    int n15 = (int)((double)tableColumn.getWidth() * d);
                    TableCellRenderer tableCellRenderer = this.reportTable.getCellRenderer(n7, n14);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.reportTable, this.tableModel.getValueAt(n7, n8), false, false, n7, n8);
                    component.setSize(n15, n12);
                    component.paint(graphics.create(n11, n6, n15, n12));
                    n11 += n15;
                    ++n14;
                }
                n6 += n12;
                ++n7;
            }
            if (n7 >= this.transactions.size()) continue;
            graphics.dispose();
            graphics = printJob.getGraphics();
            n6 = 20;
        }
        graphics.dispose();
        printJob.end();
    }

    /* synthetic */ Vector access$0() {
        return this.transactions;
    }

    /* synthetic */ int[] access$1() {
        return this.columns;
    }

    /* synthetic */ String[] access$2() {
        return this.headerNames;
    }

    /* synthetic */ DateFormat access$3() {
        return this.dateFormat;
    }

    /* synthetic */ int access$4() {
        return this.accountID;
    }

    /* synthetic */ RootAccount access$5() {
        return this.rootAccount;
    }

    /* synthetic */ MoneydanceGUI access$6() {
        return this.moneydanceGUI;
    }

    /* synthetic */ char access$7() {
        return this.dec;
    }

    /* synthetic */ char access$8() {
        return this.com;
    }

    /* synthetic */ int access$9() {
        return this.numDecimals;
    }

    /* synthetic */ String access$10() {
        return this.currencyPrefix;
    }

    /* synthetic */ String access$11() {
        return this.currencySuffix;
    }

    public ReportViewer(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, JFrame jFrame) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.parentFrame = jFrame;
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.setBackground(Color.white);
        this.transactions = new Vector();
        this.title = "";
        this.account = rootAccount;
        this.accountID = this.account.getAccountNum();
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.headerNames = new String[]{this.moneydanceGUI.resources.getString("table_column_date"), this.moneydanceGUI.resources.getString("table_column_description"), this.moneydanceGUI.resources.getString("table_column_checknum"), this.moneydanceGUI.resources.getString("table_column_account"), this.moneydanceGUI.resources.getString("table_column_credit"), this.moneydanceGUI.resources.getString("table_column_debit"), this.moneydanceGUI.resources.getString("table_column_clearedchar"), this.moneydanceGUI.resources.getString("table_column_amount")};
        ReportViewer reportViewer = this;
        if (reportViewer == null) {
            throw null;
        }
        this.tableModel = reportViewer.new ReportTableModel();
        this.reportTable = new JTable(this.tableModel);
        this.reportTable.setAutoCreateColumnsFromModel(true);
        this.reportTable.setRowSelectionAllowed(false);
        this.reportTable.setShowGrid(false);
        ReportViewer reportViewer2 = this;
        if (reportViewer2 == null) {
            throw null;
        }
        this.reportCellRenderer = reportViewer2.new ReportCellRenderer();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.headerPanel = new JPanel(gridBagLayout);
        this.headerPanel.setBackground(Color.white);
        this.reportPanel = new JPanel(gridBagLayout);
        this.reportPanel.setBackground(Color.white);
        this.add((Component)this.headerPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.reportPanel, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 2, 1, true, true));
        this.titleLabel = new JLabel("", 0);
        this.dateLabel = new JLabel("", 0);
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(new Font(font.getName(), 1, font.getSize() + 6));
        this.headerPanel.add((Component)this.titleLabel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.headerPanel.add((Component)this.dateLabel, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        this.reportPanel.add((Component)new JScrollPane(this.reportTable), AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
    }

    class HtmlFilenameFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string != null && string.toUpperCase().endsWith(".HTML");
        }

        HtmlFilenameFilter() {
        }
    }

    class TotalItem {
        int numColumns;
        String totalName;
        long total;

        TotalItem() {
        }
    }

    class BlankRow {
        BlankRow() {
        }
    }

    class SubTotalRow {
        String label = "";
        int labelColumn = 1;
        int amountColumn = 0;
        int debitColumn = 0;
        int creditColumn = 0;
        long amount = 0L;
        long creditAmount = 0L;
        long debitAmount = 0L;

        SubTotalRow() {
        }
    }

    class ReportCellRenderer
    extends DefaultTableCellRenderer {
        Font subtFont = null;
        Font normalFont = null;
        Font theFont = null;
        boolean isSubtotal = false;
        String label = "";
        int alignment = 2;
        boolean isSelected = false;
        boolean hasFocus = false;
        boolean isBlankRow = false;
        Color fgColor = Color.black;

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.isSelected) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (this.hasFocus) {
                graphics.setColor(Color.gray);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            if (this.isBlankRow) {
                return;
            }
            graphics.setColor(Color.black);
            if (this.isSubtotal) {
                graphics.drawLine(0, 0, this.getSize().width + 1, 0);
            }
            FontMetrics fontMetrics = this.getFontMetrics(this.theFont);
            graphics.setFont(this.theFont);
            graphics.setColor(this.fgColor);
            if (this.alignment == 0) {
                graphics.drawString(this.label, dimension.width / 2 - fontMetrics.stringWidth(this.label) / 2, dimension.height - fontMetrics.getMaxDescent() - 1);
            } else if (this.alignment == 4) {
                graphics.drawString(this.label, dimension.width - fontMetrics.stringWidth(this.label) - 2, dimension.height - fontMetrics.getMaxDescent() - 1);
            } else {
                graphics.drawString(this.label, 2, dimension.height - fontMetrics.getMaxDescent() - 1);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.isSelected = bl;
            this.hasFocus = bl2;
            this.fgColor = Color.black;
            this.label = String.valueOf(object);
            Object e = ReportViewer.this.access$0().elementAt(n);
            if (e instanceof SubTotalRow) {
                this.theFont = this.subtFont;
                this.isSubtotal = true;
                this.isBlankRow = false;
            } else if (e instanceof BlankRow) {
                this.isBlankRow = true;
            } else {
                this.theFont = this.normalFont;
                this.isSubtotal = false;
                this.isBlankRow = false;
            }
            if (this.isBlankRow) {
                return this;
            }
            int n3 = ReportViewer.this.access$1()[n2];
            if (n3 == 6) {
                this.alignment = 0;
            } else if (n3 == 4 || n3 == 5 || n3 == 7) {
                this.alignment = 4;
                if (this.label.indexOf(45) >= 0) {
                    this.fgColor = Color.red;
                }
            } else {
                this.alignment = 2;
            }
            return this;
        }

        public ReportCellRenderer() {
            Font font = this.getFont();
            this.subtFont = new Font(font.getName(), 1, font.getSize());
            this.normalFont = new Font(font.getName(), 0, font.getSize());
        }
    }

    class ReportTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return ReportViewer.this.access$0().size();
        }

        public String getColumnName(int n) {
            return ReportViewer.this.access$2()[ReportViewer.this.access$1()[n]];
        }

        public int getColumnCount() {
            return ReportViewer.this.access$1().length;
        }

        public Object getValueAt(int n, int n2) {
            Object e = ReportViewer.this.access$0().elementAt(n);
            if (e == null) {
                return "???";
            }
            if (e instanceof Transaction) {
                Transaction transaction = (Transaction)e;
                int n3 = ReportViewer.this.access$1()[n2];
                switch (n3) {
                    case 0: {
                        return ReportViewer.this.access$3().format(new Date(transaction.getDate()));
                    }
                    case 1: {
                        return transaction.getDescription();
                    }
                    case 2: {
                        if (transaction instanceof BankTransaction) {
                            return ((BankTransaction)transaction).getCheckNumber();
                        }
                        return "";
                    }
                    case 3: {
                        Account account = ReportViewer.this.access$5().getAccountById(transaction.getAccountId(ReportViewer.this.access$4()));
                        return account == null ? "[" + ReportViewer.this.access$6().resources.getString("split") + "]" : account.getFullAccountName();
                    }
                    case 7: {
                        return StringUtils.formatCurrency(transaction.getAmount(ReportViewer.this.access$4()), true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9());
                    }
                    case 4: {
                        long l = transaction.getAmount(ReportViewer.this.access$4());
                        return l > 0L ? StringUtils.formatCurrency(l, true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9()) : "";
                    }
                    case 5: {
                        long l = transaction.getAmount(ReportViewer.this.access$4());
                        return l <= 0L ? StringUtils.formatCurrency(-l, true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9()) : "";
                    }
                    case 6: {
                        return String.valueOf(transaction.getClearedStatus(ReportViewer.this.access$4()));
                    }
                }
                return "???";
            }
            if (e instanceof SubTotalRow) {
                SubTotalRow subTotalRow = (SubTotalRow)e;
                if (n2 == subTotalRow.labelColumn) {
                    return subTotalRow.label;
                }
                if (n2 == subTotalRow.amountColumn) {
                    return (ReportViewer.this.access$10() + " " + StringUtils.formatCurrency(subTotalRow.amount, true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9()) + " " + ReportViewer.this.access$11()).trim();
                }
                if (n2 == subTotalRow.debitColumn) {
                    return (ReportViewer.this.access$10() + " " + StringUtils.formatCurrency(subTotalRow.debitAmount, true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9()) + " " + ReportViewer.this.access$11()).trim();
                }
                if (n2 == subTotalRow.creditColumn) {
                    return (ReportViewer.this.access$10() + " " + StringUtils.formatCurrency(subTotalRow.creditAmount, true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9()) + " " + ReportViewer.this.access$11()).trim();
                }
                return "";
            }
            if (e instanceof AccountData) {
                AccountData accountData = (AccountData)e;
                int n4 = ReportViewer.this.access$1()[n2];
                switch (n4) {
                    case 3: {
                        return accountData.account.toString();
                    }
                    case 7: {
                        return StringUtils.formatCurrency(accountData.amount, true, ReportViewer.this.access$7(), ReportViewer.this.access$8(), ReportViewer.this.access$9());
                    }
                }
                return "???";
            }
            return "?????";
        }

        ReportTableModel() {
        }
    }

    class AccountData {
        Account account;
        long amount = 0L;

        AccountData() {
        }
    }
}

