/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.reporttool.BalancesSettingsPanel;
import com.seanreilly.apps.moneydance.view.gui.reporttool.ReportViewer;
import com.seanreilly.apps.moneydance.view.gui.reporttool.TransactionsSettingsPanel;
import com.seanreilly.awt.AwtUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class ReportTool
extends JFrame
implements ActionListener,
AccountInfoListener,
ItemListener {
    private MoneydanceGUI moneydanceGUI;
    private RootAccount rootAccount;
    private JPanel[] settingsPanels;
    private JPanel currentSettingsPanel = null;
    private JPanel settingsPanel;
    private JPanel buttonPanel;
    private JComboBox reportTypeChoice;
    private ReportViewer reportViewer;
    private JButton updateButton;
    private JButton doneButton;
    private JButton printButton;
    private JButton saveButton;
    private AccountPanel parentPanel;
    private char dec;
    private char com;

    public void accountInfoUpdated(Object object) {
        this.rebuildReport();
    }

    private final void finishUp() {
        this.parentPanel.reporterIsDone(this);
    }

    private final void setSettingsType() {
        int n = this.reportTypeChoice.getSelectedIndex();
        if (this.currentSettingsPanel != null) {
            this.settingsPanel.remove(this.currentSettingsPanel);
        }
        this.currentSettingsPanel = this.settingsPanels[n];
        this.settingsPanel.add(this.currentSettingsPanel);
        this.validate();
    }

    private final void rebuildReport() {
        int n = this.reportTypeChoice.getSelectedIndex();
        if (n == 0) {
            TransactionsSettingsPanel transactionsSettingsPanel = (TransactionsSettingsPanel)this.settingsPanels[0];
            long l = transactionsSettingsPanel.endDateField.getDate().getTime();
            long l2 = transactionsSettingsPanel.startDateField.getDate().getTime();
            int n2 = transactionsSettingsPanel.subtotalByChoice.getSelectedIndex();
            String string = String.valueOf(this.reportTypeChoice.getSelectedItem());
            Account account = (Account)transactionsSettingsPanel.accountChoice.getSelectedItem();
            this.reportViewer.doTransactionReport(string, l2, l, n2, account);
        } else if (n == 1) {
            BalancesSettingsPanel balancesSettingsPanel = (BalancesSettingsPanel)this.settingsPanels[1];
            CurrencyType currencyType = (CurrencyType)balancesSettingsPanel.currencyChoice.getSelectedItem();
            long l = balancesSettingsPanel.endDateField.getDate().getTime();
            boolean bl = balancesSettingsPanel.showAllAcountsCheckBox.isSelected();
            this.reportViewer.doBalanceReport(this.moneydanceGUI.resources.getString("report_balances"), l, currencyType, bl);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null && itemEvent.getSource() == this.reportTypeChoice) {
            this.setSettingsType();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doneButton) {
            this.finishUp();
        } else if (actionEvent.getSource() == this.updateButton) {
            this.rebuildReport();
        } else if (actionEvent.getSource() == this.printButton) {
            this.reportViewer.printReport();
        } else if (actionEvent.getSource() == this.saveButton) {
            this.reportViewer.saveReport();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.finishUp();
        }
        super.processEvent(aWTEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportTool(MoneydanceGUI moneydanceGUI, Account account, AccountPanel accountPanel) {
        super(moneydanceGUI.resources.getString("report_win_title") + ": " + account.getAccountName());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = account.getRootAccount();
        this.parentPanel = accountPanel;
        try {
            this.setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.reportTypeChoice = new JComboBox();
        this.reportTypeChoice.addItem(this.moneydanceGUI.resources.getString("report_transactions"));
        this.reportTypeChoice.addItem(this.moneydanceGUI.resources.getString("report_balances"));
        this.settingsPanels = new JPanel[2];
        this.settingsPanels[0] = new TransactionsSettingsPanel(this.moneydanceGUI, this.rootAccount, account);
        this.settingsPanels[1] = new BalancesSettingsPanel(this.moneydanceGUI, this.rootAccount, account);
        this.doneButton = new JButton(moneydanceGUI.resources.getString("report_done"));
        this.printButton = new JButton(moneydanceGUI.resources.getString("report_print"));
        this.saveButton = new JButton(moneydanceGUI.resources.getString("report_save"));
        this.updateButton = new JButton(moneydanceGUI.resources.getString("report_update"));
        this.settingsPanel = new JPanel(gridBagLayout);
        this.settingsPanel.setBorder(new EtchedBorder());
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        this.reportViewer = new ReportViewer(this.moneydanceGUI, this.rootAccount, this);
        this.buttonPanel = new JPanel(gridBagLayout);
        this.getContentPane().add(jPanel2);
        jPanel2.add((Component)jPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 3, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.settingsPanel, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.reportViewer, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 3, 1, true, true));
        jPanel2.add((Component)this.buttonPanel, AwtUtil.getConstraints(0, 3, 1.0f, 0.0f, 3, 1, true, false));
        this.buttonPanel.add((Component)this.saveButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.buttonPanel.add((Component)this.printButton, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.buttonPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.buttonPanel.add((Component)this.doneButton, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("report_type") + ": ", 4), AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.reportTypeChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, false, 17));
        int n = 0;
        int n2 = 0;
        while (n2 < this.settingsPanels.length) {
            gridBagLayout.setConstraints(this.settingsPanels[n2], AwtUtil.getConstraints(0, n, 1.0f, 0.0f, 4, 1, false, true));
            ++n2;
        }
        this.settingsPanel.add((Component)this.updateButton, AwtUtil.getConstraints(0, ++n, 1.0f, 0.0f, 4, 1, true, true));
        this.saveButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.reportTypeChoice.addItemListener(this);
        ((Component)this).setSize(650, 600);
        this.setSettingsType();
        this.rebuildReport();
    }
}

