/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.reporttool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JDateField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BalancesSettingsPanel
extends JPanel {
    MoneydanceGUI moneydanceGUI;
    JDateField endDateField;
    JComboBox currencyChoice;
    JCheckBox showAllAcountsCheckBox;
    private DateFormat dateFormat;
    private RootAccount rootAccount;
    private CurrencyModel currencyModel;

    public BalancesSettingsPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, Account account) {
        super(new GridBagLayout());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        Calendar calendar = Calendar.getInstance();
        this.endDateField = new JDateField(this.dateFormat);
        this.endDateField.setDate(calendar.getTime());
        CurrencyTable currencyTable = rootAccount.getCurrencyTable();
        this.currencyModel = new CurrencyModel(currencyTable);
        this.currencyChoice = new JComboBox(this.currencyModel);
        this.currencyModel.setSelectedItem(currencyTable.getBaseType());
        this.showAllAcountsCheckBox = new JCheckBox(this.moneydanceGUI.resources.getString("report_show_all_accts"), false);
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("report_asofdate") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.endDateField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("currency") + ": ", 4), AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.currencyChoice, AwtUtil.getConstraints(3, 0, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.showAllAcountsCheckBox, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 4, 1, true, false));
    }
}

