/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui.graphtool;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.graphtool.AccountData;
import com.seanreilly.apps.moneydance.view.gui.graphtool.DataSetGroup;
import com.seanreilly.apps.moneydance.view.gui.graphtool.TopAccountsSettingsPanel;
import com.seanreilly.apps.moneydance.view.gui.graphtool.TopIncomesSettingsPanel;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JDateField;
import com.seanreilly.awt.graph.BarGraphPanel;
import com.seanreilly.awt.graph.ColorEnumerator;
import com.seanreilly.awt.graph.DataSet;
import com.seanreilly.awt.graph.KeyItem;
import com.seanreilly.awt.graph.KeyPanel;
import com.seanreilly.awt.graph.LineGraphPanel;
import com.seanreilly.awt.graph.PieGraphPanel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class GraphTool
extends JFrame
implements ActionListener,
AccountInfoListener,
ItemListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private MoneydanceGUI moneydanceGUI;
    private RootAccount rootAccount;
    private AccountListModel accountModel;
    private JPanel[] settingsPanels;
    private JPanel currentSettingsPanel = null;
    private JPanel settingsPanel;
    private JPanel bottomGraphPanel;
    private JPanel topGraphPanel;
    private JComboBox accountChoice;
    private JComboBox graphTypeChoice;
    private JComboBox groupByChoice;
    private JButton doneButton;
    private JButton updateButton;
    private AccountPanel parentPanel;
    private JComboBox lineOrPieChoice;
    private JDateField startDateField;
    private JDateField endDateField;
    private LineGraphPanel lineGraph;
    private BarGraphPanel barGraph;
    private PieGraphPanel pieGraph;
    private KeyPanel key;
    private char dec;
    private char com;
    private GridBagConstraints graphConstraints;
    private long lastStartDate;
    private long lastEndDate;

    public void accountInfoUpdated(Object object) {
        this.rebuildGraph();
    }

    private final void finishUp() {
        this.parentPanel.grapherIsDone(this);
    }

    private final void setSettingsType() {
        int n = this.graphTypeChoice.getSelectedIndex();
        if (this.currentSettingsPanel != null) {
            this.settingsPanel.remove(this.currentSettingsPanel);
        }
        if (n == 3) {
            this.lineOrPieChoice.setSelectedIndex(0);
            this.lineOrPieChoice.setEnabled(false);
            this.groupByChoice.setEnabled(false);
        } else {
            this.lineOrPieChoice.setEnabled(true);
            this.groupByChoice.setEnabled(true);
        }
        this.currentSettingsPanel = this.settingsPanels[n];
        this.settingsPanel.add(this.currentSettingsPanel);
        this.validate();
    }

    private final void rebuildGraph() {
        boolean bl;
        this.lastEndDate = this.endDateField.getDate().getTime();
        this.lastStartDate = this.startDateField.getDate().getTime();
        int n = this.graphTypeChoice.getSelectedIndex();
        DataSetGroup[] dataSetGroupArray = null;
        if (n == 0) {
            dataSetGroupArray = this.rebuildTopExpenseGraph();
        } else if (n == 1) {
            dataSetGroupArray = this.rebuildTopIncomeGraph();
        } else if (n == 2) {
            dataSetGroupArray = this.rebuildIncomeExpenseGraph();
        } else if (n == 3) {
            dataSetGroupArray = this.rebuildAccountBalanceGraph();
        }
        this.barGraph.removeAllDataSets();
        this.lineGraph.removeAllDataSets();
        this.pieGraph.removeAllDataSets();
        this.key.removeAllKeyItems();
        int n2 = this.groupByChoice.getSelectedIndex();
        boolean bl2 = bl = this.lineOrPieChoice.getSelectedIndex() == 0;
        if (dataSetGroupArray != null) {
            ColorEnumerator colorEnumerator = new ColorEnumerator();
            int n3 = 0;
            while (n3 < dataSetGroupArray.length) {
                Color color = colorEnumerator.nextColor();
                if (bl) {
                    this.lineGraph.addDataSetGraph(dataSetGroupArray[n3].lineDataSet, color);
                } else {
                    this.barGraph.addDataSetGraph(dataSetGroupArray[n3].lineDataSet, color);
                }
                if (dataSetGroupArray[n3].pieDataSet != null) {
                    this.pieGraph.addDataSetGraph(dataSetGroupArray[n3].pieDataSet, color);
                }
                this.key.addKeyItem(new KeyItem(dataSetGroupArray[n3].lineDataSet.getName(), dataSetGroupArray[n3].lineDataSet, color));
                ++n3;
            }
        }
        this.bottomGraphPanel.removeAll();
        if (bl) {
            this.bottomGraphPanel.add(this.lineGraph);
        } else {
            if (n2 == 0) {
                this.barGraph.setInterval(-1);
            } else if (n2 == 1) {
                this.barGraph.setInterval(-2);
            } else if (n2 == 2) {
                this.barGraph.setInterval(-3);
            } else {
                this.barGraph.setInterval(-4);
            }
            this.bottomGraphPanel.add(this.barGraph);
        }
        this.validate();
        if (bl) {
            this.lineGraph.renderGraph();
        } else {
            this.barGraph.renderGraph();
        }
        this.pieGraph.renderGraph();
        this.key.renderKey();
    }

    private final DataSetGroup txn2DataSet(Vector vector, Account account, Account account2, boolean bl) {
        int n = account.getAccountNum();
        CurrencyType currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        DataSet.setCurrencyNumDecimalPlaces(currencyType.getDecimalPlaces());
        DataSet.setDecimalChar(this.dec);
        DataSet.setCommaChar(this.com);
        String string = account2 != null ? account2.getFullAccountName() : (!bl ? this.moneydanceGUI.resources.getString("graph_income") : this.moneydanceGUI.resources.getString("graph_expenses"));
        DataSet dataSet = new DataSet(string, 1, 1, 2);
        dataSet.yvalues[0] = new Long(0L);
        int n2 = this.groupByChoice.getSelectedIndex();
        AccountTransactionSet.sortTransactions(vector, 0, n, this.rootAccount);
        DateValuePair dateValuePair = null;
        Calendar calendar = Calendar.getInstance();
        Vector<DateValuePair> vector2 = new Vector<DateValuePair>();
        long l = 0L;
        int n3 = 0;
        while (n3 < vector.size()) {
            Transaction transaction = (Transaction)vector.elementAt(n3);
            l = transaction.getDate();
            calendar.setTime(new Date(transaction.getDate()));
            calendar.set(16, calendar.getMinimum(16));
            calendar.set(10, calendar.getMinimum(10) + 2);
            calendar.set(12, calendar.getMinimum(12));
            calendar.set(13, calendar.getMinimum(13));
            calendar.set(14, calendar.getMinimum(14));
            boolean bl2 = false;
            if (n2 != 0) {
                if (n2 == 1) {
                    while (calendar.get(7) != calendar.getMinimum(7)) {
                        calendar.roll(7, false);
                    }
                } else if (n2 == 2) {
                    calendar.set(5, calendar.getMinimum(5));
                } else if (n2 == 3) {
                    calendar.set(6, calendar.getMinimum(6));
                }
            }
            calendar.set(10, calendar.getMinimum(10) + 2);
            long l2 = calendar.getTime().getTime();
            if (bl2 || dateValuePair == null || l2 - dateValuePair.date < -3600000L || l2 - dateValuePair.date > 3600000L) {
                if (dateValuePair != null) {
                    vector2.addElement(dateValuePair);
                }
                GraphTool graphTool = this;
                if (graphTool == null) {
                    throw null;
                }
                dateValuePair = graphTool.new DateValuePair(calendar.getTime().getTime(), transaction.getAmount(n) * (long)(bl ? -1 : 1));
            } else {
                dateValuePair.value = dateValuePair.value + transaction.getAmount(n) * (long)(bl ? -1 : 1);
            }
            ++n3;
        }
        if (dateValuePair != null) {
            vector2.addElement(dateValuePair);
        }
        DataSet dataSet2 = new DataSet(string, vector2.size(), 1, 2);
        int n4 = 0;
        while (n4 < vector2.size()) {
            DateValuePair dateValuePair2 = (DateValuePair)vector2.elementAt(n4);
            dataSet2.xvalues[n4] = new Long(dateValuePair2.date);
            dataSet2.yvalues[n4] = new Long(dateValuePair2.value);
            dataSet.xvalues[0] = new Long(0L);
            dataSet.yvalues[0] = new Long(dataSet.yvalues[0].longValue() + dateValuePair2.value);
            ++n4;
        }
        return new DataSetGroup(dataSet2, dataSet);
    }

    private final DataSetGroup balance2DataSet(Vector vector, Account account, boolean bl) {
        CurrencyType currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        DataSet.setCurrencyNumDecimalPlaces(currencyType.getDecimalPlaces());
        DataSet.setDecimalChar(this.dec);
        DataSet.setCommaChar(this.com);
        String string = account.getFullAccountName();
        DataSet dataSet = new DataSet(string, vector.size(), 1, 2);
        int n = 0;
        while (n < vector.size()) {
            DateBalance dateBalance = (DateBalance)vector.elementAt(n);
            dataSet.xvalues[n] = new Long(dateBalance.date);
            dataSet.yvalues[n] = new Long(bl ? dateBalance.balance * -1L : dateBalance.balance);
            ++n;
        }
        return new DataSetGroup(dataSet, null);
    }

    private final DataSetGroup[] rebuildTopExpenseGraph() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        Account account = (Account)this.accountChoice.getSelectedItem();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        int n2 = (Integer)((TopAccountsSettingsPanel)this.settingsPanels[0]).topNumChoice.getSelectedItem();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object4 = this.rootAccount.getTransactionSet().getAllTransactions();
        while (object4.hasMoreElements()) {
            long l3;
            Transaction transaction = (Transaction)object4.nextElement();
            if (!account.containsTransaction(transaction, false, false) || (l3 = transaction.getDate()) < l || l3 > l2) continue;
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : GraphTool.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && ((BankTransaction)transaction).getSplitCount() > 0) {
                object3 = (BankTransaction)transaction;
                int n3 = 0;
                while (n3 < ((BankTransaction)object3).getSplitCount()) {
                    object2 = ((BankTransaction)object3).getSplit(n3);
                    object = new Integer(((Transaction)object2).getSourceAccountId());
                    AccountData accountData = (AccountData)hashtable.get(object);
                    if (accountData == null) {
                        accountData = new AccountData();
                        accountData.accountID = ((Transaction)object2).getSourceAccountId();
                        accountData.total = ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                        hashtable.put(object, accountData);
                    } else {
                        accountData.total += ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                    }
                    ++n3;
                }
                continue;
            }
            object = new Integer(transaction.getAccountId(n));
            object3 = (AccountData)hashtable.get(object);
            if (object3 == null) {
                object3 = new AccountData();
                ((AccountData)object3).accountID = transaction.getAccountId(n);
                ((AccountData)object3).total = transaction.getAmount(n);
                ((AccountData)object3).transactions.addElement(transaction);
                hashtable.put(object, object3);
                continue;
            }
            ((AccountData)object3).total += transaction.getAmount(n);
            ((AccountData)object3).transactions.addElement(transaction);
        }
        object4 = new Vector();
        int n4 = 0;
        while (n4 < n2) {
            if (hashtable.size() <= 0) break;
            boolean bl = true;
            long l4 = 0L;
            object3 = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (AccountData)enumeration.nextElement();
                if (bl) {
                    l4 = ((AccountData)object2).total;
                    object3 = object2;
                    bl = false;
                    continue;
                }
                if (((AccountData)object2).total >= l4) continue;
                object3 = object2;
                l4 = ((AccountData)object2).total;
            }
            if (((AccountData)object3).total >= 0L) break;
            ((Vector)object4).addElement(object3);
            hashtable.remove(new Integer(((AccountData)object3).accountID));
            ++n4;
        }
        DataSetGroup[] dataSetGroupArray = new DataSetGroup[((Vector)object4).size()];
        int n5 = 0;
        while (n5 < ((Vector)object4).size()) {
            AccountData accountData = (AccountData)((Vector)object4).elementAt(n5);
            object = this.rootAccount.getAccountById(accountData.accountID);
            dataSetGroupArray[n5] = this.txn2DataSet(accountData.transactions, account, (Account)object, true);
            ++n5;
        }
        return dataSetGroupArray;
    }

    private final DataSetGroup[] rebuildTopIncomeGraph() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        Account account = (Account)this.accountChoice.getSelectedItem();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        int n2 = (Integer)((TopIncomesSettingsPanel)this.settingsPanels[1]).topNumChoice.getSelectedItem();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object4 = this.rootAccount.getTransactionSet().getAllTransactions();
        while (object4.hasMoreElements()) {
            long l3;
            Transaction transaction = (Transaction)object4.nextElement();
            if (!account.containsTransaction(transaction, false, false) || (l3 = transaction.getDate()) < l || l3 > l2) continue;
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : GraphTool.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && ((BankTransaction)transaction).getSplitCount() > 0) {
                object3 = (BankTransaction)transaction;
                int n3 = 0;
                while (n3 < ((BankTransaction)object3).getSplitCount()) {
                    object2 = ((BankTransaction)object3).getSplit(n3);
                    object = new Integer(((Transaction)object2).getSourceAccountId());
                    AccountData accountData = (AccountData)hashtable.get(object);
                    if (accountData == null) {
                        accountData = new AccountData();
                        accountData.accountID = ((Transaction)object2).getSourceAccountId();
                        accountData.total = ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                        hashtable.put(object, accountData);
                    } else {
                        accountData.total += ((Transaction)object2).getAmount();
                        accountData.transactions.addElement(object2);
                    }
                    ++n3;
                }
                continue;
            }
            object = new Integer(transaction.getAccountId(n));
            object3 = (AccountData)hashtable.get(object);
            if (object3 == null) {
                object3 = new AccountData();
                ((AccountData)object3).accountID = transaction.getAccountId(n);
                ((AccountData)object3).total = transaction.getAmount(n);
                ((AccountData)object3).transactions.addElement(transaction);
                hashtable.put(object, object3);
                continue;
            }
            ((AccountData)object3).total += transaction.getAmount(n);
            ((AccountData)object3).transactions.addElement(transaction);
        }
        object4 = new Vector();
        int n4 = 0;
        while (n4 < n2) {
            if (hashtable.size() <= 0) break;
            boolean bl = true;
            long l4 = 0L;
            object3 = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (AccountData)enumeration.nextElement();
                if (bl) {
                    l4 = ((AccountData)object2).total;
                    object3 = object2;
                    bl = false;
                    continue;
                }
                if (((AccountData)object2).total <= l4) continue;
                object3 = object2;
                l4 = ((AccountData)object2).total;
            }
            if (((AccountData)object3).total <= 0L) break;
            ((Vector)object4).addElement(object3);
            hashtable.remove(new Integer(((AccountData)object3).accountID));
            ++n4;
        }
        DataSetGroup[] dataSetGroupArray = new DataSetGroup[((Vector)object4).size()];
        int n5 = 0;
        while (n5 < ((Vector)object4).size()) {
            AccountData accountData = (AccountData)((Vector)object4).elementAt(n5);
            object = this.rootAccount.getAccountById(accountData.accountID);
            dataSetGroupArray[n5] = this.txn2DataSet(accountData.transactions, account, (Account)object, false);
            ++n5;
        }
        return dataSetGroupArray;
    }

    private final DataSetGroup[] rebuildIncomeExpenseGraph() {
        Object object;
        Account account = (Account)this.accountChoice.getSelectedItem();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        DataSetGroup[] dataSetGroupArray = this.rootAccount.getTransactionSet().getAllTransactions();
        while (dataSetGroupArray.hasMoreElements()) {
            Integer n2;
            Object object2;
            long l3;
            object = (Transaction)dataSetGroupArray.nextElement();
            if (!account.containsTransaction((Transaction)object, false, false) || (l3 = ((Transaction)object).getDate()) < l || l3 > l2) continue;
            if (object.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : GraphTool.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && ((BankTransaction)object).getSplitCount() > 0) {
                object2 = (BankTransaction)object;
                int n3 = 0;
                while (n3 < ((BankTransaction)object2).getSplitCount()) {
                    SplitTransaction splitTransaction = ((BankTransaction)object2).getSplit(n3);
                    n2 = new Integer(splitTransaction.getAmount() > 0L ? -1 : -2);
                    AccountData accountData = (AccountData)hashtable.get(n2);
                    if (accountData == null) {
                        accountData = new AccountData();
                        accountData.accountID = n2;
                        accountData.total = splitTransaction.getAmount();
                        accountData.transactions.addElement(splitTransaction);
                        hashtable.put(n2, accountData);
                    } else {
                        accountData.total += splitTransaction.getAmount();
                        accountData.transactions.addElement(splitTransaction);
                    }
                    ++n3;
                }
                continue;
            }
            n2 = new Integer(((Transaction)object).getAmount(n) > 0L ? -1 : -2);
            object2 = (AccountData)hashtable.get(n2);
            if (object2 == null) {
                object2 = new AccountData();
                ((AccountData)object2).accountID = n2;
                ((AccountData)object2).total = ((Transaction)object).getAmount(n);
                ((AccountData)object2).transactions.addElement(object);
                hashtable.put(n2, object2);
                continue;
            }
            ((AccountData)object2).total += ((Transaction)object).getAmount(n);
            ((AccountData)object2).transactions.addElement(object);
        }
        dataSetGroupArray = new DataSetGroup[2];
        object = (AccountData)hashtable.get(new Integer(-1));
        if (object == null) {
            object = new AccountData();
            ((AccountData)object).accountID = -1;
            ((AccountData)object).total = 0L;
        }
        dataSetGroupArray[0] = this.txn2DataSet(((AccountData)object).transactions, account, null, false);
        AccountData accountData = (AccountData)hashtable.get(new Integer(-2));
        if (accountData == null) {
            accountData = new AccountData();
            accountData.accountID = -2;
            accountData.total = 0L;
        }
        dataSetGroupArray[1] = this.txn2DataSet(accountData.transactions, account, null, true);
        return dataSetGroupArray;
    }

    private final DataSetGroup[] rebuildAccountBalanceGraph() {
        Account account = (Account)this.accountChoice.getSelectedItem();
        if (account == null) {
            return null;
        }
        int n = account.getAccountNum();
        long l = this.startDateField.getDate().getTime();
        long l2 = this.endDateField.getDate().getTime();
        Vector<Transaction> vector = new Vector<Transaction>();
        Enumeration enumeration = this.rootAccount.getTransactionSet().getAllTransactions();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            if (!account.containsTransaction(transaction, false, true)) continue;
            vector.addElement(transaction);
        }
        AccountTransactionSet.sortTransactions(vector, 0, n, this.rootAccount);
        long l3 = 0L;
        Vector<DateBalance> vector2 = new Vector<DateBalance>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Transaction transaction = (Transaction)vector.elementAt(n2);
            l3 += transaction.getAmount(n);
            long l4 = transaction.getDate();
            if (l4 >= l && l4 <= l2) {
                GraphTool graphTool = this;
                if (graphTool == null) {
                    throw null;
                }
                DateBalance dateBalance = graphTool.new DateBalance(l4, l3);
                vector2.addElement(dateBalance);
            }
            ++n2;
        }
        return new DataSetGroup[]{this.balance2DataSet(vector2, account, account.getAccountType() == 5)};
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null && itemEvent.getSource() == this.graphTypeChoice) {
            this.setSettingsType();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doneButton) {
            this.finishUp();
        } else if (actionEvent.getSource() == this.updateButton) {
            this.rebuildGraph();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.finishUp();
        }
        super.processEvent(aWTEvent);
    }

    public void dispose() {
        super.dispose();
        this.accountModel.goneAway();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphTool(MoneydanceGUI moneydanceGUI, Account account, AccountPanel accountPanel) {
        super(moneydanceGUI.resources.getString("graph_win_title") + ": " + account.getAccountName());
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = account.getRootAccount();
        this.parentPanel = accountPanel;
        try {
            this.setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.accountModel = new AccountListModel(this.rootAccount);
        this.accountModel.setShowAccountsOfType(0, false);
        this.accountChoice = new JComboBox(this.accountModel);
        if (account.getAccountType() == 0) {
            this.accountChoice.setSelectedIndex(0);
        } else {
            this.accountChoice.setSelectedItem(account);
        }
        this.graphTypeChoice = new JComboBox();
        this.graphTypeChoice.addItem(this.moneydanceGUI.resources.getString("graph_top_expenses"));
        this.graphTypeChoice.addItem(this.moneydanceGUI.resources.getString("graph_top_incomes"));
        this.graphTypeChoice.addItem(this.moneydanceGUI.resources.getString("graph_income_expenses"));
        this.graphTypeChoice.addItem(this.moneydanceGUI.resources.getString("graph_account_balance"));
        this.groupByChoice = new JComboBox();
        this.groupByChoice.addItem(this.moneydanceGUI.resources.getString("graph_groupby_day"));
        this.groupByChoice.addItem(this.moneydanceGUI.resources.getString("graph_groupby_week"));
        this.groupByChoice.addItem(this.moneydanceGUI.resources.getString("graph_groupby_month"));
        this.groupByChoice.addItem(this.moneydanceGUI.resources.getString("graph_groupby_year"));
        this.settingsPanels = new JPanel[5];
        this.settingsPanels[0] = new TopAccountsSettingsPanel(moneydanceGUI);
        this.settingsPanels[1] = new TopIncomesSettingsPanel(moneydanceGUI);
        this.settingsPanels[2] = new JPanel();
        this.settingsPanels[3] = new JPanel();
        this.settingsPanels[4] = new JPanel();
        Calendar calendar = Calendar.getInstance();
        this.startDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.endDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.endDateField.setDate(calendar.getTime());
        this.lastStartDate = this.endDateField.getDate().getTime();
        calendar.set(2, 0);
        calendar.set(5, 1);
        this.startDateField.setDate(calendar.getTime());
        this.lastEndDate = this.startDateField.getDate().getTime();
        this.barGraph = new BarGraphPanel(new Dimension(0, 0));
        this.lineGraph = new LineGraphPanel(new Dimension(0, 0));
        this.pieGraph = new PieGraphPanel(new Dimension(0, 0));
        this.key = new KeyPanel(new Dimension(0, 0));
        this.doneButton = new JButton(moneydanceGUI.resources.getString("graph_done"));
        this.updateButton = new JButton(moneydanceGUI.resources.getString("graph_update"));
        this.lineOrPieChoice = new JComboBox(new String[]{moneydanceGUI.resources.getString("graph_line"), moneydanceGUI.resources.getString("graph_bar")});
        this.settingsPanel = new JPanel(gridBagLayout);
        this.settingsPanel.setBorder(new EtchedBorder());
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.setBackground(Color.white);
        this.bottomGraphPanel = new JPanel(new GridLayout(1, 1));
        this.topGraphPanel = new JPanel(new GridLayout(1, 2));
        this.getContentPane().add(jPanel2);
        jPanel2.add((Component)jPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 3, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.settingsPanel, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(" "), AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)jPanel3, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 3, 1, true, true));
        jPanel2.add((Component)this.doneButton, AwtUtil.getConstraints(0, 3, 1.0f, 0.0f, 3, 1, false, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("graph_type") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.graphTypeChoice, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("graph_account") + ": ", 4), AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel.add((Component)this.accountChoice, AwtUtil.getConstraints(3, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.topGraphPanel.add(this.pieGraph);
        this.topGraphPanel.add(this.key);
        jPanel3.add(this.topGraphPanel);
        jPanel3.add(this.bottomGraphPanel);
        int n = 0;
        int n2 = 0;
        this.settingsPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("graph_begindate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.settingsPanel.add((Component)this.startDateField, AwtUtil.getConstraints(n--, n2++, 1.0f, 0.0f, 1, 1, true, false));
        this.settingsPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("graph_enddate") + ": ", 4), AwtUtil.getConstraints(n++, n2, 0.0f, 0.0f, 1, 1, true, true));
        this.settingsPanel.add((Component)this.endDateField, AwtUtil.getConstraints(n++, n2++, 1.0f, 0.0f, 1, 1, true, false));
        n2 = 0;
        this.settingsPanel.add((Component)this.lineOrPieChoice, AwtUtil.getConstraints(n, n2++, 1.0f, 0.0f, 2, 1, true, true));
        this.settingsPanel.add((Component)this.groupByChoice, AwtUtil.getConstraints(n, n2++, 1.0f, 0.0f, 2, 1, true, false));
        n2 = 3;
        int n3 = 0;
        while (n3 < this.settingsPanels.length) {
            gridBagLayout.setConstraints(this.settingsPanels[n3], AwtUtil.getConstraints(0, n2, 1.0f, 0.0f, 4, 1, false, true));
            ++n3;
        }
        this.settingsPanel.add((Component)this.updateButton, AwtUtil.getConstraints(0, ++n2, 1.0f, 0.0f, 4, 1, true, true));
        this.doneButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.graphTypeChoice.addItemListener(this);
        ((Component)this).setSize(650, 600);
        this.setSettingsType();
        this.rebuildGraph();
    }

    class DateValuePair {
        long date;
        long value;

        DateValuePair(long l, long l2) {
            this.date = l;
            this.value = l2;
        }
    }

    class DateBalance {
        long date;
        long balance;

        DateBalance(long l, long l2) {
            this.date = l;
            this.balance = l2;
        }
    }
}

