/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.CurrencyInfoPanel;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpgradeInfoWindow
extends JDialog
implements ActionListener {
    private CurrencyInfoPanel currencyPanel;
    private ResourceBundle resources = Main.getMainController().getResources();
    private JButton okButton;
    private CurrencyType selectedCurrencyType = null;

    public CurrencyType getSelectedCurrencyType() {
        return this.selectedCurrencyType;
    }

    private final void okButtonPressed() {
        CurrencyType currencyType = this.currencyPanel.getSelectedCurrency();
        if (currencyType == null) {
            this.getToolkit().beep();
            return;
        }
        this.currencyPanel.goingAway();
        this.selectedCurrencyType = currencyType;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        }
    }

    public UpgradeInfoWindow(CurrencyTable currencyTable) {
        super((Frame)null, Main.getMainController().getResources().getString("upgrade_win_title"), true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add(jPanel);
        this.currencyPanel = new CurrencyInfoPanel(currencyTable);
        this.okButton = new JButton(this.resources.getString("ok"));
        jPanel.add((Component)new JLabel(this.resources.getString("select_currency_type"), 0), AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.currencyPanel, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 2, 1.0f, 0.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 40);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation(dimension3.width / 2 - dimension2.width / 2, dimension3.height / 2 - dimension2.height / 2);
    }
}

