/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.ReminderSet;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.TransactionReminder;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.ReminderTxnEditPanel;
import com.seanreilly.apps.moneydance.view.gui.ScheduleInfoPanel;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class TxnReminderInfoWindow
extends JDialog
implements ActionListener {
    private TransactionReminder reminder;
    private ReminderSet reminderSet;
    private RootAccount rootAccount;
    private ScheduleInfoPanel scheduleInfoPanel;
    private ReminderTxnEditPanel txnPanel;
    private JTextField descField;
    private JButton okButton;
    private JButton cancelButton;

    private final void setFields() {
        this.scheduleInfoPanel.setScheduleData(this.reminder);
        this.descField.setText(this.reminder.getDescription());
        this.txnPanel.populateFields(this.reminder.getTransaction());
    }

    private final void okButtonPressed() {
        if (!this.txnPanel.saveTransaction(this.reminder.getTransaction())) {
            return;
        }
        this.scheduleInfoPanel.getScheduleData(this.reminder);
        this.reminder.setDescription(this.descField.getText());
        ((Component)this).setVisible(false);
        this.dispose();
        this.reminderSet.reminderModified(this.reminder);
    }

    private final void cancelButtonPressed() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void dispose() {
        super.dispose();
        this.txnPanel.goneAway();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButtonPressed();
        }
    }

    public TxnReminderInfoWindow(MoneydanceGUI moneydanceGUI, TransactionReminder transactionReminder, RootAccount rootAccount) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.resources.getString("r_txn_editwin"), true);
        this.reminder = transactionReminder;
        this.rootAccount = rootAccount;
        this.reminderSet = rootAccount.getReminderSet();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.scheduleInfoPanel = new ScheduleInfoPanel(moneydanceGUI);
        this.txnPanel = new ReminderTxnEditPanel(moneydanceGUI, rootAccount);
        this.txnPanel.setBorder(new EtchedBorder());
        this.descField = new JTextField();
        this.okButton = new JButton(moneydanceGUI.resources.getString("ok"));
        this.cancelButton = new JButton(moneydanceGUI.resources.getString("cancel"));
        int n = 0;
        jPanel.add((Component)new JLabel(moneydanceGUI.resources.getString("r_desc") + ": ", 2), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.descField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.scheduleInfoPanel, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 2, 1, true, true));
        jPanel.add((Component)this.txnPanel, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel2.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.getContentPane().add((Component)jPanel, "Center");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.setFields();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 40, dimension.height + 40);
    }
}

