/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class TransactionRenderer
extends Component
implements ListCellRenderer {
    private static final int rowHeight = 18;
    private static FontMetrics fm = null;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction;
    private Transaction transaction = null;
    private int index = 0;
    private boolean isSelected = false;
    private boolean hasFocus = false;
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;
    private Account account;
    private CurrencyType currencyType;
    private int accountNum;
    private RootAccount rootAccount;
    private DateFormat shortDateFormat;
    private int numDecimals;
    private int centMult;
    private String splitLabel;
    private boolean isReconciler = false;
    private char dec;
    private char com;
    private Color color1 = Color.white;
    private Color color2 = Color.cyan;
    private HeaderComponent headerRenderer = null;
    private String[] columnNames;
    private boolean twoLines = false;
    private int[] cwidths = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};

    public Dimension getPreferredSize() {
        if (this.twoLines) {
            return new Dimension(50, 36);
        }
        return new Dimension(50, 18);
    }

    public void setDisplayTwoLines(boolean bl) {
        this.twoLines = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.transaction = (Transaction)object;
        this.index = n;
        this.isSelected = bl;
        this.hasFocus = bl2;
        return this;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return;
        }
        if (this.cwidths[2] < 0 && n3 > 0) {
            this.setDefaultFieldWidths(this.getGraphics(), n3);
        } else if (n3 != this.w) {
            this.adjustFieldWidths(this.w, n3);
        }
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        super.setBounds(n, n2, n3, n4);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return;
        }
        if (this.cwidths[2] < 0 && n3 > 0) {
            this.setDefaultFieldWidths(this.getGraphics(), n3);
        } else if (n3 != this.w) {
            this.adjustFieldWidths(this.w, n3);
        }
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        super.reshape(n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        if (this.isSelected) {
            graphics.setColor(Color.lightGray);
        } else if (this.index % 2 == 0) {
            graphics.setColor(this.color1);
        } else {
            graphics.setColor(this.color2);
        }
        graphics.fillRect(0, 0, this.w, this.h);
        if (this.hasFocus && !this.isReconciler) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.w, this.h);
        }
        if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.BankTransaction"))) && !this.isReconciler) {
            this.paintBankTransaction(graphics, (BankTransaction)this.transaction);
        } else if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            this.paintRecBankTransaction(graphics, (BankTransaction)this.transaction);
        } else if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.SplitTransaction"))) && !this.isReconciler) {
            this.paintSplitTransaction(graphics, (SplitTransaction)this.transaction);
        } else if (this.transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = TransactionRenderer.class$("com.seanreilly.apps.moneydance.model.SplitTransaction")))) {
            this.paintRecSplitTransaction(graphics, (SplitTransaction)this.transaction);
        } else {
            this.paintDefaultTransaction(graphics, this.transaction);
        }
    }

    private final void setDefaultFieldWidths(Graphics graphics, int n) {
        fm = graphics.getFontMetrics();
        int n2 = fm.stringWidth(StringUtils.formatCurrency(1000000000L, false, this.dec, this.com, this.numDecimals, this.centMult));
        if (this.isReconciler) {
            this.cwidths[0] = fm.stringWidth(this.shortDateFormat.format(new Date()) + "__");
            this.cwidths[1] = fm.stringWidth("10000000");
            this.cwidths[3] = 18;
            this.cwidths[4] = n2;
            int n3 = this.cwidths[4] + this.cwidths[0] + this.cwidths[3] + this.cwidths[1];
            this.cwidths[2] = n - n3;
        } else {
            this.cwidths[0] = fm.stringWidth(this.shortDateFormat.format(new Date()) + "__");
            this.cwidths[1] = fm.stringWidth("10000000");
            this.cwidths[4] = 18;
            this.cwidths[5] = n2;
            this.cwidths[6] = n2;
            this.cwidths[7] = n2;
            int n4 = this.cwidths[4] + this.cwidths[0] + n2 * 3 + this.cwidths[1];
            this.cwidths[2] = 2 * (n - n4) / 3;
            this.cwidths[3] = (n - n4) / 3;
        }
    }

    private final void adjustFieldWidths(int n, int n2) {
        this.cwidths[2] = this.cwidths[2] + (n2 - n);
    }

    private final void paintHeader(Graphics graphics, Dimension dimension) {
        int n;
        int n2 = dimension.width;
        int n3 = n = dimension.height;
        if (this.twoLines) {
            n3 = n / 2;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n2, n);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(2, 2, n2 - 4, n - 4);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics.drawLine(1, n - 2, n2 - 3, n - 2);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
        graphics.drawLine(n2 - 2, 1, n2 - 2, n - 2);
        graphics.setColor(Color.darkGray);
        int n4 = 0;
        graphics.drawLine(n4 += this.cwidths[0], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[1], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[2], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[3], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[4], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[5], 0, n4, n3);
        graphics.drawLine(n4 += this.cwidths[6], 0, n4, n3);
        if (this.twoLines) {
            graphics.drawLine(0, n / 2, dimension.width, n / 2);
        }
        Shape shape = graphics.getClip();
        int n5 = n - 2 - fm.getMaxDescent();
        int n6 = this.twoLines ? n / 2 - fm.getMaxDescent() : n - fm.getMaxDescent() - 2;
        graphics.setColor(Color.black);
        n4 = 0;
        graphics.setClip(shape);
        graphics.clipRect(n4, 0, this.cwidths[0], n);
        int n7 = fm.stringWidth(this.columnNames[0]);
        graphics.drawString(this.columnNames[0], n4 + (this.cwidths[0] / 2 - n7 / 2), n6);
        if (this.twoLines) {
            n7 = fm.stringWidth(this.columnNames[10]);
            graphics.drawString(this.columnNames[10], n4 + (this.cwidths[0] / 2 - n7 / 2), n5);
        }
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[0], 0, this.cwidths[1], n);
        n7 = fm.stringWidth(this.columnNames[1]);
        graphics.drawString(this.columnNames[1], n4 + (this.cwidths[1] / 2 - n7 / 2), n6);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[1], 0, this.cwidths[2], n);
        n7 = fm.stringWidth(this.columnNames[2]);
        graphics.drawString(this.columnNames[2], n4 + (this.cwidths[2] / 2 - n7 / 2), n6);
        if (this.twoLines) {
            n7 = fm.stringWidth(this.columnNames[9]);
            graphics.drawString(this.columnNames[9], n4 + (this.cwidths[2] / 2 - n7 / 2), n5);
        }
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[2], 0, this.cwidths[3], n);
        n7 = fm.stringWidth(this.columnNames[3]);
        graphics.drawString(this.columnNames[3], n4 + (this.cwidths[3] / 2 - n7 / 2), n6);
        if (this.twoLines) {
            n7 = fm.stringWidth(this.columnNames[11]);
            graphics.drawString(this.columnNames[11], n4 + (this.cwidths[3] / 2 - n7 / 2), n5);
        }
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[3], 0, this.cwidths[4], n);
        n7 = fm.stringWidth(this.columnNames[4]);
        graphics.drawString(this.columnNames[4], n4 + (this.cwidths[4] / 2 - n7 / 2), n6);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[4], 0, this.cwidths[5], n);
        n7 = fm.stringWidth(this.columnNames[5]);
        graphics.drawString(this.columnNames[5], n4 + (this.cwidths[5] / 2 - n7 / 2), n6);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[5], 0, this.cwidths[6], n);
        n7 = fm.stringWidth(this.columnNames[6]);
        graphics.drawString(this.columnNames[6], n4 + (this.cwidths[6] / 2 - n7 / 2), n6);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[6], 0, this.cwidths[7], n);
        n7 = fm.stringWidth(this.columnNames[7]);
        graphics.drawString(this.columnNames[7], n4 + (this.cwidths[7] / 2 - n7 / 2), n6);
        n4 += this.cwidths[7];
    }

    private final void paintRecHeader(Graphics graphics, Dimension dimension) {
        int n;
        int n2 = dimension.width;
        int n3 = n = dimension.height;
        if (this.twoLines) {
            n3 = n / 2;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n2, n);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(2, 2, n2 - 4, n - 4);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics.drawLine(1, n - 2, n2 - 3, n - 2);
        graphics.drawLine(n2 - 1, 0, n2 - 1, n - 1);
        graphics.drawLine(n2 - 2, 1, n2 - 2, n - 2);
        graphics.setColor(Color.darkGray);
        int n4 = 0;
        graphics.drawLine(n4 += this.cwidths[0], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[1], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[2], 0, n4, n);
        graphics.drawLine(n4 += this.cwidths[3], 0, n4, n);
        Shape shape = graphics.getClip();
        int n5 = n - fm.getMaxDescent() - 2;
        graphics.setColor(Color.black);
        n4 = 0;
        graphics.clipRect(n4, 0, this.cwidths[0], this.y);
        int n6 = fm.stringWidth(this.columnNames[0]);
        graphics.drawString(this.columnNames[0], n4 + (this.cwidths[0] / 2 - n6 / 2), n5);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[0], 0, this.cwidths[1], n);
        n6 = fm.stringWidth(this.columnNames[1]);
        graphics.drawString(this.columnNames[1], n4 + (this.cwidths[1] / 2 - n6 / 2), n5);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[1], 0, this.cwidths[2], n);
        n6 = fm.stringWidth(this.columnNames[2]);
        graphics.drawString(this.columnNames[2], n4 + (this.cwidths[2] / 2 - n6 / 2), n5);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[2], 0, this.cwidths[3], n);
        n6 = fm.stringWidth(this.columnNames[3]);
        graphics.drawString(this.columnNames[3], n4 + (this.cwidths[3] / 2 - n6 / 2), n5);
        graphics.setClip(shape);
        graphics.clipRect(n4 += this.cwidths[3], 0, this.cwidths[4], n);
        n6 = fm.stringWidth(this.columnNames[4]);
        graphics.drawString(this.columnNames[4], n4 + (this.cwidths[4] / 2 - n6 / 2), n5);
    }

    private final void paintBankTransaction(Graphics graphics, BankTransaction bankTransaction) {
        String string;
        Account account;
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        graphics.drawLine(0, this.h - 1, this.w, this.h - 1);
        int n = 0;
        graphics.drawLine(n += this.cwidths[0], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[1], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[2], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[3], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[4], 0, n, 18);
        graphics.drawLine(n += this.cwidths[5], 0, n, 18);
        graphics.drawLine(n += this.cwidths[6], 0, n, 18);
        graphics.setColor(Color.black);
        n = 0;
        Shape shape = graphics.getClip();
        graphics.clipRect(n, 0, this.cwidths[0], 18);
        graphics.drawString(this.shortDateFormat.format(new Date(bankTransaction.getDate())), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n, 18, this.cwidths[0], 18);
        graphics.drawString(this.shortDateFormat.format(new Date(bankTransaction.getTaxableDate())), n + 2, this.h - 2);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[0], 0, this.cwidths[1], 18);
        graphics.drawString(bankTransaction.getCheckNumber(), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[1], 0, this.cwidths[2], 18);
        graphics.drawString(bankTransaction.getDescription(), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n, 18, this.cwidths[2], 18);
        graphics.drawString(bankTransaction.getMemo(), n + 2, this.h - 2);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[2], 0, this.cwidths[3], 18);
        String string2 = "";
        if (bankTransaction.getSourceAccountId() != this.accountNum) {
            account = this.rootAccount.getAccountById(bankTransaction.getSourceAccountId());
            if (account == null && bankTransaction.getSourceAccountId() == -1) {
                string2 = this.splitLabel;
            }
        } else {
            account = this.rootAccount.getAccountById(bankTransaction.getDestAccountId());
            if (account == null && bankTransaction.getDestAccountId() == -1) {
                string2 = this.splitLabel;
            }
        }
        String string3 = null;
        string3 = account == null ? string2 : string2 + account.getAccountName();
        graphics.drawString(string3, n + 2, 16);
        if (this.twoLines) {
            graphics.setClip(shape);
            graphics.clipRect(n, 0, this.cwidths[3], 18);
            double d = bankTransaction.getRate(this.accountNum);
            if (d != 1.0) {
                String string4 = StringUtils.formatRate(d, this.dec);
                graphics.drawString(string4, n + this.cwidths[3] - fm.stringWidth(string4), this.h - 2);
            }
        }
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[3], 0, this.cwidths[4], 18);
        char c = bankTransaction.getClearedStatus(this.accountNum);
        if (c == 'X') {
            graphics.drawLine(n + 2, 11, n + 6, 16);
            graphics.drawLine(n + 2, 11, n + 6, 15);
            graphics.drawLine(n + 6, 15, n + 17, -5);
            graphics.drawLine(n + 6, 16, n + 17, -6);
        } else if (c == 'x') {
            graphics.drawLine(n + 2, 9, n + this.cwidths[4] - 2, 9);
        }
        long l = bankTransaction.getAmount(this.accountNum);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[4], 0, this.cwidths[5], 18);
        if (l <= 0L) {
            string = StringUtils.formatCurrency(l * -1L, false, this.dec, this.com, this.numDecimals, this.centMult);
            graphics.drawString(string, n + 2 + this.cwidths[5] - fm.stringWidth(string) - 2, 16);
        }
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[5], 0, this.cwidths[6], 18);
        if (l > 0L) {
            string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
            graphics.drawString(string, n + 2 + this.cwidths[6] - fm.stringWidth(string) - 2, 16);
        }
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[6], 0, this.cwidths[7], 18);
        long l2 = bankTransaction.getBalance(this.accountNum);
        String string5 = StringUtils.formatCurrency(l2, false, this.dec, this.com, this.numDecimals, this.centMult);
        if (l2 >= 0L) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.red);
        }
        graphics.drawString(string5, n + 2 + this.cwidths[7] - fm.stringWidth(string5) - 2, 16);
        graphics.setColor(Color.black);
    }

    private final void paintRecBankTransaction(Graphics graphics, BankTransaction bankTransaction) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        int n = 0;
        graphics.drawLine(n += this.cwidths[0], 0, n, 18);
        graphics.drawLine(n += this.cwidths[1], 0, n, 18);
        graphics.drawLine(n += this.cwidths[2], 0, n, 18);
        graphics.drawLine(n += this.cwidths[3], 0, n, 18);
        graphics.drawLine(n += this.cwidths[4], 0, n, 18);
        graphics.setColor(Color.black);
        n = 0;
        Shape shape = graphics.getClip();
        graphics.clipRect(n, 0, this.cwidths[0], 18);
        graphics.drawString(this.shortDateFormat.format(new Date(bankTransaction.getDate())), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[0], 0, this.cwidths[1], 18);
        graphics.drawString(bankTransaction.getCheckNumber(), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[1], 0, this.cwidths[2], 18);
        graphics.drawString(bankTransaction.getDescription(), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[2], 0, this.cwidths[3], 18);
        char c = bankTransaction.getClearedStatus(this.accountNum);
        this.drawClearedStatus(graphics, n, c);
        long l = bankTransaction.getAmount(this.accountNum);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[3], 0, this.cwidths[4], 18);
        String string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
        graphics.drawString(string, n + 2 + this.cwidths[4] - fm.stringWidth(string) - 2, 16);
    }

    private final void drawClearedStatus(Graphics graphics, int n, char c) {
        if (c == 'X') {
            graphics.drawLine(n + 2, 11, n + 6, 16);
            graphics.drawLine(n + 2, 11, n + 6, 15);
            graphics.drawLine(n + 6, 15, n + 17, -5);
            graphics.drawLine(n + 6, 16, n + 17, -6);
        } else if (c == 'x') {
            graphics.drawLine(n + 2, 9, n + this.cwidths[4] - 2, 9);
        }
    }

    private final void paintSplitTransaction(Graphics graphics, SplitTransaction splitTransaction) {
        String string;
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        int n = 0;
        graphics.drawLine(n += this.cwidths[0], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[1], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[2], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[3], 0, n, this.h);
        graphics.drawLine(n += this.cwidths[4], 0, n, 18);
        graphics.drawLine(n += this.cwidths[5], 0, n, 18);
        graphics.drawLine(n += this.cwidths[6], 0, n, 18);
        graphics.setColor(Color.black);
        n = 0;
        Shape shape = graphics.getClip();
        graphics.clipRect(n, 0, this.cwidths[0], 18);
        graphics.drawString(this.shortDateFormat.format(new Date(splitTransaction.getDate())), n + 2, 16);
        if (this.twoLines) {
            graphics.setClip(shape);
            graphics.clipRect(n, 18, this.cwidths[0], 18);
            graphics.drawString(this.shortDateFormat.format(new Date(splitTransaction.getTaxableDate())), n + 2, this.h - 2);
        }
        n += this.cwidths[0];
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[1], 0, this.cwidths[2], 18);
        graphics.drawString(splitTransaction.getDescription(), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[2], 0, this.cwidths[3], 18);
        Account account = this.rootAccount.getAccountById(splitTransaction.getParent().getDestAccountId());
        String string2 = null;
        string2 = account == null ? "???" : account.getAccountName();
        graphics.drawString("[split]" + string2, n + 2, 16);
        if (this.twoLines) {
            graphics.setClip(shape);
            graphics.clipRect(n, 18, this.cwidths[3], 18);
            double d = splitTransaction.getRate(this.accountNum);
            if (d != 1.0) {
                string = StringUtils.formatRate(d, this.dec);
                graphics.drawString(string, n + this.cwidths[3] - fm.stringWidth(string) - 2, this.h - 2);
            }
        }
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[3], 0, this.cwidths[4], 18);
        char c = splitTransaction.getClearedStatus(this.accountNum);
        if (c == 'X') {
            graphics.drawLine(n + 2, 11, n + 6, 16);
            graphics.drawLine(n + 2, 11, n + 6, 15);
            graphics.drawLine(n + 6, 15, n + 17, -5);
            graphics.drawLine(n + 6, 16, n + 17, -6);
        } else if (c == 'x') {
            graphics.drawLine(n + 2, 9, n + this.cwidths[4] - 2, 9);
        }
        long l = splitTransaction.getAmount(this.accountNum);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[4], 0, this.cwidths[5], 18);
        if (l <= 0L) {
            string = StringUtils.formatCurrency(l * -1L, false, this.dec, this.com, this.numDecimals, this.centMult);
            graphics.drawString(string, n + this.cwidths[5] - fm.stringWidth(string), 16);
        }
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[5], 0, this.cwidths[6], 18);
        if (l > 0L) {
            string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
            graphics.drawString(string, n + this.cwidths[6] - fm.stringWidth(string), 16);
        }
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[6], 0, this.cwidths[7], 18);
        l = splitTransaction.getBalance(this.accountNum);
        if (l >= 0L) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(Color.red);
        }
        string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
        graphics.drawString(string, n + this.cwidths[7] - fm.stringWidth(string), 16);
    }

    private final void paintRecSplitTransaction(Graphics graphics, SplitTransaction splitTransaction) {
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 18, this.w, 18);
        int n = 0;
        graphics.drawLine(n += this.cwidths[0], 0, n, 18);
        graphics.drawLine(n += this.cwidths[1], 0, n, 18);
        graphics.drawLine(n += this.cwidths[2], 0, n, 18);
        graphics.drawLine(n += this.cwidths[3], 0, n, 18);
        graphics.drawLine(n += this.cwidths[4], 0, n, 18);
        graphics.setColor(Color.black);
        n = 0;
        Shape shape = graphics.getClip();
        graphics.clipRect(n, 0, this.cwidths[0], 18);
        graphics.drawString(this.shortDateFormat.format(new Date(splitTransaction.getDate())), n + 2, 16);
        n += this.cwidths[0];
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[1], 0, this.cwidths[2], 18);
        graphics.drawString(splitTransaction.getDescription(), n + 2, 16);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[2], 0, this.cwidths[4], 18);
        char c = splitTransaction.getClearedStatus(this.accountNum);
        this.drawClearedStatus(graphics, n, c);
        long l = splitTransaction.getAmount(this.accountNum);
        graphics.setClip(shape);
        graphics.clipRect(n += this.cwidths[3], 0, this.cwidths[4], 18);
        String string = StringUtils.formatCurrency(l, false, this.dec, this.com, this.numDecimals, this.centMult);
        graphics.drawString(string, n + this.cwidths[4] - fm.stringWidth(string), 16);
        n += this.cwidths[4];
    }

    private final void paintDefaultTransaction(Graphics graphics, Transaction transaction) {
        graphics.drawString(">>>>>>>>????<<<<<<<<<", 3, 16);
    }

    public JComponent getHeaderRenderer(JList jList) {
        if (this.headerRenderer == null) {
            TransactionRenderer transactionRenderer = this;
            if (transactionRenderer == null) {
                throw null;
            }
            this.headerRenderer = transactionRenderer.new HeaderComponent(jList);
        }
        return this.headerRenderer;
    }

    /* synthetic */ int[] access$0() {
        return this.cwidths;
    }

    /* synthetic */ boolean access$1() {
        return this.twoLines;
    }

    static /* synthetic */ int access$2() {
        return rowHeight;
    }

    /* synthetic */ void access$4(Graphics graphics, int n) {
        this.setDefaultFieldWidths(graphics, n);
    }

    /* synthetic */ int access$5() {
        return this.w;
    }

    /* synthetic */ void access$6(int n) {
        this.w = n;
    }

    /* synthetic */ boolean access$7() {
        return this.isReconciler;
    }

    /* synthetic */ void access$8(Graphics graphics, Dimension dimension) {
        this.paintRecHeader(graphics, dimension);
    }

    /* synthetic */ void access$9(Graphics graphics, Dimension dimension) {
        this.paintHeader(graphics, dimension);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TransactionRenderer(Account account, MoneydanceGUI moneydanceGUI, boolean bl, boolean bl2) {
        this(account, moneydanceGUI, bl, bl2, Color.cyan, Color.white);
    }

    public TransactionRenderer(Account account, MoneydanceGUI moneydanceGUI, boolean bl, boolean bl2, Color color, Color color2) {
        this.account = account;
        this.accountNum = account.getAccountNum();
        this.currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.twoLines = bl;
        this.isReconciler = bl2;
        this.color1 = color;
        this.color2 = color2;
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.rootAccount = account.getRootAccount();
        this.shortDateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.splitLabel = moneydanceGUI.resources.getString("split_label");
        this.numDecimals = this.currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.columnNames = bl2 ? new String[]{moneydanceGUI.resources.getString("table_column_date"), moneydanceGUI.resources.getString("table_column_checknum"), moneydanceGUI.resources.getString("table_column_description"), moneydanceGUI.resources.getString("table_column_clearedchar"), moneydanceGUI.resources.getString("table_column_amount")} : new String[]{moneydanceGUI.resources.getString("table_column_date"), moneydanceGUI.resources.getString("table_column_checknum"), moneydanceGUI.resources.getString("table_column_description"), moneydanceGUI.resources.getString("table_column_account"), moneydanceGUI.resources.getString("table_column_clearedchar"), moneydanceGUI.resources.getString("table_column_debit"), moneydanceGUI.resources.getString("table_column_credit"), moneydanceGUI.resources.getString("table_column_balance"), moneydanceGUI.resources.getString("table_column_balance"), moneydanceGUI.resources.getString("table_column_memo"), moneydanceGUI.resources.getString("table_column_taxdate"), moneydanceGUI.resources.getString("table_column_rate")};
    }

    class HeaderComponent
    extends JComponent {
        JList txnList;
        boolean isDragging = false;
        int resizeColumn = -1;

        private final void repaintList() {
            this.txnList.repaint();
        }

        private final int isOverBorder(int n) {
            int n2 = 3;
            int n3 = 0;
            int n4 = 0;
            while (n4 < 8) {
                if (n4 == 0) {
                    n3 += TransactionRenderer.this.access$0()[0];
                } else if (n4 == 1) {
                    n3 += TransactionRenderer.this.access$0()[1];
                } else if (n4 == 2) {
                    n3 += TransactionRenderer.this.access$0()[2];
                } else if (n4 == 3) {
                    n3 += TransactionRenderer.this.access$0()[3];
                } else if (n4 == 4) {
                    n3 += TransactionRenderer.this.access$0()[4];
                } else if (n4 == 5) {
                    n3 += TransactionRenderer.this.access$0()[5];
                } else if (n4 == 6) {
                    n3 += TransactionRenderer.this.access$0()[6];
                } else {
                    return -1;
                }
                if (n < n3 - n2) {
                    return -1;
                }
                if (n <= n3 + n2) {
                    return n4;
                }
                ++n4;
            }
            return -1;
        }

        public Dimension getPreferredSize() {
            if (TransactionRenderer.this.access$1()) {
                return new Dimension(100, 36);
            }
            return new Dimension(100, 18);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (TransactionRenderer.this.access$0()[2] < 0 && dimension.width > 0 || fm == null) {
                TransactionRenderer.this.access$4(graphics, dimension.width);
                TransactionRenderer.this.access$6(dimension.width);
            }
            if (TransactionRenderer.this.access$7()) {
                TransactionRenderer.this.access$8(graphics, dimension);
            } else {
                TransactionRenderer.this.access$9(graphics, dimension);
            }
        }

        /* synthetic */ int access$0(int n) {
            return this.isOverBorder(n);
        }

        /* synthetic */ void access$1() {
            this.repaintList();
        }

        /* synthetic */ TransactionRenderer access$2() {
            return TransactionRenderer.this;
        }

        HeaderComponent(JList jList) {
            this.txnList = jList;
            HeaderComponent headerComponent = this;
            if (headerComponent == null) {
                throw null;
            }
            this.addMouseListener(new MouseAdapter(headerComponent){
                private final /* synthetic */ HeaderComponent this$0;

                public final void mousePressed(MouseEvent mouseEvent) {
                    this.this$0.resizeColumn = this.this$0.access$0(mouseEvent.getX());
                    this.this$0.isDragging = this.this$0.resizeColumn >= 0;
                }

                public final void mouseReleased(MouseEvent mouseEvent) {
                    if (this.this$0.isDragging) {
                        this.this$0.access$1();
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    this.this$0.isDragging = false;
                    this.this$0.resizeColumn = -1;
                }

                public final void mouseExited(MouseEvent mouseEvent) {
                    if (!this.this$0.isDragging) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                {
                    this.this$0 = headerComponent;
                    this.constructor$0(headerComponent);
                }

                public void constructor$0(HeaderComponent headerComponent) {
                }
            });
            HeaderComponent headerComponent2 = this;
            if (headerComponent2 == null) {
                throw null;
            }
            this.addMouseMotionListener(new MouseMotionListener(headerComponent2){
                private final /* synthetic */ HeaderComponent this$0;
                private final /* synthetic */ TransactionRenderer this$1;

                public final void mouseMoved(MouseEvent mouseEvent) {
                    if (this.this$0.access$0(mouseEvent.getX()) >= 0) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(10));
                        this.this$0.isDragging = this.this$0.resizeColumn >= 0;
                    } else {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                        this.this$0.isDragging = false;
                        this.this$0.resizeColumn = -1;
                    }
                }

                public final void mouseDragged(MouseEvent mouseEvent) {
                    if (!this.this$0.isDragging) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    int n = mouseEvent.getX();
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < this.this$0.resizeColumn) {
                        n2 += this.this$1.access$0()[n3];
                        ++n3;
                    }
                    if (n < n2 + 2) {
                        n = n2 + 2;
                    }
                    if (n > n2 + this.this$1.access$0()[this.this$0.resizeColumn] + this.this$1.access$0()[this.this$0.resizeColumn + 1] - 2) {
                        n = n2 + this.this$1.access$0()[this.this$0.resizeColumn] + this.this$1.access$0()[this.this$0.resizeColumn + 1] - 2;
                    }
                    n3 = this.this$1.access$0()[this.this$0.resizeColumn];
                    this.this$1.access$0()[this.this$0.resizeColumn] = n - n2;
                    this.this$1.access$0()[this.this$0.resizeColumn + 1] = this.this$1.access$0()[this.this$0.resizeColumn + 1] + n3 - this.this$1.access$0()[this.this$0.resizeColumn];
                    this.this$0.repaint();
                }
                {
                    this.this$0 = headerComponent;
                    this.this$1 = this.this$0.access$2();
                    this.constructor$0(headerComponent);
                }

                public void constructor$0(HeaderComponent headerComponent) {
                }
            });
        }
    }
}

