/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import com.seanreilly.awt.JRateField;
import com.seanreilly.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SplitEditor
extends JDialog
implements ActionListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$Account;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private JTable splitTable;
    private SplitTableModel dataModel;
    private JButton okButton;
    private JButton deleteButton;
    private JButton newButton;
    private JButton cancelButton;
    private BankTransaction parentTransaction;
    private RootAccount rootAccount;
    private JTextField descriptionField;
    private DefaultCellEditor accountEditor;
    private DefaultCellEditor descriptionEditor;
    private DefaultCellEditor clearedEditor;
    private DefaultCellEditor amountEditor;
    private DefaultCellEditor rateEditor;
    private boolean wasCancelled = true;
    private MoneydanceGUI moneydanceGUI;
    private Account account;
    private CurrencyType currencyType;
    private char dec;
    private char com;
    private AccountListModel accountModel;
    private boolean showRates = true;

    private final void initColumnSizes(JTable jTable, SplitTableModel splitTableModel) {
        TableColumn tableColumn = null;
        Component component = null;
        int n = 0;
        int n2 = 0;
        Object[] objectArray = splitTableModel.longValues;
        int n3 = 0;
        while (n3 < splitTableModel.getColumnCount()) {
            tableColumn = jTable.getColumnModel().getColumn(n3);
            component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            n = component.getPreferredSize().width;
            component = jTable.getDefaultRenderer(splitTableModel.getColumnClass(n3)).getTableCellRendererComponent(jTable, objectArray[n3], false, false, 0, n3);
            n2 = component.getPreferredSize().width;
            tableColumn.setMinWidth(Math.max(n, n2));
            ++n3;
        }
        jTable.sizeColumnsToFit(-1);
    }

    public void setUpEditors(TableColumnModel tableColumnModel) {
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        JComboBox jComboBox = new JComboBox(this.accountModel);
        this.accountEditor = new DefaultCellEditor(jComboBox);
        this.accountEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(this.accountEditor);
        tableColumn = tableColumnModel.getColumn(1);
        this.descriptionField = new JTextField();
        this.descriptionEditor = new DefaultCellEditor(this.descriptionField);
        this.descriptionEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(this.descriptionEditor);
        tableColumn = tableColumnModel.getColumn(2);
        JComboBox jComboBox2 = new JComboBox();
        jComboBox2.addItem(this.moneydanceGUI.resources.getString("uncleared"));
        jComboBox2.addItem(this.moneydanceGUI.resources.getString("reconciling"));
        jComboBox2.addItem(this.moneydanceGUI.resources.getString("cleared"));
        this.clearedEditor = new DefaultCellEditor(jComboBox2);
        this.clearedEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(this.clearedEditor);
        tableColumn = tableColumnModel.getColumn(3);
        JCurrencyField jCurrencyField = new JCurrencyField(this.currencyType, this.dec, this.com);
        this.amountEditor = new DefaultCellEditor(jCurrencyField);
        this.amountEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(this.amountEditor);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        if (this.showRates) {
            tableColumn = tableColumnModel.getColumn(4);
            JRateField jRateField = new JRateField(this.dec);
            this.rateEditor = new DefaultCellEditor(jRateField);
            this.rateEditor.setClickCountToStart(2);
            tableColumn.setCellEditor(this.rateEditor);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
        }
    }

    public synchronized void setSplits(Vector vector) {
        this.dataModel.setTransactions(vector);
    }

    public Vector getSplits() {
        return this.dataModel.getTransactions();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.accountEditor.stopCellEditing();
            this.descriptionEditor.stopCellEditing();
            this.amountEditor.stopCellEditing();
            this.clearedEditor.stopCellEditing();
            if (this.showRates) {
                this.rateEditor.stopCellEditing();
            }
            this.wasCancelled = false;
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.wasCancelled = true;
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.newButton) {
            Account account = (Account)this.accountModel.getElementAt(0);
            this.dataModel.addTransaction(new SplitTransaction(-1L, account.getAccountNum(), "", 0L, new Date().getTime(), ' ', this.parentTransaction));
        } else if (actionEvent.getSource() == this.deleteButton) {
            int n = this.splitTable.getSelectedRow();
            if (n >= 0) {
                this.dataModel.removeTransaction(n);
            } else {
                n = this.splitTable.getEditingRow();
                if (n >= 0) {
                    System.err.println("Last edited row=" + n);
                }
            }
        }
    }

    /* synthetic */ MoneydanceGUI access$0() {
        return this.moneydanceGUI;
    }

    /* synthetic */ CurrencyType access$1() {
        return this.currencyType;
    }

    /* synthetic */ boolean access$2() {
        return this.showRates;
    }

    /* synthetic */ char access$3() {
        return this.dec;
    }

    /* synthetic */ char access$4() {
        return this.com;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SplitEditor(Frame frame, BankTransaction bankTransaction, RootAccount rootAccount, MoneydanceGUI moneydanceGUI, Account account, boolean bl) {
        super(frame, moneydanceGUI.resources.getString("split_win_title"), true);
        this.parentTransaction = bankTransaction;
        this.rootAccount = rootAccount;
        this.moneydanceGUI = moneydanceGUI;
        this.account = account;
        CurrencyTable currencyTable = rootAccount.getCurrencyTable();
        this.currencyType = currencyTable.getCurrencyType(account.getCurrencyType());
        this.showRates = bl;
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.accountModel = new AccountListModel(this.rootAccount);
        this.accountModel.setShowAccount(account, false);
        SplitEditor splitEditor = this;
        if (splitEditor == null) {
            throw null;
        }
        this.dataModel = splitEditor.new SplitTableModel(rootAccount, this.currencyType, currencyTable);
        this.splitTable = new JTable(this.dataModel);
        this.splitTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.splitTable.setRowHeight(this.splitTable.getRowHeight() + 10);
        this.initColumnSizes(this.splitTable, this.dataModel);
        this.setUpEditors(this.splitTable.getColumnModel());
        JScrollPane jScrollPane = new JScrollPane(this.splitTable);
        this.okButton = new JButton(this.moneydanceGUI.resources.getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.resources.getString("cancel"));
        this.deleteButton = new JButton(this.moneydanceGUI.resources.getString("delete_split"));
        this.newButton = new JButton(this.moneydanceGUI.resources.getString("new_split"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setContentPane(jPanel2);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel.add((Component)this.newButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.deleteButton, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(2, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(3, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.okButton, AwtUtil.getConstraints(4, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        ((Component)this).setSize(700, 300);
        this.splitTable.sizeColumnsToFit(3);
    }

    class SplitTableModel
    extends AbstractTableModel {
        final String[] columnNames;
        private RootAccount rootAccount;
        private Vector transactions;
        private int lastEditedRow;
        private int numDecimals;
        private int centMult;
        private CurrencyType currency;
        private CurrencyTable currencyTable;
        public final Object[] longValues;

        public int getLastEditedRow() {
            return this.lastEditedRow;
        }

        public Vector getTransactions() {
            return this.transactions;
        }

        public void setTransactions(Vector vector) {
            this.transactions = vector;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return SplitEditor.this.access$2() ? this.columnNames.length : this.columnNames.length - 1;
        }

        public int getRowCount() {
            return this.transactions.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            SplitTransaction splitTransaction = (SplitTransaction)this.transactions.elementAt(n);
            if (n2 == 0) {
                return this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
            }
            if (n2 == 1) {
                return splitTransaction.getDescription();
            }
            if (n2 == 2) {
                char c = splitTransaction.getSourceClearedStatus();
                if (c == 'x') {
                    return SplitEditor.this.access$0().resources.getString("reconciling");
                }
                if (c == 'X') {
                    return SplitEditor.this.access$0().resources.getString("cleared");
                }
                return SplitEditor.this.access$0().resources.getString("uncleared");
            }
            if (n2 == 3) {
                return StringUtils.formatCurrency(splitTransaction.getAmount(), false, SplitEditor.this.access$3(), SplitEditor.this.access$4(), this.numDecimals, this.centMult);
            }
            if (n2 == 4) {
                double d = 1.0;
                Account account = this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
                if (account != null) {
                    CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
                    d = CurrencyType.getXRelativeRate(this.currency, currencyType, splitTransaction.getRate());
                }
                return StringUtils.formatRate(d, SplitEditor.this.access$3());
            }
            return "???";
        }

        public Class getColumnClass(int n) {
            Class clazz;
            if (n == 0) {
                Class clazz2;
                if (class$Lcom$seanreilly$apps$moneydance$model$Account != null) {
                    clazz2 = class$Lcom$seanreilly$apps$moneydance$model$Account;
                } else {
                    Class clazz3 = SplitEditor.class$("com.seanreilly.apps.moneydance.model.Account");
                    clazz2 = clazz3;
                    class$Lcom$seanreilly$apps$moneydance$model$Account = clazz3;
                }
                return clazz2;
            }
            if (n == 1) {
                Class clazz4;
                if (class$Ljava$lang$String != null) {
                    clazz4 = class$Ljava$lang$String;
                } else {
                    Class clazz5 = SplitEditor.class$("java.lang.String");
                    clazz4 = clazz5;
                    class$Ljava$lang$String = clazz5;
                }
                return clazz4;
            }
            if (n == 2) {
                Class clazz6;
                if (class$Ljava$lang$String != null) {
                    clazz6 = class$Ljava$lang$String;
                } else {
                    Class clazz7 = SplitEditor.class$("java.lang.String");
                    clazz6 = clazz7;
                    class$Ljava$lang$String = clazz7;
                }
                return clazz6;
            }
            if (n == 3) {
                Class clazz8;
                if (class$Ljava$lang$String != null) {
                    clazz8 = class$Ljava$lang$String;
                } else {
                    Class clazz9 = SplitEditor.class$("java.lang.String");
                    clazz8 = clazz9;
                    class$Ljava$lang$String = clazz9;
                }
                return clazz8;
            }
            if (n == 4) {
                Class clazz10;
                if (class$Ljava$lang$String != null) {
                    clazz10 = class$Ljava$lang$String;
                } else {
                    Class clazz11 = SplitEditor.class$("java.lang.String");
                    clazz10 = clazz11;
                    class$Ljava$lang$String = clazz11;
                }
                return clazz10;
            }
            if (class$Ljava$lang$String != null) {
                clazz = class$Ljava$lang$String;
            } else {
                Class clazz12 = SplitEditor.class$("java.lang.String");
                clazz = clazz12;
                class$Ljava$lang$String = clazz12;
            }
            return clazz;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                SplitTransaction splitTransaction = (SplitTransaction)this.transactions.elementAt(n);
                Account account = this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
                if (this.currency.getID().equals(account.getCurrencyType())) {
                    return false;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setValueAt(Object object, int n, int n2) {
            this.lastEditedRow = n;
            try {
                SplitTransaction splitTransaction = (SplitTransaction)this.transactions.elementAt(n);
                if (n2 == 0) {
                    if (!(object instanceof Account)) return;
                    Account account = (Account)object;
                    if (splitTransaction.getSourceAccountId() != account.getAccountNum()) {
                        CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
                        splitTransaction.setRate(this.currencyTable.getRate(this.currency, currencyType));
                    }
                    splitTransaction.setSourceAccountId(((Account)object).getAccountNum());
                    this.fireTableRowsUpdated(n, n);
                    return;
                }
                if (n2 == 1) {
                    splitTransaction.setDescription(object.toString());
                    return;
                }
                if (n2 == 2) {
                    String string = object.toString();
                    if (string.equals("x") || string.equals(SplitEditor.this.access$0().resources.getString("reconciling"))) {
                        splitTransaction.setSourceClearedStatus('x');
                        return;
                    }
                    if (!string.equals("X") && !string.equals(SplitEditor.this.access$0().resources.getString("cleared"))) {
                        splitTransaction.setSourceClearedStatus(' ');
                        return;
                    }
                    splitTransaction.setSourceClearedStatus('X');
                    return;
                }
                if (n2 == 3) {
                    splitTransaction.setAmount(StringUtils.parseCurrency((String)object, SplitEditor.this.access$3(), this.numDecimals, this.centMult));
                    return;
                }
                if (n2 != 4) return;
                Account account = this.rootAccount.getAccountById(splitTransaction.getSourceAccountId());
                CurrencyType currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
                double d = CurrencyType.getXRelativeRate(currencyType, this.currency, StringUtils.parseRate((String)object, SplitEditor.this.access$3()));
                splitTransaction.setRate(d);
                return;
            }
            catch (Exception exception) {
            }
        }

        public synchronized void addTransaction(Transaction transaction) {
            this.transactions.addElement(transaction);
            this.fireTableRowsInserted(this.transactions.size() - 1, this.transactions.size() - 1);
        }

        public synchronized void removeTransaction(int n) {
            if (n < 0 || n >= this.transactions.size()) {
                return;
            }
            this.transactions.removeElementAt(n);
            this.fireTableRowsDeleted(n, n);
        }

        public SplitTableModel(RootAccount rootAccount, CurrencyType currencyType, CurrencyTable currencyTable) {
            this.columnNames = new String[]{SplitEditor.this.access$0().resources.getString("txn_account"), SplitEditor.this.access$0().resources.getString("txn_payee"), SplitEditor.this.access$0().resources.getString("txn_status"), SplitEditor.this.access$0().resources.getString("txn_amount"), SplitEditor.this.access$0().resources.getString("txn_rate")};
            this.lastEditedRow = -1;
            this.longValues = new Object[]{"Maximum Length Account-----------", "Maximum Length Payee-----", "Status-----", new Integer(20), "8.8888"};
            this.rootAccount = rootAccount;
            this.numDecimals = SplitEditor.this.access$1().getDecimalPlaces();
            this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
            this.currency = currencyType;
            this.currencyTable = currencyTable;
            this.transactions = new Vector();
        }
    }
}

