/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.BasicReminder;
import com.seanreilly.apps.moneydance.model.CurrencyListener;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.DateReminderPair;
import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderListener;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import com.seanreilly.apps.moneydance.model.TransactionReminder;
import com.seanreilly.apps.moneydance.view.gui.AccountDetailInterface;
import com.seanreilly.apps.moneydance.view.gui.AccountHeaderPanel;
import com.seanreilly.apps.moneydance.view.gui.BasicReminderNotificationWindow;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.MonthView;
import com.seanreilly.apps.moneydance.view.gui.TxnReminderNotificationWindow;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JLinkLabel;
import com.seanreilly.awt.JLinkListener;
import com.seanreilly.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RootAccountDetailPanel
extends JPanel
implements AccountDetailInterface,
AccountListener,
JLinkListener,
CurrencyListener,
ReminderListener,
TransactionListener {
    private RootAccount rootAccount;
    private CurrencyTable currencyTable;
    private MoneydanceGUI moneydanceGUI;
    private int currentRow = 0;
    private Hashtable totalAmounts = null;
    private int lastAccountType = -1;
    private UserPreferences prefs;
    private char dec = (char)46;
    private char com = (char)44;
    private AccountHeaderPanel headerPanel;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private JPanel accountsPanel;
    private JPanel currencyPanel;
    private JPanel graphPanel;
    private JPanel tickerPanel;
    private JPanel reminderPanel;
    private JPanel infoPanel;
    private JLabel dateLabel;
    private JLabel timeLabel;
    private boolean active = true;
    private MonthView monthView;

    private final synchronized void buildAccountData() {
        int n;
        Object object;
        Hashtable<Integer, AccountData> hashtable = new Hashtable<Integer, AccountData>();
        this.accountsPanel.removeAll();
        Object object2 = this.rootAccount.getTransactionSet().getAllTransactions();
        while (object2.hasMoreElements()) {
            AccountData accountData;
            Integer n2;
            object = (Transaction)object2.nextElement();
            n = ((Transaction)object).getSourceAccountId();
            int n3 = ((Transaction)object).getDestAccountId();
            if (n > 0) {
                n2 = new Integer(n);
                accountData = (AccountData)hashtable.get(n2);
                if (accountData == null) {
                    RootAccountDetailPanel rootAccountDetailPanel = this;
                    if (rootAccountDetailPanel == null) {
                        throw null;
                    }
                    accountData = rootAccountDetailPanel.new AccountData();
                    hashtable.put(n2, accountData);
                }
                accountData.balance += ((Transaction)object).getAmount(n);
            }
            if (n3 <= 0) continue;
            n2 = new Integer(n3);
            accountData = (AccountData)hashtable.get(n2);
            if (accountData == null) {
                RootAccountDetailPanel rootAccountDetailPanel = this;
                if (rootAccountDetailPanel == null) {
                    throw null;
                }
                accountData = rootAccountDetailPanel.new AccountData();
                hashtable.put(n2, accountData);
            }
            accountData.balance += ((Transaction)object).getAmount(n3);
        }
        object2 = new JLabel(this.moneydanceGUI.resources.getString("home_balances"), 0);
        object = this.getFont();
        ((JComponent)object2).setFont(new Font(((Font)object).getName(), 1, ((Font)object).getSize() + 2));
        ((JComponent)object2).setForeground(Color.black);
        ((JComponent)object2).setBackground(Color.lightGray);
        ((JComponent)object2).setOpaque(true);
        this.accountsPanel.add((Component)object2, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 2, 1, true, true));
        n = 1 + this.addSubAccounts(this.rootAccount, hashtable, 1);
        this.validate();
    }

    private final int addSubAccounts(Account account, Hashtable hashtable, int n) {
        int n2 = 0;
        Enumeration enumeration = account.getSubAccounts();
        while (enumeration.hasMoreElements()) {
            Account account2 = (Account)enumeration.nextElement();
            if (account2.isRegisterAccount()) {
                AccountData accountData = (AccountData)hashtable.get(new Integer(account2.getAccountNum()));
                if (accountData == null) {
                    RootAccountDetailPanel rootAccountDetailPanel = this;
                    if (rootAccountDetailPanel == null) {
                        throw null;
                    }
                    accountData = rootAccountDetailPanel.new AccountData();
                }
                CurrencyType currencyType = this.currencyTable.getCurrencyType(account2.getCurrencyType());
                JLinkLabel jLinkLabel = new JLinkLabel(account2.toString(), account2, 2);
                jLinkLabel.addLinkListener(this);
                JLinkLabel jLinkLabel2 = new JLinkLabel((currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(accountData.balance, true, this.dec, this.com, currencyType.getDecimalPlaces()) + ' ' + currencyType.getSuffix()).trim(), account2, 4);
                jLinkLabel2.addLinkListener(this);
                if (accountData.balance < 0L) {
                    jLinkLabel2.setForeground(Color.red);
                }
                this.accountsPanel.add((Component)jLinkLabel, AwtUtil.getConstraints(0, n + n2, 1.0f, 0.0f, 1, 1, true, false));
                this.accountsPanel.add((Component)jLinkLabel2, AwtUtil.getConstraints(1, n + n2, 0.0f, 0.0f, 1, 1, true, false));
                n2 += this.addSubAccounts(account2, hashtable, n + n2 + 1);
            }
            ++n2;
        }
        return n2;
    }

    private final synchronized void buildCurrencyData() {
        this.currencyPanel.removeAll();
        JLabel jLabel = new JLabel(this.moneydanceGUI.resources.getString("home_exchrates"), 0);
        Font font = this.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize() + 2));
        jLabel.setForeground(Color.black);
        jLabel.setBackground(Color.lightGray);
        jLabel.setOpaque(true);
        this.currencyPanel.add((Component)jLabel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 3, 1, true, true));
        CurrencyModel currencyModel = new CurrencyModel(this.currencyTable);
        CurrencyType currencyType = this.currencyTable.getBaseType();
        int n = 0;
        while (n < currencyModel.getSize()) {
            CurrencyType currencyType2 = (CurrencyType)currencyModel.getElementAt(n);
            JLabel jLabel2 = new JLabel(currencyType2.getID() + ' ', 2);
            JLabel jLabel3 = new JLabel(currencyType2.getName(), 2);
            String string = StringUtils.formatRate(currencyType2.getXRelativeRate(this.currencyTable.getBaseType()), this.dec);
            JLabel jLabel4 = new JLabel(string, 4);
            if (currencyType2.getID().equals(currencyType)) {
                jLabel2.setBackground(Color.cyan);
                jLabel2.setOpaque(true);
                jLabel3.setBackground(Color.cyan);
                jLabel3.setOpaque(true);
                jLabel4.setBackground(Color.cyan);
                jLabel4.setOpaque(true);
            }
            this.currencyPanel.add((Component)jLabel2, AwtUtil.getConstraints(0, n + 1, 0.0f, 0.0f, 1, 1, true, true));
            this.currencyPanel.add((Component)jLabel3, AwtUtil.getConstraints(1, n + 1, 0.0f, 0.0f, 1, 1, true, true));
            this.currencyPanel.add((Component)jLabel4, AwtUtil.getConstraints(2, n + 1, 1.0f, 0.0f, 1, 1, true, true));
            ++n;
        }
        currencyModel.goneAway();
        this.validate();
    }

    private final synchronized void buildReminderData() {
        Object object;
        Object object2;
        this.reminderPanel.removeAll();
        int n = 0;
        Hashtable<Object, ReminderLinkItem> hashtable = new Hashtable<Object, ReminderLinkItem>();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.lightGray);
        jPanel.setOpaque(true);
        JLabel jLabel = new JLinkLabel(this.moneydanceGUI.resources.getString("scheduled_items"), "edit_reminders", 0);
        Font font = this.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize() + 2));
        jLabel.setForeground(Color.black);
        ((JLinkLabel)jLabel).addLinkListener(this);
        jPanel.add((Component)jLabel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.reminderPanel.add((Component)jPanel, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, false));
        jLabel = new JLabel(this.moneydanceGUI.resources.getString("overdue_items"), 0);
        jLabel.setForeground(Color.black);
        jLabel.setBackground(Color.lightGray);
        jLabel.setOpaque(true);
        this.reminderPanel.add((Component)jLabel, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, false));
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, 12);
        calendar.set(12, 0);
        Vector vector = this.rootAccount.getReminderSet().getOverdueItems(calendar);
        int n2 = 0;
        while (n2 < vector.size()) {
            DateReminderPair dateReminderPair = (DateReminderPair)vector.elementAt(n2);
            if (!hashtable.containsKey(dateReminderPair.reminder)) {
                RootAccountDetailPanel rootAccountDetailPanel = this;
                if (rootAccountDetailPanel == null) {
                    throw null;
                }
                object2 = rootAccountDetailPanel.new ReminderLinkItem(dateReminderPair.date, dateReminderPair.reminder, true);
                hashtable.put(dateReminderPair.reminder, (ReminderLinkItem)object2);
            } else {
                RootAccountDetailPanel rootAccountDetailPanel = this;
                if (rootAccountDetailPanel == null) {
                    throw null;
                }
                object2 = rootAccountDetailPanel.new ReminderLinkItem(dateReminderPair.date, dateReminderPair.reminder, false);
            }
            JLinkLabel jLinkLabel = new JLinkLabel(this.dateFormat.format(dateReminderPair.date), object2, 2);
            object = new JLinkLabel("   " + dateReminderPair.reminder.toString(), object2, 2);
            this.reminderPanel.add((Component)jLinkLabel, AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
            this.reminderPanel.add((Component)object, AwtUtil.getConstraints(1, n++, 0.0f, 0.0f, 1, 1, true, false));
            jLinkLabel.addLinkListener(this);
            ((JLinkLabel)object).addLinkListener(this);
            ++n2;
        }
        if (vector.size() <= 0) {
            JLabel jLabel2 = new JLabel(this.moneydanceGUI.resources.getString("r_no_overdue"), 0);
            jLabel2.setForeground(Color.gray);
            this.reminderPanel.add((Component)jLabel2, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, false));
        }
        this.reminderPanel.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, n++, 0.0f, 1.0f, 1, 1, true, true));
        jLabel = new JLabel(this.moneydanceGUI.resources.getString("upcoming_items"), 0);
        jLabel.setForeground(Color.black);
        jLabel.setBackground(Color.lightGray);
        jLabel.setOpaque(true);
        this.reminderPanel.add((Component)jLabel, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, false));
        calendar = Calendar.getInstance();
        calendar.set(10, 12);
        calendar.set(12, 0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < 14) {
            object2 = this.rootAccount.getReminderSet().getRemindersOnDay(calendar);
            int n5 = 0;
            while (n5 < ((Vector)object2).size()) {
                ReminderLinkItem reminderLinkItem;
                object = (Reminder)((Vector)object2).elementAt(n5);
                if (!hashtable.containsKey(object)) {
                    RootAccountDetailPanel rootAccountDetailPanel = this;
                    if (rootAccountDetailPanel == null) {
                        throw null;
                    }
                    reminderLinkItem = rootAccountDetailPanel.new ReminderLinkItem(calendar.getTime(), (Reminder)object, true);
                    hashtable.put(object, reminderLinkItem);
                } else {
                    RootAccountDetailPanel rootAccountDetailPanel = this;
                    if (rootAccountDetailPanel == null) {
                        throw null;
                    }
                    reminderLinkItem = rootAccountDetailPanel.new ReminderLinkItem(calendar.getTime(), (Reminder)object, false);
                }
                JLinkLabel jLinkLabel = new JLinkLabel(this.dateFormat.format(calendar.getTime()), reminderLinkItem, 2);
                JLinkLabel jLinkLabel2 = new JLinkLabel("   " + ((Reminder)object).toString(), reminderLinkItem, 2);
                this.reminderPanel.add((Component)jLinkLabel, AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
                this.reminderPanel.add((Component)jLinkLabel2, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
                jLinkLabel.addLinkListener(this);
                jLinkLabel2.addLinkListener(this);
                ++n3;
                ++n5;
            }
            calendar.add(5, 1);
            ++n4;
        }
        if (n3 <= 0) {
            JLabel jLabel3 = new JLabel(this.moneydanceGUI.resources.getString("r_no_upcoming"), 0);
            jLabel3.setForeground(Color.gray);
            this.reminderPanel.add((Component)jLabel3, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 2, 1, true, false));
        }
        this.validate();
    }

    private final synchronized void buildInfo() {
        Date date = new Date();
        this.dateLabel.setText(this.dateFormat.format(date));
        this.timeLabel.setText(this.timeFormat.format(date));
        this.infoPanel.validate();
    }

    private final synchronized void buildTopExpenseData() {
    }

    private final synchronized void buildTopIncomeData() {
    }

    public void linkActivated(Object object) {
        String string;
        if (object instanceof Account) {
            this.headerPanel.setSelectedAccount((Account)object);
        } else if (object instanceof ReminderLinkItem) {
            ReminderLinkItem reminderLinkItem = (ReminderLinkItem)object;
            if (reminderLinkItem.reminder instanceof TransactionReminder) {
                TxnReminderNotificationWindow txnReminderNotificationWindow = new TxnReminderNotificationWindow(this.moneydanceGUI, this.rootAccount, (TransactionReminder)reminderLinkItem.reminder, reminderLinkItem.date, reminderLinkItem.isFirstOccurrance);
                ((Component)txnReminderNotificationWindow).setVisible(true);
            } else if (reminderLinkItem.reminder instanceof BasicReminder) {
                BasicReminderNotificationWindow basicReminderNotificationWindow = new BasicReminderNotificationWindow(this.moneydanceGUI, this.rootAccount, (BasicReminder)reminderLinkItem.reminder, reminderLinkItem.date, reminderLinkItem.isFirstOccurrance);
                ((Component)basicReminderNotificationWindow).setVisible(true);
            }
        } else if (object instanceof String && "edit_reminders".equals(string = (String)object)) {
            this.moneydanceGUI.showReminders();
        }
    }

    public void currencyTableModified(CurrencyTable currencyTable) {
        this.buildCurrencyData();
    }

    public void reminderRemoved(Reminder reminder) {
        this.buildReminderData();
    }

    public void reminderAdded(Reminder reminder) {
        this.buildReminderData();
    }

    public void reminderModified(Reminder reminder) {
        this.buildReminderData();
    }

    public void accountModified(Account account) {
        if (!this.moneydanceGUI.getSuspendRefreshes() && (account.isRegisterAccount() || account.getAccountType() == 0)) {
            this.buildAccountData();
        }
    }

    public Account getAccount() {
        return this.rootAccount;
    }

    public void transactionRemoved(Transaction transaction) {
        if (!this.moneydanceGUI.getSuspendRefreshes()) {
            this.buildAccountData();
        }
    }

    public void transactionAdded(Transaction transaction) {
        if (!this.moneydanceGUI.getSuspendRefreshes()) {
            this.buildAccountData();
        }
    }

    public void transactionModified(Transaction transaction) {
        if (!this.moneydanceGUI.getSuspendRefreshes()) {
            this.buildAccountData();
        }
    }

    public void goingAway() {
    }

    public void goneAway() {
        this.active = false;
        this.rootAccount.removeAccountListener(this);
        this.currencyTable.removeCurrencyListener(this);
        this.rootAccount.getTransactionSet().removeTransactionListener(this);
        this.rootAccount.getReminderSet().removeReminderListener(this);
    }

    /* synthetic */ boolean access$0() {
        return this.active;
    }

    /* synthetic */ void access$1() {
        this.buildInfo();
    }

    public RootAccountDetailPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount, AccountHeaderPanel accountHeaderPanel) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.headerPanel = accountHeaderPanel;
        this.prefs = Main.getMainController().getPreferences();
        this.setDoubleBuffered(false);
        this.accountsPanel = new JPanel(new GridBagLayout());
        this.accountsPanel.setBackground(Color.white);
        this.currencyPanel = new JPanel(new GridBagLayout());
        this.currencyPanel.setBackground(Color.white);
        this.reminderPanel = new JPanel(new GridBagLayout());
        this.reminderPanel.setBackground(Color.white);
        this.infoPanel = new JPanel(new GridBagLayout());
        this.infoPanel.setBackground(Color.white);
        this.dateLabel = new JLabel(" ", 2);
        this.timeLabel = new JLabel(" ", 4);
        this.monthView = new MonthView(new Date(), rootAccount.getReminderSet());
        this.dateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.timeFormat = new SimpleDateFormat("K:mm a");
        this.buildAccountData();
        this.buildCurrencyData();
        this.buildReminderData();
        this.buildTopExpenseData();
        this.buildTopIncomeData();
        this.buildInfo();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(Color.white);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBackground(Color.white);
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)jPanel3, AwtUtil.getConstraints(1, 1, 1.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)this.infoPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, false, 11, 10));
        jPanel2.add((Component)this.accountsPanel, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, false, 11, 10));
        jPanel3.add((Component)this.reminderPanel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, false, 11, 10));
        jPanel3.add((Component)this.monthView, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true, 10, 10));
        jPanel.add((Component)this.currencyPanel, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 2, 1, true, false, 11, 10));
        this.infoPanel.add((Component)this.dateLabel, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, true, true, 11));
        this.infoPanel.add((Component)this.timeLabel, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true, 11));
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.add((Component)jScrollPane, "Center");
        rootAccount.addAccountListener(this);
        rootAccount.getTransactionSet().addTransactionListener(this);
        this.currencyTable.addCurrencyListener(this);
        rootAccount.getReminderSet().addReminderListener(this);
        RootAccountDetailPanel rootAccountDetailPanel = this;
        if (rootAccountDetailPanel == null) {
            throw null;
        }
        new Thread(rootAccountDetailPanel){
            private final /* synthetic */ RootAccountDetailPanel this$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                while (this.this$0.access$0()) {
                    this.this$0.access$1();
                    try {
                        Thread.currentThread();
                        Thread.sleep(40000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
            {
                this.this$0 = rootAccountDetailPanel;
                this.constructor$0(rootAccountDetailPanel);
            }

            public void constructor$0(RootAccountDetailPanel rootAccountDetailPanel) {
            }
        }.start();
    }

    class ReminderLinkItem {
        Date date;
        Reminder reminder;
        boolean isFirstOccurrance;

        public ReminderLinkItem(Date date, Reminder reminder, boolean bl) {
            this.date = date;
            this.reminder = reminder;
            this.isFirstOccurrance = bl;
        }
    }

    class AccountData {
        long balance = 0L;

        AccountData() {
        }
    }
}

