/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderListener;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import com.seanreilly.apps.moneydance.model.RootAccount;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class ReminderListModel
extends AbstractListModel
implements ReminderListener {
    private ReminderSet reminderSet;
    private RootAccount rootAccount;
    private Vector currentReminders;

    public synchronized void sortReminders() {
        ReminderListModel reminderListModel = this;
        synchronized (reminderListModel) {
            ReminderListModel.sortReminders(this.currentReminders);
        }
        this.fireContentsChanged(this, 0, this.currentReminders.size() - 1);
    }

    public int getSize() {
        return this.currentReminders.size();
    }

    public void goneAway() {
        this.reminderSet.removeReminderListener(this);
    }

    public void recordModifiedReminder(Reminder reminder) {
        this.rootAccount.getReminderSet().reminderModified(reminder);
    }

    public void recordDeletedReminder(Reminder reminder) {
        this.rootAccount.getReminderSet().removeReminder(reminder);
    }

    public synchronized void reminderRemoved(Reminder reminder) {
        int n = this.currentReminders.indexOf(reminder);
        if (n >= 0) {
            this.removeReminderAt(n);
        }
    }

    public synchronized void reminderAdded(Reminder reminder) {
        this.insertReminder(reminder, -1);
    }

    public void reminderModified(Reminder reminder) {
        int n = this.currentReminders.indexOf(reminder);
        this.insertReminder(reminder, n);
    }

    private final void insertReminder(Reminder reminder, int n) {
        if (n < 0) {
            this.insertSortedReminder(reminder);
            this.fireContentsChanged(this, 0, this.currentReminders.size());
        } else if (!this.isReminderSorted(n, reminder)) {
            this.removeReminderAt(n);
            this.insertSortedReminder(reminder);
        }
    }

    private final synchronized void insertSortedReminder(Reminder reminder) {
        int n = this.currentReminders.size() - 1;
        while (n >= 0) {
            Reminder reminder2 = (Reminder)this.currentReminders.elementAt(n);
            if (reminder2.getDescription().compareTo(reminder.getDescription()) <= 0) {
                this.insertReminderAt(reminder, n + 1);
                return;
            }
            --n;
        }
        this.insertReminderAt(reminder, 0);
    }

    private final void insertReminderAt(Reminder reminder, int n) {
        this.currentReminders.insertElementAt(reminder, n);
        this.fireIntervalAdded(this, n, n);
    }

    private final boolean isReminderSorted(int n, Reminder reminder) {
        Reminder reminder2;
        boolean bl = true;
        if (n > 0 && (reminder2 = (Reminder)this.currentReminders.elementAt(n - 1)).getDescription().compareTo(reminder.getDescription()) > 0) {
            return false;
        }
        return n >= this.currentReminders.size() - 1 || (reminder2 = (Reminder)this.currentReminders.elementAt(n + 1)).getDescription().compareTo(reminder.getDescription()) >= 0;
    }

    private final void removeReminderAt(int n) {
        this.currentReminders.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public static void sortReminders(Vector vector) {
        ReminderListModel.quicksortAscending(vector, 0, vector.size() - 1);
    }

    private static final void quicksortAscending(Vector vector, int n, int n2) {
        if (n < n2) {
            int n3 = ReminderListModel.partitionAscending(vector, n, n2);
            ReminderListModel.quicksortAscending(vector, n, n3 - 1);
            ReminderListModel.quicksortAscending(vector, n3, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final int partitionAscending(Vector var0, int var1_1, int var2_2) {
        var3_3 = (Reminder)var0.elementAt((var1_1 + var2_2) / 2);
        ** GOTO lbl15
        {
            ++var1_1;
            do {
                if (((Reminder)var0.elementAt(var1_1)).getDescription().compareTo(var3_3.getDescription()) < 0) continue block0;
                while (((Reminder)var0.elementAt(var2_2)).getDescription().compareTo(var3_3.getDescription()) > 0) {
                    --var2_2;
                }
                if (var1_1 > var2_2) continue;
                var4_4 = (Reminder)var0.elementAt(var1_1);
                var0.setElementAt(var0.elementAt(var2_2), var1_1);
                var0.setElementAt(var4_4, var2_2);
                ++var1_1;
                --var2_2;
lbl15:
                // 3 sources

            } while (var1_1 <= var2_2);
        }
        return var1_1;
    }

    public int getRowCount() {
        return this.currentReminders.size();
    }

    public Object getElementAt(int n) {
        return this.currentReminders.elementAt(n);
    }

    public ReminderListModel(ReminderSet reminderSet) {
        this.reminderSet = reminderSet;
        this.currentReminders = new Vector();
        Enumeration enumeration = reminderSet.getAllReminders();
        while (enumeration.hasMoreElements()) {
            this.currentReminders.addElement(enumeration.nextElement());
        }
        reminderSet.addReminderListener(this);
        this.sortReminders();
        this.fireContentsChanged(this, 0, this.currentReminders.size() - 1);
    }
}

