/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.BankAccountDetailPanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.TransactionRenderer;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StringUtils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReconcilerWindow
extends JFrame
implements ActionListener,
ListSelectionListener,
AccountInfoListener {
    private JList debitList;
    private JList creditList;
    private AccountTransactionSet debitTransactionSet;
    private AccountTransactionSet creditTransactionSet;
    private AccountTransactionSet accountTransactionSet;
    private Account account;
    private CurrencyType currencyType;
    private JLabel beginBalanceLabel;
    private JLabel targetBalanceLabel;
    private JLabel currentBalanceLabel;
    private JLabel balanceDiffLabel;
    private long targetBalance;
    private JButton doneButton;
    private JButton cancelButton;
    private JButton newTransactionButton;
    private JButton deleteTransactionButton;
    private JButton editTransactionButton;
    private MoneydanceGUI moneydanceGUI;
    private BankAccountDetailPanel detailPanel;
    private boolean isActive = false;
    private char dec;
    private char com;

    public void accountInfoUpdated(Object object) {
        this.beginBalanceLabel.setText((this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.accountTransactionSet.getClearedBalance(), true, this.dec, this.com, this.currencyType.getDecimalPlaces()) + ' ' + this.currencyType.getSuffix()).trim());
        this.currentBalanceLabel.setText((this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.accountTransactionSet.getReconcilingBalance(), true, this.dec, this.com, this.currencyType.getDecimalPlaces()) + ' ' + this.currencyType.getSuffix()).trim());
        this.balanceDiffLabel.setText((this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.targetBalance - this.accountTransactionSet.getReconcilingBalance(), true, this.dec, this.com, this.currencyType.getDecimalPlaces()) + ' ' + this.currencyType.getSuffix()).trim());
        this.validate();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.debitList) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.transactionSelected((Transaction)this.debitList.getSelectedValue(), this.debitTransactionSet);
                this.debitList.setSelectedIndices(new int[0]);
            }
        } else if (listSelectionEvent.getSource() == this.creditList && !listSelectionEvent.getValueIsAdjusting()) {
            this.transactionSelected((Transaction)this.creditList.getSelectedValue(), this.creditTransactionSet);
            this.creditList.setSelectedIndices(new int[0]);
        }
    }

    private final void doneReconciling() {
        Transaction transaction;
        int n = this.account.getAccountNum();
        Vector vector = new Vector();
        Enumeration enumeration = this.debitTransactionSet.getAllTransactions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            transaction = (Transaction)enumeration.nextElement();
            if (transaction.getClearedStatus(n) != 'x') continue;
            transaction.setClearedStatus('X', n);
            this.debitTransactionSet.recordModifiedTransaction(transaction);
        }
        vector = new Vector();
        enumeration = this.creditTransactionSet.getAllTransactions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            transaction = (Transaction)enumeration.nextElement();
            if (transaction.getClearedStatus(n) != 'x') continue;
            transaction.setClearedStatus('X', n);
            this.creditTransactionSet.recordModifiedTransaction(transaction);
        }
        this.isActive = false;
        ((Component)this).setVisible(false);
        this.dispose();
        this.debitTransactionSet.disconnect();
        this.creditTransactionSet.disconnect();
        this.accountTransactionSet.disconnect();
    }

    public void cancelReconciling() {
        this.isActive = false;
        ((Component)this).setVisible(false);
        this.dispose();
        this.debitTransactionSet.disconnect();
        this.creditTransactionSet.disconnect();
        this.accountTransactionSet.disconnect();
    }

    public boolean isActive() {
        return this.isActive;
    }

    private final void transactionSelected(Transaction transaction, AccountTransactionSet accountTransactionSet) {
        if (transaction == null) {
            return;
        }
        char c = transaction.getClearedStatus(this.account.getAccountNum());
        if (c == 'x' || c == 'X') {
            transaction.setClearedStatus(' ', this.account.getAccountNum());
        } else {
            transaction.setClearedStatus('x', this.account.getAccountNum());
        }
        accountTransactionSet.recordModifiedTransaction(transaction);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Transaction transaction = (Transaction)this.debitList.getSelectedValue();
        if (transaction == null) {
            transaction = (Transaction)this.creditList.getSelectedValue();
        }
        if (actionEvent.getSource() == this.newTransactionButton) {
            this.detailPanel.createNewTransaction();
            this.moneydanceGUI.getTopLevelFrame().toFront();
        } else if (actionEvent.getSource() == this.editTransactionButton) {
            if (transaction != null) {
                this.detailPanel.setCurrentTransaction(transaction);
                this.moneydanceGUI.getTopLevelFrame().toFront();
            } else {
                this.getToolkit().beep();
            }
        } else if (actionEvent.getSource() == this.deleteTransactionButton) {
            if (transaction != null) {
                if (this.moneydanceGUI.askQuestion(this.moneydanceGUI.resources.getString("rec_delete_txn?"))) {
                    this.debitTransactionSet.recordDeletedTransaction(transaction);
                }
            } else {
                this.getToolkit().beep();
            }
        } else if (actionEvent.getSource() == this.doneButton) {
            this.doneReconciling();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelReconciling();
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.cancelReconciling();
        }
        super.processEvent(aWTEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReconcilerWindow(MoneydanceGUI moneydanceGUI, Account account, long l, BankAccountDetailPanel bankAccountDetailPanel) {
        super(moneydanceGUI.resources.getString("reconcile_win_title") + ": " + account.getAccountName());
        this.account = account;
        this.targetBalance = l;
        this.currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.detailPanel = bankAccountDetailPanel;
        this.moneydanceGUI = moneydanceGUI;
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.debitTransactionSet = new AccountTransactionSet(this.account, false, false, true);
        this.creditTransactionSet = new AccountTransactionSet(this.account, false, true, false);
        this.accountTransactionSet = new AccountTransactionSet(this.account);
        this.debitList = new JList(this.debitTransactionSet);
        this.creditList = new JList(this.creditTransactionSet);
        TransactionRenderer transactionRenderer = new TransactionRenderer(this.account, this.moneydanceGUI, false, true, Color.white, Color.white);
        TransactionRenderer transactionRenderer2 = new TransactionRenderer(this.account, this.moneydanceGUI, false, true, Color.white, Color.white);
        this.debitList.setCellRenderer(transactionRenderer);
        this.creditList.setCellRenderer(transactionRenderer2);
        this.debitList.setSelectionMode(0);
        this.creditList.setSelectionMode(0);
        this.beginBalanceLabel = new JLabel("", 4);
        this.currentBalanceLabel = new JLabel("", 4);
        this.balanceDiffLabel = new JLabel("", 4);
        this.targetBalanceLabel = new JLabel((this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(l, true, this.dec, this.com, this.currencyType.getDecimalPlaces()) + ' ' + this.currencyType.getSuffix()).trim(), 4);
        this.doneButton = new JButton(moneydanceGUI.resources.getString("rec_done"));
        try {
            this.doneButton.setFont(new Font("Serif", 1, 12));
        }
        catch (Exception exception) {
        }
        this.cancelButton = new JButton(moneydanceGUI.resources.getString("rec_cancel"));
        this.newTransactionButton = new JButton(moneydanceGUI.resources.getString("rec_new_txn"));
        this.deleteTransactionButton = new JButton(moneydanceGUI.resources.getString("rec_delete_txn"));
        this.editTransactionButton = new JButton(moneydanceGUI.resources.getString("rec_edit_txn"));
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.getContentPane().add(jPanel3);
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        jPanel.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_debits"), 0), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel2.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_credits"), 0), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        JScrollPane jScrollPane = new JScrollPane(this.debitList);
        jScrollPane.setColumnHeaderView(transactionRenderer.getHeaderRenderer(this.debitList));
        jPanel.add((Component)jScrollPane, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true));
        JScrollPane jScrollPane2 = new JScrollPane(this.creditList);
        jScrollPane2.setColumnHeaderView(transactionRenderer2.getHeaderRenderer(this.creditList));
        jPanel2.add((Component)jScrollPane2, AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, 1, true, true));
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel2.add((Component)jPanel4, AwtUtil.getConstraints(0, 2, 0.0f, 0.5f, 1, 1, false, false));
        jPanel4.add((Component)this.cancelButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.doneButton, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, true));
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel2.add((Component)jPanel5, AwtUtil.getConstraints(0, 3, 0.0f, 0.5f, 1, 1, false, false));
        jPanel5.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_txn_functions") + ":"), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 3, 1, true, false));
        jPanel5.add((Component)this.editTransactionButton, AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, false));
        jPanel5.add((Component)this.newTransactionButton, AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 1, true, false));
        jPanel5.add((Component)this.deleteTransactionButton, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, true, false));
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel2.add((Component)jPanel6, AwtUtil.getConstraints(0, 4, 0.0f, 0.0f, 1, 1, false, false));
        jPanel6.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_start_bal") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)this.beginBalanceLabel, AwtUtil.getConstraints(1, 0, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_curr_bal") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)this.currentBalanceLabel, AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_target_bal") + ": ", 4), AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)this.targetBalanceLabel, AwtUtil.getConstraints(1, 2, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_diff") + ": ", 4), AwtUtil.getConstraints(0, 3, 0.0f, 0.0f, 1, 1, true, false));
        jPanel6.add((Component)this.balanceDiffLabel, AwtUtil.getConstraints(1, 3, 0.0f, 0.0f, 1, 1, true, false));
        this.debitList.addListSelectionListener(this);
        this.creditList.addListSelectionListener(this);
        this.newTransactionButton.addActionListener(this);
        this.editTransactionButton.addActionListener(this);
        this.deleteTransactionButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.accountInfoUpdated(null);
        this.accountTransactionSet.addAccountInfoListener(this);
        ((Component)this).setSize(750, 400);
        this.validate();
        this.isActive = true;
    }
}

