/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PreferencesWindow
extends JDialog
implements ActionListener {
    private JCheckBox confirmTxnChangesCheckBox;
    private JCheckBox checkVersionCheckBox;
    private JCheckBox beepOnTxnChangeCheckBox;
    private JCheckBox restoreDesktopCheckBox;
    private JComboBox dateFormatChoice;
    private JComboBox decimalCharChoice;
    private JComboBox localeChoice;
    private JComboBox lookAndFeelChoice;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private String[] localeCountries = new String[]{"us", "fr", "br", "uk", "it"};
    private String[] localeLanguages = new String[]{"EN", "FR", "PT", "EN", "IT"};
    private String[] localeNames = new String[]{"US English", "French", "Brazil/Portugese", "UK English", "Italian"};
    private String[] lookAndFeelNames;
    private MoneydanceGUI moneydanceGUI;

    private final void populateFields() {
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        if (userPreferences.getSetting("confirm_transaction_changes", "y").equals("y")) {
            this.confirmTxnChangesCheckBox.setSelected(true);
        } else {
            this.confirmTxnChangesCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("check_version_at_startup", "n").equals("y")) {
            this.checkVersionCheckBox.setSelected(true);
        } else {
            this.checkVersionCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("beep_on_transaction_change", "y").equals("y")) {
            this.beepOnTxnChangeCheckBox.setSelected(true);
        } else {
            this.beepOnTxnChangeCheckBox.setSelected(false);
        }
        if (userPreferences.getSetting("restore_desktop_on_startup", "y").equals("y")) {
            this.restoreDesktopCheckBox.setSelected(true);
        } else {
            this.restoreDesktopCheckBox.setSelected(false);
        }
        this.decimalCharChoice.setSelectedItem(new Character(userPreferences.getDecimalChar()));
        this.dateFormatChoice.setSelectedItem(userPreferences.getSetting("date_format", "MM/dd/yyyy"));
        String string = userPreferences.getSetting("locale.country", "us");
        String string2 = userPreferences.getSetting("locale.language", "EN");
        int n = -1;
        int n2 = 0;
        while (n2 < this.localeCountries.length) {
            if (this.localeCountries[n2].equals(string)) {
                n = n2;
                if (this.localeLanguages[n2].equals(string2)) {
                    n = n2;
                    break;
                }
            }
            ++n2;
        }
        if (n < 0) {
            this.localeChoice.setSelectedIndex(0);
        } else {
            this.localeChoice.setSelectedIndex(n);
        }
        String string3 = userPreferences.getSetting("look_and_feel", "metal");
        if (string3.equals("windows")) {
            this.lookAndFeelChoice.setSelectedIndex(2);
        } else if (string3.equals("motif")) {
            this.lookAndFeelChoice.setSelectedIndex(1);
        } else {
            this.lookAndFeelChoice.setSelectedIndex(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveFields() {
        UserPreferences userPreferences;
        block22: {
            int n;
            Character c;
            userPreferences = Main.getMainController().getPreferences();
            if (this.confirmTxnChangesCheckBox.isSelected()) {
                userPreferences.setSetting("confirm_transaction_changes", "y");
            } else {
                userPreferences.setSetting("confirm_transaction_changes", "n");
            }
            if (this.checkVersionCheckBox.isSelected()) {
                userPreferences.setSetting("check_version_at_startup", "y");
            } else {
                userPreferences.setSetting("check_version_at_startup", "n");
            }
            if (this.beepOnTxnChangeCheckBox.isSelected()) {
                userPreferences.setSetting("beep_on_transaction_change", "y");
            } else {
                userPreferences.setSetting("beep_on_transaction_change", "n");
            }
            if (this.restoreDesktopCheckBox.isSelected()) {
                userPreferences.setSetting("restore_desktop_on_startup", "y");
            } else {
                userPreferences.setSetting("restore_desktop_on_startup", "n");
            }
            String string = (String)this.dateFormatChoice.getSelectedItem();
            if (string != null) {
                userPreferences.setSetting("date_format", string);
            }
            if ((c = (Character)this.decimalCharChoice.getSelectedItem()) != null) {
                userPreferences.setSetting("decimal_character", c.toString());
            }
            if ((n = this.localeChoice.getSelectedIndex()) >= 0) {
                userPreferences.setSetting("locale.country", this.localeCountries[n]);
                userPreferences.setSetting("locale.language", this.localeLanguages[n]);
            }
            int n2 = this.lookAndFeelChoice.getSelectedIndex();
            String string2 = userPreferences.getSetting("look_and_feel", "metal");
            if (n2 < 0) {
                n2 = 0;
            }
            try {
                if (n2 == 0) {
                    if (!string2.equals("metal")) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(this.moneydanceGUI.getTopLevelFrame());
                    }
                    userPreferences.setSetting("look_and_feel", "metal");
                    break block22;
                }
                if (n2 == 1) {
                    if (!string2.equals("motif")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(this.moneydanceGUI.getTopLevelFrame());
                    }
                    userPreferences.setSetting("look_and_feel", "motif");
                    break block22;
                }
                if (n2 == 2 && !string2.equals("windows")) {
                    if (!string2.equals("windows")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                        SwingUtilities.updateComponentTreeUI(this.moneydanceGUI.getTopLevelFrame());
                    }
                    userPreferences.setSetting("look_and_feel", "windows");
                }
            }
            catch (Exception exception) {
                this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("unable_to_set_laf"));
            }
        }
        try {
            userPreferences.writeSettings();
            return;
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage("Error saving preferences: " + exception.getMessage());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.saveFields();
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public PreferencesWindow(JFrame jFrame, MoneydanceGUI moneydanceGUI) {
        super(jFrame, "User Preferences", true);
        this.moneydanceGUI = moneydanceGUI;
        this.lookAndFeelNames = new String[]{this.moneydanceGUI.resources.getString("java_laf"), this.moneydanceGUI.resources.getString("motif_laf"), this.moneydanceGUI.resources.getString("windows_laf")};
        this.confirmTxnChangesCheckBox = new JCheckBox(this.moneydanceGUI.resources.getString("confirm_txn_changes"));
        this.checkVersionCheckBox = new JCheckBox(this.moneydanceGUI.resources.getString("check_version_at_startup"));
        this.beepOnTxnChangeCheckBox = new JCheckBox(this.moneydanceGUI.resources.getString("beep_on_txn_change"));
        this.restoreDesktopCheckBox = new JCheckBox(this.moneydanceGUI.resources.getString("restore_settings_on_startup"));
        this.decimalCharChoice = new JComboBox(new Character[]{new Character('.'), new Character(',')});
        this.dateFormatChoice = new JComboBox(new String[]{"MM/dd/yyyy", "MM.dd.yyyy", "yyyy/MM/dd", "yyyy.MM.dd", "dd/MM/yyyy", "dd.MM.yyyy"});
        this.localeChoice = new JComboBox(this.localeNames);
        this.lookAndFeelChoice = new JComboBox(this.lookAndFeelNames);
        this.okButton = new JButton(this.moneydanceGUI.resources.getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.resources.getString("cancel"));
        this.buttonPanel = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        int n = 0;
        int n2 = 0;
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("pref_header"), 0), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)this.confirmTxnChangesCheckBox, AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)this.checkVersionCheckBox, AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)this.beepOnTxnChangeCheckBox, AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)this.restoreDesktopCheckBox, AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)this.buttonPanel, AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, false));
        n = 1;
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("date_format") + ": ", 4), AwtUtil.getConstraints(++n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.dateFormatChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("decimal_char") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.decimalCharChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("locale") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.localeChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 1.0f, 1, 1, true, false));
        jPanel.add((Component)new JLabel(this.moneydanceGUI.resources.getString("look_and_feel") + ": ", 4), AwtUtil.getConstraints(n2, n, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.lookAndFeelChoice, AwtUtil.getConstraints(n2 + 1, n++, 1.0f, 1.0f, 1, 1, true, false));
        this.buttonPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, false, false));
        this.buttonPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 1.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.populateFields();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 40, dimension.height + 60);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension3.width / 2 - dimension2.width / 2, point.y + dimension3.height / 2 - dimension2.height / 2);
    }
}

