/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PreReconcilerWindow
extends JDialog
implements ActionListener {
    private GridBagLayout gridbag = new GridBagLayout();
    private boolean canceled = true;
    private long beginStatementBalance = 0L;
    private JButton okButton;
    private JButton cancelButton;
    private JCurrencyField beginBalanceField;
    private JCurrencyField endBalanceField;
    private long endBalance = 0L;

    public boolean wasCancelled() {
        return this.canceled;
    }

    public long getEndBalance() {
        return this.endBalance;
    }

    private final void okButtonPressed() {
        this.endBalance = this.endBalanceField.getValue();
        this.canceled = false;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final void cancelButtonPressed() {
        this.canceled = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButtonPressed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreReconcilerWindow(MoneydanceGUI moneydanceGUI, Account account, long l) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.resources.getString("reconcile_win_title") + ": " + account.getAccountName(), true);
        char c = Main.getMainController().getPreferences().getDecimalChar();
        char c2 = c == ',' ? (char)'.' : ',';
        CurrencyType currencyType = account.getRootAccount().getCurrencyTable().getCurrencyType(account.getCurrencyType());
        JPanel jPanel = new JPanel(this.gridbag);
        this.getContentPane().add(jPanel);
        this.endBalanceField = new JCurrencyField(currencyType, c, c2);
        this.endBalanceField.setValue(0L);
        this.beginBalanceField = new JCurrencyField(currencyType, c, c2);
        this.beginBalanceField.setEditable(false);
        this.beginBalanceField.setValue(l);
        this.okButton = new JButton(moneydanceGUI.resources.getString("ok"));
        this.cancelButton = new JButton(moneydanceGUI.resources.getString("cancel"));
        JLabel jLabel = new JLabel(moneydanceGUI.resources.getString("reconcile_header") + ": " + account.getAccountName(), 0);
        int n = 0;
        try {
            jLabel.setFont(new Font("SansSerif", 1, 18));
        }
        catch (Exception exception) {
        }
        jPanel.add((Component)jLabel, AwtUtil.getConstraints(0, n++, 1.0f, 0.0f, 5, 1, true, true));
        jPanel.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_begin_balance") + ": ", 2), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.beginBalanceField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(moneydanceGUI.resources.getString("rec_end_balance") + ": ", 2), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.endBalanceField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, true));
        JPanel jPanel2 = new JPanel(this.gridbag);
        jPanel2.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, n, 1.0f, 0.0f, 2, 1, true, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 20, dimension.height + 40);
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        ((Component)this).setLocation(dimension3.width / 2 - dimension2.width / 2, dimension3.height / 2 - dimension2.height / 2);
    }
}

