/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderListener;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public class MonthView
extends JPanel
implements ReminderListener {
    private static String[] dayHeader = new String[]{"S", "M", "T", "W", "R", "F", "S"};
    protected Calendar monthBeginning;
    private Image bufferImg = null;
    private Rectangle nextMonthButton = null;
    private Rectangle prevMonthButton = null;
    private Rectangle nextYearButton = null;
    private Rectangle prevYearButton = null;
    private Vector dayRectangles = new Vector();
    private Font titleFont;
    private Font normalFont;
    private int dayWidth = 0;
    private int weekHeight = 0;
    private int numWeeks = 0;
    private DateFormat longDateFormat;
    private DateFormat dateFormat;
    private DateFormat shortDateFormat;
    private DateFormat superShortDateFormat;
    private ReminderSet reminderSet;
    private boolean showDayHeaders = true;

    private final void doClickOnDay(DayRect dayRect) {
    }

    private final void gotoPreviousYear() {
        this.monthBeginning.add(1, -1);
        this.render();
        this.repaint();
    }

    private final void gotoNextYear() {
        this.monthBeginning.add(1, 1);
        this.render();
        this.repaint();
    }

    private final void gotoPreviousMonth() {
        this.monthBeginning.add(2, -1);
        this.render();
        this.repaint();
    }

    private final void gotoNextMonth() {
        this.monthBeginning.add(2, 1);
        this.render();
        this.repaint();
    }

    public void reminderAdded(Reminder reminder) {
        this.reminderModified(reminder);
    }

    public void reminderRemoved(Reminder reminder) {
        this.reminderModified(reminder);
    }

    public void reminderModified(Reminder reminder) {
        this.render();
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.bufferImg = null;
        Dimension dimension = this.getSize();
        this.recalcFonts(dimension);
        this.recalcButtons(dimension);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.bufferImg == null) {
            Dimension dimension = this.getSize();
            this.bufferImg = this.createImage(dimension.width, dimension.height);
            this.render();
        }
        if (this.bufferImg != null) {
            graphics.drawImage(this.bufferImg, 0, 0, null);
        }
    }

    private final void recalcFonts(Dimension dimension) {
        this.normalFont = this.getFont();
        this.titleFont = new Font(this.normalFont.getName(), 1, this.normalFont.getSize());
        this.showDayHeaders = dimension.height >= 120;
        this.dayWidth = dimension.width / 7;
    }

    private final void recalcButtons(Dimension dimension) {
        int n = 10;
        int n2 = 5;
        FontMetrics fontMetrics = this.getFontMetrics(this.titleFont);
        n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        n2 = n / 2;
        int n3 = 1;
        this.prevYearButton = new Rectangle(n3, 1, n2 * 2 - 1, n - 1);
        this.prevMonthButton = new Rectangle(n3 += n2 * 2, 1, n2 - 1, n - 1);
        n3 = this.getSize().width - n2 * 3 - 1;
        this.nextMonthButton = new Rectangle(n3, 1, n2 - 1, n - 1);
        this.nextYearButton = new Rectangle(n3 += n2, 1, n2 * 2 - 1, n - 1);
    }

    private final void render() {
        FontMetrics fontMetrics;
        int n;
        if (this.bufferImg == null) {
            return;
        }
        Graphics graphics = this.bufferImg.getGraphics();
        Dimension dimension = this.getSize();
        graphics.setColor(Color.cyan);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.titleFont);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, dimension.width, fontMetrics2.getMaxDescent() + fontMetrics2.getMaxAscent() + 2);
        graphics.setColor(Color.black);
        graphics.setFont(this.titleFont);
        String string = this.longDateFormat.format(this.monthBeginning.getTime());
        int n2 = this.nextMonthButton.x - (this.prevMonthButton.x + this.prevMonthButton.width);
        if (fontMetrics2.stringWidth(string) >= n2 && fontMetrics2.stringWidth(string = this.dateFormat.format(this.monthBeginning.getTime())) >= n2 && fontMetrics2.stringWidth(string = this.shortDateFormat.format(this.monthBeginning.getTime())) >= n2) {
            string = this.superShortDateFormat.format(this.monthBeginning.getTime());
        }
        graphics.drawString(string, dimension.width / 2 - fontMetrics2.stringWidth(string) / 2, fontMetrics2.getMaxAscent() + 2);
        graphics.setColor(Color.red);
        int[] nArray = new int[]{this.prevYearButton.x, this.prevYearButton.x + this.prevYearButton.width / 2, this.prevYearButton.x + this.prevYearButton.width / 2};
        int[] nArray2 = new int[]{this.prevYearButton.y + this.prevYearButton.height / 2, this.prevYearButton.y, this.prevYearButton.y + this.prevYearButton.height};
        graphics.fillPolygon(nArray, nArray2, 3);
        nArray = new int[]{this.prevYearButton.x + this.prevYearButton.width / 2, this.prevYearButton.x + this.prevYearButton.width, this.prevYearButton.x + this.prevYearButton.width};
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(Color.black);
        nArray = new int[]{this.prevMonthButton.x, this.prevMonthButton.x + this.prevMonthButton.width, this.prevMonthButton.x + this.prevMonthButton.width};
        nArray2 = new int[]{this.prevMonthButton.y + this.prevMonthButton.height / 2, this.prevMonthButton.y, this.prevMonthButton.y + this.prevMonthButton.height};
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(Color.black);
        nArray = new int[]{this.nextMonthButton.x + this.nextMonthButton.width, this.nextMonthButton.x, this.nextMonthButton.x};
        nArray2 = new int[]{this.nextMonthButton.y + this.nextMonthButton.height / 2, this.nextMonthButton.y, this.nextMonthButton.y + this.nextMonthButton.height};
        graphics.fillPolygon(nArray, nArray2, 3);
        graphics.setColor(Color.red);
        nArray = new int[]{this.nextYearButton.x + this.nextYearButton.width / 2, this.nextYearButton.x, this.nextYearButton.x};
        nArray2 = new int[]{this.nextYearButton.y + this.nextYearButton.height / 2, this.nextYearButton.y, this.nextYearButton.y + this.nextYearButton.height};
        graphics.fillPolygon(nArray, nArray2, 3);
        nArray = new int[]{this.nextYearButton.x + this.nextYearButton.width, this.nextYearButton.x + this.nextYearButton.width / 2, this.nextYearButton.x + this.nextYearButton.width / 2};
        graphics.fillPolygon(nArray, nArray2, 3);
        int n3 = this.nextYearButton.y + this.nextYearButton.height + 1;
        graphics.setFont(this.normalFont);
        fontMetrics2 = this.getFontMetrics(this.normalFont);
        if (this.showDayHeaders) {
            n = fontMetrics2.getMaxAscent() + fontMetrics2.getMaxDescent() + 2;
            graphics.setColor(Color.gray);
            graphics.fillRect(0, n3, dimension.width, n);
            graphics.setColor(Color.white);
            int n4 = 0;
            while (n4 < 7) {
                graphics.drawString(dayHeader[n4], n4 * dimension.width / 7 + this.dayWidth / 2 - fontMetrics2.stringWidth(dayHeader[n4]) / 2, n3 + n - fontMetrics2.getMaxDescent() - 1);
                ++n4;
            }
            n3 += n;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, n3, dimension.width, dimension.height - n3);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, n3, this.dayWidth, dimension.height - n3);
        graphics.fillRect(this.dayWidth * 6, n3, dimension.width - this.dayWidth * 6, dimension.height - n3);
        graphics.setColor(Color.black);
        graphics.drawLine(1 * this.dayWidth, n3, 1 * this.dayWidth, dimension.height);
        graphics.drawLine(2 * this.dayWidth, n3, 2 * this.dayWidth, dimension.height);
        graphics.drawLine(3 * this.dayWidth, n3, 3 * this.dayWidth, dimension.height);
        graphics.drawLine(4 * this.dayWidth, n3, 4 * this.dayWidth, dimension.height);
        graphics.drawLine(5 * this.dayWidth, n3, 5 * this.dayWidth, dimension.height);
        graphics.drawLine(6 * this.dayWidth, n3, 6 * this.dayWidth, dimension.height);
        this.numWeeks = this.monthBeginning.getMaximum(4) - 1;
        this.weekHeight = (dimension.height - n3) / this.numWeeks;
        n = 0;
        while (n < this.numWeeks) {
            graphics.drawLine(0, n3 + this.weekHeight * n, dimension.width, n3 + this.weekHeight * n);
            ++n;
        }
        String string2 = "30";
        while (this.normalFont.getSize() >= 4 && ((fontMetrics = graphics.getFontMetrics(this.normalFont)).getMaxDescent() + fontMetrics.getMaxAscent() >= this.weekHeight || fontMetrics.stringWidth(string2) >= this.dayWidth)) {
            this.normalFont = new Font(this.normalFont.getName(), 0, this.normalFont.getSize() - 1);
        }
        graphics.setFont(this.normalFont);
        this.dayRectangles.removeAllElements();
        Calendar calendar = (Calendar)this.monthBeginning.clone();
        int n5 = this.monthBeginning.get(2);
        while (calendar.get(2) == n5) {
            int n6 = calendar.get(4) - 1;
            int n7 = calendar.get(7) - 1;
            String string3 = String.valueOf(calendar.get(5));
            Vector vector = this.reminderSet.getEventsInDay(calendar);
            int n8 = n7 == 6 ? dimension.width - 6 * this.dayWidth : this.dayWidth;
            int n9 = n6 == this.numWeeks - 1 ? dimension.height - (this.numWeeks - 1) * this.weekHeight : this.weekHeight;
            Rectangle rectangle = new Rectangle(this.dayWidth * n7 + 1, n3 + n6 * this.weekHeight + 1, n8 - 1, n9 - 1);
            MonthView monthView = this;
            if (monthView == null) {
                throw null;
            }
            DayRect dayRect = monthView.new DayRect(rectangle, (Calendar)calendar.clone());
            this.dayRectangles.addElement(dayRect);
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.setClip(rectangle);
            if (vector.size() > 0) {
                graphics.setColor(Color.yellow.brighter().brighter());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics.setColor(Color.black);
            int n10 = fontMetrics2.getMaxAscent() + fontMetrics2.getMaxDescent() + 2;
            int n11 = n3 + this.weekHeight * n6 + fontMetrics2.getMaxAscent() + 1;
            graphics.drawString(string3, this.dayWidth * n7 + 2, n11);
            n11 += n10;
            int n12 = 0;
            while (n12 < vector.size() && n11 < rectangle.y + rectangle.height) {
                Reminder reminder = (Reminder)vector.elementAt(n12);
                graphics.drawString(reminder.getDescription(), this.dayWidth * n7 + 2, n11);
                n11 += n10;
                ++n12;
            }
            calendar.roll(6, true);
            graphics.setClip(rectangle2);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 180);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 200);
    }

    /* synthetic */ Rectangle access$0() {
        return this.prevYearButton;
    }

    /* synthetic */ void access$1() {
        this.gotoPreviousYear();
    }

    /* synthetic */ Rectangle access$2() {
        return this.nextYearButton;
    }

    /* synthetic */ void access$3() {
        this.gotoNextYear();
    }

    /* synthetic */ Rectangle access$4() {
        return this.prevMonthButton;
    }

    /* synthetic */ void access$5() {
        this.gotoPreviousMonth();
    }

    /* synthetic */ Rectangle access$6() {
        return this.nextMonthButton;
    }

    /* synthetic */ void access$7() {
        this.gotoNextMonth();
    }

    /* synthetic */ Vector access$8() {
        return this.dayRectangles;
    }

    /* synthetic */ void access$9(DayRect dayRect) {
        this.doClickOnDay(dayRect);
    }

    public MonthView() {
        this(new Date());
    }

    public MonthView(Date date) {
        this(date, null);
    }

    public MonthView(Date date, ReminderSet reminderSet) {
        this.reminderSet = reminderSet;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getMinimum(5));
        calendar.set(10, 12);
        calendar.set(12, calendar.getMinimum(12));
        calendar.set(13, calendar.getMinimum(13));
        this.monthBeginning = calendar;
        this.longDateFormat = new SimpleDateFormat("MMMM yyyy");
        this.dateFormat = new SimpleDateFormat("MMM yyyy");
        this.shortDateFormat = new SimpleDateFormat("MM/yy");
        this.superShortDateFormat = new SimpleDateFormat("MMM");
        MonthView monthView = this;
        if (monthView == null) {
            throw null;
        }
        this.addMouseListener(monthView.new MonthMouseListener());
    }

    class MonthMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (MonthView.this.access$0() != null && MonthView.this.access$0().contains(point)) {
                MonthView.this.access$1();
            } else if (MonthView.this.access$2() != null && MonthView.this.access$2().contains(point)) {
                MonthView.this.access$3();
            } else if (MonthView.this.access$4() != null && MonthView.this.access$4().contains(point)) {
                MonthView.this.access$5();
            } else if (MonthView.this.access$6() != null && MonthView.this.access$6().contains(point)) {
                MonthView.this.access$7();
            } else {
                Enumeration enumeration = MonthView.this.access$8().elements();
                while (enumeration.hasMoreElements()) {
                    DayRect dayRect = (DayRect)enumeration.nextElement();
                    if (!dayRect.bounds.contains(point)) continue;
                    MonthView.this.access$9(dayRect);
                }
            }
        }

        MonthMouseListener() {
        }
    }

    class DayRect {
        Rectangle bounds;
        Calendar day;

        DayRect(Rectangle rectangle, Calendar calendar) {
            this.bounds = rectangle;
            this.day = calendar;
        }
    }
}

