/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.MoneydanceUI;
import com.seanreilly.apps.moneydance.view.gui.AboutWindow;
import com.seanreilly.apps.moneydance.view.gui.CreateFileWindow;
import com.seanreilly.apps.moneydance.view.gui.EditCurrencyWindow;
import com.seanreilly.apps.moneydance.view.gui.EditRemindersWindow;
import com.seanreilly.apps.moneydance.view.gui.ExportWindow;
import com.seanreilly.apps.moneydance.view.gui.ImportWindow;
import com.seanreilly.apps.moneydance.view.gui.MainFrame;
import com.seanreilly.apps.moneydance.view.gui.PreferencesWindow;
import com.seanreilly.apps.moneydance.view.gui.QuestionDialog;
import com.seanreilly.apps.moneydance.view.gui.TranslateCurrencyWindow;
import com.seanreilly.apps.moneydance.view.gui.help.HelpFrame;
import com.seanreilly.awt.NeedToUpgradeWindow;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MoneydanceGUI
extends MoneydanceUI {
    public ResourceBundle resources;
    private MainFrame mainFrame;
    private HelpFrame helpFrame;
    private boolean suspendRefreshes;

    public boolean getSuspendRefreshes() {
        return this.suspendRefreshes;
    }

    public void setSuspendRefresh(boolean bl) {
        this.suspendRefreshes = bl;
    }

    public JFrame getTopLevelFrame() {
        return this.mainFrame;
    }

    public void go() {
        this.mainFrame.setVisible(true);
    }

    public void openFile() {
        File file = this.askForAccountFileToLoad();
        if (file != null) {
            Main.getMainController().openAccountFile(file);
        }
    }

    public void newFile() {
        CreateFileWindow createFileWindow = new CreateFileWindow(this.mainFrame, this);
        ((Component)createFileWindow).setVisible(true);
        if (!createFileWindow.wasCancelled()) {
            Main.getMainController().setCurrentAccount(createFileWindow.getNewAccount(), null);
        }
    }

    public void saveCurrentAccount() {
        Main.getMainController().saveCurrentAccount();
    }

    public void saveCurrentAccountAs() {
        Main.getMainController().saveCurrentAccountAs();
    }

    public void exit() {
        Main.getMainController().shutdown();
    }

    public void editPreferences() {
        PreferencesWindow preferencesWindow = new PreferencesWindow(this.mainFrame, this);
        ((Component)preferencesWindow).setVisible(true);
    }

    public void showAbout() {
        ((Component)new AboutWindow(this)).setVisible(true);
    }

    public synchronized void showHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame(this, "index.html");
            ((Component)this.helpFrame).setVisible(true);
        } else {
            this.helpFrame.showSection("index.html");
            ((Component)this.helpFrame).setVisible(true);
            this.helpFrame.toFront();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void unshowHelp() {
        if (this.helpFrame != null) {
            block3: {
                try {
                    ((Component)this.helpFrame).setVisible(false);
                    this.helpFrame.dispose();
                }
                catch (Exception exception) {
                    if (!Main.DEBUG) break block3;
                    System.err.println("Got exception: " + exception);
                    exception.printStackTrace(System.err);
                }
            }
            this.helpFrame = null;
        }
    }

    public void setCurrentAccount(RootAccount rootAccount, File file) {
        this.mainFrame.setCurrentAccount(rootAccount, file);
    }

    public void shutdown(boolean bl) {
        if (bl) {
            this.mainFrame.saveWorkspace();
        }
        this.mainFrame.goingAway();
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
    }

    public void editCurrencies() {
        RootAccount rootAccount = Main.getMainController().getCurrentAccount();
        if (rootAccount != null) {
            EditCurrencyWindow editCurrencyWindow = new EditCurrencyWindow(this.mainFrame, rootAccount.getCurrencyTable());
            ((Component)editCurrencyWindow).setVisible(true);
        } else {
            this.showErrorMessage(this.resources.getString("no_file_opened_error"));
        }
    }

    public void showReminders() {
        RootAccount rootAccount = Main.getMainController().getCurrentAccount();
        if (rootAccount != null) {
            EditRemindersWindow editRemindersWindow = new EditRemindersWindow(this.mainFrame, rootAccount, this);
            ((Component)editRemindersWindow).setVisible(true);
        } else {
            this.showErrorMessage(this.resources.getString("no_file_opened_error"));
        }
    }

    public void translateCurrencies() {
        RootAccount rootAccount = Main.getMainController().getCurrentAccount();
        if (rootAccount != null) {
            TranslateCurrencyWindow translateCurrencyWindow = new TranslateCurrencyWindow(this.mainFrame, rootAccount.getCurrencyTable(), this);
            ((Component)translateCurrencyWindow).setVisible(true);
        } else {
            this.showErrorMessage(this.resources.getString("no_file_opened_error"));
        }
    }

    public void importFile() {
        Object object;
        RootAccount rootAccount = Main.getMainController().getCurrentAccount();
        if (rootAccount == null) {
            object = CurrencyTable.createDefaultTable(this.resources.getString("default_currency"));
            rootAccount = new RootAccount(((CurrencyTable)object).getBaseType().getID(), (CurrencyTable)object);
            Main.getMainController().setCurrentAccount(rootAccount, null);
        }
        object = new ImportWindow(this.mainFrame, rootAccount, this);
        ((Component)object).setVisible(true);
    }

    public void exportFile() {
        RootAccount rootAccount = Main.getMainController().getCurrentAccount();
        if (rootAccount == null) {
            return;
        }
        ExportWindow exportWindow = new ExportWindow(this.mainFrame, rootAccount, this);
        ((Component)exportWindow).setVisible(true);
    }

    public boolean askQuestion(String string, String string2) {
        return QuestionDialog.askQuestion(string, string2, this);
    }

    public boolean askQuestion(String string) {
        return QuestionDialog.askQuestion(string, this);
    }

    public void showErrorMessage(String string) {
        this.showErrorMessage(this.mainFrame, string);
    }

    public void showErrorMessage(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, this.resources.getString("error"), 0);
    }

    public void showInfoMessage(String string) {
        this.showInfoMessage(this.mainFrame, string);
    }

    public void showInfoMessage(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, this.resources.getString("info"), 1);
    }

    public File askForAccountFileToSave() {
        FileDialog fileDialog = new FileDialog((Frame)this.mainFrame, this.resources.getString("choose_acct_file_title"), 1);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return null;
        }
        File file = new File(string2, string);
        if (!file.getAbsolutePath().toUpperCase().endsWith("." + "md".toUpperCase())) {
            file = new File(string2, string + "." + "md");
        }
        return file;
    }

    public File askForAccountFileToLoad() {
        FileDialog fileDialog = new FileDialog((Frame)this.mainFrame, this.resources.getString("choose_acct_file_title"), 0);
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null || string2 == null) {
            return null;
        }
        return new File(string2, string);
    }

    public void showNeedToUpgradeAlert(String string, String string2, String[] stringArray) {
        NeedToUpgradeWindow needToUpgradeWindow = new NeedToUpgradeWindow(this.mainFrame, string, "2.0", string2, stringArray);
        needToUpgradeWindow.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MoneydanceGUI() {
        block5: {
            this.helpFrame = null;
            this.suspendRefreshes = false;
            UserPreferences userPreferences = Main.getMainController().getPreferences();
            this.resources = userPreferences.getResources();
            String string = userPreferences.getSetting("look_and_feel", "metal");
            try {
                if (string.equals("metal")) {
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    break block5;
                }
                if (string.equals("motif")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    break block5;
                }
                if (string.equals("windows")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
            }
            catch (Exception exception) {
            }
        }
        this.mainFrame = new MainFrame(this);
    }
}

