/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountPanel;
import com.seanreilly.apps.moneydance.view.gui.InterfacePanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;

public class MainFrame
extends JFrame
implements ActionListener {
    public static final String TITLE = "Moneydance 2.0b5";
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu toolsMenu;
    private Menu helpMenu;
    private MenuItem fileNewMenuItem;
    private MenuItem fileOpenMenuItem;
    private MenuItem fileSaveMenuItem;
    private MenuItem fileSaveAsMenuItem;
    private MenuItem filePreferencesMenuItem;
    private MenuItem fileQuitMenuItem;
    private MenuItem toolsImportMenuItem;
    private MenuItem toolsExportMenuItem;
    private MenuItem toolsCurrencyMenuItem;
    private MenuItem toolsTranslateCurrencyMenuItem;
    private MenuItem toolsRemindersMenuItem;
    private MenuItem helpAboutMenuItem;
    private MenuItem helpHelpMenuItem;
    private InterfacePanel currentPanel = null;
    private MoneydanceGUI moneydanceGUI;

    public void goingAway() {
        if (this.currentPanel != null) {
            this.currentPanel.goingAway();
        }
    }

    public void setCurrentAccount(RootAccount rootAccount, File file) {
        if (this.currentPanel != null) {
            this.currentPanel.goingAway();
        }
        if (rootAccount == null) {
            this.accountClosed();
        } else {
            this.accountOpened();
        }
        if (this.currentPanel != null) {
            this.currentPanel.goneAway();
        }
        this.getContentPane().removeAll();
        AccountPanel accountPanel = new AccountPanel(this.moneydanceGUI, rootAccount);
        this.currentPanel = accountPanel;
        this.currentPanel.loadWorkspace();
        this.getContentPane().add((Component)accountPanel, "Center");
        this.getContentPane().validate();
        if (file != null) {
            this.setTitle(TITLE + ": " + file.getAbsolutePath());
        } else {
            this.setTitle(TITLE);
        }
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.moneydanceGUI.exit();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileNewMenuItem) {
            this.moneydanceGUI.newFile();
        } else if (actionEvent.getSource() == this.fileOpenMenuItem) {
            this.moneydanceGUI.openFile();
        } else if (actionEvent.getSource() == this.fileSaveMenuItem) {
            this.moneydanceGUI.saveCurrentAccount();
        } else if (actionEvent.getSource() == this.fileSaveAsMenuItem) {
            this.moneydanceGUI.saveCurrentAccountAs();
        } else if (actionEvent.getSource() == this.filePreferencesMenuItem) {
            this.moneydanceGUI.editPreferences();
        } else if (actionEvent.getSource() == this.toolsImportMenuItem) {
            this.moneydanceGUI.importFile();
        } else if (actionEvent.getSource() == this.toolsExportMenuItem) {
            this.moneydanceGUI.exportFile();
        } else if (actionEvent.getSource() == this.toolsCurrencyMenuItem) {
            this.moneydanceGUI.editCurrencies();
        } else if (actionEvent.getSource() == this.toolsTranslateCurrencyMenuItem) {
            this.moneydanceGUI.translateCurrencies();
        } else if (actionEvent.getSource() == this.toolsRemindersMenuItem) {
            this.moneydanceGUI.showReminders();
        } else if (actionEvent.getSource() == this.fileQuitMenuItem) {
            this.moneydanceGUI.exit();
        } else if (actionEvent.getSource() == this.helpAboutMenuItem) {
            this.moneydanceGUI.showAbout();
        } else if (actionEvent.getSource() == this.helpHelpMenuItem) {
            this.moneydanceGUI.showHelp();
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void saveWorkspace() {
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        Point point = this.getLocationOnScreen();
        userPreferences.setSetting("gui.screen_location", "" + point.x + 'x' + point.y);
        Dimension dimension = this.getSize();
        userPreferences.setSetting("gui.screen_size", "" + dimension.width + 'x' + dimension.height);
        if (this.currentPanel != null) {
            this.currentPanel.saveWorkspace();
        }
    }

    public void accountOpened() {
        this.fileSaveAsMenuItem.setEnabled(true);
        this.fileSaveMenuItem.setEnabled(true);
        this.toolsRemindersMenuItem.setEnabled(true);
        this.toolsTranslateCurrencyMenuItem.setEnabled(true);
        this.toolsCurrencyMenuItem.setEnabled(true);
    }

    public void accountClosed() {
        this.fileSaveAsMenuItem.setEnabled(false);
        this.fileSaveMenuItem.setEnabled(false);
        this.toolsRemindersMenuItem.setEnabled(false);
        this.toolsTranslateCurrencyMenuItem.setEnabled(false);
        this.toolsCurrencyMenuItem.setEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void restoreWorkspace() {
        int n;
        int n2;
        if (!Main.getMainController().getPreferences().getSetting("restore_desktop_on_startup", "y").toUpperCase().equals("Y")) {
            ((Component)this).setSize(700, 400);
            return;
        }
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        String string = userPreferences.getSetting("gui.screen_location", "10x10");
        String string2 = userPreferences.getSetting("gui.screen_size", "700x400");
        int n3 = string.indexOf(120);
        if (n3 > 0) {
            try {
                n2 = Integer.parseInt(string.substring(0, n3));
                n = Integer.parseInt(string.substring(n3 + 1));
            }
            catch (Exception exception) {
                System.err.println("Error trying to set window location: " + exception);
            }
        }
        if ((n3 = string2.indexOf(120)) > 0) {
            try {
                n2 = Integer.parseInt(string2.substring(0, n3));
                n = Integer.parseInt(string2.substring(n3 + 1));
                ((Component)this).setSize(new Dimension(n2, n));
            }
            catch (Exception exception) {
                System.err.println("Error trying to set window size: " + exception);
            }
        }
        if (this.currentPanel != null) {
            this.currentPanel.loadWorkspace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MainFrame(MoneydanceGUI moneydanceGUI) {
        super(TITLE);
        try {
            this.setIconImage(AwtUtil.loadImage("/com/seanreilly/apps/moneydance/images/dollar.gif"));
        }
        catch (Exception exception) {
            System.err.println("exception: " + exception);
            exception.printStackTrace(System.err);
        }
        this.moneydanceGUI = moneydanceGUI;
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu(this.moneydanceGUI.resources.getString("file"));
        this.menuBar.add(this.fileMenu);
        this.fileNewMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("new..."));
        this.fileMenu.add(this.fileNewMenuItem);
        this.fileOpenMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("open..."), new MenuShortcut(111));
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileSaveMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("save"), new MenuShortcut(115));
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileSaveAsMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("save_as..."));
        this.fileMenu.add(this.fileSaveAsMenuItem);
        this.filePreferencesMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("preferences..."), new MenuShortcut(112));
        this.fileMenu.add(this.filePreferencesMenuItem);
        this.fileQuitMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("quit"), new MenuShortcut(113));
        this.fileMenu.add(this.fileQuitMenuItem);
        this.toolsMenu = new Menu(this.moneydanceGUI.resources.getString("tools"));
        this.menuBar.add(this.toolsMenu);
        this.toolsImportMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("import_data..."));
        this.toolsMenu.add(this.toolsImportMenuItem);
        this.toolsExportMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("export_data..."));
        this.toolsMenu.add(this.toolsExportMenuItem);
        this.toolsCurrencyMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("edit_currencies..."));
        this.toolsMenu.add(this.toolsCurrencyMenuItem);
        this.toolsTranslateCurrencyMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("translate_currencies..."));
        this.toolsMenu.add(this.toolsTranslateCurrencyMenuItem);
        this.toolsRemindersMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("reminders..."));
        this.toolsMenu.add(this.toolsRemindersMenuItem);
        this.helpMenu = new Menu(this.moneydanceGUI.resources.getString("help"));
        this.menuBar.setHelpMenu(this.helpMenu);
        this.helpAboutMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("about_moneydance"));
        this.helpMenu.add(this.helpAboutMenuItem);
        this.helpHelpMenuItem = new MenuItem(this.moneydanceGUI.resources.getString("help_contents"));
        this.helpMenu.add(this.helpHelpMenuItem);
        this.setMenuBar(this.menuBar);
        this.enableEvents(201L);
        this.accountClosed();
        this.fileNewMenuItem.addActionListener(this);
        this.fileOpenMenuItem.addActionListener(this);
        this.fileSaveMenuItem.addActionListener(this);
        this.fileSaveAsMenuItem.addActionListener(this);
        this.filePreferencesMenuItem.addActionListener(this);
        this.fileQuitMenuItem.addActionListener(this);
        this.toolsImportMenuItem.addActionListener(this);
        this.toolsExportMenuItem.addActionListener(this);
        this.toolsCurrencyMenuItem.addActionListener(this);
        this.toolsTranslateCurrencyMenuItem.addActionListener(this);
        this.toolsRemindersMenuItem.addActionListener(this);
        this.helpAboutMenuItem.addActionListener(this);
        this.helpHelpMenuItem.addActionListener(this);
        this.toolsExportMenuItem.setEnabled(false);
        this.restoreWorkspace();
    }
}

