/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IncomeAccountInfoPanel
extends AccountInfoPanel
implements ChangeListener {
    private IncomeAccount account;
    private JTextField accountNameField;
    private JCheckBox isChildOfCheckbox;
    private JComboBox parentAccountChoice;
    private AccountListModel accountChoiceModel;
    private MoneydanceGUI moneydanceGUI;
    private CurrencyModel currencyModel;
    private JComboBox currencyChoice;
    private CurrencyTable currencyTable;

    private final void childCheckboxChanged() {
        if (this.isChildOfCheckbox.isSelected()) {
            if (this.accountChoiceModel.getSize() <= 0) {
                this.isChildOfCheckbox.setSelected(false);
            } else {
                this.parentAccountChoice.setEnabled(true);
            }
        } else {
            this.parentAccountChoice.setEnabled(false);
        }
    }

    public void setDataFromHashtable(Hashtable hashtable) {
        if (hashtable.containsKey("account_name")) {
            this.accountNameField.setText(String.valueOf(hashtable.get("account_name")));
        }
        if (hashtable.containsKey("currency")) {
            this.currencyChoice.setSelectedItem(hashtable.get("currency"));
        }
        if (hashtable.containsKey("income_account")) {
            this.parentAccountChoice.setSelectedItem(hashtable.get("income_account"));
        }
        if (hashtable.containsKey("income_parent_selected") && this.parentAccountChoice.getItemCount() > 0) {
            this.isChildOfCheckbox.setSelected("yes".equals(hashtable.get("income_parent_selected")));
        }
    }

    public void saveDataToHashtable(Hashtable hashtable) {
        hashtable.put("account_name", this.accountNameField.getText());
        hashtable.put("currency", this.currencyChoice.getSelectedItem());
        hashtable.put("income_account", this.parentAccountChoice.getSelectedItem());
        hashtable.put("income_parent_selected", this.isChildOfCheckbox.isSelected() ? "yes" : "no");
    }

    public void saveEdits() {
        if (this.account.getAccountNum() < 0) {
            this.account.setCurrencyType(((CurrencyType)this.currencyChoice.getSelectedItem()).getID());
        }
        this.account.setAccountName(this.accountNameField.getText());
        if (this.isChildOfCheckbox.isSelected()) {
            this.account.setParentAccount((Account)this.parentAccountChoice.getSelectedItem());
        } else {
            this.account.setParentAccount(this.account.getRootAccount());
        }
        this.account.getParentAccount().sortAccounts();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.isChildOfCheckbox) {
            this.childCheckboxChanged();
        }
    }

    public IncomeAccountInfoPanel(IncomeAccount incomeAccount, MoneydanceGUI moneydanceGUI) {
        this.account = incomeAccount;
        this.currencyTable = this.account.getRootAccount().getCurrencyTable();
        this.moneydanceGUI = moneydanceGUI;
        this.setLayout(new GridBagLayout());
        this.accountNameField = new JTextField(this.account.getAccountName(), 15);
        this.accountChoiceModel = new AccountListModel(incomeAccount.getRootAccount(), false);
        this.accountChoiceModel.setShowAccount(this.account, false);
        this.accountChoiceModel.setShowAccountsOfType(0, true);
        this.accountChoiceModel.setShowAccountsOfType(1, false);
        this.accountChoiceModel.setShowAccountsOfType(2, false);
        this.accountChoiceModel.setShowAccountsOfType(4, false);
        this.accountChoiceModel.setShowAccountsOfType(5, true);
        this.accountChoiceModel.setShowAccountsOfType(3, false);
        this.parentAccountChoice = new JComboBox(this.accountChoiceModel);
        this.isChildOfCheckbox = new JCheckBox(this.moneydanceGUI.resources.getString("is_child_of") + ": ", false);
        this.currencyModel = new CurrencyModel(this.currencyTable);
        this.currencyChoice = new JComboBox(this.currencyModel);
        this.currencyModel.setSelectedItem(this.currencyTable.getCurrencyType(this.account.getCurrencyType()));
        if (incomeAccount.getAccountNum() >= 0) {
            this.currencyChoice.setEnabled(false);
        }
        if (incomeAccount.getParentAccount().getAccountType() != 0) {
            this.isChildOfCheckbox.setSelected(true);
            this.parentAccountChoice.setSelectedItem(incomeAccount.getParentAccount());
        } else {
            this.parentAccountChoice.setSelectedIndex(0);
            this.parentAccountChoice.setEnabled(false);
        }
        int n = 0;
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("account_name") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.accountNameField, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("currency_type") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.currencyChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.isChildOfCheckbox, AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.parentAccountChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 1, 1, true, false));
        this.isChildOfCheckbox.addChangeListener(this);
        this.setSize(this.getPreferredSize());
    }
}

