/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.TransactionEditor;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JRateField;
import com.seanreilly.util.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExchangeRateEditor
extends JPanel
implements ItemListener,
KeyListener {
    private CurrencyTable currencyTable;
    private MoneydanceGUI moneydanceGUI;
    private TransactionEditor editor;
    private JComboBox rateDirectionChoice;
    private JRateField rateField;
    private JLabel otherAmountLabel;
    private CurrencyType primaryCurrency = null;
    private CurrencyType otherCurrency = null;
    private DefaultComboBoxModel choiceModel = new DefaultComboBoxModel();
    private int lastDirection = 0;
    private char dec;
    private char com;

    public void setOtherCurrencyType(CurrencyType currencyType) {
        this.otherCurrency = currencyType;
        this.resetDirectionChoice();
        this.refresh();
    }

    public void addFieldFocusListener(FocusListener focusListener) {
        this.rateField.addFocusListener(focusListener);
    }

    public void removeFieldFocusListener(FocusListener focusListener) {
        this.rateField.removeFocusListener(focusListener);
    }

    public void setEnabled(boolean bl) {
        this.rateField.setEditable(bl);
        this.rateDirectionChoice.setEnabled(bl);
    }

    public double getValue() {
        if (this.rateDirectionChoice.getSelectedIndex() == 0) {
            return this.rateField.getValue();
        }
        return this.rateField.getValue();
    }

    public void setValue(double d) {
        if (this.rateDirectionChoice.getSelectedIndex() == 0) {
            this.rateField.setValue(d);
        } else {
            this.rateField.setValue(1.0 / d);
        }
        this.refresh();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.rateField.isEditable()) {
            this.refresh();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private final void resetDirectionChoice() {
        if (this.otherCurrency == null || this.primaryCurrency == null || this.otherCurrency.getID().equals(this.primaryCurrency.getID())) {
            this.rateField.setValue(1.0);
            this.rateField.setEditable(false);
            this.rateDirectionChoice.setEnabled(false);
            this.otherAmountLabel.setText("");
            return;
        }
        int n = this.rateDirectionChoice.getSelectedIndex();
        this.choiceModel.insertElementAt(this.primaryCurrency.getID() + '/' + this.otherCurrency.getID(), 0);
        if (this.choiceModel.getSize() > 2) {
            this.choiceModel.removeElementAt(1);
        }
        this.choiceModel.insertElementAt(this.otherCurrency.getID() + '/' + this.primaryCurrency.getID(), 1);
        if (this.choiceModel.getSize() > 2) {
            this.choiceModel.removeElementAt(2);
        }
        if (n >= 0) {
            this.rateDirectionChoice.setSelectedIndex(n);
        } else {
            this.rateDirectionChoice.setSelectedIndex(0);
        }
    }

    public void refresh() {
        int n;
        if (this.otherCurrency == null || this.primaryCurrency == null || this.otherCurrency.getID().equals(this.primaryCurrency.getID())) {
            this.rateField.setValue(1.0);
            this.rateField.setEditable(false);
            this.rateDirectionChoice.setEnabled(false);
            this.otherAmountLabel.setText("");
            return;
        }
        double d = this.rateField.getValue();
        if (d == 0.0) {
            d = 1.0E-9;
        }
        if ((n = this.rateDirectionChoice.getSelectedIndex()) == 1) {
            d = 1.0 / d;
        }
        if (n == 0 || n == 1) {
            this.rateField.setEditable(true);
            this.rateDirectionChoice.setEnabled(true);
        } else {
            this.otherAmountLabel.setText("");
            this.rateField.setEditable(false);
            this.rateDirectionChoice.setEnabled(false);
        }
        long l = this.editor.getTransactionAmount();
        long l2 = CurrencyTable.convertValue(l, this.primaryCurrency, this.otherCurrency, d);
        this.otherAmountLabel.setText((" => " + this.otherCurrency.getPrefix() + " " + StringUtils.formatCurrency(Math.abs(l2), true, this.dec, this.com, this.otherCurrency.getDecimalPlaces()) + " " + this.otherCurrency.getSuffix()).trim() + " (" + this.otherCurrency.getID() + ')');
        this.validate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.rateDirectionChoice) {
            int n = this.rateDirectionChoice.getSelectedIndex();
            if (n != this.lastDirection) {
                double d = this.rateField.getValue();
                if (d == 0.0) {
                    d = 1.0E-8;
                }
                this.rateField.setValue(1.0 / d);
                this.refresh();
            }
            this.lastDirection = n;
        }
    }

    public ExchangeRateEditor(MoneydanceGUI moneydanceGUI, CurrencyTable currencyTable, CurrencyType currencyType, TransactionEditor transactionEditor) {
        this.currencyTable = currencyTable;
        this.moneydanceGUI = moneydanceGUI;
        this.primaryCurrency = currencyType;
        this.editor = transactionEditor;
        this.setLayout(new GridBagLayout());
        this.dec = Main.getMainController().getPreferences().getDecimalChar();
        this.com = (char)(this.dec == ',' ? 46 : 44);
        this.rateField = new JRateField(this.dec);
        this.rateDirectionChoice = new JComboBox(this.choiceModel);
        this.otherAmountLabel = new JLabel("     ", 4);
        Font font = this.otherAmountLabel.getFont();
        this.otherAmountLabel.setFont(new Font(font.getName(), 2, font.getSize()));
        int n = 0;
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_rate") + ":  ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.rateField, AwtUtil.getConstraints(1, n, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.rateDirectionChoice, AwtUtil.getConstraints(2, n++, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.otherAmountLabel, AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        this.rateDirectionChoice.addItemListener(this);
        this.rateField.addKeyListener(this);
    }
}

