/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountDetailInterface;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.TransactionRenderer;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StringUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class DefaultAccountDetailPanel
extends JPanel
implements AccountDetailInterface,
AccountInfoListener,
AccountListener,
ItemListener {
    private String[] sortByItems;
    private Account account;
    private CurrencyType currencyType;
    private int numDecimals;
    private int centMult;
    private MoneydanceGUI moneydanceGUI;
    private JLabel accountNameLabel;
    private JLabel balanceLabel;
    private JLabel clearedBalanceLabel;
    private JComboBox sortByChoice;
    private AccountTransactionSet transactionSet;
    private JTable transactionTable;
    private JList transactionList;
    private UserPreferences prefs;
    private JCheckBox twoLineCheckbox;
    private TransactionRenderer txnRenderer;
    private RootAccount rootAccount;

    public void accountModified(Account account) {
        if (account != this.account) {
            return;
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public void goingAway() {
    }

    public void goneAway() {
        this.transactionSet.removeAccountInfoListener(this);
        this.sortByChoice.removeItemListener(this);
        this.transactionSet.disconnect();
    }

    public void accountInfoUpdated(Object object) {
        if (object == this.transactionSet) {
            char c = this.prefs.getDecimalChar();
            char c2 = c == ',' ? (char)'.' : ',';
            this.balanceLabel.setText(this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.transactionSet.getBalance(), true, c, c2, this.numDecimals, this.centMult) + ' ' + this.currencyType.getSuffix());
            this.clearedBalanceLabel.setText(this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.transactionSet.getClearedBalance(), true, c, c2, this.numDecimals, this.centMult) + ' ' + this.currencyType.getSuffix());
            this.validate();
        }
    }

    private final void setTwoLineDisplay() {
        if (this.twoLineCheckbox.isSelected()) {
            this.txnRenderer.setDisplayTwoLines(true);
            this.prefs.setSetting("gui.two_line_transactions", "y");
            this.transactionList.setPrototypeCellValue(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, new Date().getTime(), new Date().getTime(), new Date().getTime(), ' ', ' ', "", null, ""));
        } else {
            this.txnRenderer.setDisplayTwoLines(false);
            this.prefs.setSetting("gui.two_line_transactions", "n");
            this.transactionList.setPrototypeCellValue(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, new Date().getTime(), new Date().getTime(), new Date().getTime(), ' ', ' ', "", null, ""));
        }
        this.validate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sortByChoice) {
            this.transactionSet.sortTransactions(this.sortByChoice.getSelectedIndex());
        } else if (itemEvent.getSource() == this.twoLineCheckbox) {
            this.setTwoLineDisplay();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public DefaultAccountDetailPanel(MoneydanceGUI moneydanceGUI, Account account) {
        this.moneydanceGUI = moneydanceGUI;
        this.account = account;
        this.transactionSet = new AccountTransactionSet(account);
        this.rootAccount = account.getRootAccount();
        this.currencyType = this.rootAccount.getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.numDecimals = this.currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.prefs = Main.getMainController().getPreferences();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.balanceLabel = new JLabel("?", 4);
        this.clearedBalanceLabel = new JLabel("?", 4);
        this.sortByChoice = new JComboBox(new String[]{this.moneydanceGUI.resources.getString("sortby_date"), this.moneydanceGUI.resources.getString("sortby_date_entered"), this.moneydanceGUI.resources.getString("sortby_description"), this.moneydanceGUI.resources.getString("sortby_amount"), this.moneydanceGUI.resources.getString("sortby_status"), this.moneydanceGUI.resources.getString("sortby_account"), this.moneydanceGUI.resources.getString("sortby_date_status"), this.moneydanceGUI.resources.getString("sortby_date_amount")});
        this.sortByChoice.setSelectedIndex(0);
        this.accountNameLabel = new JLabel(Account.getAccountTypeName(account.getAccountType()) + ' ' + this.moneydanceGUI.resources.getString("account") + "; " + this.moneydanceGUI.resources.getString("currency") + ": " + this.currencyType.getName(), 2);
        this.setLayout(gridBagLayout);
        this.twoLineCheckbox = new JCheckBox(this.moneydanceGUI.resources.getString("show_two_lines"), this.prefs.getSetting("gui.two_line_transactions", "n").equals("y"));
        this.transactionList = new JList(this.transactionSet);
        this.txnRenderer = new TransactionRenderer(account, this.moneydanceGUI, this.twoLineCheckbox.isSelected(), false);
        this.transactionList.setCellRenderer(this.txnRenderer);
        this.accountNameLabel = new JLabel(this.moneydanceGUI.resources.getString("acct_type" + account.getAccountType()) + "; " + this.moneydanceGUI.resources.getString("currency") + ": " + this.currencyType.getName(), 2);
        this.add((Component)this.accountNameLabel, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 2, 1, true, true));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("sort_by") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.sortByChoice, AwtUtil.getConstraints(1, 1, 0.0f, 0.0f, 1, 1, false, false));
        this.add((Component)this.twoLineCheckbox, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, false, false));
        this.add((Component)new JLabel(""), AwtUtil.getConstraints(3, 1, 1.0f, 0.0f, 1, 1, false, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("balance") + ":   ", 4), AwtUtil.getConstraints(4, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.balanceLabel, AwtUtil.getConstraints(5, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("cleared_balance") + ":   ", 4), AwtUtil.getConstraints(4, 1, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.clearedBalanceLabel, AwtUtil.getConstraints(5, 1, 0.0f, 0.0f, 1, 1, true, false));
        JScrollPane jScrollPane = new JScrollPane(this.transactionList);
        jScrollPane.setColumnHeaderView(this.txnRenderer.getHeaderRenderer(this.transactionList));
        this.add((Component)jScrollPane, AwtUtil.getConstraints(0, 5, 1.0f, 1.0f, 6, 1, true, true));
        this.transactionSet.addAccountInfoListener(this);
        this.twoLineCheckbox.addItemListener(this);
        this.sortByChoice.addItemListener(this);
        this.accountInfoUpdated(this.transactionSet);
        this.accountModified(account);
    }
}

