/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.NewCurrencyWindow;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JRateField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CurrencyInfoPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private CurrencyModel currencyModel;
    private CurrencyTable currencyTable;
    private JList currencyList;
    private JTextField idField;
    private JTextField nameField;
    private JRateField rateField;
    private JTextField tickerSymbolField;
    private JTextField prefixField;
    private JTextField suffixField;
    private JTextField numDecimalField;
    private JButton newCurrencyButton;
    private JButton setBaseButton;
    private JLabel baseLabel;
    private ResourceBundle resources;
    private CurrencyType currentCurrency = null;

    public CurrencyType getSelectedCurrency() {
        return (CurrencyType)this.currencyList.getSelectedValue();
    }

    public void goingAway() {
        this.savePreviousValue();
        this.currencyModel.goneAway();
    }

    private final void newCurrencyButtonPressed() {
        Object object = this.currencyList.getSelectedValue();
        NewCurrencyWindow newCurrencyWindow = new NewCurrencyWindow(this.currencyTable);
        ((Component)newCurrencyWindow).setVisible(true);
        CurrencyType currencyType = newCurrencyWindow.getNewCurrencyType();
        if (currencyType != null) {
            this.currencyTable.addCurrencyType(currencyType);
            this.currencyList.setSelectedValue(currencyType, true);
            this.itemSelected();
        }
        this.currencyList.validate();
        this.currencyList.repaint();
    }

    private final void setBaseButtonPressed() {
        if (this.currentCurrency == null) {
            this.getToolkit().beep();
            return;
        }
        this.currencyTable.setBaseType(this.currentCurrency);
        this.rateField.setValue(1.0);
        this.rateField.setEditable(false);
        this.baseLabel.setText(this.currentCurrency.toString());
    }

    private final void savePreviousValue() {
        if (this.currentCurrency == null) {
            return;
        }
        this.currentCurrency.setName(this.nameField.getText());
        this.currentCurrency.setXRelativeRate(this.rateField.getValue(), this.currencyTable.getBaseType());
        this.currentCurrency.setTickerSymbol(this.tickerSymbolField.getText());
        this.currentCurrency.setPrefix(this.prefixField.getText());
        this.currentCurrency.setSuffix(this.suffixField.getText());
        this.currencyModel.resynchronize();
    }

    private final void itemSelected() {
        this.savePreviousValue();
        this.currentCurrency = this.getSelectedCurrency();
        if (this.currentCurrency == null) {
            this.idField.setText("");
            this.nameField.setText("");
            this.nameField.setEditable(false);
            this.rateField.setValue(1.0);
            this.rateField.setEditable(false);
            this.tickerSymbolField.setText("");
            this.tickerSymbolField.setEditable(false);
            this.prefixField.setText("");
            this.prefixField.setEditable(false);
            this.suffixField.setText("");
            this.suffixField.setEditable(false);
            this.numDecimalField.setText("");
        } else {
            this.idField.setText("" + this.currentCurrency.getID());
            this.nameField.setText(this.currentCurrency.getName());
            this.nameField.setEditable(true);
            this.rateField.setValue(this.currentCurrency.getXRelativeRate(this.currencyTable.getBaseType()));
            if (!this.currentCurrency.getID().equals(this.currencyTable.getBaseType().getID())) {
                this.rateField.setEditable(true);
            } else {
                this.rateField.setEditable(false);
            }
            this.tickerSymbolField.setText(this.currentCurrency.getTickerSymbol());
            this.tickerSymbolField.setEditable(true);
            this.prefixField.setText(this.currentCurrency.getPrefix());
            this.prefixField.setEditable(true);
            this.suffixField.setText(this.currentCurrency.getSuffix());
            this.suffixField.setEditable(true);
            this.numDecimalField.setText("" + this.currentCurrency.getDecimalPlaces());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newCurrencyButton) {
            this.newCurrencyButtonPressed();
        } else if (actionEvent.getSource() == this.setBaseButton) {
            this.setBaseButtonPressed();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.currencyList) {
            this.itemSelected();
        }
    }

    public CurrencyInfoPanel(CurrencyTable currencyTable) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.currencyTable = currencyTable;
        this.resources = Main.getMainController().getResources();
        this.currencyModel = new CurrencyModel(currencyTable);
        this.currencyList = new JList(this.currencyModel);
        char c = Main.getMainController().getPreferences().getDecimalChar();
        int n = c == ',' ? 46 : 44;
        this.baseLabel = new JLabel(currencyTable.getBaseType().toString(), 2);
        this.idField = new JTextField("");
        this.idField.setEditable(false);
        this.nameField = new JTextField("", 20);
        this.rateField = new JRateField(c);
        this.tickerSymbolField = new JTextField();
        this.prefixField = new JTextField();
        this.suffixField = new JTextField();
        this.numDecimalField = new JTextField("");
        this.numDecimalField.setEditable(false);
        this.newCurrencyButton = new JButton(this.resources.getString("new..."));
        this.setBaseButton = new JButton(this.resources.getString("set_base_currency"));
        int n2 = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, AwtUtil.getConstraints(0, n2++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel.add((Component)new JLabel(this.resources.getString("base_currency") + ": ", 4), AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.baseLabel, AwtUtil.getConstraints(1, 0, 1.0f, 1.0f, 1, 1, true, true));
        this.add((Component)new JLabel(this.resources.getString("currency_id") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.idField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.resources.getString("currency_name") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.nameField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.resources.getString("currency_rate") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.rateField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.resources.getString("currency_ticker") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.tickerSymbolField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.resources.getString("currency_prefix") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.prefixField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.resources.getString("currency_suffix") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.suffixField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.resources.getString("currency_num_decimal_points") + ":  ", 4), AwtUtil.getConstraints(1, n2, 0.0f, 1.0f, 1, 1, true, true));
        this.add((Component)this.numDecimalField, AwtUtil.getConstraints(2, n2++, 1.0f, 1.0f, 1, 1, true, false));
        this.add((Component)this.newCurrencyButton, AwtUtil.getConstraints(1, n2++, 1.0f, 0.0f, 2, 1, true, true));
        this.add((Component)this.setBaseButton, AwtUtil.getConstraints(1, n2++, 1.0f, 0.0f, 2, 1, true, true));
        this.add((Component)new JScrollPane(this.currencyList), AwtUtil.getConstraints(0, 1, 1.0f, 1.0f, 1, n2 - 1, true, true, 10, 4));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.add((Component)jPanel2, AwtUtil.getConstraints(n2, 0, 1.0f, 0.0f, 3, 1, true, true));
        this.currencyList.addListSelectionListener(this);
        this.newCurrencyButton.addActionListener(this);
        this.setBaseButton.addActionListener(this);
    }
}

