/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.CurrencyModel;
import com.seanreilly.apps.moneydance.view.gui.EditCurrencyWindow;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StreamTable;
import com.seanreilly.util.StreamVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CreateFileWindow
extends JDialog
implements ActionListener,
ItemListener {
    private JButton okButton;
    private JButton cancelButton;
    private JButton editCurrencyButton;
    private JComboBox fileTypeChoice;
    private JComboBox currencyTypeChoice;
    private JTextArea fileDescriptionArea;
    private CurrencyTable currencyTable;
    private CurrencyModel currencyModel;
    private MoneydanceGUI moneydanceGUI;
    private boolean wasCancelled = true;
    private RootAccount newAccount = null;
    private JFrame parentFrame;

    private final void fileTypeSelected() {
        int n = this.fileTypeChoice.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.fileDescriptionArea.setText(this.moneydanceGUI.resources.getString("new_file_desc" + n));
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public RootAccount getNewAccount() {
        return this.newAccount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void createNewAccount() {
        String string = ((CurrencyType)this.currencyTypeChoice.getSelectedItem()).getID();
        int n = this.fileTypeChoice.getSelectedIndex();
        StreamTable streamTable = new StreamTable();
        try {
            streamTable.readFrom(ClassLoader.getSystemResourceAsStream(this.moneydanceGUI.resources.getString("new_file_contents" + n)));
            StreamTable streamTable2 = (StreamTable)streamTable.get("root");
            this.newAccount = new RootAccount(string, this.currencyTable);
            this.newAccount.setAccountName("" + streamTable2.get("acct_name"));
            this.readAccountsFromTable(this.newAccount, (StreamVector)streamTable2.get("sub_accounts"), string);
            return;
        }
        catch (Exception exception) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("error") + ": " + exception);
        }
    }

    private final void readAccountsFromTable(Account account, StreamVector streamVector, String string) throws Exception {
        if (streamVector == null) {
            return;
        }
        Enumeration enumeration = streamVector.elements();
        while (enumeration.hasMoreElements()) {
            StreamTable streamTable = (StreamTable)enumeration.nextElement();
            String string2 = (String)streamTable.get("acct_name");
            String string3 = (String)streamTable.get("acct_type");
            String string4 = (String)streamTable.get("currency_type");
            if (string2 == null) {
                throw new Exception(this.moneydanceGUI.resources.getString("new_file_inv_acct_name") + ": " + string4);
            }
            if (string4 != null && string4.equals("*DEFAULT*")) {
                string4 = string;
            }
            if (string4 == null || this.currencyTable.getCurrencyType(string4) == null) {
                throw new Exception(this.moneydanceGUI.resources.getString("new_file_inv_curr_type") + ": " + string4);
            }
            Account account2 = null;
            if (string3 != null && string3.equals("BANK")) {
                account2 = new BankAccount(string2, -1, string4, null, null, account);
            } else if (string3 != null && string3.equals("INCOME")) {
                account2 = new IncomeAccount(string2, -1, string4, null, null, account);
            } else if (string3 != null && string3.equals("EXPENSE")) {
                account2 = new ExpenseAccount(string2, -1, string4, null, null, account);
            } else {
                throw new Exception(this.moneydanceGUI.resources.getString("new_file_inv_acct_type") + ": " + string4);
            }
            account.addSubAccount(account2);
            this.readAccountsFromTable(account2, (StreamVector)streamTable.get("sub_accounts"), string);
        }
    }

    public void dispose() {
        super.dispose();
        this.currencyModel.goneAway();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.wasCancelled = false;
            this.createNewAccount();
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.wasCancelled = true;
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.editCurrencyButton) {
            EditCurrencyWindow editCurrencyWindow = new EditCurrencyWindow(this.parentFrame, this.currencyTable);
            ((Component)editCurrencyWindow).setVisible(true);
            this.currencyModel.resynchronize();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.fileTypeChoice) {
            this.fileTypeSelected();
        }
    }

    public CreateFileWindow(JFrame jFrame, MoneydanceGUI moneydanceGUI) {
        super(jFrame, moneydanceGUI.resources.getString("new_file_win_title"), true);
        this.parentFrame = jFrame;
        this.currencyTable = CurrencyTable.createDefaultTable(moneydanceGUI.resources.getString("default_currency"));
        this.moneydanceGUI = moneydanceGUI;
        Object[] objectArray = new String[]{this.moneydanceGUI.resources.getString("new_file_type0"), this.moneydanceGUI.resources.getString("new_file_type1")};
        this.fileTypeChoice = new JComboBox(objectArray);
        this.fileTypeChoice.setSelectedIndex(0);
        this.fileTypeChoice.addItemListener(this);
        this.editCurrencyButton = new JButton(this.moneydanceGUI.resources.getString("edit..."));
        this.fileDescriptionArea = new JTextArea(this.moneydanceGUI.resources.getString("new_file_desc0"));
        this.fileDescriptionArea.setEditable(false);
        this.fileDescriptionArea.setBackground(((Component)this).getBackground());
        this.currencyModel = new CurrencyModel(this.currencyTable);
        this.currencyTypeChoice = new JComboBox(this.currencyModel);
        this.currencyTypeChoice.setSelectedItem(this.currencyTable.getBaseType());
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.okButton = new JButton(this.moneydanceGUI.resources.getString("ok"));
        this.cancelButton = new JButton(this.moneydanceGUI.resources.getString("cancel"));
        int n = 0;
        jPanel2.add((Component)new JLabel(this.moneydanceGUI.resources.getString("new_file_header"), 0), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel2.add((Component)new JLabel(this.moneydanceGUI.resources.getString("new_file_currency") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.currencyTypeChoice, AwtUtil.getConstraints(1, n, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.editCurrencyButton, AwtUtil.getConstraints(2, n++, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(this.moneydanceGUI.resources.getString("new_file_type") + ": ", 4), AwtUtil.getConstraints(0, n, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)this.fileTypeChoice, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel2.add((Component)new JLabel(""), AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel2.add((Component)this.fileDescriptionArea, AwtUtil.getConstraints(1, n++, 1.0f, 0.0f, 2, 1, true, true));
        jPanel2.add((Component)new JLabel(""), AwtUtil.getConstraints(0, n++, 1.0f, 1.0f, 3, 1, true, true));
        jPanel3.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel3.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.editCurrencyButton.addActionListener(this);
        this.fileTypeSelected();
        ((Component)this).setSize(530, 300);
        Dimension dimension = this.getSize();
        Dimension dimension2 = jFrame.getSize();
        Point point = jFrame.getLocation();
        ((Component)this).setLocation(point.x + dimension2.width / 2 - dimension.width / 2, point.y + dimension2.height / 2 - dimension.height / 2);
    }
}

