/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountModel;
import com.seanreilly.apps.moneydance.view.gui.AccountSelectionListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class COATreePanel
extends JPanel
implements ChangeListener {
    private Vector listeners;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private JTree coaTree;
    private AccountModel treeModel;
    private JPanel controlPanel;
    private JCheckBox showAllAccountsCheckbox;
    private AccountTreeCellRenderer cellRenderer;
    private TreePath lastPath = null;

    public void goingAway() {
        this.treeModel.goingAway();
    }

    public void goneAway() {
        this.showAllAccountsCheckbox.removeChangeListener(this);
        this.treeModel.goneAway();
    }

    public void addAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.addElement(accountSelectionListener);
    }

    public void removeAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.removeElement(accountSelectionListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireAccountSelected(Account account) {
        this.cellRenderer.setSelectedAccoundID(account.getAccountNum());
        this.coaTree.repaint();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).accountSelected(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireEditAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).editAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireCreateAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).createAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireDeleteAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).deleteAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireGraphAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).graphAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireReportOnAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).reportOnAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    private final void showAccountsChanged() {
        TreePath treePath = this.coaTree.getSelectionPath();
        this.treeModel.setShowNonRegisterAccounts(this.showAllAccountsCheckbox.isSelected());
        if (treePath != null) {
            this.coaTree.setSelectionPath(treePath);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.showAllAccountsCheckbox) {
            this.showAccountsChanged();
        }
    }

    private final void singleRightClickOnAccount(Account account, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(this.moneydanceGUI.resources.getString("new..."));
        JMenuItem jMenuItem2 = new JMenuItem(this.moneydanceGUI.resources.getString("edit..."));
        JMenuItem jMenuItem3 = null;
        JMenuItem jMenuItem4 = null;
        JMenuItem jMenuItem5 = null;
        if (account.getAccountType() != 0) {
            jMenuItem3 = new JMenuItem(this.moneydanceGUI.resources.getString("delete..."));
            jMenuItem4 = new JMenuItem(this.moneydanceGUI.resources.getString("graph..."));
            jMenuItem5 = new JMenuItem(this.moneydanceGUI.resources.getString("report..."));
        }
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        if (account.getAccountType() != 0) {
            jPopupMenu.add(jMenuItem3);
            jPopupMenu.add(jMenuItem4);
            jPopupMenu.add(jMenuItem5);
        }
        jPopupMenu.setLightWeightPopupEnabled(false);
        COATreePanel cOATreePanel = this;
        if (cOATreePanel == null) {
            throw null;
        }
        AccountPopupListener accountPopupListener = cOATreePanel.new AccountPopupListener(account, jMenuItem, jMenuItem2, jMenuItem3, jMenuItem4, jMenuItem5);
        jMenuItem2.addActionListener(accountPopupListener);
        jMenuItem.addActionListener(accountPopupListener);
        if (account.getAccountType() != 0) {
            jMenuItem3.addActionListener(accountPopupListener);
            jMenuItem4.addActionListener(accountPopupListener);
            jMenuItem5.addActionListener(accountPopupListener);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        jMenuItem.paintImmediately(jMenuItem.getVisibleRect());
        jMenuItem2.paintImmediately(jMenuItem2.getVisibleRect());
        if (account.getAccountType() != 0) {
            jMenuItem3.paintImmediately(jMenuItem3.getVisibleRect());
            jMenuItem4.paintImmediately(jMenuItem4.getVisibleRect());
            jMenuItem5.paintImmediately(jMenuItem5.getVisibleRect());
        }
        jPopupMenu.paintImmediately(jPopupMenu.getVisibleRect());
    }

    /* synthetic */ JTree access$0() {
        return this.coaTree;
    }

    /* synthetic */ void access$1(Account account, MouseEvent mouseEvent) {
        this.singleRightClickOnAccount(account, mouseEvent);
    }

    /* synthetic */ void access$2(Account account) {
        this.fireAccountSelected(account);
    }

    /* synthetic */ void access$3(Account account) {
        this.fireCreateAccount(account);
    }

    /* synthetic */ void access$4(Account account) {
        this.fireEditAccount(account);
    }

    /* synthetic */ void access$5(Account account) {
        this.fireDeleteAccount(account);
    }

    /* synthetic */ void access$6(Account account) {
        this.fireGraphAccount(account);
    }

    /* synthetic */ void access$7(Account account) {
        this.fireReportOnAccount(account);
    }

    public COATreePanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.setLayout(new BorderLayout());
        this.listeners = new Vector();
        this.treeModel = new AccountModel(rootAccount);
        this.coaTree = new JTree(this.treeModel);
        this.showAllAccountsCheckbox = new JCheckBox(this.moneydanceGUI.resources.getString("show_all_accounts"), true);
        this.cellRenderer = new AccountTreeCellRenderer(this.moneydanceGUI);
        this.coaTree.setCellRenderer(this.cellRenderer);
        this.coaTree.setSelectionModel(null);
        JScrollPane jScrollPane = new JScrollPane(this.coaTree, 20, 30);
        this.controlPanel = new JPanel(new FlowLayout());
        this.controlPanel.add(this.showAllAccountsCheckbox);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.controlPanel, "South");
        this.showAllAccountsCheckbox.addChangeListener(this);
        COATreePanel cOATreePanel = this;
        if (cOATreePanel == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(cOATreePanel){
            private final /* synthetic */ COATreePanel this$0;
            private boolean isPopupTrigger;

            public final void mousePressed(MouseEvent mouseEvent) {
                int n = this.this$0.access$0().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                TreePath treePath = this.this$0.access$0().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                Account account = (Account)treePath.getLastPathComponent();
                if (mouseEvent.isPopupTrigger()) {
                    this.isPopupTrigger = true;
                    if (n != -1 && mouseEvent.getClickCount() == 1) {
                        this.this$0.access$1(account, mouseEvent);
                    }
                }
            }

            public final void mouseClicked(MouseEvent mouseEvent) {
                int n = this.this$0.access$0().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n < 0) {
                    return;
                }
                TreePath treePath = this.this$0.access$0().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                Account account = (Account)treePath.getLastPathComponent();
                if (mouseEvent.isPopupTrigger() && !this.isPopupTrigger) {
                    this.isPopupTrigger = false;
                } else if (mouseEvent.getClickCount() >= 1) {
                    this.this$0.access$2(account);
                }
            }
            {
                this.this$0 = cOATreePanel;
                this.isPopupTrigger = false;
                this.constructor$0(cOATreePanel);
            }

            public void constructor$0(COATreePanel cOATreePanel) {
            }
        };
        this.coaTree.addMouseListener(mouseAdapter);
        this.coaTree.setSelectionRow(0);
    }

    class AccountPopupListener
    implements ActionListener {
        private Account account;
        private JMenuItem newAccountMenuItem;
        private JMenuItem editAccountMenuItem;
        private JMenuItem deleteAccountMenuItem;
        private JMenuItem graphAccountMenuItem;
        private JMenuItem reportAccountMenuItem;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.newAccountMenuItem) {
                COATreePanel.this.access$3(this.account);
            } else if (actionEvent.getSource() == this.editAccountMenuItem) {
                COATreePanel.this.access$4(this.account);
            } else if (actionEvent.getSource() == this.deleteAccountMenuItem) {
                COATreePanel.this.access$5(this.account);
            } else if (actionEvent.getSource() == this.graphAccountMenuItem) {
                COATreePanel.this.access$6(this.account);
            } else if (actionEvent.getSource() == this.reportAccountMenuItem) {
                COATreePanel.this.access$7(this.account);
            }
        }

        public AccountPopupListener(Account account, JMenuItem jMenuItem, JMenuItem jMenuItem2, JMenuItem jMenuItem3, JMenuItem jMenuItem4, JMenuItem jMenuItem5) {
            this.account = account;
            this.newAccountMenuItem = jMenuItem;
            this.editAccountMenuItem = jMenuItem2;
            this.deleteAccountMenuItem = jMenuItem3;
            this.graphAccountMenuItem = jMenuItem4;
            this.reportAccountMenuItem = jMenuItem5;
        }
    }
}

