/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.BasicReminder;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.ScheduleInfoPanel;
import com.seanreilly.awt.AwtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BasicReminderInfoWindow
extends JDialog
implements ActionListener {
    private BasicReminder reminder;
    private ReminderSet reminderSet;
    private ScheduleInfoPanel scheduleInfoPanel;
    private JTextField descField;
    private JTextArea memoField;
    private JButton okButton;
    private JButton cancelButton;

    private final void setFields() {
        this.scheduleInfoPanel.setScheduleData(this.reminder);
        this.descField.setText(this.reminder.getDescription());
        this.memoField.setText(this.reminder.getMemo());
    }

    private final void okButtonPressed() {
        this.scheduleInfoPanel.getScheduleData(this.reminder);
        this.reminder.setDescription(this.descField.getText());
        this.reminder.setMemo(this.memoField.getText());
        ((Component)this).setVisible(false);
        this.dispose();
        this.reminderSet.reminderModified(this.reminder);
    }

    private final void cancelButtonPressed() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.okButtonPressed();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButtonPressed();
        }
    }

    public BasicReminderInfoWindow(MoneydanceGUI moneydanceGUI, BasicReminder basicReminder, ReminderSet reminderSet) {
        super(moneydanceGUI.getTopLevelFrame(), moneydanceGUI.resources.getString("r_gen_editwin"), true);
        this.reminder = basicReminder;
        this.reminderSet = reminderSet;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.scheduleInfoPanel = new ScheduleInfoPanel(moneydanceGUI);
        this.descField = new JTextField();
        this.memoField = new JTextArea(5, 40);
        this.okButton = new JButton(moneydanceGUI.resources.getString("ok"));
        this.cancelButton = new JButton(moneydanceGUI.resources.getString("cancel"));
        jPanel.add((Component)new JLabel(moneydanceGUI.resources.getString("r_desc") + ": ", 2), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.descField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(moneydanceGUI.resources.getString("r_memo") + ": ", 2), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JScrollPane(this.memoField), AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 2, 1, true, true));
        jPanel.add((Component)this.scheduleInfoPanel, AwtUtil.getConstraints(0, 3, 1.0f, 0.0f, 2, 1, true, true));
        jPanel.add((Component)jPanel2, AwtUtil.getConstraints(0, 4, 1.0f, 0.0f, 2, 1, true, true));
        jPanel2.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0f, 0.0f, 1, 1, false, false));
        jPanel2.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, false, false));
        this.getContentPane().add((Component)jPanel, "Center");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.setFields();
        Dimension dimension = this.getPreferredSize();
        ((Component)this).setSize(dimension.width + 40, dimension.height + 40);
    }
}

