/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.view.gui.AccountKeySelectionManager;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.EditTransactionListener;
import com.seanreilly.apps.moneydance.view.gui.ExchangeRateEditor;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.SplitEditor;
import com.seanreilly.apps.moneydance.view.gui.TransactionEditor;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.awt.JCurrencyField;
import com.seanreilly.awt.JDateField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class BankTransactionEditor
extends TransactionEditor
implements ActionListener,
KeyListener,
FocusListener,
ItemListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private JDateField dateField;
    private JDateField taxableDateField;
    private JComboBox accountChoice;
    private JTextField descriptionField;
    private JComboBox clearedStatusChoice;
    private JCurrencyField debitAmountField;
    private JCurrencyField creditAmountField;
    private JTextField checkNumField;
    private JTextArea memoField;
    private JLabel numSplitsLabel;
    private AccountListModel accountModel;
    private ExchangeRateEditor rateEditor;
    private JButton recordButton;
    private JButton cancelButton;
    private JButton deleteButton;
    private JButton splitsButton;
    private EditTransactionListener listener;
    private Account account;
    private CurrencyType currencyType;
    private CurrencyTable currencyTable;
    private Vector splits = null;
    private Vector removedSplits = null;
    private BankTransaction currentTransaction;
    private boolean inverseAccounts = false;
    private boolean adjustingAccountChoice = false;
    private AccountTransactionSet transactionSet;
    private boolean editingSplits = false;
    private boolean completing = false;
    private boolean descriptionWasCompleted = false;
    private Transaction matchedTransaction = null;

    private final void synchronizeDates() {
        this.taxableDateField.setDate(this.dateField.getDate());
    }

    private final void setDateToToday(JDateField jDateField) {
        jDateField.setDate(new Date());
    }

    public Transaction getCurrentTransaction() {
        return this.currentTransaction;
    }

    public void setCurrentTransaction(Transaction transaction) {
        this.currentTransaction = (BankTransaction)transaction;
        this.inverseAccounts = this.currentTransaction.getSourceAccountId() == this.account.getAccountNum();
        this.populateFields();
    }

    public void transactionUpdated(Transaction transaction) {
        if (this.currentTransaction != null && this.currentTransaction.getId() == transaction.getId()) {
            this.setCurrentTransaction(transaction);
        }
    }

    public void goingAway() {
        if (this.transactionModified()) {
            if (Main.getMainController().getPreferences().getSetting("confirm_transaction_changes", "y").equals("y")) {
                if (this.askToSaveTransaction()) {
                    this.saveTransaction();
                }
            } else {
                this.saveTransaction();
            }
        }
    }

    public void goneAway() {
        this.accountModel.goneAway();
    }

    private final boolean transactionModified() {
        Object object;
        Calendar calendar;
        if (this.currentTransaction == null) {
            return false;
        }
        if (this.dateField.getDate().getTime() != this.currentTransaction.getDate()) {
            calendar = Calendar.getInstance();
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.dateField.getDate());
            calendar.setTime(new Date(this.currentTransaction.getDate()));
            if (((Calendar)object).get(1) != calendar.get(1) || ((Calendar)object).get(2) != calendar.get(2) || ((Calendar)object).get(5) != calendar.get(5)) {
                return true;
            }
        }
        if (this.taxableDateField.getDate().getTime() != this.currentTransaction.getTaxableDate()) {
            calendar = Calendar.getInstance();
            object = Calendar.getInstance();
            ((Calendar)object).setTime(this.taxableDateField.getDate());
            calendar.setTime(new Date(this.currentTransaction.getTaxableDate()));
            if (((Calendar)object).get(1) != calendar.get(1) || ((Calendar)object).get(2) != calendar.get(2) || ((Calendar)object).get(5) != calendar.get(5)) {
                return true;
            }
        }
        if (this.splits.size() != this.currentTransaction.getSplitCount()) {
            return true;
        }
        int n = 0;
        while (n < this.splits.size()) {
            object = (SplitTransaction)this.splits.elementAt(n);
            if (((Transaction)object).getId() < 0L) {
                return true;
            }
            if (((Transaction)object).isDirty()) {
                return true;
            }
            ++n;
        }
        Account account = (Account)this.accountChoice.getSelectedItem();
        int n2 = this.currentTransaction.getAccountId(this.account.getAccountNum());
        if (account != null && n2 != account.getAccountNum() || account == null && n2 >= 0) {
            return true;
        }
        if (!this.descriptionField.getText().trim().equals(this.currentTransaction.getDescription())) {
            return true;
        }
        long l = this.currentTransaction.getAmount(this.account.getAccountNum());
        long l2 = this.getTransactionAmount();
        if (l2 != l) {
            return true;
        }
        int n3 = this.clearedStatusChoice.getSelectedIndex();
        if (n3 == 2 && this.currentTransaction.getClearedStatus(this.account.getAccountNum()) != 'X') {
            return true;
        }
        if (n3 == 1 && this.currentTransaction.getClearedStatus(this.account.getAccountNum()) != 'x') {
            return true;
        }
        if (n3 != 2 && n3 != 1 && this.currentTransaction.getClearedStatus(this.account.getAccountNum()) != ' ') {
            return true;
        }
        if (!this.checkNumField.getText().trim().equals(this.currentTransaction.getCheckNumber())) {
            return true;
        }
        return !this.memoField.getText().trim().equals(this.currentTransaction.getMemo());
    }

    public long getTransactionAmount() {
        long l = 0L;
        l -= this.debitAmountField.getValue();
        return l += this.creditAmountField.getValue();
    }

    private final void populateFields() {
        Account account;
        int n;
        if (this.currentTransaction == null) {
            return;
        }
        CurrencyType currencyType = null;
        CurrencyType currencyType2 = this.currencyType;
        this.accountChoice.setEnabled(true);
        if (this.currentTransaction.getSplitCount() > 0) {
            this.accountChoice.setEnabled(false);
            this.accountModel.setSelectedAccount(null);
        } else if (!this.inverseAccounts) {
            n = this.currentTransaction.getSourceAccountId();
            if (n < 0) {
                if (this.accountModel.getSize() <= 0) {
                    this.account.getRootAccount().addSubAccount(new ExpenseAccount("", -1, this.currencyTable.getBaseType().getID(), null, null, this.account.getRootAccount()));
                }
                this.accountModel.setSelectedAccountIndex(0);
            } else {
                this.accountModel.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
            }
            account = (Account)this.accountModel.getSelectedItem();
            if (account != null) {
                currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
            }
        } else if (this.inverseAccounts) {
            n = this.currentTransaction.getDestAccountId();
            if (n < 0) {
                if (this.accountModel.getSize() <= 0) {
                    this.account.getRootAccount().addSubAccount(new ExpenseAccount("", -1, this.currencyTable.getBaseType().getID(), null, null, this.account.getRootAccount()));
                }
                this.accountModel.setSelectedAccountIndex(0);
            } else {
                this.accountModel.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
            }
            account = (Account)this.accountChoice.getSelectedItem();
            currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
        }
        this.accountChoice.repaint();
        this.rateEditor.setOtherCurrencyType(currencyType);
        if (currencyType != null) {
            if (this.inverseAccounts) {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate(currencyType2, currencyType, 1.0 / this.currentTransaction.getRate()));
            } else {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate(currencyType2, currencyType, this.currentTransaction.getRate()));
            }
        } else {
            this.rateEditor.setEnabled(false);
        }
        this.dateField.setDate(new Date(this.currentTransaction.getDate()));
        this.taxableDateField.setDate(new Date(this.currentTransaction.getTaxableDate()));
        this.descriptionField.setText(this.currentTransaction.getDescription());
        this.checkNumField.setText(this.currentTransaction.getCheckNumber());
        this.memoField.setText(this.currentTransaction.getMemo());
        long l = this.currentTransaction.getAmount(this.account.getAccountNum());
        if (this.account.getAccountNum() != this.currentTransaction.getDestAccountId()) {
            this.splitsButton.setEnabled(false);
        } else {
            this.splitsButton.setEnabled(true);
        }
        if (l <= 0L) {
            this.debitAmountField.setValue(l * -1L);
            this.creditAmountField.setText("");
        } else {
            this.debitAmountField.setText("");
            this.creditAmountField.setValue(l);
        }
        char c = this.currentTransaction.getClearedStatus(this.account.getAccountNum());
        if (c == 'X') {
            this.clearedStatusChoice.setSelectedIndex(2);
        } else if (c == 'x') {
            this.clearedStatusChoice.setSelectedIndex(1);
        } else {
            this.clearedStatusChoice.setSelectedIndex(0);
        }
        this.clearedStatusChoice.repaint();
        this.splits = new Vector();
        this.removedSplits = new Vector();
        if (this.currentTransaction != null) {
            int n2 = 0;
            while (n2 < this.currentTransaction.getSplitCount()) {
                SplitTransaction splitTransaction = this.currentTransaction.getSplit(n2).duplicate();
                splitTransaction.resetDirty();
                this.splits.addElement(splitTransaction);
                ++n2;
            }
        }
        this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
        if (this.splits.size() > 0) {
            this.debitAmountField.setEnabled(false);
            this.creditAmountField.setEnabled(false);
        } else {
            this.debitAmountField.setEnabled(true);
            this.creditAmountField.setEnabled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveTransaction() {
        CurrencyType currencyType;
        Object object;
        long l;
        block24: {
            block23: {
                int n;
                this.currentTransaction.setDate(this.dateField.getDate().getTime());
                this.currentTransaction.setTaxableDate(this.taxableDateField.getDate().getTime());
                this.currentTransaction.setDescription(this.descriptionField.getText());
                l = this.getTransactionAmount();
                int n2 = this.clearedStatusChoice.getSelectedIndex();
                if (n2 == 2) {
                    this.currentTransaction.setClearedStatus('X', this.account.getAccountNum());
                } else if (n2 == 1) {
                    this.currentTransaction.setClearedStatus('x', this.account.getAccountNum());
                } else {
                    this.currentTransaction.setClearedStatus(' ', this.account.getAccountNum());
                }
                this.currentTransaction.setCheckNumber(this.checkNumField.getText());
                this.currentTransaction.setMemo(this.memoField.getText());
                int n3 = 0;
                while (n3 < this.removedSplits.size()) {
                    object = (SplitTransaction)this.removedSplits.elementAt(n3);
                    n = 0;
                    while (n < this.currentTransaction.getSplitCount()) {
                        if (this.currentTransaction.getSplit(n).getId() == ((Transaction)object).getId()) {
                            this.currentTransaction.removeSplit(n);
                            break;
                        }
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < this.splits.size()) {
                    object = (SplitTransaction)this.splits.elementAt(n3);
                    if (((Transaction)object).getId() < 0L) {
                        this.currentTransaction.addSplit((SplitTransaction)object);
                    } else {
                        n = 0;
                        int n4 = 0;
                        while (n4 < this.currentTransaction.getSplitCount()) {
                            SplitTransaction splitTransaction = this.currentTransaction.getSplit(n4);
                            if (splitTransaction.getId() == ((Transaction)object).getId()) {
                                splitTransaction.takeValuesFrom((SplitTransaction)object);
                                n = 1;
                                break;
                            }
                            ++n4;
                        }
                        if (n == 0) {
                            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("txn_split_error_a") + " - " + ((Transaction)object).getDescription());
                        }
                    }
                    ++n3;
                }
                currencyType = this.currencyType;
                object = null;
                if (this.currentTransaction.getSplitCount() > 0) break block23;
                Account account = (Account)this.accountChoice.getSelectedItem();
                if (account == null) {
                    this.accountChoice.setSelectedIndex(0);
                }
                account = (Account)this.accountChoice.getSelectedItem();
                if (this.inverseAccounts) {
                    this.currentTransaction.setDestAccountId(account.getAccountNum());
                    object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                    break block24;
                } else if (this.currentTransaction.getDestAccountId() == this.account.getAccountNum()) {
                    this.currentTransaction.setSourceAccountId(account.getAccountNum());
                    object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                }
                break block24;
            }
            this.currentTransaction.setSourceAccountId(-1);
            object = null;
        }
        double d = this.rateEditor.getValue();
        if (currencyType == null || object == null) {
            d = 1.0;
            this.rateEditor.setEnabled(false);
        } else {
            if (d == 0.0) {
                d = 1.0;
            }
            d = this.inverseAccounts ? CurrencyType.getXRelativeRate(currencyType, (CurrencyType)object, 1.0 / d) : CurrencyType.getXRelativeRate((CurrencyType)object, currencyType, d);
            this.rateEditor.setEnabled(true);
        }
        this.currentTransaction.setRate(d);
        this.currentTransaction.setAmount(l, this.account.getAccountNum());
        this.listener.recordTransaction(this.currentTransaction, this, this.removedSplits);
        if (Main.getMainController().getPreferences().getSetting("beep_on_transaction_change", "y").equals("y")) {
            try {
                this.getToolkit().beep();
            }
            catch (Exception exception) {
            }
        }
        this.populateFields();
    }

    private final void cancelTransaction() {
        this.listener.cancelEdits(this.currentTransaction, this);
        this.currentTransaction = null;
    }

    private final void deleteTransaction() {
        this.listener.deleteTransaction(this.currentTransaction, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void editSplits() {
        if (this.currentTransaction == null) {
            return;
        }
        if (this.editingSplits) {
            return;
        }
        try {
            this.editingSplits = true;
            SplitEditor splitEditor = new SplitEditor(this.moneydanceGUI.getTopLevelFrame(), this.currentTransaction, this.account.getRootAccount(), this.moneydanceGUI, this.account, true);
            Vector vector = new Vector();
            Enumeration enumeration = this.splits.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            splitEditor.setSplits(vector);
            ((Component)splitEditor).setVisible(true);
            if (!splitEditor.wasCancelled()) {
                Object object;
                long l = 0L;
                Vector vector2 = splitEditor.getSplits();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (SplitTransaction)enumeration2.nextElement();
                    l += ((Transaction)object).getAmount();
                    if (this.splits.indexOf(object) >= 0) continue;
                    this.splits.addElement(object);
                }
                int n = 0;
                while (n < this.splits.size()) {
                    object = (SplitTransaction)this.splits.elementAt(n);
                    if (vector2.indexOf(object) < 0) {
                        if (((Transaction)object).getId() >= 0L) {
                            SplitTransaction splitTransaction = this.currentTransaction.getSplitById(((Transaction)object).getId());
                            if (this.removedSplits.indexOf(splitTransaction) < 0) {
                                this.removedSplits.addElement(splitTransaction);
                            }
                            this.splits.removeElement(object);
                            --n;
                        } else {
                            this.splits.removeElement(object);
                        }
                    }
                    ++n;
                }
                if (vector2.size() <= 0) {
                    this.accountChoice.setEnabled(true);
                    this.debitAmountField.setEnabled(true);
                    this.creditAmountField.setEnabled(true);
                    if (this.accountChoice.getSelectedItem() == null) {
                        if (this.inverseAccounts) {
                            n = this.currentTransaction.getDestAccountId();
                            if (n >= 0) {
                                this.accountModel.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
                            } else {
                                this.accountModel.setSelectedAccountIndex(0);
                            }
                        } else {
                            n = this.currentTransaction.getSourceAccountId();
                            if (n >= 0) {
                                this.accountModel.setSelectedAccount(this.account.getRootAccount().getAccountById(n));
                            } else {
                                this.accountModel.setSelectedAccountIndex(0);
                            }
                        }
                    }
                    this.debitAmountField.setEnabled(true);
                    this.creditAmountField.setEnabled(true);
                    Account account = (Account)this.accountChoice.getSelectedItem();
                    if (account == null) {
                        this.accountModel.setSelectedAccountIndex(0);
                        account = (Account)this.accountChoice.getSelectedItem();
                    }
                    object = null;
                    if (account != null) {
                        object = this.currencyTable.getCurrencyType(account.getCurrencyType());
                    }
                    if (object == null || this.currencyType.getID().equals(((CurrencyType)object).getID())) {
                        if (object != null) {
                            this.rateEditor.setOtherCurrencyType((CurrencyType)object);
                        }
                        this.rateEditor.setEnabled(false);
                    } else {
                        this.rateEditor.setOtherCurrencyType((CurrencyType)object);
                        this.rateEditor.setEnabled(true);
                    }
                } else {
                    this.accountChoice.setEnabled(false);
                    this.accountModel.setSelectedAccount(null);
                    this.creditAmountField.setEnabled(false);
                    this.debitAmountField.setEnabled(false);
                    this.rateEditor.setEnabled(false);
                }
                this.accountChoice.repaint();
                if (this.account.getAccountNum() == this.currentTransaction.getDestAccountId()) {
                    if (l <= 0L) {
                        this.debitAmountField.setValue(l * -1L);
                        this.creditAmountField.setText("");
                    } else {
                        this.debitAmountField.setText("");
                        this.creditAmountField.setValue(l);
                    }
                } else if ((l *= -1L) <= 0L) {
                    this.debitAmountField.setValue(l * -1L);
                    this.creditAmountField.setText("");
                } else {
                    this.debitAmountField.setText("");
                    this.creditAmountField.setValue(l);
                }
            }
            this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
            Object var2_11 = null;
            this.editingSplits = false;
            return;
        }
        catch (Throwable throwable) {
            Object var2_12 = null;
            this.editingSplits = false;
            throw throwable;
        }
    }

    private final void accountWasSelected(Account account) {
        Account account2 = (Account)this.accountChoice.getSelectedItem();
        CurrencyType currencyType = this.currencyTable.getCurrencyType(account2.getCurrencyType());
        if (currencyType.getID().equals(this.currencyType.getID())) {
            this.rateEditor.setValue(1.0);
            this.rateEditor.setOtherCurrencyType(currencyType);
            return;
        }
        if (account2 == null) {
            this.rateEditor.setEnabled(false);
        } else {
            this.rateEditor.setOtherCurrencyType(currencyType);
            double d = this.currencyTable.getRate(this.currencyType, currencyType);
            if (this.inverseAccounts) {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate(currencyType, this.currencyType, 1.0 / d));
            } else {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate(this.currencyType, currencyType, d));
            }
        }
    }

    private final int getIndexForId(Vector vector, long l) {
        int n = 0;
        while (n < vector.size()) {
            if (((Transaction)vector.elementAt(n)).getId() == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.recordButton) {
            if (this.currentTransaction != null) {
                this.saveTransaction();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            if (this.currentTransaction != null) {
                this.cancelTransaction();
            }
        } else if (actionEvent.getSource() == this.deleteButton) {
            if (this.currentTransaction != null) {
                this.deleteTransaction();
            }
        } else if (actionEvent.getSource() == this.splitsButton) {
            this.editSplits();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void autoCompleteDescription(KeyEvent keyEvent) {
        JTextField jTextField = this.descriptionField;
        synchronized (jTextField) {
            String string = this.descriptionField.getText();
            if (string.length() < 2) {
                return;
            }
            char c = keyEvent.getKeyChar();
            if (c == '\t') return;
            this.descriptionWasCompleted = false;
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '\'' || c == '\"' || c == ' ' || c >= '0' && c <= '9' || c == '-')) {
                if (c != '&') return;
            }
            if (this.descriptionField.getCaretPosition() != string.length()) return;
            this.matchedTransaction = this.transactionSet.autoCompleteDescription(string);
            if (this.matchedTransaction == null) return;
            this.descriptionField.setText(this.matchedTransaction.getDescription());
            this.descriptionField.setCaretPosition(this.matchedTransaction.getDescription().length());
            this.descriptionField.select(string.length(), this.descriptionField.getText().length());
            this.descriptionField.repaint();
            this.descriptionWasCompleted = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyPressed(KeyEvent keyEvent) {
        try {
            while (true) {
                if (!this.completing) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
        }
    }

    public synchronized void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        Object object = keyEvent.getSource();
        if (object == this.descriptionField) {
            if (!this.completing) {
                this.completing = true;
                this.autoCompleteDescription(keyEvent);
                this.completing = false;
            }
        } else if (object == this.debitAmountField || object == this.creditAmountField) {
            this.rateEditor.refresh();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyTyped(KeyEvent keyEvent) {
        try {
            while (true) {
                if (!this.completing) {
                    return;
                }
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextComponent) {
            ((JTextComponent)focusEvent.getSource()).selectAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void focusLost(FocusEvent focusEvent) {
        Object object;
        if (focusEvent.getSource() != this.descriptionField) return;
        if (!this.descriptionWasCompleted) return;
        this.descriptionWasCompleted = false;
        if (this.matchedTransaction == null) return;
        boolean bl = false;
        try {
            bl = this.debitAmountField.getValue() == 0L && this.creditAmountField.getValue() == 0L && this.splits.size() == 0;
        }
        catch (Exception exception) {
        }
        if (!bl) return;
        long l = this.matchedTransaction.getAmount(this.account.getAccountNum());
        Account account = this.account.getRootAccount().getAccountById(this.matchedTransaction.getAccountId(this.account.getAccountNum()));
        this.accountModel.setSelectedAccount(account);
        if (account != null) {
            object = this.currencyTable.getCurrencyType(account.getCurrencyType());
            double d = this.matchedTransaction.getRate(this.account.getAccountNum());
            this.rateEditor.setOtherCurrencyType((CurrencyType)object);
            if (this.inverseAccounts) {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate((CurrencyType)object, this.currencyType, 1.0 / d));
            } else {
                this.rateEditor.setValue(CurrencyType.getXRelativeRate(this.currencyType, (CurrencyType)object, d));
            }
            this.accountChoice.setEnabled(true);
        } else {
            this.accountChoice.setEnabled(false);
        }
        this.accountChoice.repaint();
        if (l <= 0L) {
            this.debitAmountField.setValue(l * -1L);
            this.creditAmountField.setValue(0L);
        } else {
            this.debitAmountField.setValue(0L);
            this.creditAmountField.setValue(l);
        }
        if (this.matchedTransaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = BankTransactionEditor.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            object = (BankTransaction)this.matchedTransaction;
            this.memoField.setText(((BankTransaction)object).getMemo());
            if (this.currentTransaction.getSplitCount() <= 0) {
                int n = 0;
                while (n < ((BankTransaction)object).getSplitCount()) {
                    SplitTransaction splitTransaction = ((BankTransaction)object).getSplit(n).duplicate();
                    splitTransaction.setId(-1L);
                    this.splits.addElement(splitTransaction);
                    ++n;
                }
            }
        }
        this.numSplitsLabel.setText("  " + this.splits.size() + "   ");
        if (this.splits.size() > 0) {
            this.debitAmountField.setEnabled(false);
            this.creditAmountField.setEnabled(false);
            return;
        }
        this.debitAmountField.setEnabled(true);
        this.creditAmountField.setEnabled(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.accountModel) {
            this.accountWasSelected((Account)this.accountModel.getSelectedItem());
        }
    }

    public void requestFocus() {
        this.dateField.requestFocus();
    }

    /* synthetic */ JDateField access$0() {
        return this.dateField;
    }

    /* synthetic */ JDateField access$1() {
        return this.taxableDateField;
    }

    /* synthetic */ void access$2() {
        this.synchronizeDates();
    }

    /* synthetic */ void access$3(JDateField jDateField) {
        this.setDateToToday(jDateField);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BankTransactionEditor(MoneydanceGUI moneydanceGUI, Account account, AccountTransactionSet accountTransactionSet, EditTransactionListener editTransactionListener) {
        this.account = account;
        this.listener = editTransactionListener;
        this.moneydanceGUI = moneydanceGUI;
        this.transactionSet = accountTransactionSet;
        this.currencyTable = this.account.getRootAccount().getCurrencyTable();
        this.currencyType = this.currencyTable.getCurrencyType(this.account.getCurrencyType());
        UserPreferences userPreferences = Main.getMainController().getPreferences();
        char c = userPreferences.getDecimalChar();
        char c2 = c == ',' ? (char)'.' : ',';
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        JPanel jPanel3 = new JPanel(gridBagLayout);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel3.setOpaque(true);
        this.currentTransaction = null;
        this.dateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        this.taxableDateField = new JDateField(Main.getMainController().getPreferences().getShortDateFormatter());
        BankTransactionEditor bankTransactionEditor = this;
        if (bankTransactionEditor == null) {
            throw null;
        }
        KeyAdapter keyAdapter = new KeyAdapter(bankTransactionEditor){
            private final /* synthetic */ BankTransactionEditor this$0;

            public final void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getSource() == this.this$0.access$0() || keyEvent.getSource() == this.this$0.access$1()) {
                    if (keyEvent.getKeyCode() == 89 && (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                        this.this$0.access$2();
                    } else if (keyEvent.getKeyCode() == 84 && (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown())) {
                        this.this$0.access$3((JDateField)keyEvent.getSource());
                    }
                }
            }
            {
                this.this$0 = bankTransactionEditor;
                this.constructor$0(bankTransactionEditor);
            }

            public void constructor$0(BankTransactionEditor bankTransactionEditor) {
            }
        };
        this.dateField.addKeyListener(keyAdapter);
        this.taxableDateField.addKeyListener(keyAdapter);
        this.accountModel = new AccountListModel(this.account.getRootAccount());
        this.accountModel.setShowAccount(this.account, false);
        this.accountChoice = new JComboBox(this.accountModel);
        this.accountChoice.setEditable(false);
        AccountTreeCellRenderer accountTreeCellRenderer = new AccountTreeCellRenderer(this.moneydanceGUI);
        accountTreeCellRenderer.setRealBackground(this.getBackground());
        this.accountChoice.setRenderer(accountTreeCellRenderer);
        this.accountChoice.setKeySelectionManager(new AccountKeySelectionManager(this.accountChoice));
        this.descriptionField = new JTextField(25);
        this.clearedStatusChoice = new JComboBox();
        this.clearedStatusChoice.addItem(this.moneydanceGUI.resources.getString("uncleared"));
        this.clearedStatusChoice.addItem(this.moneydanceGUI.resources.getString("reconciling"));
        this.clearedStatusChoice.addItem(this.moneydanceGUI.resources.getString("cleared"));
        this.debitAmountField = new JCurrencyField(this.currencyType, c, c2);
        this.creditAmountField = new JCurrencyField(this.currencyType, c, c2);
        this.checkNumField = new JTextField(6);
        this.memoField = new JTextArea(3, 10);
        this.memoField.setLineWrap(true);
        this.numSplitsLabel = new JLabel("0", 2);
        this.numSplitsLabel.setVerticalAlignment(3);
        this.rateEditor = new ExchangeRateEditor(this.moneydanceGUI, this.currencyTable, this.currencyType, this);
        this.recordButton = new JButton(this.moneydanceGUI.resources.getString("record_txn"));
        this.cancelButton = new JButton(this.moneydanceGUI.resources.getString("cancel_txn"));
        this.deleteButton = new JButton(this.moneydanceGUI.resources.getString("delete_txn"));
        this.splitsButton = new JButton(this.moneydanceGUI.resources.getString("split_txn"));
        this.add((Component)jPanel2, AwtUtil.getConstraints(0, 0, 1.0f, 1.0f, 1, 1, true, true));
        this.add((Component)jPanel, AwtUtil.getConstraints(1, 0, 0.0f, 1.0f, 1, 1, true, true));
        jPanel2.add((Component)jPanel5, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_date") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)this.dateField, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_tax_date") + ": ", 4), AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel5.add((Component)this.taxableDateField, AwtUtil.getConstraints(1, 2, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)new JLabel(""), AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)jPanel4, AwtUtil.getConstraints(2, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_checknum") + ": ", 4), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.checkNumField, AwtUtil.getConstraints(1, 0, 1.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_status") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel4.add((Component)this.clearedStatusChoice, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, true, true));
        jPanel2.add((Component)jPanel6, AwtUtil.getConstraints(0, 2, 1.0f, 1.0f, 3, 1, true, true));
        jPanel6.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_payee") + ": ", 2), AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 2, 1, true, true));
        JPanel jPanel7 = new JPanel(new GridLayout(1, 2));
        jPanel7.setOpaque(false);
        jPanel7.add(new JLabel(this.moneydanceGUI.resources.getString("txn_debit") + ": ", 2));
        jPanel7.add(new JLabel(this.moneydanceGUI.resources.getString("txn_credit") + ": ", 2));
        jPanel6.add((Component)jPanel7, AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 2, 1, true, true));
        jPanel6.add((Component)this.descriptionField, AwtUtil.getConstraints(0, 1, 1.0f, 0.0f, 2, 1, true, true));
        jPanel7 = new JPanel(new GridLayout(1, 2));
        jPanel7.setOpaque(false);
        jPanel7.add(this.debitAmountField);
        jPanel7.add(this.creditAmountField);
        jPanel6.add((Component)jPanel7, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 2, 1, true, true));
        jPanel6.add((Component)new JLabel(this.moneydanceGUI.resources.getString("account") + ": "), AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel6.add((Component)this.accountChoice, AwtUtil.getConstraints(1, 2, 1.0f, 0.0f, 1, 1, true, true));
        jPanel6.add((Component)this.rateEditor, AwtUtil.getConstraints(2, 2, 0.0f, 0.0f, 2, 2, true, true));
        jPanel6.add((Component)new JLabel(this.moneydanceGUI.resources.getString("txn_memo") + ": ", 2), AwtUtil.getConstraints(0, 3, 0.0f, 0.0f, 1, 1, true, true));
        JPanel jPanel8 = new JPanel(gridBagLayout);
        jPanel2.add((Component)jPanel8, AwtUtil.getConstraints(0, 4, 1.0f, 1.0f, 3, 1, true, true));
        JScrollPane jScrollPane = new JScrollPane(this.memoField);
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel8.add((Component)jScrollPane, AwtUtil.getConstraints(0, 0, 1.0f, 2.0f, 1, 2, true, true));
        JLabel jLabel = new JLabel("  " + this.moneydanceGUI.resources.getString("txn_numsplits") + ": ", 4);
        jLabel.setVerticalAlignment(3);
        jPanel8.add((Component)jLabel, AwtUtil.getConstraints(2, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel8.add((Component)this.numSplitsLabel, AwtUtil.getConstraints(3, 0, 0.0f, 1.0f, 1, 1, true, true));
        jPanel.add((Component)this.recordButton, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)this.deleteButton, AwtUtil.getConstraints(0, 2, 0.0f, 0.0f, 1, 1, true, true));
        jPanel.add((Component)new JLabel(""), AwtUtil.getConstraints(0, 3, 0.0f, 1.0f, 1, 1, false, false));
        jPanel.add((Component)this.splitsButton, AwtUtil.getConstraints(0, 4, 0.0f, 0.0f, 1, 1, true, true));
        jPanel2.setBackground(Color.cyan);
        this.rateEditor.setOpaque(false);
        jPanel4.setOpaque(false);
        jPanel5.setOpaque(false);
        jPanel3.setOpaque(false);
        jPanel6.setOpaque(false);
        jPanel8.setOpaque(false);
        this.recordButton.addActionListener(this);
        this.recordButton.setMnemonic('r');
        this.recordButton.registerKeyboardAction(this, "record_transaction", KeyStroke.getKeyStroke(82, 2), 2);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic('c');
        this.cancelButton.registerKeyboardAction(this, "cancel_transaction", KeyStroke.getKeyStroke(67, 2), 2);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setMnemonic('d');
        this.deleteButton.registerKeyboardAction(this, "delete_transaction", KeyStroke.getKeyStroke(68, 2), 2);
        this.splitsButton.addActionListener(this);
        this.splitsButton.setMnemonic('s');
        this.splitsButton.registerKeyboardAction(this, "edit_transaction_splits", KeyStroke.getKeyStroke(83, 2), 2);
        this.descriptionField.addKeyListener(this);
        this.descriptionField.addFocusListener(this);
        this.rateEditor.addFieldFocusListener(this);
        this.dateField.addFocusListener(this);
        this.taxableDateField.addFocusListener(this);
        this.debitAmountField.addFocusListener(this);
        this.debitAmountField.addKeyListener(this);
        this.creditAmountField.addFocusListener(this);
        this.creditAmountField.addKeyListener(this);
        this.checkNumField.addFocusListener(this);
        this.memoField.addFocusListener(this);
        this.accountModel.addItemListener(this);
    }
}

