/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.controller.UserPreferences;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import com.seanreilly.apps.moneydance.view.gui.AccountDetailInterface;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTransactionSet;
import com.seanreilly.apps.moneydance.view.gui.BankTransactionEditor;
import com.seanreilly.apps.moneydance.view.gui.EditTransactionListener;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.PreReconcilerWindow;
import com.seanreilly.apps.moneydance.view.gui.ReconcilerWindow;
import com.seanreilly.apps.moneydance.view.gui.TransactionEditor;
import com.seanreilly.apps.moneydance.view.gui.TransactionRenderer;
import com.seanreilly.awt.AwtUtil;
import com.seanreilly.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BankAccountDetailPanel
extends JPanel
implements AccountDetailInterface,
AccountInfoListener,
AccountListener,
ItemListener,
ListSelectionListener,
EditTransactionListener,
TransactionListener,
ActionListener {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction;
    private Account account;
    private CurrencyType currencyType;
    private MoneydanceGUI moneydanceGUI;
    private JLabel balanceLabel;
    private JLabel clearedBalanceLabel;
    private JComboBox sortByChoice;
    private AccountTransactionSet transactionSet;
    private JList transactionList;
    private TransactionRenderer txnRenderer;
    private BankTransactionEditor bankTransactionEditor;
    private TransactionEditor transactionEditor = null;
    private boolean editorIsVisible = false;
    private JPanel editorPanel;
    private JButton newTransactionButton;
    private JButton reconcileButton;
    private JLabel accountNameLabel;
    private int centMult;
    private int numDecimals;
    private boolean isRightClick = false;
    private ReconcilerWindow reconcilerWindow = null;
    private UserPreferences prefs;
    private JCheckBox twoLineCheckbox;
    private long lastRecordedDate = new Date().getTime();
    private RootAccount rootAccount;

    public Account getAccount() {
        return this.account;
    }

    public void goingAway() {
        if (this.transactionEditor != null) {
            this.transactionEditor.goingAway();
        }
        if (this.transactionEditor != this.bankTransactionEditor) {
            this.bankTransactionEditor.goingAway();
        }
    }

    public void goneAway() {
        this.transactionSet.removeAccountInfoListener(this);
        this.sortByChoice.removeItemListener(this);
        this.transactionList.removeListSelectionListener(this);
        if (this.reconcilerWindow != null) {
            this.reconcilerWindow.cancelReconciling();
        }
        this.transactionSet.disconnect();
        this.bankTransactionEditor.goneAway();
        this.rootAccount.getTransactionSet().removeTransactionListener(this);
    }

    public void accountModified(Account account) {
        if (account != this.account) {
            return;
        }
    }

    public void accountInfoUpdated(Object object) {
        if (object == this.transactionSet) {
            char c = this.prefs.getDecimalChar();
            char c2 = c == ',' ? (char)'.' : ',';
            this.balanceLabel.setText(this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.transactionSet.getBalance(), true, c, c2, this.numDecimals, this.centMult) + ' ' + this.currencyType.getSuffix());
            this.clearedBalanceLabel.setText(this.currencyType.getPrefix() + ' ' + StringUtils.formatCurrency(this.transactionSet.getClearedBalance(), true, c, c2, this.numDecimals, this.centMult) + ' ' + this.currencyType.getSuffix());
            this.validate();
        }
    }

    private final void setTwoLineDisplay() {
        if (this.twoLineCheckbox.isSelected()) {
            this.txnRenderer.setDisplayTwoLines(true);
            this.prefs.setSetting("gui.two_line_transactions", "y");
            this.transactionList.setPrototypeCellValue(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, this.lastRecordedDate, new Date().getTime(), this.lastRecordedDate, ' ', ' ', "", null, ""));
        } else {
            this.txnRenderer.setDisplayTwoLines(false);
            this.prefs.setSetting("gui.two_line_transactions", "n");
            this.transactionList.setPrototypeCellValue(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, this.lastRecordedDate, new Date().getTime(), this.lastRecordedDate, ' ', ' ', "", null, ""));
        }
        this.validate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sortByChoice) {
            Object object = this.transactionList.getSelectedValue();
            this.transactionSet.sortTransactions(this.sortByChoice.getSelectedIndex());
            this.transactionList.setSelectedValue(object, true);
        } else if (itemEvent.getSource() == this.twoLineCheckbox) {
            this.setTwoLineDisplay();
        }
    }

    public void setCurrentTransaction(Transaction transaction) {
        if (transaction == null) {
            this.editorPanel.removeAll();
            this.transactionEditor = null;
            this.transactionList.setSelectedIndices(new int[0]);
            this.validate();
            return;
        }
        if (this.transactionEditor == null) {
            if (transaction.getClass() != (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
                if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.SplitTransaction")))) {
                    this.moneydanceGUI.showInfoMessage(this.moneydanceGUI.resources.getString("cant_edit_splits"));
                    return;
                }
                this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("unknown_txn_type") + ": " + transaction.getClass());
                return;
            }
            this.transactionEditor = this.bankTransactionEditor;
            this.transactionEditor.setCurrentTransaction(transaction);
            this.editorPanel.removeAll();
            this.editorPanel.add((Component)this.transactionEditor, "Center");
            this.validate();
            this.transactionList.setSelectedValue(transaction, true);
        } else if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            if (this.transactionEditor.getCurrentTransaction().getId() != transaction.getId() || transaction.getId() < 0L) {
                this.transactionEditor.goingAway();
            }
            if (this.transactionEditor != this.bankTransactionEditor) {
                this.transactionEditor = this.bankTransactionEditor;
                this.editorPanel.removeAll();
                this.editorPanel.add((Component)this.transactionEditor, "Center");
                this.editorPanel.repaint();
            }
            this.transactionEditor.setCurrentTransaction(transaction);
            this.transactionList.setSelectedValue(transaction, true);
        } else {
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction = BankAccountDetailPanel.class$("com.seanreilly.apps.moneydance.model.SplitTransaction")))) {
                this.transactionEditor.goingAway();
                this.transactionEditor = null;
                this.moneydanceGUI.showInfoMessage(this.moneydanceGUI.resources.getString("cant_edit_splits"));
                this.editorPanel.removeAll();
                this.validate();
                return;
            }
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("unknown_txn_type") + ": " + transaction.getClass());
            return;
        }
    }

    private final void transactionSelected() {
        Transaction transaction = (Transaction)this.transactionList.getSelectedValue();
        this.setCurrentTransaction(transaction);
    }

    public void recordTransaction(Transaction transaction, TransactionEditor transactionEditor, Vector vector) {
        Transaction transaction2 = (Transaction)this.transactionList.getSelectedValue();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.transactionSet.recordDeletedTransaction((SplitTransaction)enumeration.nextElement());
        }
        this.transactionSet.recordModifiedTransaction(transaction);
        this.lastRecordedDate = transaction.getDate();
        this.transactionList.repaint();
    }

    public void deleteTransaction(Transaction transaction, TransactionEditor transactionEditor) {
        if (transaction.getId() >= 0L) {
            this.transactionSet.recordDeletedTransaction(transaction);
        }
        this.setCurrentTransaction(null);
        this.transactionList.setSelectedIndices(new int[0]);
    }

    public void cancelEdits(Transaction transaction, TransactionEditor transactionEditor) {
        this.setCurrentTransaction(null);
        this.transactionList.setSelectedIndices(new int[0]);
        this.transactionList.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newTransactionButton) {
            this.createNewTransaction();
        } else if (actionEvent.getSource() == this.reconcileButton) {
            this.reconcileAccount();
        }
    }

    public void createNewTransaction() {
        this.transactionList.setSelectedIndices(new int[0]);
        this.setCurrentTransaction(new BankTransaction(-1L, -1, this.account.getAccountNum(), "", 0L, this.lastRecordedDate, new Date().getTime(), this.lastRecordedDate, ' ', ' ', "", null, ""));
        this.transactionEditor.requestFocus();
    }

    private final void reconcileAccount() {
        if (this.reconcilerWindow != null && this.reconcilerWindow.isActive()) {
            this.reconcilerWindow.toFront();
        } else {
            this.reconcilerWindow = null;
            PreReconcilerWindow preReconcilerWindow = new PreReconcilerWindow(this.moneydanceGUI, this.account, this.transactionSet.getClearedBalance());
            ((Component)preReconcilerWindow).setVisible(true);
            if (preReconcilerWindow.wasCancelled()) {
                return;
            }
            long l = preReconcilerWindow.getEndBalance();
            this.reconcilerWindow = new ReconcilerWindow(this.moneydanceGUI, this.account, l, this);
            ((Component)this.reconcilerWindow).setVisible(true);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.transactionList && !listSelectionEvent.getValueIsAdjusting()) {
            this.transactionSelected();
        }
    }

    public void transactionRemoved(Transaction transaction) {
        if (this.transactionEditor != null) {
            this.transactionEditor.transactionUpdated(transaction);
        }
    }

    public void transactionAdded(Transaction transaction) {
    }

    public void transactionModified(Transaction transaction) {
        Transaction transaction2;
        if (this.transactionEditor != null && (transaction2 = this.transactionEditor.getCurrentTransaction()) != null && transaction2.getId() == transaction.getId()) {
            this.setCurrentTransaction(null);
            this.transactionList.setSelectedIndices(new int[0]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BankAccountDetailPanel(MoneydanceGUI moneydanceGUI, Account account) {
        this.moneydanceGUI = moneydanceGUI;
        this.account = account;
        this.transactionSet = new AccountTransactionSet(account);
        this.rootAccount = account.getRootAccount();
        this.currencyType = this.rootAccount.getCurrencyTable().getCurrencyType(account.getCurrencyType());
        this.numDecimals = this.currencyType.getDecimalPlaces();
        this.centMult = (int)Math.round(Math.pow(10.0, this.numDecimals));
        this.prefs = Main.getMainController().getPreferences();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        int n = 2;
        int n2 = 0;
        this.editorPanel = new JPanel(new BorderLayout());
        this.newTransactionButton = new JButton(this.moneydanceGUI.resources.getString("new_transaction"));
        this.newTransactionButton.setMargin(new Insets(n2, n, n2, n));
        this.reconcileButton = new JButton(this.moneydanceGUI.resources.getString("reconcile"));
        this.reconcileButton.setMargin(new Insets(n2, n, n2, n));
        this.balanceLabel = new JLabel("?", 4);
        this.clearedBalanceLabel = new JLabel("?", 4);
        this.sortByChoice = new JComboBox(new String[]{this.moneydanceGUI.resources.getString("sortby_date"), this.moneydanceGUI.resources.getString("sortby_date_entered"), this.moneydanceGUI.resources.getString("sortby_description"), this.moneydanceGUI.resources.getString("sortby_amount"), this.moneydanceGUI.resources.getString("sortby_status"), this.moneydanceGUI.resources.getString("sortby_account"), this.moneydanceGUI.resources.getString("sortby_date_status"), this.moneydanceGUI.resources.getString("sortby_date_amount")});
        this.sortByChoice.setSelectedIndex(0);
        this.setLayout(gridBagLayout);
        this.twoLineCheckbox = new JCheckBox(this.moneydanceGUI.resources.getString("show_two_lines"), this.prefs.getSetting("gui.two_line_transactions", "n").equals("y"));
        this.transactionList = new JList(this.transactionSet);
        this.txnRenderer = new TransactionRenderer(account, this.moneydanceGUI, this.twoLineCheckbox.isSelected(), false);
        this.transactionList.setCellRenderer(this.txnRenderer);
        this.transactionList.setSelectionMode(0);
        this.accountNameLabel = new JLabel(this.moneydanceGUI.resources.getString("acct_type" + account.getAccountType()) + "; " + this.moneydanceGUI.resources.getString("currency") + ": " + this.currencyType.getName(), 2);
        this.add((Component)this.accountNameLabel, AwtUtil.getConstraints(0, 0, 0.0f, 0.0f, 10, 1, true, true));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("balance") + ":   ", 4), AwtUtil.getConstraints(10, 0, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.balanceLabel, AwtUtil.getConstraints(11, 0, 0.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("sort_by") + ": ", 4), AwtUtil.getConstraints(0, 1, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.sortByChoice, AwtUtil.getConstraints(1, 1, 1.0f, 0.0f, 1, 1, false, false));
        this.add((Component)this.newTransactionButton, AwtUtil.getConstraints(2, 1, 0.0f, 0.0f, 1, 1, false, false));
        this.add((Component)this.reconcileButton, AwtUtil.getConstraints(3, 1, 0.0f, 0.0f, 1, 1, false, false));
        this.add((Component)this.twoLineCheckbox, AwtUtil.getConstraints(4, 1, 0.0f, 0.0f, 1, 1, false, false));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(5, 1, 5.0f, 0.0f, 1, 1, true, false));
        this.add((Component)new JLabel(this.moneydanceGUI.resources.getString("cleared_balance") + ":   ", 4), AwtUtil.getConstraints(10, 1, 1.0f, 0.0f, 1, 1, true, false));
        this.add((Component)this.clearedBalanceLabel, AwtUtil.getConstraints(11, 1, 0.0f, 0.0f, 1, 1, true, false));
        JScrollPane jScrollPane = new JScrollPane(this.transactionList);
        jScrollPane.setColumnHeaderView(this.txnRenderer.getHeaderRenderer(this.transactionList));
        this.add((Component)jScrollPane, AwtUtil.getConstraints(0, 4, 1.0f, 1.0f, 12, 1, true, true));
        this.add((Component)this.editorPanel, AwtUtil.getConstraints(0, 5, 1.0f, 0.0f, 12, 1, true, true));
        this.bankTransactionEditor = new BankTransactionEditor(this.moneydanceGUI, account, this.transactionSet, this);
        this.transactionSet.addAccountInfoListener(this);
        this.sortByChoice.addItemListener(this);
        this.transactionList.addListSelectionListener(this);
        this.twoLineCheckbox.addItemListener(this);
        this.accountInfoUpdated(this.transactionSet);
        this.newTransactionButton.addActionListener(this);
        this.newTransactionButton.setMnemonic('n');
        this.newTransactionButton.registerKeyboardAction(this, "new_transaction", KeyStroke.getKeyStroke(78, 2), 2);
        this.reconcileButton.addActionListener(this);
        this.accountModified(account);
        account.getRootAccount().getTransactionSet().addTransactionListener(this);
    }
}

