/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.controller.Main;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoListener;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class AccountTransactionSet
extends AbstractListModel
implements TransactionListener {
    public static final int DATE = 0;
    public static final int DATE_ENTERED = 1;
    public static final int DESCRIPTION = 2;
    public static final int AMOUNT = 3;
    public static final int STATUS = 4;
    public static final int ACCOUNT = 5;
    public static final int DATE_THEN_STATUS = 6;
    public static final int DATE_THEN_AMOUNT = 7;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private Account account;
    private RootAccount rootAccount;
    private int accountID;
    private Vector currentTransactions;
    private Vector accountInfoListeners;
    private Vector tableListeners;
    private int sortedBy = 0;
    private DateFormat shortDateFormat;
    private NumberFormat currencyFormat;
    private ResourceBundle resources;
    private long balance = 0L;
    private long clearedBalance = 0L;
    private long reconcilingBalance = 0L;
    private String[] tableColumnNames;
    private boolean showReconciled = true;
    private boolean showDebits = true;
    private boolean showCredits = true;
    private boolean isIncomeAccount = false;

    public void disconnect() {
        this.rootAccount.getTransactionSet().removeTransactionListener(this);
    }

    private final boolean isTransactionVisible(Transaction transaction) {
        if (!this.account.containsTransaction(transaction, false, true)) {
            return false;
        }
        if (!this.showCredits && transaction.getAmount(this.accountID) > 0L) {
            return false;
        }
        if (!this.showDebits && transaction.getAmount(this.accountID) <= 0L) {
            return false;
        }
        return this.showReconciled || transaction.getClearedStatus(this.accountID) != 'X';
    }

    public Enumeration getAllTransactions() {
        return this.currentTransactions.elements();
    }

    public synchronized void sortTransactions(int n) {
        if (n >= 0 && n <= 7) {
            this.sortedBy = n;
            AccountTransactionSet accountTransactionSet = this;
            synchronized (accountTransactionSet) {
                AccountTransactionSet.sortTransactions(this.currentTransactions, this.sortedBy, this.accountID, this.rootAccount);
                this.recalcBalances();
            }
            this.fireContentsChanged(this, 0, this.currentTransactions.size() - 1);
        }
    }

    public int getSize() {
        return this.currentTransactions.size();
    }

    public long getBalance() {
        return this.balance;
    }

    public long getClearedBalance() {
        return this.clearedBalance;
    }

    public long getReconcilingBalance() {
        return this.reconcilingBalance;
    }

    public int getTransactionCount() {
        return this.currentTransactions.size();
    }

    public void recordModifiedTransaction(Transaction transaction) {
        this.rootAccount.getTransactionSet().transactionModified(transaction);
    }

    public void recordDeletedTransaction(Transaction transaction) {
        this.rootAccount.getTransactionSet().removeTransaction(transaction);
    }

    public void addAccountInfoListener(AccountInfoListener accountInfoListener) {
        this.accountInfoListeners.addElement(accountInfoListener);
    }

    public void removeAccountInfoListener(AccountInfoListener accountInfoListener) {
        this.accountInfoListeners.removeElement(accountInfoListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireInfoUpdated() {
        Enumeration enumeration = this.accountInfoListeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountInfoListener)enumeration.nextElement()).accountInfoUpdated(this);
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void recalcBalances() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        Enumeration enumeration = this.currentTransactions.elements();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            char c = transaction.getClearedStatus(this.accountID);
            long l4 = transaction.getAmount(this.accountID, l);
            if (this.isIncomeAccount) {
                l4 *= -1L;
            }
            if (c == 'x') {
                l3 += l4;
            } else if (c == 'X') {
                l3 += l4;
                l2 += l4;
            }
            l += l4;
        }
        this.balance = l;
        this.clearedBalance = l2;
        this.reconcilingBalance = l3;
        this.fireInfoUpdated();
    }

    public synchronized void transactionRemoved(Transaction transaction) {
        int n = this.currentTransactions.indexOf(transaction);
        if (n >= 0) {
            this.removeTransactionAt(n);
        }
    }

    public synchronized void transactionAdded(Transaction transaction) {
        if (this.isTransactionVisible(transaction)) {
            this.insertTransaction(transaction, -1);
            this.recalcBalances();
        }
    }

    public void transactionModified(Transaction transaction) {
        int n = this.currentTransactions.indexOf(transaction);
        if (!this.isTransactionVisible(transaction)) {
            if (n >= 0) {
                this.removeTransactionAt(n);
            }
        } else {
            this.insertTransaction(transaction, n);
            this.recalcBalances();
        }
    }

    public Transaction autoCompleteDescription(String string) {
        int n = this.currentTransactions.size();
        string = string.toUpperCase();
        int n2 = n - 1;
        while (n2 >= 0) {
            Transaction transaction = (Transaction)this.currentTransactions.elementAt(n2);
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : AccountTransactionSet.class$("com.seanreilly.apps.moneydance.model.BankTransaction")) && transaction.getDescription().toUpperCase().startsWith(string)) {
                return transaction;
            }
            --n2;
        }
        return null;
    }

    private final void insertTransaction(Transaction transaction, int n) {
        if (n < 0) {
            this.insertSortedTransaction(transaction);
            this.fireContentsChanged(this, 0, this.currentTransactions.size());
        } else if (!this.isTransactionSorted(n, transaction)) {
            this.removeTransactionAt(n);
            this.insertSortedTransaction(transaction);
        }
        this.recalcBalances();
    }

    private final synchronized void insertSortedTransaction(Transaction transaction) {
        int n = this.currentTransactions.size() - 1;
        while (n >= 0) {
            Transaction transaction2 = (Transaction)this.currentTransactions.elementAt(n);
            if (this.sortedBy == 0) {
                if (transaction2.getDate() < transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getDateEntered() <= transaction.getDateEntered()) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (this.sortedBy == 1) {
                if (transaction2.getDateEntered() <= transaction.getDateEntered()) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (this.sortedBy == 2) {
                if (transaction2.getDescription().compareTo(transaction.getDescription()) <= 0) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (this.sortedBy == 5) {
                String string;
                Account account = this.rootAccount.getAccountById(transaction.getAccountId(this.accountID));
                String string2 = string = account != null ? account.getFullAccountName() : "";
                if (AccountTransactionSet.getFullAccountName(this.rootAccount, transaction2.getAccountId(this.accountID)).compareTo(string) <= 0) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (this.sortedBy == 3) {
                if (transaction2.getAmount(this.accountID) <= transaction.getAmount(this.accountID)) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (this.sortedBy == 7) {
                if (transaction2.getDate() < transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getAmount(this.accountID) <= transaction.getAmount(this.accountID)) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (this.sortedBy == 6) {
                if (transaction2.getDate() < transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getClearedStatus(this.accountID) >= transaction.getClearedStatus(this.accountID)) {
                    this.insertTransactionAt(transaction, n + 1);
                    return;
                }
            } else if (transaction2.getClearedStatus(this.accountID) <= transaction.getClearedStatus(this.accountID)) {
                this.insertTransactionAt(transaction, n + 1);
                return;
            }
            --n;
        }
        this.insertTransactionAt(transaction, 0);
    }

    private final void insertTransactionAt(Transaction transaction, int n) {
        this.currentTransactions.insertElementAt(transaction, n);
        this.fireIntervalAdded(this, n, n);
    }

    private final boolean isTransactionSorted(int n, Transaction transaction) {
        String string;
        Account account;
        String string2;
        Account account2;
        Transaction transaction2;
        boolean bl = true;
        if (n > 0) {
            transaction2 = (Transaction)this.currentTransactions.elementAt(n - 1);
            if (this.sortedBy == 0) {
                if (transaction2.getDate() > transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getDateEntered() > transaction.getDateEntered()) {
                    return false;
                }
            } else if (this.sortedBy == 1) {
                if (transaction2.getDateEntered() > transaction.getDateEntered() || transaction2.getDateEntered() == transaction.getDateEntered() && transaction2.getDate() > transaction.getDate()) {
                    return false;
                }
            } else if (this.sortedBy == 2) {
                if (transaction2.getDescription().compareTo(transaction.getDescription()) > 0 || transaction2.getDescription().compareTo(transaction.getDescription()) == 0 && transaction2.getDateEntered() > transaction.getDateEntered()) {
                    return false;
                }
            } else if (this.sortedBy == 5) {
                account2 = this.rootAccount.getAccountById(transaction2.getAccountId(this.accountID));
                string2 = account2 != null ? account2.getFullAccountName() : "";
                account = this.rootAccount.getAccountById(transaction.getAccountId(this.accountID));
                String string3 = string = account != null ? account.getFullAccountName() : "";
                if (string2.compareTo(string) > 0 || string2.compareTo(string) == 0 && transaction2.getDateEntered() > transaction.getDateEntered()) {
                    return false;
                }
            } else if (this.sortedBy == 7 ? transaction2.getDate() > transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getAmount(this.accountID) > transaction.getAmount(this.accountID) : (this.sortedBy == 6 ? transaction2.getDate() > transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getClearedStatus(this.accountID) < transaction.getClearedStatus(this.accountID) : (this.sortedBy == 3 ? transaction2.getAmount(this.accountID) > transaction.getAmount(this.accountID) || transaction2.getAmount(this.accountID) == transaction.getAmount(this.accountID) && transaction2.getDateEntered() > transaction.getDateEntered() : transaction2.getClearedStatus(this.accountID) > transaction.getClearedStatus(this.accountID) || transaction2.getClearedStatus(this.accountID) == transaction.getClearedStatus(this.accountID) && transaction2.getDateEntered() > transaction.getDateEntered()))) {
                return false;
            }
        }
        if (n < this.currentTransactions.size() - 1) {
            transaction2 = (Transaction)this.currentTransactions.elementAt(n + 1);
            if (this.sortedBy == 0) {
                if (transaction2.getDate() < transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getDateEntered() < transaction.getDateEntered()) {
                    return false;
                }
            } else if (this.sortedBy == 1) {
                if (transaction2.getDateEntered() < transaction.getDateEntered() || transaction2.getDateEntered() == transaction.getDateEntered() && transaction2.getDate() < transaction.getDate()) {
                    return false;
                }
            } else if (this.sortedBy == 2) {
                if (transaction2.getDescription().compareTo(transaction.getDescription()) < 0 || transaction2.getDescription().compareTo(transaction.getDescription()) == 0 && transaction2.getDateEntered() < transaction.getDateEntered()) {
                    return false;
                }
            } else if (this.sortedBy == 5) {
                account2 = this.rootAccount.getAccountById(transaction2.getAccountId(this.accountID));
                string2 = account2 != null ? account2.getFullAccountName() : "";
                account = this.rootAccount.getAccountById(transaction.getAccountId(this.accountID));
                String string4 = string = account != null ? account.getFullAccountName() : "";
                if (string2.compareTo(string) < 0 || string2.compareTo(string) == 0 && transaction2.getDateEntered() < transaction.getDateEntered()) {
                    return false;
                }
            } else if (this.sortedBy == 7 ? transaction2.getDate() < transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getAmount(this.accountID) < transaction.getAmount(this.accountID) : (this.sortedBy == 6 ? transaction2.getDate() < transaction.getDate() || transaction2.getDate() == transaction.getDate() && transaction2.getClearedStatus(this.accountID) > transaction.getClearedStatus(this.accountID) : (this.sortedBy == 3 ? transaction2.getAmount(this.accountID) < transaction.getAmount(this.accountID) || transaction2.getAmount(this.accountID) == transaction.getAmount(this.accountID) && transaction2.getDateEntered() < transaction.getDateEntered() : transaction2.getClearedStatus(this.accountID) < transaction.getClearedStatus(this.accountID) || transaction2.getClearedStatus(this.accountID) == transaction.getClearedStatus(this.accountID) && transaction2.getDateEntered() < transaction.getDateEntered()))) {
                return false;
            }
        }
        return true;
    }

    private final void removeTransactionAt(int n) {
        this.currentTransactions.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
        this.recalcBalances();
    }

    private final void dumpTransactions() {
        int n = 0;
        while (n < this.currentTransactions.size()) {
            Transaction transaction = (Transaction)this.currentTransactions.elementAt(n);
            System.err.println(">>> " + transaction.getDescription());
            ++n;
        }
    }

    public static void sortTransactions(Vector vector, int n, int n2, RootAccount rootAccount) {
        AccountTransactionSet.quicksortAscending(vector, n, n2, 0, vector.size() - 1, rootAccount);
    }

    private static final void quicksortAscending(Vector vector, int n, int n2, int n3, int n4, RootAccount rootAccount) {
        if (n3 < n4) {
            int n5 = AccountTransactionSet.partitionAscending(vector, n, n2, n3, n4, rootAccount);
            AccountTransactionSet.quicksortAscending(vector, n, n2, n3, n5 - 1, rootAccount);
            AccountTransactionSet.quicksortAscending(vector, n, n2, n5, n4, rootAccount);
        }
    }

    private static final String getFullAccountName(RootAccount rootAccount, int n) {
        Account account = rootAccount.getAccountById(n);
        return account != null ? account.getFullAccountName() : "";
    }

    private static final Transaction getTxnAt(Vector vector, int n) {
        return (Transaction)vector.elementAt(n);
    }

    /*
     * Unable to fully structure code
     */
    private static final int partitionAscending(Vector var0, int var1_1, int var2_2, int var3_3, int var4_4, RootAccount var5_5) {
        var6_6 = AccountTransactionSet.getTxnAt(var0, (var3_3 + var4_4) / 2);
        while (var3_3 <= var4_4) {
            block25: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block24: {
                                        block18: {
                                            block23: {
                                                block22: {
                                                    block21: {
                                                        block20: {
                                                            block19: {
                                                                block17: {
                                                                    if (var1_1 != 0) break block17;
                                                                    while (AccountTransactionSet.getTxnAt(var0, var3_3).getDate() < var6_6.getDate() || AccountTransactionSet.getTxnAt(var0, var3_3).getDate() == var6_6.getDate() && AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() < var6_6.getDateEntered()) {
                                                                        ++var3_3;
                                                                    }
                                                                    break block18;
                                                                }
                                                                if (var1_1 != 1) break block19;
                                                                while (AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() < var6_6.getDateEntered() || AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() == var6_6.getDateEntered() && AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() < var6_6.getDateEntered()) {
                                                                    ++var3_3;
                                                                }
                                                                break block18;
                                                            }
                                                            if (var1_1 != 2) break block20;
                                                            while (AccountTransactionSet.getTxnAt(var0, var3_3).getDescription().compareTo(var6_6.getDescription()) < 0 || AccountTransactionSet.getTxnAt(var0, var3_3).getDescription().compareTo(var6_6.getDescription()) == 0 && AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() < var6_6.getDateEntered()) {
                                                                ++var3_3;
                                                            }
                                                            break block18;
                                                        }
                                                        if (var1_1 != 5) break block21;
                                                        var8_8 = var5_5.getAccountById(var6_6.getAccountId(var2_2));
                                                        var9_9 = var8_8 != null ? var8_8.getFullAccountName() : "";
                                                        while (AccountTransactionSet.getFullAccountName(var5_5, AccountTransactionSet.getTxnAt(var0, var3_3).getAccountId(var2_2)).compareTo(var9_9) < 0 || AccountTransactionSet.getFullAccountName(var5_5, AccountTransactionSet.getTxnAt(var0, var3_3).getAccountId(var2_2)).compareTo(var9_9) == 0 && AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() < var6_6.getDateEntered()) {
                                                            ++var3_3;
                                                        }
                                                        break block18;
                                                    }
                                                    if (var1_1 != 7) break block22;
                                                    while (AccountTransactionSet.getTxnAt(var0, var3_3).getDate() < var6_6.getDate() || AccountTransactionSet.getTxnAt(var0, var3_3).getDate() == var6_6.getDate() && AccountTransactionSet.getTxnAt(var0, var3_3).getAmount(var2_2) < var6_6.getAmount(var2_2)) {
                                                        ++var3_3;
                                                    }
                                                    break block18;
                                                }
                                                if (var1_1 != 6) break block23;
                                                while (AccountTransactionSet.getTxnAt(var0, var3_3).getDate() < var6_6.getDate() || AccountTransactionSet.getTxnAt(var0, var3_3).getDate() == var6_6.getDate() && AccountTransactionSet.getTxnAt(var0, var3_3).getClearedStatus(var2_2) > var6_6.getClearedStatus(var2_2)) {
                                                    ++var3_3;
                                                }
                                                break block18;
                                            }
                                            if (var1_1 != 3) ** GOTO lbl47
                                            while (AccountTransactionSet.getTxnAt(var0, var3_3).getAmount(var2_2) < var6_6.getAmount(var2_2) || AccountTransactionSet.getTxnAt(var0, var3_3).getAmount(var2_2) == var6_6.getAmount(var2_2) && AccountTransactionSet.getTxnAt(var0, var3_3).getDateEntered() < var6_6.getDateEntered()) {
                                                ++var3_3;
                                            }
                                            break block18;
lbl-1000:
                                            // 1 sources

                                            {
                                                ++var3_3;
lbl47:
                                                // 2 sources

                                                ** while (AccountTransactionSet.getTxnAt((Vector)var0, (int)var3_3).getClearedStatus((int)var2_2) < var6_6.getClearedStatus((int)var2_2) || AccountTransactionSet.getTxnAt((Vector)var0, (int)var3_3).getClearedStatus((int)var2_2) == var6_6.getClearedStatus((int)var2_2) && AccountTransactionSet.getTxnAt((Vector)var0, (int)var3_3).getDateEntered() < var6_6.getDateEntered())
                                            }
                                        }
                                        if (var1_1 != 0) break block24;
                                        while (AccountTransactionSet.getTxnAt(var0, var4_4).getDate() > var6_6.getDate() || AccountTransactionSet.getTxnAt(var0, var4_4).getDate() == var6_6.getDate() && AccountTransactionSet.getTxnAt(var0, var4_4).getDateEntered() > var6_6.getDateEntered()) {
                                            --var4_4;
                                        }
                                        break block25;
                                    }
                                    if (var1_1 != 1) break block26;
                                    while (AccountTransactionSet.getTxnAt(var0, var4_4).getDateEntered() > var6_6.getDateEntered() || AccountTransactionSet.getTxnAt(var0, var4_4).getDateEntered() == var6_6.getDateEntered() && AccountTransactionSet.getTxnAt(var0, var4_4).getDate() > var6_6.getDate()) {
                                        --var4_4;
                                    }
                                    break block25;
                                }
                                if (var1_1 != 2) break block27;
                                while (AccountTransactionSet.getTxnAt(var0, var4_4).getDescription().compareTo(var6_6.getDescription()) > 0 || AccountTransactionSet.getTxnAt(var0, var4_4).getDescription().compareTo(var6_6.getDescription()) == 0 && AccountTransactionSet.getTxnAt(var0, var4_4).getDateEntered() > var6_6.getDateEntered()) {
                                    --var4_4;
                                }
                                break block25;
                            }
                            if (var1_1 != 5) break block28;
                            var8_8 = var5_5.getAccountById(var6_6.getAccountId(var2_2));
                            var9_9 = var8_8 != null ? var8_8.getFullAccountName() : "";
                            while (AccountTransactionSet.getFullAccountName(var5_5, AccountTransactionSet.getTxnAt(var0, var4_4).getAccountId(var2_2)).compareTo(var9_9) > 0 || AccountTransactionSet.getFullAccountName(var5_5, AccountTransactionSet.getTxnAt(var0, var4_4).getAccountId(var2_2)).compareTo(var9_9) == 0 && AccountTransactionSet.getTxnAt(var0, var4_4).getDateEntered() > var6_6.getDateEntered()) {
                                --var4_4;
                            }
                            break block25;
                        }
                        if (var1_1 != 7) break block29;
                        while (AccountTransactionSet.getTxnAt(var0, var4_4).getDate() > var6_6.getDate() || AccountTransactionSet.getTxnAt(var0, var4_4).getDate() == var6_6.getDate() && AccountTransactionSet.getTxnAt(var0, var4_4).getAmount(var2_2) > var6_6.getAmount(var2_2)) {
                            --var4_4;
                        }
                        break block25;
                    }
                    if (var1_1 != 6) break block30;
                    while (AccountTransactionSet.getTxnAt(var0, var4_4).getDate() > var6_6.getDate() || AccountTransactionSet.getTxnAt(var0, var4_4).getDate() == var6_6.getDate() && AccountTransactionSet.getTxnAt(var0, var4_4).getClearedStatus(var2_2) < var6_6.getClearedStatus(var2_2)) {
                        --var4_4;
                    }
                    break block25;
                }
                if (var1_1 != 3) ** GOTO lbl93
                while (AccountTransactionSet.getTxnAt(var0, var4_4).getAmount(var2_2) > var6_6.getAmount(var2_2) || AccountTransactionSet.getTxnAt(var0, var4_4).getAmount(var2_2) == var6_6.getAmount(var2_2) && AccountTransactionSet.getTxnAt(var0, var4_4).getDateEntered() > var6_6.getDateEntered()) {
                    --var4_4;
                }
                break block25;
lbl-1000:
                // 1 sources

                {
                    --var4_4;
lbl93:
                    // 2 sources

                    ** while (AccountTransactionSet.getTxnAt((Vector)var0, (int)var4_4).getClearedStatus((int)var2_2) > var6_6.getClearedStatus((int)var2_2) || AccountTransactionSet.getTxnAt((Vector)var0, (int)var4_4).getClearedStatus((int)var2_2) == var6_6.getClearedStatus((int)var2_2) && AccountTransactionSet.getTxnAt((Vector)var0, (int)var4_4).getDateEntered() > var6_6.getDateEntered())
                }
            }
            if (var3_3 > var4_4) continue;
            var7_7 = (Transaction)var0.elementAt(var3_3);
            var0.setElementAt(var0.elementAt(var4_4), var3_3);
            var0.setElementAt(var7_7, var4_4);
            ++var3_3;
            --var4_4;
        }
        return var3_3;
    }

    public int getRowCount() {
        return this.currentTransactions.size();
    }

    public Object getElementAt(int n) {
        return this.currentTransactions.elementAt(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AccountTransactionSet(Account account) {
        this(account, true, true, true);
    }

    public AccountTransactionSet(Account account, boolean bl, boolean bl2, boolean bl3) {
        this.account = account;
        this.accountID = account.getAccountNum();
        this.showDebits = bl3;
        this.showCredits = bl2;
        this.showReconciled = bl;
        this.rootAccount = account.getRootAccount();
        if (account.getAccountType() == 5) {
            this.isIncomeAccount = true;
        }
        this.resources = Main.getMainController().getPreferences().getResources();
        TransactionSet transactionSet = this.rootAccount.getTransactionSet();
        this.currentTransactions = new Vector();
        this.accountInfoListeners = new Vector();
        this.tableListeners = new Vector();
        Object object = transactionSet.getAllTransactions();
        while (object.hasMoreElements()) {
            Transaction transaction = (Transaction)object.nextElement();
            if (!this.isTransactionVisible(transaction)) continue;
            this.currentTransactions.addElement(transaction);
        }
        this.shortDateFormat = Main.getMainController().getPreferences().getShortDateFormatter();
        this.currencyFormat = Main.getMainController().getPreferences().getCurrencyFormatter();
        this.tableColumnNames = new String[]{this.resources.getString("table_column_date"), this.resources.getString("table_column_checknum"), this.resources.getString("table_column_description"), this.resources.getString("table_column_account"), this.resources.getString("table_column_clearedchar"), this.resources.getString("table_column_debit"), this.resources.getString("table_column_credit")};
        transactionSet.addTransactionListener(this);
        object = this;
        synchronized (object) {
            AccountTransactionSet.sortTransactions(this.currentTransactions, this.sortedBy, this.accountID, this.rootAccount);
        }
        this.recalcBalances();
        this.fireContentsChanged(this, 0, this.currentTransactions.size() - 1);
    }
}

