/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.apps.moneydance.view.gui.AccountDetailInterface;
import com.seanreilly.apps.moneydance.view.gui.AccountHeaderPanel;
import com.seanreilly.apps.moneydance.view.gui.AccountInfoWindow;
import com.seanreilly.apps.moneydance.view.gui.AccountSelectionListener;
import com.seanreilly.apps.moneydance.view.gui.BankAccountDetailPanel;
import com.seanreilly.apps.moneydance.view.gui.COATreePanel;
import com.seanreilly.apps.moneydance.view.gui.CreateAccountWindow;
import com.seanreilly.apps.moneydance.view.gui.DefaultAccountDetailPanel;
import com.seanreilly.apps.moneydance.view.gui.InterfacePanel;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.apps.moneydance.view.gui.RootAccountDetailPanel;
import com.seanreilly.apps.moneydance.view.gui.graphtool.GraphTool;
import com.seanreilly.apps.moneydance.view.gui.reporttool.ReportTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class AccountPanel
extends JPanel
implements AccountSelectionListener,
InterfacePanel {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$RootAccount;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankAccount;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$InvestmentAccount;
    private JSplitPane splitPane;
    private COATreePanel coaPanel;
    private JPanel mainPanel;
    private AccountHeaderPanel headerPanel;
    private AccountDetailInterface detailPanel;
    private RootAccount rootAccount;
    private Vector graphers;
    private Vector reporters;
    private MoneydanceGUI moneydanceGUI;

    public void accountSelected(Account account) {
        if (this.detailPanel != null && this.detailPanel.getAccount() == account) {
            return;
        }
        if (this.detailPanel != null) {
            this.detailPanel.goingAway();
        }
        this.mainPanel.removeAll();
        if (this.detailPanel != null) {
            this.detailPanel.goneAway();
        }
        if (account.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$RootAccount != null ? class$Lcom$seanreilly$apps$moneydance$model$RootAccount : (class$Lcom$seanreilly$apps$moneydance$model$RootAccount = AccountPanel.class$("com.seanreilly.apps.moneydance.model.RootAccount")))) {
            RootAccountDetailPanel rootAccountDetailPanel = new RootAccountDetailPanel(this.moneydanceGUI, (RootAccount)account, this.headerPanel);
            this.detailPanel = rootAccountDetailPanel;
            this.mainPanel.add((Component)rootAccountDetailPanel, "Center");
            this.mainPanel.validate();
        } else if (account.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankAccount != null ? class$Lcom$seanreilly$apps$moneydance$model$BankAccount : (class$Lcom$seanreilly$apps$moneydance$model$BankAccount = AccountPanel.class$("com.seanreilly.apps.moneydance.model.BankAccount"))) || account.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$InvestmentAccount != null ? class$Lcom$seanreilly$apps$moneydance$model$InvestmentAccount : (class$Lcom$seanreilly$apps$moneydance$model$InvestmentAccount = AccountPanel.class$("com.seanreilly.apps.moneydance.model.InvestmentAccount")))) {
            BankAccountDetailPanel bankAccountDetailPanel = new BankAccountDetailPanel(this.moneydanceGUI, account);
            this.detailPanel = bankAccountDetailPanel;
            this.mainPanel.add((Component)bankAccountDetailPanel, "Center");
            this.mainPanel.validate();
        } else {
            DefaultAccountDetailPanel defaultAccountDetailPanel = new DefaultAccountDetailPanel(this.moneydanceGUI, account);
            this.detailPanel = defaultAccountDetailPanel;
            this.mainPanel.add((Component)defaultAccountDetailPanel, "Center");
            this.mainPanel.validate();
        }
        System.gc();
    }

    public void editAccount(Account account) {
        if (account == null) {
            return;
        }
        AccountInfoWindow accountInfoWindow = new AccountInfoWindow(this.moneydanceGUI, account);
        ((Component)accountInfoWindow).setVisible(true);
    }

    public void createAccount(Account account) {
        CreateAccountWindow createAccountWindow = new CreateAccountWindow(this.moneydanceGUI.getTopLevelFrame(), account, this.moneydanceGUI);
        ((Component)createAccountWindow).setVisible(true);
    }

    public void deleteAccount(Account account) {
        if (account.getAccountType() == 0) {
            JOptionPane.showMessageDialog(this, this.moneydanceGUI.resources.getString("cant_delete_root_acct"), this.moneydanceGUI.resources.getString("error"), 0);
            return;
        }
        if (this.detailPanel != null && this.detailPanel.getAccount() == account) {
            this.detailPanel.goingAway();
        }
        boolean bl = true;
        TransactionSet transactionSet = account.getRootAccount().getTransactionSet();
        int n = account.getAccountNum();
        Object object = transactionSet.getAllTransactions();
        while (object.hasMoreElements()) {
            Transaction transaction = (Transaction)object.nextElement();
            if (!account.containsTransaction(transaction, true, false)) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.mainPanel.removeAll();
            if (JOptionPane.showConfirmDialog(this, this.moneydanceGUI.resources.getString("confirm_delete_acct") + account.getAccountName(), this.moneydanceGUI.resources.getString("generic_confirm"), 0) == 0) {
                if (this.detailPanel != null && this.detailPanel.getAccount() == account) {
                    this.detailPanel.goneAway();
                }
                this.headerPanel.selectPreviousAccount();
                object = this.headerPanel.getSelectedAccount();
                if (object != null) {
                    this.accountSelected((Account)object);
                } else {
                    this.accountSelected(account.getRootAccount());
                }
                account.getParentAccount().removeSubAccount(account, true);
            }
        } else {
            JOptionPane.showMessageDialog(this, this.moneydanceGUI.resources.getString("cant_delete_nonempty_acct"), this.moneydanceGUI.resources.getString("error"), 0);
        }
    }

    public void graphAccount(Account account) {
        if (this.rootAccount.getSubAccountCount() <= 0) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("nothing_to_graph"));
            return;
        }
        GraphTool graphTool = new GraphTool(this.moneydanceGUI, account, this);
        this.graphers.addElement(graphTool);
        ((Component)graphTool).setVisible(true);
    }

    public void grapherIsDone(GraphTool graphTool) {
        this.graphers.removeElement(graphTool);
        ((Component)graphTool).setVisible(false);
        graphTool.dispose();
    }

    public void reportOnAccount(Account account) {
        if (this.rootAccount.getSubAccountCount() <= 0) {
            this.moneydanceGUI.showErrorMessage(this.moneydanceGUI.resources.getString("nothing_to_report"));
            return;
        }
        ReportTool reportTool = new ReportTool(this.moneydanceGUI, account, this);
        this.reporters.addElement(reportTool);
        ((Component)reportTool).setVisible(true);
    }

    public void reporterIsDone(ReportTool reportTool) {
        this.reporters.removeElement(reportTool);
        ((Component)reportTool).setVisible(false);
        reportTool.dispose();
    }

    public void goingAway() {
        if (this.rootAccount.isUnsavedData() && this.moneydanceGUI.askQuestion(this.moneydanceGUI.resources.getString("save_changes"), this.moneydanceGUI.resources.getString("save_changes_question"))) {
            this.moneydanceGUI.saveCurrentAccount();
        }
        if (this.detailPanel != null) {
            this.detailPanel.goingAway();
        }
        if (this.headerPanel != null) {
            this.headerPanel.goingAway();
        }
    }

    public void goneAway() {
        JFrame jFrame;
        Enumeration enumeration = this.graphers.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (GraphTool)enumeration.nextElement();
            this.grapherIsDone((GraphTool)jFrame);
        }
        enumeration = this.reporters.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (ReportTool)enumeration.nextElement();
            this.reporterIsDone((ReportTool)jFrame);
        }
        if (this.detailPanel != null) {
            this.detailPanel.goneAway();
        }
        if (this.headerPanel != null) {
            this.headerPanel.goneAway();
        }
    }

    public void saveWorkspace() {
    }

    public void loadWorkspace() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AccountPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.setLayout(new BorderLayout());
        this.graphers = new Vector();
        this.reporters = new Vector();
        rootAccount.sortAccounts();
        this.headerPanel = new AccountHeaderPanel(this.moneydanceGUI, rootAccount);
        this.headerPanel.addAccountSelectionListener(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.mainPanel, "Center");
        this.accountSelected(rootAccount);
    }
}

