/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.RootAccount;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AccountModel
implements TreeModel,
AccountListener {
    private boolean showNonRegisterAccounts = true;
    private RootAccount rootAccount;
    private Vector treeModelListeners;
    private Vector listModelListeners;
    private Vector accountList;

    public void goingAway() {
    }

    public void goneAway() {
        this.rootAccount.removeAccountListener(this);
    }

    public void setShowNonRegisterAccounts(boolean bl) {
        if (bl != this.showNonRegisterAccounts) {
            this.showNonRegisterAccounts = bl;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.rootAccount.getPath()));
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.addElement(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.removeElement(treeModelListener);
    }

    public Object getChild(Object object, int n) {
        Account account = (Account)object;
        int n2 = 0;
        int n3 = 0;
        while (n3 < account.getSubAccountCount()) {
            Account account2 = account.getSubAccount(n3);
            if (this.accountIsViewable(account2)) {
                if (n == n2) {
                    return account2;
                }
                ++n2;
            }
            ++n3;
        }
        return null;
    }

    private final boolean accountIsViewable(Account account) {
        if (this.showNonRegisterAccounts) {
            return true;
        }
        return account.isRegisterAccount();
    }

    public int getChildCount(Object object) {
        Account account = (Account)object;
        int n = 0;
        int n2 = 0;
        while (n2 < account.getSubAccountCount()) {
            if (this.accountIsViewable(account.getSubAccount(n2))) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Account account = (Account)object;
        if (!this.accountIsViewable((Account)object2)) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < account.getSubAccountCount()) {
            Account account2 = account.getSubAccount(n2);
            if (object2 == account2) {
                return n;
            }
            if (this.accountIsViewable(account2)) {
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    public Object getRoot() {
        return this.rootAccount;
    }

    public boolean isLeaf(Object object) {
        Account account = (Account)object;
        Enumeration enumeration = account.getSubAccounts();
        while (enumeration.hasMoreElements()) {
            if (!this.accountIsViewable((Account)enumeration.nextElement())) continue;
            return false;
        }
        return true;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void accountModified(Account account) {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, account.getRootAccount().getPath()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        Enumeration enumeration = this.treeModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((TreeModelListener)enumeration.nextElement()).treeStructureChanged(treeModelEvent);
            }
            catch (Exception exception) {
                System.err.println("" + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public AccountModel(RootAccount rootAccount) {
        this.rootAccount = rootAccount;
        rootAccount.sortAccounts();
        this.accountList = new Vector();
        this.listModelListeners = new Vector();
        this.treeModelListeners = new Vector();
        rootAccount.addAccountListener(this);
    }
}

