/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.RootAccount;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class AccountListModel
extends AbstractListModel
implements ComboBoxModel,
AccountListener,
ItemSelectable {
    private RootAccount rootAccount;
    private Vector listSelectionListeners;
    private Vector accountList;
    private Account selectedItem = null;
    private boolean[] viewAccountTypes;
    private Vector dontShowAccounts;

    public void goingAway() {
    }

    public void goneAway() {
        this.rootAccount.removeAccountListener(this);
    }

    public void clearDontShowAccounts() {
        this.dontShowAccounts.removeAllElements();
        this.rebuildList();
    }

    public void setShowAccount(Account account, boolean bl) {
        if (account == null) {
            return;
        }
        if (bl) {
            if (this.dontShowAccounts.contains(account)) {
                while (this.dontShowAccounts.removeElement(account)) {
                }
            }
        } else {
            this.dontShowAccounts.addElement(account);
        }
        this.rebuildList();
    }

    public void setShowAccountsOfType(int n, boolean bl) {
        if (n < this.viewAccountTypes.length && n >= 0 && this.viewAccountTypes[n] != bl) {
            this.viewAccountTypes[n] = bl;
            this.rebuildList();
        }
    }

    public void accountModified(Account account) {
        this.rebuildList();
    }

    private final boolean isAccountViewable(Account account) {
        if (!this.viewAccountTypes[account.getAccountType()]) {
            return false;
        }
        return !this.dontShowAccounts.contains(account);
    }

    private final synchronized void rebuildList() {
        this.accountList.removeAllElements();
        if (this.isAccountViewable(this.rootAccount)) {
            this.accountList.addElement(this.rootAccount);
        }
        int n = 0;
        while (n < this.rootAccount.getSubAccountCount()) {
            Account account = this.rootAccount.getSubAccount(n);
            if (this.isAccountViewable(account)) {
                this.addAccountToList(account);
            }
            ++n;
        }
        if (this.selectedItem != null && !this.isAccountViewable(this.selectedItem)) {
            this.selectedItem = null;
            if (this.accountList.size() > 0) {
                this.selectedItem = (Account)this.accountList.elementAt(0);
            }
        }
        this.fireContentsChanged(this, 0, this.accountList.size() - 1);
    }

    private final void addAccountToList(Account account) {
        this.accountList.addElement(account);
        int n = 0;
        while (n < account.getSubAccountCount()) {
            Account account2 = account.getSubAccount(n);
            if (this.isAccountViewable(account2)) {
                this.addAccountToList(account2);
            }
            ++n;
        }
    }

    public synchronized Object getElementAt(int n) {
        return this.accountList.elementAt(n);
    }

    public synchronized int getSize() {
        return this.accountList.size();
    }

    public void addItemListener(ItemListener itemListener) {
        this.listSelectionListeners.addElement(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listSelectionListeners.removeElement(itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.selectedItem != null) {
            return new Object[]{this.selectedItem};
        }
        return new Object[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireItemEvent(Account account) {
        ItemEvent itemEvent = null;
        Enumeration enumeration = this.listSelectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            if (itemEvent == null) {
                itemEvent = new ItemEvent(this, 701, account, 1);
            }
            try {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
            }
            catch (Exception exception) {
                System.err.println("Got exception dispatching event: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedAccount(Account account) {
        this.selectedItem = account;
    }

    public void setSelectedAccountIndex(int n) {
        this.selectedItem = this.accountList.size() > n && n >= 0 ? (Account)this.accountList.elementAt(n) : null;
    }

    public void setSelectedItem(Object object) {
        if (object != this.selectedItem) {
            this.selectedItem = object != null && !this.accountList.contains(object) ? (this.accountList.size() > 0 ? (Account)this.accountList.elementAt(0) : null) : (Account)object;
            this.fireItemEvent(this.selectedItem);
        }
    }

    public AccountListModel(RootAccount rootAccount) {
        this(rootAccount, false);
    }

    public AccountListModel(RootAccount rootAccount, boolean bl) {
        this.rootAccount = rootAccount;
        if (bl) {
            rootAccount.sortAccounts();
        }
        this.accountList = new Vector();
        this.dontShowAccounts = new Vector();
        this.listSelectionListeners = new Vector();
        rootAccount.addAccountListener(this);
        this.viewAccountTypes = new boolean[6];
        this.viewAccountTypes[1] = true;
        this.viewAccountTypes[4] = true;
        this.viewAccountTypes[5] = true;
        this.viewAccountTypes[0] = false;
        this.viewAccountTypes[2] = true;
        this.viewAccountTypes[3] = true;
        this.rebuildList();
        if (this.accountList.size() > 0) {
            this.selectedItem = (Account)this.accountList.elementAt(0);
        }
    }
}

