/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.view.gui;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.view.gui.AccountKeySelectionManager;
import com.seanreilly.apps.moneydance.view.gui.AccountListModel;
import com.seanreilly.apps.moneydance.view.gui.AccountSelectionListener;
import com.seanreilly.apps.moneydance.view.gui.AccountTreeCellRenderer;
import com.seanreilly.apps.moneydance.view.gui.MoneydanceGUI;
import com.seanreilly.awt.AwtUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AccountHeaderPanel
extends JPanel
implements ActionListener,
ItemListener {
    private Vector listeners;
    private RootAccount rootAccount;
    private MoneydanceGUI moneydanceGUI;
    private AccountListModel accountModel;
    private JComboBox accountChoice;
    private JButton newAccountButton;
    private JButton editAccountButton;
    private JButton deleteAccountButton;
    private JButton graphAccountButton;
    private JButton reportAccountButton;

    public void setSelectedAccount(Account account) {
        this.accountChoice.setSelectedItem(account);
        this.accountChoice.repaint();
    }

    public Account getSelectedAccount() {
        return (Account)this.accountChoice.getSelectedItem();
    }

    public void selectPreviousAccount() {
        int n = this.accountChoice.getSelectedIndex() - 1;
        if (n < 0) {
            n = 0;
        }
        this.accountChoice.setSelectedIndex(n);
    }

    public void goingAway() {
        this.accountModel.goingAway();
    }

    public void goneAway() {
        this.accountModel.goneAway();
    }

    public void addAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.addElement(accountSelectionListener);
    }

    public void removeAccountSelectionListener(AccountSelectionListener accountSelectionListener) {
        this.listeners.removeElement(accountSelectionListener);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.accountModel) {
            this.fireAccountSelected((Account)this.accountChoice.getSelectedItem());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.accountChoice) {
            this.fireAccountSelected((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.newAccountButton) {
            this.fireCreateAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.editAccountButton) {
            this.fireEditAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.deleteAccountButton) {
            this.fireDeleteAccount((Account)this.accountChoice.getSelectedItem());
            this.deleteAccountButton.repaint();
        } else if (actionEvent.getSource() == this.graphAccountButton) {
            this.fireGraphAccount((Account)this.accountChoice.getSelectedItem());
        } else if (actionEvent.getSource() == this.reportAccountButton) {
            this.fireReportOnAccount((Account)this.accountChoice.getSelectedItem());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireAccountSelected(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).accountSelected(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireEditAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).editAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireCreateAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).createAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireDeleteAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).deleteAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireGraphAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).graphAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireReportOnAccount(Account account) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountSelectionListener)enumeration.nextElement()).reportOnAccount(account);
            }
            catch (Exception exception) {
                System.err.println("Exception during listener notification: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public AccountHeaderPanel(MoneydanceGUI moneydanceGUI, RootAccount rootAccount) {
        this.moneydanceGUI = moneydanceGUI;
        this.rootAccount = rootAccount;
        this.setLayout(new GridBagLayout());
        this.listeners = new Vector();
        int n = 2;
        int n2 = 0;
        this.accountModel = new AccountListModel(rootAccount);
        this.accountModel.setShowAccountsOfType(0, true);
        this.accountChoice = new JComboBox(this.accountModel);
        this.accountChoice.setBackground(Color.black);
        this.accountChoice.setForeground(Color.cyan);
        this.accountChoice.setKeySelectionManager(new AccountKeySelectionManager(this.accountChoice));
        AccountTreeCellRenderer accountTreeCellRenderer = new AccountTreeCellRenderer(this.moneydanceGUI);
        accountTreeCellRenderer.setRealBackground(Color.black);
        accountTreeCellRenderer.setRealForeground(Color.lightGray);
        this.accountChoice.setRenderer(accountTreeCellRenderer);
        this.accountChoice.setMaximumRowCount(16);
        this.newAccountButton = new JButton(this.moneydanceGUI.resources.getString("new"));
        this.newAccountButton.setForeground(Color.cyan);
        this.newAccountButton.setBackground(Color.black);
        this.newAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.editAccountButton = new JButton(this.moneydanceGUI.resources.getString("edit"));
        this.editAccountButton.setForeground(Color.cyan);
        this.editAccountButton.setBackground(Color.black);
        this.editAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.deleteAccountButton = new JButton(this.moneydanceGUI.resources.getString("delete"));
        this.deleteAccountButton.setForeground(Color.cyan);
        this.deleteAccountButton.setBackground(Color.black);
        this.deleteAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.graphAccountButton = new JButton(this.moneydanceGUI.resources.getString("graph"));
        this.graphAccountButton.setForeground(Color.cyan);
        this.graphAccountButton.setBackground(Color.black);
        this.graphAccountButton.setMargin(new Insets(n2, n, 0, n));
        this.reportAccountButton = new JButton(this.moneydanceGUI.resources.getString("report"));
        this.reportAccountButton.setForeground(Color.cyan);
        this.reportAccountButton.setBackground(Color.black);
        this.reportAccountButton.setMargin(new Insets(n2, n, 0, n));
        int n3 = 0;
        JLabel jLabel = new JLabel(this.moneydanceGUI.resources.getString("account") + ": ", 4);
        jLabel.setForeground(Color.cyan);
        this.add((Component)jLabel, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.accountChoice, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)new JLabel(""), AwtUtil.getConstraints(n3++, 0, 1.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.newAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.editAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.deleteAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.graphAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.add((Component)this.reportAccountButton, AwtUtil.getConstraints(n3++, 0, 0.0f, 0.0f, 1, 1, true, true));
        this.setBackground(Color.black);
        this.setForeground(Color.cyan);
        this.newAccountButton.addActionListener(this);
        this.editAccountButton.addActionListener(this);
        this.deleteAccountButton.addActionListener(this);
        this.graphAccountButton.addActionListener(this);
        this.reportAccountButton.addActionListener(this);
        this.accountChoice.setSelectedIndex(0);
        this.accountModel.addItemListener(this);
    }
}

