/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.model.InvestmentAccount;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.io.QIFDataReader;
import com.seanreilly.util.StringUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;

public class QIFDataReader {
    private RootAccount rootAccount;
    private File qifFile;
    private ExpenseAccount defaultExpenseCategory = null;
    private IncomeAccount defaultIncomeCategory = null;
    private boolean autoSwitch = false;
    private Hashtable transferAccounts;
    private Account lastAccountRead = null;
    private Account accountToImportTo = null;
    private CurrencyType currency = null;
    private CurrencyTable currencyTable = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readTransactions(StatusMonitor statusMonitor) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.qifFile));
        this.autoSwitch = false;
        this.lastAccountRead = null;
        String string = this.readUpToSectionStart(dataInputStream);
        try {
            while (true) {
                if (string == null) {
                    Object var5_5 = null;
                    this.rootAccount.sortAccounts();
                    return;
                }
                if (string.length() <= 0) {
                    throw new Exception("Invalid section start: " + string);
                }
                if (string.startsWith("!Type:")) {
                    String string2 = string.substring(6).trim();
                    if (string2.equals("Class")) {
                        string = this.readUpToSectionStart(dataInputStream);
                        continue;
                    }
                    if (string2.equals("Bank")) {
                        string = this.readBankRegister("Imported Bank Account", dataInputStream);
                        continue;
                    }
                    if (string2.equals("Invst")) {
                        string = this.readInvstRegister("Imported Investment Account", dataInputStream);
                        continue;
                    }
                    if (string2.equals("CCard")) {
                        string = this.readBankRegister("Imported Credit Card Account", dataInputStream);
                        continue;
                    }
                    if (string2.equals("Cash")) {
                        string = this.readBankRegister("Imported Cash Account", dataInputStream);
                        continue;
                    }
                    if (string2.equals("Oth A")) {
                        string = this.readBankRegister("Imported Asset", dataInputStream);
                        continue;
                    }
                    if (string2.equals("Oth L")) {
                        string = this.readBankRegister("Imported Liability", dataInputStream);
                        continue;
                    }
                    System.err.println("QIF: ignoring unknown account type: " + string);
                    string = this.readUpToSectionStart(dataInputStream);
                    continue;
                }
                if (string.startsWith("!Account")) {
                    string = this.readAccountDefinitions(dataInputStream);
                    continue;
                }
                if (string.startsWith("!Option:")) {
                    if (string.substring(9).trim().toUpperCase().equals("AUTOSWITCH")) {
                        this.autoSwitch = true;
                    }
                    string = dataInputStream.readLine();
                    continue;
                }
                if (string.startsWith("!Clear:")) {
                    if (string.substring(8).trim().toUpperCase().equals("AUTOSWITCH")) {
                        this.autoSwitch = false;
                        this.lastAccountRead = null;
                    }
                    string = dataInputStream.readLine();
                    continue;
                }
                System.err.println("Unknown section type: " + string);
                string = this.readUpToSectionStart(dataInputStream);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.rootAccount.sortAccounts();
            throw throwable;
        }
    }

    private final String readAccountDefinitions(DataInputStream dataInputStream) throws Exception {
        String string;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while ((string = dataInputStream.readLine()) != null) {
            if ((string = string.trim()).startsWith("^") || string.startsWith("!")) {
                if (string2.length() > 0 || string3.length() > 0 || string4.length() > 0) {
                    Account account = null;
                    if (string3.toUpperCase().trim().equals("BANK")) {
                        account = new BankAccount(string2, -1, this.currency.getID(), null, null, this.rootAccount);
                        ((BankAccount)account).setBankName(string4);
                    } else if (string3.toUpperCase().trim().equals("INVST")) {
                        account = new InvestmentAccount(string2, -1, this.currency.getID(), null, null, this.rootAccount);
                        ((InvestmentAccount)account).setAccountDescription(string4);
                    } else if (string3.toUpperCase().trim().equals("CASH")) {
                        account = new BankAccount(string2, -1, this.currency.getID(), null, null, this.rootAccount);
                        ((BankAccount)account).setBankName(string4);
                    } else if (string3.toUpperCase().trim().equals("OTH A")) {
                        account = new BankAccount(string2, -1, this.currency.getID(), null, null, this.rootAccount);
                        ((BankAccount)account).setBankName(string4);
                    } else if (string3.toUpperCase().trim().equals("CCARD")) {
                        account = new BankAccount(string2, -1, this.currency.getID(), null, null, this.rootAccount);
                        ((BankAccount)account).setBankName(string4);
                    } else if (string3.toUpperCase().trim().equals("OTH L")) {
                        account = new BankAccount(string2, -1, this.currency.getID(), null, null, this.rootAccount);
                        ((BankAccount)account).setBankName(string4);
                    } else {
                        System.err.println("QIF Import: Unrecognized account type: " + string3);
                    }
                    if (account != null) {
                        this.transferAccounts.put(string2, account);
                        this.rootAccount.addSubAccount(account);
                        this.lastAccountRead = account;
                    }
                }
                string2 = "";
                string4 = "";
                string3 = "";
                if (!string.startsWith("!")) continue;
                break;
            }
            if (string.startsWith("D")) {
                string4 = string.substring(1).trim();
                continue;
            }
            if (string.startsWith("N")) {
                string2 = string.substring(1).trim();
                continue;
            }
            if (!string.startsWith("T")) continue;
            string3 = string.substring(1).trim();
        }
        return string;
    }

    private final String readBankRegister(String string, DataInputStream dataInputStream) throws Exception {
        String string2;
        Account account = null;
        CurrencyType currencyType = this.currency;
        if (this.accountToImportTo == null && this.lastAccountRead != null && this.lastAccountRead.isRegisterAccount()) {
            if (this.rootAccount.getTransactionSet().getTransactionsForAccount(this.lastAccountRead).size() <= 0) {
                account = this.lastAccountRead;
                currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
            }
        } else if (this.accountToImportTo != null) {
            account = this.accountToImportTo;
            currencyType = this.currencyTable.getCurrencyType(account.getCurrencyType());
            this.accountToImportTo = null;
        }
        if (account == null) {
            account = new BankAccount(string, -1, currencyType.getID(), null, null, this.rootAccount);
            this.rootAccount.addSubAccount(account);
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        QIFDataReader qIFDataReader = this;
        if (qIFDataReader == null) {
            throw null;
        }
        class SplitInfo {
            private final /* synthetic */ QIFDataReader this$0;
            boolean haveInfo;
            String splitCategory;
            String splitDesc;
            String splitAmount;

            SplitInfo(QIFDataReader qIFDataReader) {
                this.this$0 = qIFDataReader;
                this.haveInfo = false;
                this.splitCategory = "";
                this.splitDesc = "";
                this.splitAmount = "";
                this.constructor$0(qIFDataReader);
            }

            void constructor$0(QIFDataReader qIFDataReader) {
            }
        }
        SplitInfo splitInfo = new SplitInfo(qIFDataReader);
        Vector<SplitInfo> vector = new Vector<SplitInfo>();
        while ((string2 = dataInputStream.readLine()) != null) {
            if ((string2 = string2.trim()).startsWith("^") || string2.startsWith("!")) {
                if (splitInfo.haveInfo) {
                    vector.addElement(splitInfo);
                }
                QIFDataReader qIFDataReader2 = this;
                if (qIFDataReader2 == null) {
                    throw null;
                }
                splitInfo = new SplitInfo(qIFDataReader2);
                if (vector.size() > 0 || string3.length() > 0 || string4.length() > 0 || string5.length() > 0 || string6.length() > 0 || string7.length() > 0 || string8.length() > 0 || string9.length() > 0) {
                    Object object;
                    long l = StringUtils.parseCurrency(string4, '.', currencyType.getDecimalPlaces());
                    long l2 = StringUtils.parseQuickenDate(string3);
                    char c = ' ';
                    if (string5.startsWith("x") || string5.startsWith("X")) {
                        c = 'X';
                    } else if (string5.startsWith("*")) {
                        c = 'x';
                    }
                    int n = -1;
                    double d = 1.0;
                    if (vector.size() <= 0) {
                        if (string9.startsWith("[") && string9.endsWith("]")) {
                            string9 = string9.substring(1, string9.length() - 1).trim();
                        }
                        object = this.getAccountForCategory(string9, l);
                        CurrencyType currencyType2 = this.currencyTable.getCurrencyType(((Account)object).getCurrencyType());
                        n = ((Account)object).getAccountNum();
                        d = CurrencyType.getXRelativeRate(currencyType2, currencyType, d);
                    }
                    object = new BankTransaction(-1L, n, account.getAccountNum(), string7, l, l2, l2, l2, c, c, string6, null, string8);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        SplitInfo splitInfo2 = (SplitInfo)vector.elementAt(n2);
                        long l3 = StringUtils.parseCurrency(splitInfo2.splitAmount, '.', currencyType.getDecimalPlaces());
                        splitInfo2.splitCategory = splitInfo2.splitCategory.trim();
                        if (splitInfo2.splitCategory.startsWith("[") && splitInfo2.splitCategory.endsWith("]")) {
                            splitInfo2.splitCategory = splitInfo2.splitCategory.substring(1, splitInfo2.splitCategory.length() - 1).trim();
                        }
                        Account account2 = this.getAccountForCategory(splitInfo2.splitCategory, l3);
                        int n3 = account2.getAccountNum();
                        CurrencyType currencyType3 = this.currencyTable.getCurrencyType(account2.getCurrencyType());
                        double d2 = CurrencyType.getXRelativeRate(currencyType3, currencyType, d);
                        ((BankTransaction)object).addSplit(new SplitTransaction(-1L, n3, d2, splitInfo2.splitDesc, l3, l2, c, (BankTransaction)object));
                        ++n2;
                    }
                    this.rootAccount.getTransactionSet().addNewTransaction((Transaction)object);
                }
                string3 = "";
                string4 = "";
                string5 = "";
                string6 = "";
                string7 = "";
                string8 = "";
                string9 = "";
                vector.removeAllElements();
                if (!string2.startsWith("!")) continue;
                break;
            }
            if (string2.startsWith("D")) {
                string3 = string2.substring(1).trim();
                continue;
            }
            if (string2.startsWith("T")) {
                string4 = string2.substring(1).trim();
                continue;
            }
            if (string2.startsWith("C")) {
                string5 = string2.substring(1).trim();
                continue;
            }
            if (string2.startsWith("N")) {
                string6 = string2.substring(1).trim();
                continue;
            }
            if (string2.startsWith("P")) {
                string7 = string2.substring(1).trim();
                continue;
            }
            if (string2.startsWith("M") || string2.startsWith("A")) {
                string8 = (string8 + "\n" + string2.substring(1)).trim();
                continue;
            }
            if (string2.startsWith("L")) {
                string9 = string2.substring(1).trim();
                continue;
            }
            if (string2.startsWith("S")) {
                if (splitInfo.haveInfo) {
                    vector.addElement(splitInfo);
                    QIFDataReader qIFDataReader3 = this;
                    if (qIFDataReader3 == null) {
                        throw null;
                    }
                    splitInfo = new SplitInfo(qIFDataReader3);
                }
                splitInfo.splitCategory = string2.substring(1).trim();
                splitInfo.haveInfo = true;
                continue;
            }
            if (string2.startsWith("E")) {
                splitInfo.splitDesc = string2.substring(1).trim();
                splitInfo.haveInfo = true;
                continue;
            }
            if (!string2.startsWith("$")) continue;
            if (splitInfo.haveInfo || vector.size() > 0) {
                splitInfo.splitAmount = string2.substring(1).trim();
                splitInfo.haveInfo = true;
                continue;
            }
            string4 = string2.substring(1).trim();
        }
        return string2;
    }

    private final String readInvstRegister(String string, DataInputStream dataInputStream) throws Exception {
        String string2;
        Account account = null;
        if (this.accountToImportTo == null && this.lastAccountRead != null && this.lastAccountRead.getAccountNum() == 2) {
            if (this.rootAccount.getTransactionSet().getTransactionsForAccount(this.lastAccountRead).size() <= 0) {
                this.lastAccountRead.setCurrencyType(this.currency.getID());
                account = this.lastAccountRead;
            }
        } else if (this.accountToImportTo != null) {
            account = this.accountToImportTo;
            this.currency = this.currencyTable.getCurrencyType(account.getCurrencyType());
            this.accountToImportTo = null;
        }
        if (account == null) {
            account = new InvestmentAccount(string, -1, this.currency.getID(), null, null, this.rootAccount);
            this.rootAccount.addSubAccount(account);
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        while ((string2 = dataInputStream.readLine()) != null) {
            if ((string2 = string2.trim()).startsWith("^") || string2.startsWith("!")) {
                if (string3.length() > 0 || string4.length() > 0 || string5.length() > 0 || string6.length() > 0 || string7.length() > 0 || string8.length() > 0 || string9.length() > 0 || string10.length() > 0 || string11.length() > 0 || string12.length() > 0) {
                    long l = StringUtils.parseQuickenDate(string3);
                    double d = StringUtils.parseRate(string6, '.');
                    double d2 = StringUtils.parseRate(string7, '.');
                    long l2 = StringUtils.parseCurrency(string11, '.', this.currency.getDecimalPlaces());
                    long l3 = StringUtils.parseCurrency(string13, '.', this.currency.getDecimalPlaces());
                    char c = ' ';
                    if (string8.startsWith("x") || string8.startsWith("X")) {
                        c = 'X';
                    } else if (string8.startsWith("*")) {
                        c = 'x';
                    }
                    int n = -1;
                    if (string12.startsWith("[") && string12.endsWith("]")) {
                        string12 = string12.substring(1, string12.length() - 1).trim();
                    }
                    Account account2 = this.getAccountForCategory(string12, l3);
                    n = account2.getAccountNum();
                    CurrencyType currencyType = this.currencyTable.getCurrencyType(account2.getCurrencyType());
                    String string14 = "";
                    if (d != 1.0 && d2 > 0.0) {
                        string14 = "Purchase " + d2 + " shares";
                    } else if (d != 1.0 && d2 < 0.0) {
                        string14 = "Sell " + d2 + " shares";
                    }
                    d = CurrencyType.getXRelativeRate(currencyType, this.currency, 1.0);
                    if (string4.equals("SellX")) {
                        l3 *= -1L;
                    }
                    BankTransaction bankTransaction = new BankTransaction(-1L, n, account.getAccountNum(), d, string5, l3, l, l, l, c, c, string4, null, ((string10 + "\n" + string9).trim() + '\n' + string14).trim());
                    this.rootAccount.getTransactionSet().addNewTransaction(bankTransaction);
                }
                string3 = "";
                string4 = "";
                string5 = "";
                string6 = "";
                string7 = "";
                string8 = "";
                string9 = "";
                string10 = "";
                string11 = "";
                string12 = "";
                string13 = "";
                if (!string2.startsWith("!")) continue;
                break;
            }
            String string15 = "";
            if (string2.length() > 0) {
                string15 = string2.substring(1).trim();
            }
            if (string2.startsWith("D")) {
                string3 = string15;
                continue;
            }
            if (string2.startsWith("N")) {
                string4 = string15;
                continue;
            }
            if (string2.startsWith("Y")) {
                string5 = string15;
                continue;
            }
            if (string2.startsWith("I")) {
                string6 = string15;
                continue;
            }
            if (string2.startsWith("Q")) {
                string7 = string15;
                continue;
            }
            if (string2.startsWith("C")) {
                string8 = string15;
                continue;
            }
            if (string2.startsWith("P")) {
                string10 = string15;
                continue;
            }
            if (string2.startsWith("M")) {
                string9 = string15;
                continue;
            }
            if (string2.startsWith("O")) {
                string11 = string15;
                continue;
            }
            if (string2.startsWith("L")) {
                string12 = string15;
                continue;
            }
            if (string2.startsWith("$") || string2.startsWith("T")) {
                string13 = string15;
                continue;
            }
            System.err.println("Unknown INVST transaction identifier: " + string2);
        }
        return string2;
    }

    public Account getAccountForCategory(String string, long l) {
        Account account;
        String string2 = null;
        int n = l <= 0L ? 4 : 5;
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1).trim();
            string = string.substring(0, n2).trim();
        }
        if ((account = this.rootAccount.getAccountByName(string, n)) != null) {
            // empty if block
        }
        if (account == null) {
            account = this.rootAccount.getAccountByName(string);
        }
        if (account == null) {
            if (n == 4) {
                account = new ExpenseAccount(string, -1, this.currency.getID(), null, null, this.rootAccount);
            } else if (n == 5) {
                account = new IncomeAccount(string, -1, this.currency.getID(), null, null, this.rootAccount);
            } else if (n == 1) {
                account = new BankAccount(string, -1, this.currency.getID(), null, null, this.rootAccount);
            }
            this.rootAccount.addSubAccount(account);
        }
        n = account.getAccountType();
        if (string2 == null) {
            return account;
        }
        Account account2 = account.getAccountByName(string2, n);
        if (account2 == null) {
            if (n == 4) {
                account2 = new ExpenseAccount(string2, -1, this.currency.getID(), null, null, account);
            } else if (n == 5) {
                account2 = new IncomeAccount(string2, -1, this.currency.getID(), null, null, account);
            } else if (n == 1) {
                account2 = new BankAccount(string2, -1, this.currency.getID(), null, null, account);
            }
            account.addSubAccount(account2);
        }
        return account2;
    }

    private final String getValueForKey(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string2.startsWith(string)) {
                stringBuffer.append("\n");
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String readUpToSectionStart(DataInputStream dataInputStream) throws Exception {
        String string = "";
        while (string != null) {
            string = dataInputStream.readLine();
            if (string == null) {
                return null;
            }
            if (!string.startsWith("!")) continue;
            return string;
        }
        return string;
    }

    public QIFDataReader(RootAccount rootAccount, File file, CurrencyType currencyType) {
        this(rootAccount, file, currencyType, null);
    }

    public QIFDataReader(RootAccount rootAccount, File file, CurrencyType currencyType, Account account) {
        this.qifFile = file;
        this.rootAccount = rootAccount;
        this.currency = currencyType;
        this.currencyTable = rootAccount.getCurrencyTable();
        this.accountToImportTo = account;
        this.transferAccounts = new Hashtable();
    }
}

