/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model.io;

import com.seanreilly.apps.moneydance.controller.StatusMonitor;
import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankAccount;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.BasicReminder;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.apps.moneydance.model.ExpenseAccount;
import com.seanreilly.apps.moneydance.model.IncomeAccount;
import com.seanreilly.apps.moneydance.model.InvestmentAccount;
import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionReminder;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import com.seanreilly.apps.moneydance.model.io.DataReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.Hashtable;

public class MDV4DataReader
implements DataReader {
    private static final int VERSION = 4;
    private static final int BANK_TRANSACTION_TYPE = 0;
    private DataInputStream inputStream;

    public RootAccount readAccountsFromFile(StatusMonitor statusMonitor) throws Exception {
        statusMonitor.setStatus("Reading account info...");
        CurrencyTable currencyTable = this.readCurrencies(this.inputStream);
        RootAccount rootAccount = (RootAccount)this.readAccount(null, this.inputStream, currencyTable);
        statusMonitor.setStatus("Reading transaction info...");
        this.readTransactions(rootAccount, this.inputStream);
        this.readReminders(rootAccount, this.inputStream);
        return rootAccount;
    }

    private final CurrencyTable readCurrencies(DataInputStream dataInputStream) throws Exception {
        long l = dataInputStream.readLong();
        CurrencyTable currencyTable = new CurrencyTable();
        int n = 0;
        while ((long)n < l) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            double d = dataInputStream.readDouble();
            int n2 = dataInputStream.readInt();
            String string3 = dataInputStream.readUTF();
            String string4 = dataInputStream.readUTF();
            String string5 = dataInputStream.readUTF();
            CurrencyType currencyType = new CurrencyType(string, string2, d, n2, string3, string4, string5);
            if (n == 0) {
                currencyTable.setBaseType(currencyType);
            } else {
                currencyTable.addCurrencyType(currencyType);
            }
            ++n;
        }
        return currencyTable;
    }

    private final Account readAccount(Account account, DataInputStream dataInputStream, CurrencyTable currencyTable) throws Exception {
        char c = dataInputStream.readChar();
        String string = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        String string2 = dataInputStream.readUTF();
        int n2 = dataInputStream.readInt();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n3 = 0;
        while (n3 < n2) {
            String string3 = dataInputStream.readUTF();
            String string4 = dataInputStream.readUTF();
            hashtable.put(string3, string4);
            ++n3;
        }
        Account account2 = null;
        if (c == 'r') {
            account2 = new RootAccount(string, string2, currencyTable, hashtable);
        } else if (c == 'b') {
            account2 = new BankAccount(string, n, string2, hashtable, null, account);
        } else if (c == 'e') {
            account2 = new ExpenseAccount(string, n, string2, hashtable, null, account);
        } else if (c == 'i') {
            account2 = new IncomeAccount(string, n, string2, hashtable, null, account);
        } else if (c == 'v') {
            account2 = new InvestmentAccount(string, n, string2, hashtable, null, account);
        } else {
            throw new Exception("Invalid account type: " + c);
        }
        int n4 = dataInputStream.readInt();
        int n5 = 0;
        while (n5 < n4) {
            account2.addSubAccount(this.readAccount(account2, dataInputStream, currencyTable));
            ++n5;
        }
        return account2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readReminders(RootAccount rootAccount, DataInputStream dataInputStream) throws Exception {
        long l = 0L;
        try {
            l = dataInputStream.readLong();
        }
        catch (EOFException eOFException) {
        }
        ReminderSet reminderSet = rootAccount.getReminderSet();
        long l2 = 0L;
        while (l2 < l) {
            reminderSet.addReminder(this.readReminder(dataInputStream));
            ++l2;
        }
    }

    private final Reminder readReminder(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        long l = dataInputStream.readLong();
        String string = dataInputStream.readUTF();
        long l2 = dataInputStream.readLong();
        long l3 = dataInputStream.readLong();
        long l4 = dataInputStream.readLong();
        int[] nArray = new int[dataInputStream.readInt()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = dataInputStream.readInt();
            ++n2;
        }
        n2 = dataInputStream.readInt();
        int[] nArray2 = new int[dataInputStream.readInt()];
        int n3 = 0;
        while (n3 < nArray2.length) {
            nArray2[n3] = dataInputStream.readInt();
            ++n3;
        }
        n3 = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        if (n == 0) {
            return new TransactionReminder(l, string, l2, l3, l4, nArray, n2, nArray2, n3, bl, (BankTransaction)this.readTransaction(dataInputStream));
        }
        if (n == 1) {
            return new BasicReminder(l, string, l2, l3, l4, nArray, n2, nArray2, n3, bl, dataInputStream.readUTF());
        }
        throw new Exception("Invalid reminder type: " + n);
    }

    private final void readTransactions(RootAccount rootAccount, DataInputStream dataInputStream) throws Exception {
        long l = dataInputStream.readLong();
        TransactionSet transactionSet = rootAccount.getTransactionSet();
        long l2 = 0L;
        while (l2 < l) {
            Transaction transaction = this.readTransaction(dataInputStream);
            if (transaction != null) {
                transactionSet.addTransaction(transaction);
            }
            ++l2;
        }
    }

    private final Transaction readTransaction(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return this.readBankTransaction(dataInputStream);
        }
        if (n == 1) {
            return null;
        }
        throw new Exception("Invalid transaction type: " + n);
    }

    private final BankTransaction readBankTransaction(DataInputStream dataInputStream) throws Exception {
        long l = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        char c = dataInputStream.readChar();
        char c2 = dataInputStream.readChar();
        long l2 = dataInputStream.readLong();
        long l3 = dataInputStream.readLong();
        long l4 = dataInputStream.readLong();
        long l5 = dataInputStream.readLong();
        String string2 = dataInputStream.readUTF();
        String string3 = dataInputStream.readUTF();
        double d = dataInputStream.readDouble();
        BankTransaction bankTransaction = new BankTransaction(l, n, n2, d, string, l2, l3, l4, l5, c, c2, string2, null, string3);
        int n3 = dataInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            this.readSplit(dataInputStream, bankTransaction);
            ++n4;
        }
        return bankTransaction;
    }

    private final void readSplit(DataInputStream dataInputStream, BankTransaction bankTransaction) throws Exception {
        long l = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        double d = dataInputStream.readDouble();
        String string = dataInputStream.readUTF();
        long l2 = dataInputStream.readLong();
        char c = dataInputStream.readChar();
        bankTransaction.addSplit(new SplitTransaction(l, n, d, string, l2, bankTransaction.getDate(), c, bankTransaction));
    }

    public MDV4DataReader(DataInputStream dataInputStream) {
        this.inputStream = dataInputStream;
    }
}

