/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.BankTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;
import com.seanreilly.apps.moneydance.model.TransactionListener;
import java.util.Enumeration;
import java.util.Vector;

public class TransactionSet {
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$BankTransaction;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction;
    private Vector listeners;
    private Vector transactions = new Vector();
    private boolean dirty = false;

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirtyFlags() {
        this.dirty = false;
    }

    public synchronized void addTransaction(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        if (transaction.id < 0L) {
            this.addNewTransaction(transaction);
        } else {
            this.transactions.addElement(transaction);
            this.notifyTransactionAdded(transaction);
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionSet.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
                BankTransaction bankTransaction = (BankTransaction)transaction;
                int n = 0;
                while (n < bankTransaction.getSplitCount()) {
                    this.addTransaction(bankTransaction.getSplit(n));
                    ++n;
                }
            }
        }
        this.dirty = true;
    }

    public synchronized void addNewTransaction(Transaction transaction) {
        long l = 1L;
        Enumeration enumeration = this.transactions.elements();
        while (enumeration.hasMoreElements()) {
            long l2 = ((Transaction)enumeration.nextElement()).getId();
            if (l2 <= l) continue;
            l = l2;
        }
        transaction.id = l + 1L;
        this.addTransaction(transaction);
    }

    public synchronized void removeTransaction(Transaction transaction) {
        this.dirty = true;
        this.transactions.removeElement(transaction);
        this.notifyTransactionRemoved(transaction);
        if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionSet.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
            BankTransaction bankTransaction = (BankTransaction)transaction;
            int n = 0;
            while (n < bankTransaction.getSplitCount()) {
                this.removeTransaction(bankTransaction.getSplit(n));
                ++n;
            }
        }
    }

    public void transactionModified(Transaction transaction) {
        this.dirty = true;
        if (transaction.id < 0L) {
            this.addNewTransaction(transaction);
        } else {
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$BankTransaction : (class$Lcom$seanreilly$apps$moneydance$model$BankTransaction = TransactionSet.class$("com.seanreilly.apps.moneydance.model.BankTransaction")))) {
                BankTransaction bankTransaction = (BankTransaction)transaction;
                int n = 0;
                while (n < bankTransaction.getSplitCount()) {
                    this.transactionModified(bankTransaction.getSplit(n));
                    ++n;
                }
            }
            this.notifyTransactionModified(transaction);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyTransactionAdded(Transaction transaction) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((TransactionListener)enumeration.nextElement()).transactionAdded(transaction);
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyTransactionModified(Transaction transaction) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((TransactionListener)enumeration.nextElement()).transactionModified(transaction);
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyTransactionRemoved(Transaction transaction) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((TransactionListener)enumeration.nextElement()).transactionRemoved(transaction);
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this.listeners.addElement(transactionListener);
    }

    public void removeTransactionListener(TransactionListener transactionListener) {
        this.listeners.removeElement(transactionListener);
    }

    public Enumeration getAllTransactions() {
        return this.transactions.elements();
    }

    public long getTransactionCount() {
        return this.transactions.size();
    }

    public Vector getTransactionsForAccount(Account account) {
        int n = account.getAccountNum();
        if (n < 0) {
            return new Vector();
        }
        Vector<Transaction> vector = new Vector<Transaction>();
        Enumeration enumeration = this.getAllTransactions();
        while (enumeration.hasMoreElements()) {
            Transaction transaction = (Transaction)enumeration.nextElement();
            if (transaction.getClass() == (class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction != null ? class$Lcom$seanreilly$apps$moneydance$model$SplitTransaction : TransactionSet.class$("com.seanreilly.apps.moneydance.model.SplitTransaction"))) {
                if (transaction.getSourceAccountId() != n) continue;
                vector.addElement(transaction);
                continue;
            }
            if (transaction.getSourceAccountId() != n && transaction.getDestAccountId() != n) continue;
            vector.addElement(transaction);
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TransactionSet() {
        this.listeners = new Vector();
    }
}

