/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.Account;
import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.CurrencyTable;
import com.seanreilly.apps.moneydance.model.ReminderSet;
import com.seanreilly.apps.moneydance.model.TransactionSet;
import java.util.Hashtable;

public class RootAccount
extends Account
implements AccountListener {
    private TransactionSet transactionSet = new TransactionSet();
    private ReminderSet reminderSet = new ReminderSet();
    private Hashtable accountRegistry = new Hashtable();
    private CurrencyTable currencyTable;

    public CurrencyTable getCurrencyTable() {
        return this.currencyTable;
    }

    public boolean isUnsavedData() {
        return super.isDirty() || this.currencyTable.isDirty() || this.transactionSet.isDirty() || this.reminderSet.isDirty();
    }

    public TransactionSet getTransactionSet() {
        return this.transactionSet;
    }

    public ReminderSet getReminderSet() {
        return this.reminderSet;
    }

    public String getFullAccountName() {
        return "";
    }

    synchronized void registerAccount(Account account) {
        this.accountRegistry.put(new Integer(account.getAccountNum()), account);
        account.addAccountListener(this);
    }

    synchronized void deregisterAccount(Account account) {
        this.accountRegistry.remove(new Integer(account.getAccountNum()));
        account.removeAccountListener(this);
    }

    public Account getAccountById(int n) {
        return (Account)this.accountRegistry.get(new Integer(n));
    }

    public synchronized void resetDirtyFlags() {
        super.resetDirtyFlags();
        this.reminderSet.resetDirtyFlags();
        this.transactionSet.resetDirtyFlags();
        this.currencyTable.resetDirtyFlags();
    }

    public void accountModified(Account account) {
        this.notifyAccountModified(account);
    }

    public RootAccount(String string, CurrencyTable currencyTable) {
        this(string, currencyTable, new Hashtable());
    }

    public RootAccount(String string, CurrencyTable currencyTable, Hashtable hashtable) {
        this("Root Account", string, currencyTable, hashtable);
    }

    public RootAccount(String string, String string2, CurrencyTable currencyTable, Hashtable hashtable) {
        super(string, 0, 0, string2, hashtable, null, null);
        this.currencyTable = currencyTable;
    }
}

