/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.DateReminderPair;
import com.seanreilly.apps.moneydance.model.Reminder;
import com.seanreilly.apps.moneydance.model.ReminderListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ReminderSet {
    private Vector listeners;
    private Vector reminders = new Vector();
    private boolean dirty = false;

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirtyFlags() {
        this.dirty = false;
    }

    public synchronized void addReminder(Reminder reminder) {
        if (reminder == null) {
            return;
        }
        if (reminder.getId() < 0L) {
            this.addNewReminder(reminder);
        } else {
            this.reminders.addElement(reminder);
            this.notifyReminderAdded(reminder);
        }
        this.dirty = true;
    }

    public synchronized void addNewReminder(Reminder reminder) {
        long l = 1L;
        Enumeration enumeration = this.reminders.elements();
        while (enumeration.hasMoreElements()) {
            long l2 = ((Reminder)enumeration.nextElement()).getId();
            if (l2 <= l) continue;
            l = l2;
        }
        reminder.setId(l + 1L);
        this.addReminder(reminder);
    }

    public synchronized void removeReminder(Reminder reminder) {
        this.dirty = true;
        this.reminders.removeElement(reminder);
        this.notifyReminderRemoved(reminder);
    }

    public void reminderModified(Reminder reminder) {
        this.dirty = true;
        if (reminder.getId() < 0L) {
            this.addNewReminder(reminder);
        } else {
            this.notifyReminderModified(reminder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyReminderAdded(Reminder reminder) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((ReminderListener)enumeration.nextElement()).reminderAdded(reminder);
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyReminderModified(Reminder reminder) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((ReminderListener)enumeration.nextElement()).reminderModified(reminder);
            }
            catch (Throwable throwable) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void notifyReminderRemoved(Reminder reminder) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((ReminderListener)enumeration.nextElement()).reminderRemoved(reminder);
            }
            catch (Throwable throwable) {
            }
        }
    }

    public Vector getRemindersOnDay(Calendar calendar) {
        Vector<Reminder> vector = new Vector<Reminder>();
        Enumeration enumeration = this.getAllReminders();
        while (enumeration.hasMoreElements()) {
            Reminder reminder = (Reminder)enumeration.nextElement();
            if (!reminder.occursOnDate(calendar) || reminder.hasBeenAcknowledged(calendar.getTime())) continue;
            vector.addElement(reminder);
        }
        return vector;
    }

    public Vector getOverdueItems(Calendar calendar) {
        Vector<DateReminderPair> vector = new Vector<DateReminderPair>();
        Enumeration enumeration = this.getAllReminders();
        while (enumeration.hasMoreElements()) {
            Reminder reminder = (Reminder)enumeration.nextElement();
            Enumeration enumeration2 = reminder.getPastDueDates(calendar).elements();
            while (enumeration2.hasMoreElements()) {
                Date date = (Date)enumeration2.nextElement();
                vector.addElement(new DateReminderPair(date, reminder));
            }
        }
        ReminderSet.sortDateReminders(vector);
        return vector;
    }

    public void addReminderListener(ReminderListener reminderListener) {
        this.listeners.addElement(reminderListener);
    }

    public void removeReminderListener(ReminderListener reminderListener) {
        this.listeners.removeElement(reminderListener);
    }

    public Enumeration getAllReminders() {
        return this.reminders.elements();
    }

    public long getReminderCount() {
        return this.reminders.size();
    }

    public static void sortDateReminders(Vector vector) {
        ReminderSet.quicksortDateReminders(vector, 0, vector.size() - 1);
    }

    private static final void quicksortDateReminders(Vector vector, int n, int n2) {
        if (n < n2) {
            int n3 = ReminderSet.partitionDateReminders(vector, n, n2);
            ReminderSet.quicksortDateReminders(vector, n, n3 - 1);
            ReminderSet.quicksortDateReminders(vector, n3, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final int partitionDateReminders(Vector var0, int var1_1, int var2_2) {
        var3_3 = (DateReminderPair)var0.elementAt((var1_1 + var2_2) / 2);
        ** GOTO lbl15
        {
            ++var1_1;
            do {
                if (((DateReminderPair)var0.elementAt((int)var1_1)).date.getTime() < var3_3.date.getTime() || ((DateReminderPair)var0.elementAt((int)var1_1)).date.getTime() == var3_3.date.getTime() && ((DateReminderPair)var0.elementAt((int)var1_1)).reminder.getDescription().compareTo(var3_3.reminder.getDescription()) < 0) continue block0;
                while (((DateReminderPair)var0.elementAt((int)var2_2)).date.getTime() > var3_3.date.getTime() || ((DateReminderPair)var0.elementAt((int)var2_2)).date.getTime() == var3_3.date.getTime() && ((DateReminderPair)var0.elementAt((int)var2_2)).reminder.getDescription().compareTo(var3_3.reminder.getDescription()) > 0) {
                    --var2_2;
                }
                if (var1_1 > var2_2) continue;
                var4_4 = (DateReminderPair)var0.elementAt(var1_1);
                var0.setElementAt(var0.elementAt(var2_2), var1_1);
                var0.setElementAt(var4_4, var2_2);
                ++var1_1;
                --var2_2;
lbl15:
                // 3 sources

            } while (var1_1 <= var2_2);
        }
        return var1_1;
    }

    public Vector getEventsInDay(Calendar calendar) {
        Vector<Reminder> vector = new Vector<Reminder>();
        Enumeration enumeration = this.getAllReminders();
        while (enumeration.hasMoreElements()) {
            Reminder reminder = (Reminder)enumeration.nextElement();
            if (!reminder.occursOnDate(calendar)) continue;
            vector.addElement(reminder);
        }
        return vector;
    }

    public ReminderSet() {
        this.listeners = new Vector();
    }
}

