/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public abstract class Reminder {
    public static final int TXN_REMINDER_TYPE = 0;
    public static final int BASIC_REMINDER_TYPE = 1;
    public static final int REPEAT_BY_NONE = 0;
    public static final int REPEAT_BY_DAY_OF_WEEK = 1;
    public static final int REPEAT_BY_DAY_OF_MONTH = 2;
    public static final int REPEAT_BY_NDAYS = 3;
    public static final int REPEAT_BY_EVERY_YEAR = 4;
    public static final int WEEKLY_EVERY = 0;
    public static final int WEEKLY_EVERY_FIRST = 1;
    public static final int WEEKLY_EVERY_SECOND = 2;
    public static final int WEEKLY_EVERY_THIRD = 3;
    public static final int WEEKLY_EVERY_FOURTH = 4;
    public static final int WEEKLY_EVERY_FIFTH = 5;
    public static final int WEEKLY_EVERY_LAST = 6;
    public static final int LAST_DAY_OF_MONTH = 32;
    private long id;
    private boolean dirty = false;
    private String description;
    private long initialDate;
    private long dateAcknowledged;
    private Calendar initialDateC;
    private long lastDate = 0L;
    private int[] daysOfWeek = null;
    private int daysOfWeekModifier = 0;
    private int[] daysOfMonth = null;
    private int everyNDays = 0;
    private boolean everyYear = false;

    public abstract int getReminderType();

    public void resetDirty() {
        this.dirty = false;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getId() {
        return this.id;
    }

    public synchronized void setId(long l) {
        if (this.id != l) {
            this.dirty = true;
        }
        this.id = l;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String string) {
        if (!string.equals(this.description)) {
            this.dirty = true;
        }
        this.description = string;
    }

    public long getInitialDate() {
        return this.initialDate;
    }

    public synchronized void setInitialDate(long l) {
        if (this.initialDate != l) {
            this.dirty = true;
        }
        this.initialDate = l;
        this.initialDateC.setTime(new Date(this.initialDate));
    }

    public long getLastDate() {
        return this.lastDate;
    }

    public synchronized void setLastDate(long l) {
        if (this.lastDate != l) {
            this.dirty = true;
        }
        this.lastDate = l;
    }

    public long getDateAcknowledged() {
        return this.dateAcknowledged;
    }

    public synchronized void setAcknowledged(Date date) {
        this.dirty = true;
        this.dateAcknowledged = date.getTime();
    }

    public int getRepeatWeeklyModifier() {
        return this.daysOfWeekModifier;
    }

    public int[] getRepeatWeeklyDays() {
        return this.daysOfWeek;
    }

    public synchronized void setRepeatWeekly(int n, int[] nArray) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Invalid weekly repetition: " + n);
        }
        if (!Reminder.equalIntArrays(nArray, this.daysOfWeek) || n != this.daysOfWeekModifier) {
            this.dirty = true;
        }
        this.daysOfWeekModifier = n;
        if (nArray == null) {
            this.daysOfWeek = null;
        } else {
            this.daysOfWeek = new int[nArray.length];
            System.arraycopy(nArray, 0, this.daysOfWeek, 0, nArray.length);
        }
    }

    public int[] getRepeatMonthly() {
        return this.daysOfMonth;
    }

    public synchronized void setRepeatMonthly(int[] nArray) {
        if (!Reminder.equalIntArrays(nArray, this.daysOfMonth)) {
            this.dirty = true;
        }
        if (nArray == null) {
            this.daysOfMonth = null;
        } else {
            this.daysOfMonth = new int[nArray.length];
            System.arraycopy(nArray, 0, this.daysOfMonth, 0, nArray.length);
        }
    }

    public int getRepeatDaily() {
        return this.everyNDays;
    }

    public synchronized void setRepeatDaily(int n) {
        if (this.everyNDays != n) {
            this.dirty = true;
        }
        this.everyNDays = n;
    }

    public boolean getRepeatYearly() {
        return this.everyYear;
    }

    public synchronized void setRepeatYearly(boolean bl) {
        if (bl != this.everyYear) {
            this.dirty = true;
        }
        this.everyYear = bl;
    }

    public Vector getPastDueDates(Calendar calendar) {
        long l = calendar.getTime().getTime() / 86400000L;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date(Math.max(this.dateAcknowledged + 86400000L, this.initialDate)));
        long l2 = calendar2.getTime().getTime() / 86400000L;
        Vector<Date> vector = new Vector<Date>();
        while (l2 < l && vector.size() < 20) {
            if (this.occursOnDate(calendar2)) {
                vector.addElement(calendar2.getTime());
            }
            calendar2.add(5, 1);
            l2 = calendar2.getTime().getTime() / 86400000L;
        }
        return vector;
    }

    public boolean hasBeenAcknowledged(Date date) {
        return date.getTime() / 86400000L <= this.dateAcknowledged / 86400000L;
    }

    public boolean occursOnDate(Calendar calendar) {
        block27: {
            int n;
            int n2;
            int n3;
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    int n4;
                                    int n5 = calendar.get(1);
                                    int n6 = calendar.get(2);
                                    n3 = calendar.get(5);
                                    n2 = calendar.get(7);
                                    long l = calendar.getTime().getTime() / 86400000L;
                                    int n7 = this.initialDateC.get(1);
                                    int n8 = this.initialDateC.get(2);
                                    int n9 = this.initialDateC.get(5);
                                    int n10 = this.initialDateC.get(7);
                                    long l2 = this.initialDateC.getTime().getTime() / 86400000L;
                                    if (l < l2) {
                                        return false;
                                    }
                                    if (l == l2) {
                                        return true;
                                    }
                                    if (this.lastDate > 0L) {
                                        Calendar calendar2 = Calendar.getInstance();
                                        calendar2.setTime(new Date(this.lastDate));
                                        n4 = calendar2.get(1);
                                        n = calendar2.get(2);
                                        int n11 = calendar2.get(5);
                                        if (n5 * 10000 + n6 * 100 + n3 > n4 * 10000 + n * 100 + n11) {
                                            return false;
                                        }
                                    }
                                    if (this.daysOfMonth != null) {
                                        int n12 = 0;
                                        while (n12 < this.daysOfMonth.length) {
                                            if (this.daysOfMonth[n12] == n3) {
                                                return true;
                                            }
                                            if (this.daysOfMonth[n12] == 32 && n3 >= 27) {
                                                n4 = n3;
                                                Date date = calendar.getTime();
                                                do {
                                                    n4 = calendar.get(5);
                                                    calendar.roll(5, true);
                                                } while (calendar.get(5) > n4);
                                                calendar.setTime(date);
                                                if (n4 == n3) {
                                                    return true;
                                                }
                                            }
                                            ++n12;
                                        }
                                    }
                                    if (this.everyYear && n6 == n8 && n3 == n9) {
                                        return true;
                                    }
                                    if (this.everyNDays != 0 && (l2 - l) % (long)this.everyNDays == 0L) {
                                        return true;
                                    }
                                    if (this.daysOfWeek == null) break block27;
                                    if (this.daysOfWeekModifier != 0) break block28;
                                    int n13 = 0;
                                    while (n13 < this.daysOfWeek.length) {
                                        if (n2 == this.daysOfWeek[n13]) {
                                            return true;
                                        }
                                        ++n13;
                                    }
                                    break block27;
                                }
                                if (this.daysOfWeekModifier != 1) break block29;
                                int n14 = 0;
                                while (n14 < this.daysOfWeek.length) {
                                    if (n2 == this.daysOfWeek[n14] && n3 < 8) {
                                        return true;
                                    }
                                    ++n14;
                                }
                                break block27;
                            }
                            if (this.daysOfWeekModifier != 2) break block30;
                            int n15 = 0;
                            while (n15 < this.daysOfWeek.length) {
                                if (n2 == this.daysOfWeek[n15] && n3 >= 8 && n3 < 15) {
                                    return true;
                                }
                                ++n15;
                            }
                            break block27;
                        }
                        if (this.daysOfWeekModifier != 3) break block31;
                        int n16 = 0;
                        while (n16 < this.daysOfWeek.length) {
                            if (n2 == this.daysOfWeek[n16] && n3 >= 15 && n3 < 22) {
                                return true;
                            }
                            ++n16;
                        }
                        break block27;
                    }
                    if (this.daysOfWeekModifier != 4) break block32;
                    int n17 = 0;
                    while (n17 < this.daysOfWeek.length) {
                        if (n2 == this.daysOfWeek[n17] && n3 >= 22 && n3 < 29) {
                            return true;
                        }
                        ++n17;
                    }
                    break block27;
                }
                if (this.daysOfWeekModifier != 5) break block33;
                int n18 = 0;
                while (n18 < this.daysOfWeek.length) {
                    if (n2 == this.daysOfWeek[n18] && n3 >= 29 && n3 < 36) {
                        return true;
                    }
                    ++n18;
                }
                break block27;
            }
            if (this.daysOfWeekModifier != 6) break block27;
            int n19 = n3;
            Date date = calendar.getTime();
            do {
                n19 = calendar.get(5);
                calendar.roll(5, true);
            } while (calendar.get(5) > n19);
            calendar.setTime(date);
            n = 0;
            while (n < this.daysOfWeek.length) {
                if (n2 == this.daysOfWeek[n] && n19 - n3 < 7) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static final boolean equalIntArrays(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 != null) {
            return false;
        }
        if (nArray != null && nArray2 == null) {
            return false;
        }
        if (nArray == null && nArray2 == null) {
            return true;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        return this.description.trim().length() <= 0 ? "<null>" : this.description;
    }

    public Reminder(long l, String string, long l2, long l3, long l4, int[] nArray, int n, int[] nArray2, int n2, boolean bl) {
        this.id = l;
        this.description = string;
        this.initialDate = l2;
        this.lastDate = l4;
        this.daysOfWeek = nArray;
        this.daysOfWeekModifier = n;
        this.daysOfMonth = nArray2;
        this.everyNDays = n2;
        this.everyYear = bl;
        this.dateAcknowledged = l3;
        this.initialDateC = Calendar.getInstance();
        this.initialDateC.setTime(new Date(l2));
    }
}

