/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.CurrencyListener;
import com.seanreilly.apps.moneydance.model.CurrencyType;
import com.seanreilly.util.StringUtils;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CurrencyTable {
    private static String defaultExchangeRateFileName = "com/seanreilly/apps/moneydance/model/exchange_rates";
    private CurrencyType baseType;
    private Hashtable currencyTable = new Hashtable();
    private boolean dirty = false;
    private Vector listeners = new Vector();

    public void addCurrencyListener(CurrencyListener currencyListener) {
        this.listeners.addElement(currencyListener);
    }

    public void removeCurrencyListener(CurrencyListener currencyListener) {
        this.listeners.removeElement(currencyListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fireCurrencyTableModified() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((CurrencyListener)enumeration.nextElement()).currencyTableModified(this);
            }
            catch (Exception exception) {
                System.err.println("Exception during exception dispatching: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public CurrencyType getBaseType() {
        return this.baseType;
    }

    public synchronized void setBaseType(CurrencyType currencyType) {
        Enumeration enumeration = this.currencyTable.elements();
        while (enumeration.hasMoreElements()) {
            CurrencyType currencyType2 = (CurrencyType)enumeration.nextElement();
            if (currencyType2.getID().equals(currencyType.getID())) continue;
            currencyType2.convertToNewBase(currencyType);
        }
        currencyType.setXRelativeRate(1.0, currencyType);
        this.currencyTable.put(currencyType.getID(), currencyType);
        this.baseType = currencyType;
        this.dirty = true;
    }

    public CurrencyType getCurrencyType(String string) {
        return (CurrencyType)this.currencyTable.get(string);
    }

    public void addCurrencyType(CurrencyType currencyType) {
        this.currencyTable.put(currencyType.getID(), currencyType);
        this.dirty = true;
        this.fireCurrencyTableModified();
    }

    public long getCurrencyCount() {
        return this.currencyTable.size();
    }

    public synchronized void resetDirtyFlags() {
        this.dirty = false;
        Enumeration enumeration = this.currencyTable.elements();
        while (enumeration.hasMoreElements()) {
            ((CurrencyType)enumeration.nextElement()).resetDirtyFlags();
        }
    }

    public CurrencyType getType(String string) {
        return (CurrencyType)this.currencyTable.get(string);
    }

    public double getRate(CurrencyType currencyType, CurrencyType currencyType2) {
        return currencyType2.getRawRate() / currencyType.getRawRate();
    }

    public static long convertValue(long l, CurrencyType currencyType, CurrencyType currencyType2, double d) {
        int n = currencyType.getDecimalPlaces();
        int n2 = currencyType2.getDecimalPlaces();
        return Math.round((double)l * d * Math.pow(10.0, n2 - n));
    }

    public long convertValue(long l, CurrencyType currencyType, CurrencyType currencyType2) {
        if (currencyType == currencyType2) {
            return l;
        }
        long l2 = currencyType == this.baseType ? l : currencyType.invertValue(l);
        if (currencyType2 == this.baseType) {
            return l2;
        }
        return currencyType2.convertValue(l2);
    }

    public Enumeration getAllValues() {
        return this.currencyTable.elements();
    }

    public synchronized boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        Enumeration enumeration = this.currencyTable.elements();
        while (enumeration.hasMoreElements()) {
            if (!((CurrencyType)enumeration.nextElement()).isDirty()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CurrencyTable createDefaultTable(String string) {
        CurrencyTable currencyTable = new CurrencyTable();
        try {
            DataInputStream dataInputStream = new DataInputStream(ClassLoader.getSystemResourceAsStream(defaultExchangeRateFileName));
            CurrencyType currencyType = null;
            while (true) {
                Object object;
                if ((object = dataInputStream.readLine()) == null) {
                    if (string == null) return currencyTable;
                    object = currencyTable.getCurrencyType(string);
                    if (object == null) return currencyTable;
                    currencyTable.setBaseType((CurrencyType)object);
                    return currencyTable;
                }
                if (((String)object).startsWith("#") || ((String)(object = ((String)object).trim())).length() < 3) continue;
                try {
                    String string2 = StringUtils.fieldIndex((String)object, ',', 0);
                    String string3 = StringUtils.fieldIndex((String)object, ',', 1);
                    double d = Double.valueOf(StringUtils.fieldIndex((String)object, ',', 3));
                    int n = Integer.parseInt(StringUtils.fieldIndex((String)object, ',', 4));
                    String string4 = StringUtils.fieldIndex((String)object, ',', 5);
                    String string5 = StringUtils.fieldIndex((String)object, ',', 6);
                    CurrencyType currencyType2 = new CurrencyType(string3, string2, d, n, string4, string5, "");
                    if (currencyType == null) {
                        currencyTable.setBaseType(currencyType2);
                        currencyType = currencyType2;
                    }
                    currencyType2.setXRelativeRate(d, currencyType);
                    currencyTable.addCurrencyType(currencyType2);
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error reading default currency table: " + exception);
        }
        return currencyTable;
    }
}

