/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.SplitTransaction;
import com.seanreilly.apps.moneydance.model.Transaction;

public class BankTransaction
extends Transaction {
    protected String checkNumber;
    protected String memo;
    protected long taxableDate;
    protected SplitTransaction[] splits;

    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String string) {
        if (!this.checkNumber.equals(string)) {
            this.dirty = true;
        }
        this.checkNumber = string;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String string) {
        if (!this.memo.equals(string)) {
            this.dirty = true;
        }
        this.memo = string;
    }

    public long getTaxableDate() {
        return this.taxableDate;
    }

    public synchronized void setTaxableDate(long l) {
        if (this.taxableDate != l) {
            this.dirty = true;
        }
        this.taxableDate = l;
    }

    public int getSplitCount() {
        return this.splits == null ? 0 : this.splits.length;
    }

    public synchronized SplitTransaction getSplitById(long l) {
        int n = 0;
        while (n < this.splits.length) {
            if (this.splits[n].getId() == l) {
                return this.splits[n];
            }
            ++n;
        }
        return null;
    }

    public synchronized SplitTransaction getSplit(int n) {
        return this.splits[n];
    }

    public synchronized void addSplit(SplitTransaction splitTransaction) {
        splitTransaction.setParent(this);
        if (this.splits == null) {
            this.splits = new SplitTransaction[1];
            this.splits[0] = splitTransaction;
        } else {
            SplitTransaction[] splitTransactionArray = new SplitTransaction[this.splits.length + 1];
            System.arraycopy(this.splits, 0, splitTransactionArray, 0, this.splits.length);
            splitTransactionArray[this.splits.length] = splitTransaction;
            this.splits = splitTransactionArray;
        }
        this.dirty = true;
    }

    public synchronized void removeSplit(int n) {
        if (this.splits != null && this.splits.length > n) {
            this.splits[n].setParent(null);
            if (this.splits.length == 1) {
                this.splits = null;
                return;
            }
            SplitTransaction[] splitTransactionArray = new SplitTransaction[this.splits.length - 1];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.splits.length) {
                if (n3 != n) {
                    splitTransactionArray[n2++] = this.splits[n3];
                }
                ++n3;
            }
            this.splits = splitTransactionArray;
            this.dirty = true;
        }
    }

    public void takeValuesFrom(Transaction transaction) {
        super.takeValuesFrom(transaction);
        this.splits = null;
        if (transaction instanceof BankTransaction) {
            BankTransaction bankTransaction = (BankTransaction)transaction;
            int n = 0;
            while (n < bankTransaction.getSplitCount()) {
                this.addSplit(bankTransaction.getSplit(n));
                ++n;
            }
        }
    }

    public BankTransaction(long l, int n, int n2, double d, String string, long l2, long l3, long l4, long l5, char c, char c2, String string2, SplitTransaction[] splitTransactionArray, String string3) {
        super(l, n, n2, d, string, l2, l3, l4, c, c2);
        this.checkNumber = string2;
        this.memo = string3;
        this.taxableDate = l5;
        this.splits = splitTransactionArray;
    }

    public BankTransaction(long l, int n, int n2, String string, long l2, long l3, long l4, long l5, char c, char c2, String string2, SplitTransaction[] splitTransactionArray, String string3) {
        this(l, n, n2, 1.0, string, l2, l3, l4, l5, c, c2, string2, splitTransactionArray, string3);
    }
}

