/*
 * Decompiled with CFR 0.152.
 */
package com.seanreilly.apps.moneydance.model;

import com.seanreilly.apps.moneydance.model.AccountListener;
import com.seanreilly.apps.moneydance.model.RootAccount;
import com.seanreilly.apps.moneydance.model.Transaction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Account {
    public static final int SPLIT_ACCOUNT_ID = -1;
    public static final int ACCOUNT_TYPE_ROOT = 0;
    public static final int ACCOUNT_TYPE_BANK = 1;
    public static final int ACCOUNT_TYPE_INVESTMENT = 2;
    public static final int ACCOUNT_TYPE_CREDIT_CARD = 3;
    public static final int ACCOUNT_TYPE_EXPENSE = 4;
    public static final int ACCOUNT_TYPE_INCOME = 5;
    private static /* synthetic */ Class class$Lcom$seanreilly$apps$moneydance$model$RootAccount;
    private String accountName = null;
    private int accountNum = -1;
    private int accountType = 0;
    private Hashtable parameters = null;
    private Vector subAccounts = null;
    private Vector listeners = null;
    private Account parentAccount = null;
    private String currency = null;
    private boolean dirty = false;

    public String[] getAllAccountNames() {
        String[] stringArray = new String[this.getDepth()];
        Account account = this;
        int n = stringArray.length - 1;
        while (n >= 0) {
            stringArray[n] = account.getAccountName();
            account = account.getParentAccount();
            --n;
        }
        return stringArray;
    }

    public String getFullAccountName() {
        String string = this.accountName;
        Account account = this.getParentAccount();
        if (account.getAccountType() == 0) {
            return string;
        }
        return this.getParentAccount().getFullAccountName() + ':' + string;
    }

    public String getCurrencyType() {
        return this.currency;
    }

    public void setCurrencyType(String string) {
        this.currency = string;
        this.dirty = true;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String string) {
        this.accountName = string;
        this.notifyAccountModified(this);
        this.dirty = true;
    }

    public int getAccountNum() {
        return this.accountNum;
    }

    void setAccountNum(int n) {
        this.accountNum = n;
        this.notifyAccountModified(this);
        this.dirty = true;
    }

    public int getAccountType() {
        return this.accountType;
    }

    public String getParameter(String string) {
        if (this.parameters != null) {
            return (String)this.parameters.get(string);
        }
        return null;
    }

    public String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public synchronized void setParameter(String string, String string2) {
        if (this.parameters == null) {
            this.parameters = new Hashtable();
        }
        this.parameters.put(string, string2);
        this.notifyAccountModified(this);
        this.dirty = true;
    }

    public int getParameterCount() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public Enumeration getParameterKeys() {
        if (this.parameters == null) {
            return new Hashtable().keys();
        }
        return this.parameters.keys();
    }

    public int getDepth() {
        int n = 0;
        Account account = this;
        while (account.getAccountType() != 0) {
            account = account.getParentAccount();
            ++n;
        }
        return n;
    }

    public Account[] getPath() {
        Vector<Account> vector = new Vector<Account>();
        vector.addElement(this);
        Account account = this;
        while (account.getAccountType() != 0) {
            vector.addElement(account);
            account = account.getParentAccount();
        }
        Account[] accountArray = new Account[vector.size()];
        int n = 0;
        while (n < accountArray.length) {
            accountArray[n] = (Account)vector.elementAt(n);
            ++n;
        }
        return accountArray;
    }

    public int getSubAccountCount() {
        if (this.subAccounts != null) {
            return this.subAccounts.size();
        }
        return 0;
    }

    public Account getSubAccount(int n) {
        return (Account)this.subAccounts.elementAt(n);
    }

    public int indexOf(Account account) {
        if (this.subAccounts == null) {
            return -1;
        }
        return this.subAccounts.indexOf(account);
    }

    public Enumeration getSubAccounts() {
        if (this.subAccounts == null) {
            return new Vector().elements();
        }
        return this.subAccounts.elements();
    }

    public Account getAccountByName(String string) {
        if (this.accountName.equals(string)) {
            return this;
        }
        Enumeration enumeration = this.getSubAccounts();
        while (enumeration.hasMoreElements()) {
            Account account = (Account)enumeration.nextElement();
            Account account2 = account.getAccountByName(string);
            if (account2 == null) continue;
            return account2;
        }
        return null;
    }

    public Account getAccountByName(String string, int n) {
        if (this.accountName.equals(string) && this.accountType == n) {
            return this;
        }
        Enumeration enumeration = this.getSubAccounts();
        while (enumeration.hasMoreElements()) {
            Account account = (Account)enumeration.nextElement();
            Account account2 = account.getAccountByName(string, n);
            if (account2 == null) continue;
            return account2;
        }
        return null;
    }

    public Account getParentAccount() {
        return this.parentAccount;
    }

    public void setParentAccount(Account account) {
        if (this.parentAccount != account || this.accountNum < 0) {
            if (this.parentAccount != null) {
                this.parentAccount.removeSubAccount(this, false);
            }
            this.parentAccount = account;
            this.parentAccount.ensureHasSubAccount(this);
            this.notifyAccountModified(this);
            this.dirty = true;
        }
    }

    public RootAccount getRootAccount() {
        Account account = this;
        while (account != null && account.getClass() != (class$Lcom$seanreilly$apps$moneydance$model$RootAccount != null ? class$Lcom$seanreilly$apps$moneydance$model$RootAccount : Account.class$("com.seanreilly.apps.moneydance.model.RootAccount"))) {
            account = account.getParentAccount();
        }
        return (RootAccount)account;
    }

    public String toString() {
        int n = this.getDepth();
        if (n <= 0) {
            return this.accountName;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("   ");
            ++n2;
        }
        return stringBuffer.toString() + this.accountName;
    }

    public boolean isRegisterAccount() {
        return this.accountType == 1 || this.accountType == 3 || this.accountType == 2;
    }

    public void resetDirtyFlags() {
        this.dirty = false;
        Enumeration enumeration = this.getSubAccounts();
        while (enumeration.hasMoreElements()) {
            ((Account)enumeration.nextElement()).resetDirtyFlags();
        }
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.subAccounts != null) {
            Enumeration enumeration = this.subAccounts.elements();
            while (enumeration.hasMoreElements()) {
                if (!((Account)enumeration.nextElement()).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void removeSubAccount(Account account, boolean bl) {
        if (this.subAccounts == null) {
            return;
        }
        int n = 0;
        while (n < this.subAccounts.size()) {
            Account account2 = (Account)this.subAccounts.elementAt(n);
            if (account2.getAccountNum() == account.getAccountNum()) {
                if (bl) {
                    account2.removeAllSubAccounts();
                }
                this.subAccounts.removeElement(account2);
                this.getRootAccount().deregisterAccount(account2);
                break;
            }
            ++n;
        }
        this.notifyAccountModified(this);
        this.getRootAccount().notifyAccountModified(this);
    }

    void removeAllSubAccounts() {
        while (this.subAccounts != null && this.subAccounts.size() > 0) {
            this.removeSubAccount((Account)this.subAccounts.elementAt(0), true);
        }
    }

    public synchronized void addSubAccount(Account account) {
        if (this.subAccounts == null) {
            this.subAccounts = new Vector();
        }
        RootAccount rootAccount = this.getRootAccount();
        if (this.subAccounts.contains(account)) {
            return;
        }
        if (account.getAccountNum() <= 0) {
            int n = rootAccount.getHighestAccountNum() + 1;
            if (n < 1) {
                n = 1;
            }
            account.setAccountNum(n);
        }
        rootAccount.registerAccount(account);
        this.subAccounts.addElement(account);
        account.setParentAccount(this);
        this.getRootAccount().notifyAccountModified(this);
        this.dirty = true;
    }

    public synchronized void ensureHasSubAccount(Account account) {
        if (this.subAccounts == null) {
            this.addSubAccount(account);
            return;
        }
        boolean bl = false;
        Enumeration enumeration = this.subAccounts.elements();
        while (enumeration.hasMoreElements()) {
            Account account2 = (Account)enumeration.nextElement();
            if (account2.getAccountNum() != account.getAccountNum()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.addSubAccount(account);
        }
    }

    public synchronized int getHighestAccountNum() {
        int n = this.accountNum;
        if (this.subAccounts != null) {
            Enumeration enumeration = this.subAccounts.elements();
            while (enumeration.hasMoreElements()) {
                int n2 = ((Account)enumeration.nextElement()).getHighestAccountNum();
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public void addAccountListener(AccountListener accountListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(accountListener);
    }

    public void removeAccountListener(AccountListener accountListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(accountListener);
    }

    public void notifyAccountModified() {
        this.notifyAccountModified(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyAccountModified(Account account) {
        if (this.listeners == null) {
            return;
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((AccountListener)enumeration.nextElement()).accountModified(account);
            }
            catch (Exception exception) {
            }
        }
    }

    public synchronized void sortAccounts() {
        if (this.subAccounts == null || this.subAccounts.size() <= 0) {
            return;
        }
        this.quicksortAscending(0, this.subAccounts.size() - 1);
        this.notifyAccountModified();
    }

    public boolean containsTransaction(Transaction transaction, boolean bl, boolean bl2) {
        if (bl2 ? transaction.isInAccountRegister(this.accountNum) : transaction.affectsAccount(this.accountNum)) {
            return true;
        }
        if (bl) {
            Enumeration enumeration = this.getSubAccounts();
            while (enumeration.hasMoreElements()) {
                if (!((Account)enumeration.nextElement()).containsTransaction(transaction, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }

    private final void quicksortAscending(int n, int n2) {
        if (n < n2) {
            int n3 = this.partitionAscending(n, n2);
            this.quicksortAscending(n, n3 - 1);
            this.quicksortAscending(n3, n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int partitionAscending(int var1_1, int var2_2) {
        var3_3 = (Account)this.subAccounts.elementAt((var1_1 + var2_2) / 2);
        ** GOTO lbl15
        {
            ++var1_1;
            do {
                if (((Account)this.subAccounts.elementAt(var1_1)).getAccountType() < var3_3.getAccountType() || ((Account)this.subAccounts.elementAt(var1_1)).getAccountType() == var3_3.getAccountType() && ((Account)this.subAccounts.elementAt(var1_1)).getAccountName().compareTo(var3_3.getAccountName()) < 0) continue block0;
                while (((Account)this.subAccounts.elementAt(var2_2)).getAccountType() > var3_3.getAccountType() || ((Account)this.subAccounts.elementAt(var2_2)).getAccountType() == var3_3.getAccountType() && ((Account)this.subAccounts.elementAt(var2_2)).getAccountName().compareTo(var3_3.getAccountName()) > 0) {
                    --var2_2;
                }
                if (var1_1 > var2_2) continue;
                var4_4 = (Account)this.subAccounts.elementAt(var1_1);
                this.subAccounts.setElementAt(this.subAccounts.elementAt(var2_2), var1_1);
                this.subAccounts.setElementAt(var4_4, var2_2);
                ++var1_1;
                --var2_2;
lbl15:
                // 3 sources

            } while (var1_1 <= var2_2);
        }
        return var1_1;
    }

    public static String getAccountTypeName(int n) {
        if (n == 0) {
            return "Root";
        }
        if (n == 5) {
            return "Income";
        }
        if (n == 4) {
            return "Expense";
        }
        if (n == 1) {
            return "Bank";
        }
        if (n == 3) {
            return "Credit Card";
        }
        if (n == 2) {
            return "Investment";
        }
        return "???";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Account(String string, int n, int n2, String string2, Hashtable hashtable, Vector vector, Account account) {
        this.accountName = string;
        this.accountNum = n;
        this.accountType = n2;
        this.parameters = hashtable;
        this.currency = string2;
        this.parentAccount = account;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.addSubAccount((Account)enumeration.nextElement());
            }
        }
        this.dirty = false;
    }
}

